/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.EntityUI;
import yesman.epicfight.client.gui.ScreenCalculations;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.modules.ChargeableSkill;
import yesman.epicfight.skill.modules.HoldableSkill;

@OnlyIn(value=Dist.CLIENT)
public class BattleModeGui {
    private final List<SkillContainer> skillIcons = new ArrayList<SkillContainer>();
    private Minecraft minecraft;
    private boolean isVisible = false;
    private int slidingO;
    private int sliding = 7;
    private float staminaO;
    private float stamina;

    public BattleModeGui(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void tick(LocalPlayerPatch playerpatch) {
        this.staminaO = this.stamina;
        this.stamina = playerpatch.getStamina();
        this.slidingO = this.sliding;
        if (this.sliding > 6) {
            return;
        }
        if (this.sliding > 0) {
            this.sliding = this.isVisible ? --this.sliding : ++this.sliding;
        }
    }

    public void renderStaminaBar(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch == null || !((LocalPlayer)playerpatch.getOriginal()).isAlive() || ((LocalPlayer)playerpatch.getOriginal()).isSpectator()) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.setIdentity();
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(false);
        float sliding = Mth.lerp((float)partialTick, (float)this.slidingO, (float)this.sliding) * 5.0f + 4.0f;
        poseStack.translate(0.0f, sliding, 0.0f);
        float maxStamina = playerpatch.getMaxStamina();
        if (maxStamina > 0.0f && this.stamina < maxStamina) {
            Vec2i pos = ClientConfig.getStaminaPosition();
            float ratio = (this.staminaO + (this.stamina - this.staminaO) * partialTick) / maxStamina;
            RenderSystem.setShaderColor((float)1.0f, (float)ratio, (float)0.25f, (float)1.0f);
            guiGraphics.blit(EntityUI.BATTLE_ICON, pos.x, pos.y, 118, 4, 2.0f, 38.0f, 237, 9, 255, 255);
            guiGraphics.blit(EntityUI.BATTLE_ICON, pos.x, pos.y, (int)(118.0f * ratio), 4, 2.0f, 47.0f, (int)(237.0f * ratio), 9, 255, 255);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        poseStack.popPose();
    }

    public void renderChargingBar(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        HoldableSkill holdableSkill;
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch == null || !((LocalPlayer)playerpatch.getOriginal()).isAlive() || ((LocalPlayer)playerpatch.getOriginal()).isSpectator()) {
            return;
        }
        if (playerpatch.isHoldingAny() && (holdableSkill = playerpatch.getHoldingSkill()) instanceof ChargeableSkill) {
            ChargeableSkill chageableSkill = (ChargeableSkill)holdableSkill;
            float partialTick = deltaTracker.getGameTimeDeltaPartialTick(false);
            int chargeTicks = playerpatch.getChargingTicks();
            int prevChargingAmount = playerpatch.getChargingTicksO();
            float ratio = Math.min(((float)prevChargingAmount + (float)(chargeTicks - prevChargingAmount) * partialTick) / (float)chageableSkill.getMaxChargingTicks(), 1.0f);
            Vec2i pos = ClientConfig.getChargingBarPosition();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blit(EntityUI.BATTLE_ICON, pos.x, pos.y, 1.0f, 71.0f, 238, 13, 255, 255);
            guiGraphics.blit(EntityUI.BATTLE_ICON, pos.x, pos.y, 1.0f, 57.0f, (int)(238.0f * ratio), 13, 255, 255);
            ResourceLocation rl = ResourceLocation.parse((String)chageableSkill.toString());
            String skillName = Component.translatable((String)String.format("skill.%s.%s", rl.getNamespace(), rl.getPath())).getString();
            int stringWidth = this.minecraft.font.width(skillName);
            guiGraphics.drawString(this.minecraft.font, skillName, (float)(pos.x + 120) - (float)stringWidth * 0.5f, (float)(pos.y - 12), 0xFFFFFF, true);
        }
    }

    public void renderNormalSkills(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch == null || !((LocalPlayer)playerpatch.getOriginal()).isAlive() || ((LocalPlayer)playerpatch.getOriginal()).isSpectator()) {
            return;
        }
        for (SkillSlot slot : SkillSlot.ENUM_MANAGER.universalValues()) {
            SkillContainer container;
            if (slot == SkillSlots.WEAPON_INNATE || (container = playerpatch.getSkill(slot)).isEmpty() || this.skillIcons.contains(container) || !container.getSkill().shouldDraw(container)) continue;
            this.skillIcons.add(container);
        }
        this.skillIcons.removeIf(skillContainer -> skillContainer.isEmpty() || !skillContainer.getSkill().shouldDraw((SkillContainer)skillContainer));
        ScreenCalculations.AlignDirection alignDirection = ClientConfig.passiveAlignDirection;
        ScreenCalculations.HorizontalBasis horBasis = ClientConfig.passiveBaseX;
        ScreenCalculations.VerticalBasis verBasis = ClientConfig.passiveBaseY;
        Window window = Minecraft.getInstance().getWindow();
        int passiveX = horBasis.positionGetter.apply(window.getGuiScaledWidth(), ClientConfig.passiveX);
        int passiveY = verBasis.positionGetter.apply(window.getGuiScaledHeight(), ClientConfig.passiveY);
        int icons = this.skillIcons.size();
        Vec2i slotCoord = alignDirection.startCoordGetter.get(passiveX, passiveY, 24, 24, icons, horBasis, verBasis);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(false);
        for (SkillContainer container : this.skillIcons) {
            if (container.isEmpty()) continue;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            container.getSkill().drawOnGui(this, container, guiGraphics, slotCoord.x, slotCoord.y, partialTick);
            slotCoord = alignDirection.nextPositionGetter.getNext(horBasis, verBasis, slotCoord, 24, 24);
        }
        RenderSystem.disableBlend();
    }

    public void renderWeaponInnateSkill(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch == null || !((LocalPlayer)playerpatch.getOriginal()).isAlive() || ((LocalPlayer)playerpatch.getOriginal()).isSpectator()) {
            return;
        }
        SkillContainer container = playerpatch.getSkill(SkillSlots.WEAPON_INNATE);
        if (!container.isEmpty() && container.getSkill().shouldDraw(container)) {
            float partialTick = deltaTracker.getGameTimeDeltaPartialTick(false);
            Vec2i pos = ClientConfig.getWeaponInnatePosition();
            container.getSkill().drawOnGui(this, container, guiGraphics, pos.x, pos.y, partialTick);
        }
    }

    public void renderCharingBar(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        HoldableSkill holdableSkill;
        LocalPlayerPatch playerpatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerpatch == null) {
            return;
        }
        if (playerpatch.isHoldingAny() && (holdableSkill = playerpatch.getHoldingSkill()) instanceof ChargeableSkill) {
            ChargeableSkill chargeableSkill = (ChargeableSkill)holdableSkill;
            float partialTick = deltaTracker.getGameTimeDeltaPartialTick(false);
            int chargeAmount = playerpatch.getChargingTicks();
            int prevChargingAmount = playerpatch.getChargingTicksO();
            float ratio = Math.min(((float)prevChargingAmount + (float)(chargeAmount - prevChargingAmount) * partialTick) / (float)chargeableSkill.getMaxChargingTicks(), 1.0f);
            Vec2i pos = ClientConfig.getChargingBarPosition();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, (float)this.sliding, 0.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blit(EntityUI.BATTLE_ICON, pos.x, pos.y, 1.0f, 71.0f, 238, 13, 255, 255);
            guiGraphics.blit(EntityUI.BATTLE_ICON, pos.x, pos.y, 1.0f, 57.0f, (int)(238.0f * ratio), 13, 255, 255);
            ResourceLocation rl = ResourceLocation.parse((String)chargeableSkill.toString());
            String skillName = Component.translatable((String)String.format("skill.%s.%s", rl.getNamespace(), rl.getPath())).getString();
            int stringWidth = this.minecraft.font.width(skillName);
            guiGraphics.drawString(this.minecraft.font, skillName, (float)(pos.x + 120) - (float)stringWidth * 0.5f, (float)(pos.y - 12), 0xFFFFFF, true);
            guiGraphics.pose().popPose();
        }
    }

    public void slideUp() {
        if (!this.isVisible) {
            this.sliding = 6;
            this.isVisible = true;
        }
    }

    public void slideDown() {
        if (this.isVisible) {
            this.sliding = 1;
            this.isVisible = false;
        }
    }

    public void init(LocalPlayerPatch playerpatch) {
        this.skillIcons.clear();
        this.staminaO = playerpatch.getStamina();
        this.stamina = playerpatch.getStamina();
    }

    public Font getFont() {
        return this.minecraft.font;
    }
}

