/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.screen;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.datapack.screen.SelectFromRegistryScreen;

@OnlyIn(value=Dist.CLIENT)
public class SelectFromRegistryScreen<T>
extends Screen {
    private final RegistryList registryList;
    private final Screen parentScreen;
    private final Consumer<T> onPressRow;
    private final BiConsumer<String, T> onAccept;
    private final BiConsumer<String, T> onCancel;

    public SelectFromRegistryScreen(Screen parentScreen, Registry<T> registry, BiConsumer<String, T> onAccept, BiConsumer<String, T> onCancel, Predicate<T> filter) {
        this(parentScreen, registry, onAccept, onCancel, select -> {}, filter);
    }

    public SelectFromRegistryScreen(Screen parentScreen, Registry<T> registry, BiConsumer<String, T> onAccept, BiConsumer<String, T> onCancel, Consumer<T> onPressRow, Predicate<T> filter) {
        super((Component)Component.translatable((String)"gui.epicfight.select", (Object[])new Object[]{ParseUtil.snakeToSpacedCamel(registry.key().location().getPath())}));
        this.parentScreen = parentScreen;
        this.minecraft = parentScreen.getMinecraft();
        this.font = parentScreen.getMinecraft().font;
        HashMap filteredItems = Maps.newHashMap();
        registry.holders().map(Holder::value).filter(filter).forEach(value -> filteredItems.put(registry.getKey(value), value));
        this.registryList = new RegistryList(parentScreen.getMinecraft(), this.width, this.height - 52, 36, 21, filteredItems);
        this.onPressRow = onPressRow;
        this.onAccept = onAccept;
        this.onCancel = onCancel;
    }

    public SelectFromRegistryScreen(Screen parentScreen, Set<Pair<ResourceLocation, T>> entries, String title, BiConsumer<String, T> onAccept, BiConsumer<String, T> onCancel, Consumer<T> onPressRow, Predicate<T> filter) {
        super((Component)Component.translatable((String)"gui.epicfight.select", (Object[])new Object[]{ParseUtil.snakeToSpacedCamel(title)}));
        this.parentScreen = parentScreen;
        this.minecraft = parentScreen.getMinecraft();
        this.font = this.minecraft.font;
        Map filteredItems = entries.stream().filter(entry -> filter.test(entry.getSecond())).reduce(Maps.newHashMap(), (map, element) -> {
            map.put((ResourceLocation)element.getFirst(), element.getSecond());
            return map;
        }, (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        });
        this.registryList = new RegistryList(parentScreen.getMinecraft(), this.width, this.height - 68, 36, 21, filteredItems);
        this.onPressRow = onPressRow;
        this.onAccept = onAccept;
        this.onCancel = onCancel;
    }

    protected void init() {
        this.registryList.updateSizeAndPosition(this.width, this.height - 68, 36);
        EditBox editBox = new EditBox(this.minecraft.font, this.width / 2, 12, this.width / 2 - 12, 16, (Component)Component.literal((String)"epicfight:"));
        editBox.setResponder(this.registryList::applyFilter);
        this.addRenderableWidget((GuiEventListener)this.registryList);
        this.addRenderableWidget((GuiEventListener)editBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_OK, button$1 -> {
            if (this.registryList.getSelected() == null) {
                this.minecraft.setScreen(new MessageScreen("", "Select an item from the list", this, button$2 -> this.minecraft.setScreen((Screen)this), 180, 60));
            } else {
                try {
                    this.onAccept.accept(((RegistryList.RegistryEntry)this.registryList.getSelected()).name, (String)((RegistryList.RegistryEntry)this.registryList.getSelected()).item);
                    this.minecraft.setScreen(this.parentScreen);
                }
                catch (Exception e) {
                    this.minecraft.setScreen(new MessageScreen("", e.getMessage(), this.parentScreen, button$2 -> this.minecraft.setScreen(this.parentScreen), 180, 70).autoCalculateHeight());
                }
            }
        }).pos(this.width / 2 - 162, this.height - 28).size(160, 21).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            this.onCancel.accept("", null);
            this.minecraft.setScreen(this.parentScreen);
        }).pos(this.width / 2 + 2, this.height - 28).size(160, 21).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, this.title, 20, 16, 0xFFFFFF);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }

    @OnlyIn(value=Dist.CLIENT)
    class RegistryList
    extends ObjectSelectionList<yesman.epicfight.client.gui.datapack.screen.SelectFromRegistryScreen$RegistryList.RegistryEntry> {
        private final Map<ResourceLocation, T> registry;

        public RegistryList(Minecraft minecraft, int width, int height, int y, int itemHeight, Map<ResourceLocation, T> registry) {
            super(minecraft, width, height, y, itemHeight);
            this.registry = registry;
            registry.entrySet().stream().sorted((entry1, entry2) -> ((ResourceLocation)entry1.getKey()).toString().compareTo(((ResourceLocation)entry2.getKey()).toString())).forEach(entry -> this.addEntry((AbstractSelectionList.Entry)new RegistryEntry(entry.getValue(), ((ResourceLocation)entry.getKey()).toString())));
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public void setSelected(@Nullable RegistryEntry selEntry) {
            SelectFromRegistryScreen.this.onPressRow.accept(selEntry.item);
            super.setSelected((AbstractSelectionList.Entry)selEntry);
        }

        public int getRowWidth() {
            return this.width;
        }

        protected int getScrollbarPosition() {
            return this.getX() - 6;
        }

        public void applyFilter(String keyward) {
            this.setScrollAmount(0.0);
            this.children().clear();
            this.registry.entrySet().stream().sorted((entry1, entry2) -> ((ResourceLocation)entry1.getKey()).toString().compareTo(((ResourceLocation)entry2.getKey()).toString())).filter(entry -> StringUtil.isNullOrEmpty((String)keyward) ? true : ((ResourceLocation)entry.getKey()).toString().contains(keyward)).map(entry -> new RegistryEntry(entry.getValue(), ((ResourceLocation)entry.getKey()).toString())).forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
        }

        @OnlyIn(value=Dist.CLIENT)
        class RegistryEntry
        extends ObjectSelectionList.Entry<yesman.epicfight.client.gui.datapack.screen.SelectFromRegistryScreen$RegistryList.RegistryEntry> {
            private final T item;
            private final String name;

            public RegistryEntry(T item, String name) {
                this.item = item;
                this.name = name;
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                guiGraphics.drawString(((SelectFromRegistryScreen)SelectFromRegistryScreen.this).minecraft.font, this.name, left + 25, top + 5, 0xFFFFFF, false);
            }

            public Component getNarration() {
                return Component.translatable((String)"narrator.select");
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (RegistryList.this.getSelected() == this) {
                        try {
                            SelectFromRegistryScreen.this.onAccept.accept(this.name, (String)this.item);
                            SelectFromRegistryScreen.this.minecraft.setScreen(SelectFromRegistryScreen.this.parentScreen);
                        }
                        catch (Exception e) {
                            SelectFromRegistryScreen.this.minecraft.setScreen(new MessageScreen("", e.getMessage(), SelectFromRegistryScreen.this.parentScreen, button$2 -> SelectFromRegistryScreen.this.minecraft.setScreen(SelectFromRegistryScreen.this.parentScreen), 180, 70).autoCalculateHeight());
                        }
                        return true;
                    }
                    RegistryList.this.setSelected(this);
                    return true;
                }
                return false;
            }
        }
    }
}

