/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.screen.DatapackEditScreen;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.datapack.screen.PackEntry;
import yesman.epicfight.client.gui.datapack.widgets.Grid;
import yesman.epicfight.client.gui.datapack.widgets.InputComponentList;
import yesman.epicfight.client.gui.datapack.widgets.ModelPreviewer;
import yesman.epicfight.client.gui.datapack.widgets.PopupBox;
import yesman.epicfight.client.gui.datapack.widgets.ResizableComponent;
import yesman.epicfight.client.gui.datapack.widgets.Static;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;

@OnlyIn(value=Dist.CLIENT)
public class WeaponComboScreen
extends Screen {
    private final Screen parentScreen;
    private Grid stylesGrid;
    private Grid comboGrid;
    private PopupBox.AnimationPopupBox dashAttackPopupbox;
    private PopupBox.AnimationPopupBox airSlashPopupbox;
    private final InputComponentList<ListTag> inputComponentsList;
    private final ModelPreviewer modelPreviewer;
    private final List<PackEntry<String, ListTag>> styles = Lists.newArrayList();
    private final CompoundTag rootTag;

    public WeaponComboScreen(Screen parentScreen, CompoundTag rootTag) {
        super((Component)Component.translatable((String)"datapack_edit.weapon_type.combos"));
        this.minecraft = parentScreen.getMinecraft();
        this.font = parentScreen.getMinecraft().font;
        this.parentScreen = parentScreen;
        this.inputComponentsList = new InputComponentList<ListTag>((Screen)this, 0, 0, 0, 20){

            @Override
            public void importTag(ListTag tag) {
                boolean isMount;
                this.setComponentsActive(true);
                boolean bl = isMount = WeaponComboScreen.this.stylesGrid.getValue(WeaponComboScreen.this.stylesGrid.getRowposition(), "style") == CapabilityItem.Styles.MOUNT;
                if (!isMount) {
                    while (tag.size() < 2) {
                        tag.add((Object)StringTag.valueOf((String)""));
                    }
                }
                Grid.PackImporter packImporter = new Grid.PackImporter();
                int tagSize = tag.size();
                if (isMount) {
                    for (int i = 0; i < tagSize; ++i) {
                        packImporter.newRow().newValue("combo_animation", DatapackEditScreen.animationByKey(tag.getString(i)));
                    }
                    this.setDataBindingComponenets(new Object[]{packImporter});
                } else {
                    for (int i = 0; i < tagSize - 2; ++i) {
                        packImporter.newRow().newValue("combo_animation", DatapackEditScreen.animationByKey(tag.getString(i)));
                    }
                    this.setDataBindingComponenets(new Object[]{packImporter, DatapackEditScreen.animationByKey(tag.getString(tagSize - 2)), DatapackEditScreen.animationByKey(tag.getString(tagSize - 1))});
                }
            }
        };
        this.inputComponentsList.setX(parentScreen.width - 205);
        this.rootTag = ParseUtil.getOrDefaultTag(rootTag, "combos", new CompoundTag());
        this.stylesGrid = Grid.builder(this, parentScreen.getMinecraft()).xy1(12, 60).xy2(85, 50).horizontalSizing(ResizableComponent.HorizontalSizing.LEFT_WIDTH).verticalSizing(ResizableComponent.VerticalSizing.TOP_BOTTOM).rowHeight(21).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).rowpositionChanged((rowposition, values) -> {
            this.inputComponentsList.importTag(this.styles.get((int)rowposition).getValue());
            this.reloadAnimationPlayer();
            if (values.get("style") == CapabilityItem.Styles.MOUNT) {
                this.dashAttackPopupbox._setValue(null);
                this.airSlashPopupbox._setValue(null);
                this.dashAttackPopupbox._setActive(false);
                this.airSlashPopupbox._setActive(false);
            }
        }).addColumn(Grid.combo("style", Style.ENUM_MANAGER.universalValues()).valueChanged(event -> {
            if (event.prevValue == CapabilityItem.Styles.MOUNT) {
                this.dashAttackPopupbox._setActive(true);
                this.airSlashPopupbox._setActive(true);
                ListTag combosList = this.styles.get(event.rowposition).getValue();
                combosList.add((Object)StringTag.valueOf((String)""));
                combosList.add((Object)StringTag.valueOf((String)""));
            } else if (event.postValue == CapabilityItem.Styles.MOUNT) {
                this.dashAttackPopupbox._setValue(null);
                this.airSlashPopupbox._setValue(null);
                this.dashAttackPopupbox._setActive(false);
                this.airSlashPopupbox._setActive(false);
                ListTag combosList = this.styles.get(event.rowposition).getValue();
                combosList.remove(combosList.size() - 1);
                combosList.remove(combosList.size() - 1);
            }
            this.styles.get(event.rowposition).setPackKey(ParseUtil.nullParam(event.postValue).toLowerCase(Locale.ROOT));
        }).defaultVal(CapabilityItem.Styles.ONE_HAND)).pressAdd((grid, button) -> {
            this.styles.add(PackEntry.of("", ListTag::new));
            int rowposition = grid.addRow();
            grid.setGridFocus(rowposition, "style");
        }).pressRemove((grid, button) -> {
            grid.removeRow(removedRow -> this.styles.remove(removedRow));
            if (grid.children().size() == 0) {
                this.inputComponentsList.setComponentsActive(false);
            }
        }).build();
        this.comboGrid = Grid.builder(this, parentScreen.getMinecraft()).xy1(177, 40).xy2(14, 80).horizontalSizing(ResizableComponent.HorizontalSizing.WIDTH_RIGHT).rowHeight(21).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).addColumn(Grid.popup("combo_animation", PopupBox.AnimationPopupBox::new).filter(animation -> animation instanceof AttackAnimation).editWidgetCreated(popupBox -> popupBox.setModel(Armatures.BIPED, Meshes.BIPED)).toDisplayText(animation -> animation == null ? "" : animation.registryName().toString()).valueChanged(event -> {
            ListTag animationList = this.styles.get(this.stylesGrid.getRowposition()).getValue();
            animationList.remove(event.rowposition);
            animationList.add(event.rowposition, (Tag)StringTag.valueOf((String)ParseUtil.nullOrToString((AssetAccessor)event.postValue, animation -> animation.registryName().toString())));
            if (event.postValue != null) {
                this.reloadAnimationPlayer();
            }
        }).width(150)).pressAdd((grid, button) -> {
            this.styles.get(this.stylesGrid.getRowposition()).getValue().add(grid.children().size(), (Tag)StringTag.valueOf((String)""));
            int rowposition = grid.addRow();
            grid.setGridFocus(rowposition, "combo_animation");
        }).pressRemove((grid, button) -> {
            grid.removeRow(removedRow -> this.styles.get(this.stylesGrid.getRowposition()).getValue().remove(removedRow));
            this.reloadAnimationPlayer();
        }).build();
        this.modelPreviewer = new ModelPreviewer(110, 200, 45, 49, ResizableComponent.HorizontalSizing.LEFT_RIGHT, ResizableComponent.VerticalSizing.TOP_BOTTOM, Armatures.BIPED, Meshes.BIPED);
        CompoundTag colliderTag = rootTag.getCompound("collider");
        try {
            Collider collider = ColliderPreset.deserializeSimpleCollider(colliderTag);
            this.modelPreviewer.setCollider(collider);
        }
        catch (IllegalArgumentException collider) {
            // empty catch block
        }
        this.dashAttackPopupbox = new PopupBox.AnimationPopupBox(this, this.font, 110, 15, -1, 15, ResizableComponent.HorizontalSizing.WIDTH_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.weapon_type.styles.dash_attak"), pair -> {
            if (pair.getSecond() != null) {
                ListTag listTag = this.styles.get(this.stylesGrid.getRowposition()).getValue();
                listTag.remove(listTag.size() - 2);
                listTag.add(listTag.size() - 1, (Tag)StringTag.valueOf((String)ParseUtil.nullOrToString((AssetAccessor)pair.getSecond(), animation$2 -> animation$2.registryName().toString())));
                this.reloadAnimationPlayer();
            }
        });
        this.airSlashPopupbox = new PopupBox.AnimationPopupBox(this, this.font, 110, 15, -1, 15, ResizableComponent.HorizontalSizing.WIDTH_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.weapon_type.styles.air_slash"), pair -> {
            if (pair.getSecond() != null) {
                ListTag listTag = this.styles.get(this.stylesGrid.getRowposition()).getValue();
                listTag.remove(listTag.size() - 1);
                listTag.add(listTag.size(), (Tag)StringTag.valueOf((String)ParseUtil.nullOrToString((AssetAccessor)pair.getSecond(), animation$2 -> animation$2.registryName().toString())));
                this.reloadAnimationPlayer();
            }
        });
        this.dashAttackPopupbox.setModel(Armatures.BIPED, Meshes.BIPED);
        this.airSlashPopupbox.setModel(Armatures.BIPED, Meshes.BIPED);
        this.dashAttackPopupbox.applyFilter(animation -> animation.checkType(AttackAnimation.class));
        this.airSlashPopupbox.applyFilter(animation -> animation.checkType(AttackAnimation.class));
        this.inputComponentsList.newRow();
        this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, 80, 110, -1, 15, ResizableComponent.HorizontalSizing.WIDTH_RIGHT, null, "datapack_edit.weapon_type.combos.combo_attacks"));
        this.inputComponentsList.newRow();
        this.inputComponentsList.newRow();
        this.inputComponentsList.newRow();
        this.inputComponentsList.addComponentCurrentRow(this.comboGrid);
        this.inputComponentsList.newRow();
        this.inputComponentsList.newRow();
        this.inputComponentsList.newRow();
        this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, 60, 130, -1, 15, ResizableComponent.HorizontalSizing.WIDTH_RIGHT, null, "datapack_edit.weapon_type.combos.dash_attak"));
        this.inputComponentsList.addComponentCurrentRow(this.dashAttackPopupbox);
        this.inputComponentsList.newRow();
        this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, 60, 130, -1, 15, ResizableComponent.HorizontalSizing.WIDTH_RIGHT, null, "datapack_edit.weapon_type.combos.air_slash"));
        this.inputComponentsList.addComponentCurrentRow(this.airSlashPopupbox);
        this.inputComponentsList.setComponentsActive(false);
        Grid.PackImporter packImporter = new Grid.PackImporter();
        for (String style : this.rootTag.getAllKeys()) {
            this.styles.add(PackEntry.of(style, () -> this.rootTag.getList(style, 8)));
            packImporter.newRow();
            packImporter.newValue("style", Style.ENUM_MANAGER.get(style));
        }
        this.stylesGrid._setValue(packImporter);
    }

    protected void init() {
        ScreenRectangle screenRectangle = this.getRectangle();
        this.stylesGrid.resize(this.getRectangle());
        this.inputComponentsList.updateSizeAndPosition(205, screenRectangle.height() - 79 - screenRectangle.top(), screenRectangle.top() + 34);
        this.inputComponentsList.setX(this.width - 205);
        this.modelPreviewer.resize(screenRectangle);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            HashSet styles = Sets.newHashSet();
            for (PackEntry<String, ListTag> entry : this.styles) {
                if (styles.contains(entry.getKey())) {
                    this.minecraft.setScreen(new MessageScreen("Save Failed", "Unable to save because of duplicated style: " + entry.getKey(), this, button2 -> this.minecraft.setScreen((Screen)this), 180, 90));
                    return;
                }
                styles.add(entry.getKey());
            }
            boolean allTagsNormal = true;
            String animation = null;
            String style = null;
            block1: for (PackEntry<String, ListTag> entry : this.styles) {
                for (Tag tag : entry.getValue()) {
                    if (DatapackEditScreen.animationByKey(tag.getAsString()) != null) continue;
                    animation = tag.getAsString();
                    style = entry.getKey();
                    allTagsNormal = false;
                    break block1;
                }
            }
            if (!allTagsNormal) {
                this.minecraft.setScreen(new MessageScreen("Save Failed", "No animation named: " + animation + " in " + style, this, button2 -> this.minecraft.setScreen((Screen)this), 180, 90));
            } else {
                this.rootTag.tags.clear();
                for (PackEntry<String, ListTag> entry : this.styles) {
                    this.rootTag.put(entry.getKey(), (Tag)entry.getValue());
                }
                this.onClose();
            }
        }).pos(this.width / 2 - 162, this.height - 32).size(160, 21).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen(new MessageScreen("", "Do you want to quit without saving changes?", this, button2 -> this.onClose(), button2 -> this.minecraft.setScreen((Screen)this), 180, 70))).pos(this.width / 2 + 2, this.height - 32).size(160, 21).build());
        this.addRenderableWidget(new Static(this, 12, 60, 40, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.translatable((String)"datapack_edit.styles"), (Component)Component.translatable((String)"datapack_edit.styles.tooltip.mandatory")));
        this.addRenderableWidget(this.stylesGrid);
        this.addRenderableWidget(this.modelPreviewer);
        this.addRenderableWidget((GuiEventListener)this.inputComponentsList);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
        this.modelPreviewer.onDestroy();
    }

    public void tick() {
        this.modelPreviewer._tick();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.modelPreviewer.mouseDragged(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        if (this.inputComponentsList.mouseDragged(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dx, dy);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int yBegin = 32;
        int yEnd = this.height - 45;
        guiGraphics.drawString(this.font, this.title, 20, 16, 0xFFFFFF);
        guiGraphics.setColor(0.125f, 0.125f, 0.125f, 1.0f);
        guiGraphics.blit(Screen.MENU_BACKGROUND, 0, yBegin, (float)this.width, (float)yEnd - (float)yBegin, this.width, yEnd, 32, 32);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.setColor(0.25f, 0.25f, 0.25f, 1.0f);
        guiGraphics.blit(Screen.MENU_BACKGROUND, 0, 0, 0.0f, 0.0f, this.width, yBegin, 32, 32);
        guiGraphics.blit(Screen.MENU_BACKGROUND, 0, yEnd, 0.0f, (float)yEnd - (float)yBegin, this.width, yEnd, 32, 32);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.fillGradient(RenderType.guiOverlay(), 0, yBegin, this.width, yBegin + 4, -16777216, 0, 0);
        guiGraphics.fillGradient(RenderType.guiOverlay(), 0, yEnd, this.width, yEnd + 1, 0, -16777216, 0);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void reloadAnimationPlayer() {
        ArrayList animations = Lists.newArrayList();
        this.comboGrid.visitRows(values -> {
            AssetAccessor animation = (AssetAccessor)values.get("combo_animation");
            if (animation != null) {
                animations.add(animation);
            }
        });
        AssetAccessor dashAttack = (AssetAccessor)this.dashAttackPopupbox._getValue();
        AssetAccessor airSlash = (AssetAccessor)this.airSlashPopupbox._getValue();
        if (dashAttack != null) {
            animations.add(dashAttack);
        }
        if (airSlash != null) {
            animations.add(airSlash);
        }
        this.modelPreviewer.clearAnimations();
        animations.forEach(this.modelPreviewer::addAnimationToPlay);
    }
}

