/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen.config;

import java.io.File;
import java.io.IOException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.transformer.HumanoidModelBaker;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.gui.screen.config.EpicFightOptionSubScreen;
import yesman.epicfight.client.gui.screen.config.UISetupScreen;
import yesman.epicfight.client.gui.widgets.ColorSlider;
import yesman.epicfight.client.gui.widgets.EpicFightOptionList;
import yesman.epicfight.client.renderer.shader.compute.loader.ComputeShaderProvider;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.main.EpicFightMod;

@OnlyIn(value=Dist.CLIENT)
public class EpicFightGraphicOptionScreen
extends EpicFightOptionSubScreen {
    private EpicFightOptionList optionsList;

    public EpicFightGraphicOptionScreen(Screen parentScreen) {
        super(parentScreen, (Component)Component.translatable((String)"gui.epicfight.graphic_options"));
    }

    @Override
    protected void init() {
        super.init();
        String modid = "epicfight";
        this.optionsList = new EpicFightOptionList(this.minecraft, this.width, this.height - 64, 32, 25);
        int buttonHeight = -32;
        Button showTargetIndicatorButton = Button.builder((Component)Component.translatable((String)("gui." + modid + ".target_indicator." + (ClientConfig.showTargetIndicator ? "on" : "off"))), button -> {
            ClientConfig.showTargetIndicator = !ClientConfig.showTargetIndicator;
            button.setMessage((Component)Component.translatable((String)("gui." + modid + ".target_indicator." + (ClientConfig.showTargetIndicator ? "on" : "off"))));
        }).pos(this.width / 2 + 5, this.height / 4 - 8).size(160, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui." + modid + ".target_indicator.tooltip")))).build();
        Button healthBarVisibilityOptionButton = Button.builder((Component)Component.translatable((String)("gui." + modid + ".health_bar_show_option." + ClientConfig.healthBarVisibility.toString())), button -> {
            ClientConfig.healthBarVisibility = ClientConfig.healthBarVisibility.nextEnum();
            button.setMessage((Component)Component.translatable((String)("gui." + modid + ".health_bar_show_option." + ClientConfig.healthBarVisibility.toString())));
        }).pos(this.width / 2 - 165, this.height / 4 - 8).size(160, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui." + modid + ".filter_animation.tooltip")))).build();
        this.optionsList.addSmall((AbstractWidget)showTargetIndicatorButton, (AbstractWidget)healthBarVisibilityOptionButton);
        Button aimingCorrectionButton = Button.builder((Component)Component.translatable((String)("gui." + modid + ".aiming_correction." + (ClientConfig.aimingPovCorrection ? "on" : "off"))), button -> {
            ClientConfig.aimingPovCorrection = !ClientConfig.aimingPovCorrection;
            button.setMessage((Component)Component.translatable((String)("gui." + modid + ".aiming_correction." + (ClientConfig.aimingPovCorrection ? "on" : "off"))));
        }).pos(this.width / 2 - 165, this.height / 4 + (buttonHeight += 24)).size(160, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui." + modid + ".aiming_correction.tooltip")))).build();
        Button enableAimHelperButton = Button.builder((Component)Component.translatable((String)("gui." + modid + ".aim_helper." + (ClientConfig.enableAimHelper ? "on" : "off"))), button -> {
            ClientConfig.enableAimHelper = !ClientConfig.enableAimHelper;
            button.setMessage((Component)Component.translatable((String)("gui." + modid + ".aim_helper." + (ClientConfig.enableAimHelper ? "on" : "off"))));
        }).pos(this.width / 2 + 5, this.height / 4 - 8).size(160, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui." + modid + ".aim_helper.tooltip")))).build();
        this.optionsList.addSmall((AbstractWidget)aimingCorrectionButton, (AbstractWidget)enableAimHelperButton);
        Button bloodEffectsButton = Button.builder((Component)Component.translatable((String)("gui." + modid + ".blood_effects." + (ClientConfig.bloodEffects ? "on" : "off"))), button -> {
            ClientConfig.bloodEffects = !ClientConfig.bloodEffects;
            button.setMessage((Component)Component.translatable((String)("gui." + modid + ".blood_effects." + (ClientConfig.bloodEffects ? "on" : "off"))));
        }).pos(this.width / 2 - 165, this.height / 4 - 8).size(160, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui." + modid + ".blood_effects.tooltip")))).build();
        Button exportCustomArmors = Button.builder((Component)Component.translatable((String)("gui." + modid + ".export_custom_armor")), button -> {
            File resourcePackDirectory = Minecraft.getInstance().getResourcePackDirectory().toFile();
            try {
                HumanoidModelBaker.exportModels(resourcePackDirectory);
                Util.getPlatform().openFile(resourcePackDirectory);
            }
            catch (IOException e) {
                EpicFightMod.LOGGER.info("Failed to export custom armor models");
                e.printStackTrace();
            }
        }).pos(this.width / 2 + 5, this.height / 4 + (buttonHeight += 24)).size(160, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui." + modid + ".export_custom_armor.tooltip")))).build();
        this.optionsList.addSmall((AbstractWidget)bloodEffectsButton, (AbstractWidget)exportCustomArmors);
        Button enablePovAction = Button.builder((Component)Component.translatable((String)("gui." + modid + ".enable_pov_action." + (ClientConfig.enablePovAction ? "on" : "off"))), button -> {
            ClientConfig.enablePovAction = !ClientConfig.enablePovAction;
            button.setMessage((Component)Component.translatable((String)("gui." + modid + ".enable_pov_action." + (ClientConfig.enablePovAction ? "on" : "off"))));
        }).pos(this.width / 2 - 165, this.height / 4 + (buttonHeight += 24)).size(160, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui." + modid + ".enable_pov_action.tooltip")))).build();
        Button uiSetupButton = Button.builder((Component)Component.translatable((String)("gui." + modid + ".ui_setup")), button -> this.minecraft.setScreen((Screen)new UISetupScreen(this))).pos(this.width / 2 + 5, this.height / 4 + buttonHeight).size(160, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui." + modid + ".ui_setup.tooltip")))).build();
        this.optionsList.addSmall((AbstractWidget)enablePovAction, (AbstractWidget)uiSetupButton);
        Button showEpicfightAttributesButton = Button.builder((Component)Component.translatable((String)("gui." + modid + ".show_attributes." + (ClientConfig.showEpicFightAttributesInTooltip ? "on" : "off"))), button -> {
            ClientConfig.showEpicFightAttributesInTooltip = !ClientConfig.showEpicFightAttributesInTooltip;
            button.setMessage((Component)Component.translatable((String)("gui." + modid + ".show_attributes." + (ClientConfig.showEpicFightAttributesInTooltip ? "on" : "off"))));
        }).pos(this.width / 2 - 165, this.height / 4 + (buttonHeight += 24)).size(160, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui." + modid + ".show_attributes.tooltip")))).build();
        Button maxHitProjectilesButton = Button.builder((Component)Component.translatable((String)("gui." + modid + ".max_stuck_projectiles"), (Object[])new Object[]{String.valueOf(ClientConfig.maxStuckProjectiles)}), button -> {
            ClientConfig.maxStuckProjectiles = (ClientConfig.maxStuckProjectiles + 1) % 30;
            button.setMessage((Component)Component.translatable((String)("gui." + modid + ".max_stuck_projectiles"), (Object[])new Object[]{String.valueOf(ClientConfig.maxStuckProjectiles)}));
        }).pos(this.width / 2 + 5, this.height / 4 + buttonHeight).size(160, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui." + modid + ".max_stuck_projectiles.tooltip")))).build();
        this.optionsList.addSmall((AbstractWidget)showEpicfightAttributesButton, (AbstractWidget)maxHitProjectilesButton);
        Button firstPersonModelButton = Button.builder((Component)Component.translatable((String)("gui." + modid + ".first_person_model." + (ClientConfig.enableAnimatedFirstPersonModel ? "on" : "off"))), button -> {
            ClientConfig.enableAnimatedFirstPersonModel = !ClientConfig.enableAnimatedFirstPersonModel;
            button.setMessage((Component)Component.translatable((String)("gui." + modid + ".first_person_model." + (ClientConfig.enableAnimatedFirstPersonModel ? "on" : "off"))));
        }).pos(this.width / 2 - 165, this.height / 4 + (buttonHeight += 24)).size(160, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui." + modid + ".first_person_model.tooltip")))).build();
        Button useAnimationShaderButton = Button.builder((Component)Component.translatable((String)("gui." + modid + ".use_compute_shader." + (ClientConfig.activateComputeShader ? "on" : "off"))), button -> {
            ClientConfig.activateComputeShader = !ClientConfig.activateComputeShader;
            button.setMessage((Component)Component.translatable((String)("gui." + modid + ".use_compute_shader." + (ClientConfig.activateComputeShader ? "on" : "off"))));
        }).pos(this.width / 2 + 5, this.height / 4 + buttonHeight).size(160, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui." + modid + ".use_compute_shader.tooltip")))).build();
        if (!ComputeShaderProvider.supportComputeShader()) {
            useAnimationShaderButton.active = false;
            useAnimationShaderButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.epicfight.use_compute_shader.locked.tooltip")));
        }
        this.optionsList.addSmall((AbstractWidget)firstPersonModelButton, (AbstractWidget)useAnimationShaderButton);
        Button enableCosmetics = Button.builder((Component)Component.translatable((String)("gui." + modid + ".enable_cosmetics." + (ClientConfig.enableCosmetics ? "on" : "off"))), button -> {
            ClientConfig.enableCosmetics = !ClientConfig.enableCosmetics;
            button.setMessage((Component)Component.translatable((String)("gui." + modid + ".enable_cosmetics." + (ClientConfig.enableCosmetics ? "on" : "off"))));
        }).pos(this.width / 2 - 165, this.height / 4 + (buttonHeight += 24)).size(160, 20).tooltip(Tooltip.create((Component)Component.translatable((String)("gui." + modid + ".enable_cosmetics.tooltip")))).build();
        this.optionsList.addSmall((AbstractWidget)enableCosmetics, null);
        this.optionsList.addBig((AbstractWidget)new ColorSlider(this.font, this.width / 2 - 150, this.height / 4 + (buttonHeight += 30), 300, 20, (Component)Component.translatable((String)("gui." + modid + ".aim_helper_color")), ColorSlider.Style.CLASSIC, ClientConfig.aimHelperColor, (position, color) -> {
            ClientConfig.aimHelperColor = position;
        }));
        this.addWidget((GuiEventListener)this.optionsList);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderEngine.getInstance().versionNotifier.render(guiGraphics, false);
        this.basicListRender(guiGraphics, this.optionsList, mouseX, mouseY, partialTicks);
    }
}

