/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen.config;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.item.WeaponItem;

@OnlyIn(value=Dist.CLIENT)
public class PreferredItemsScreen
extends Screen {
    private static final Set<Class<? extends Item>> WEAPON_CATEGORIZED_ITEM_CLASSES = new HashSet<Class<? extends Item>>();
    private static final Set<Class<? extends Item>> TOOL_CATEGORIZED_ITEM_CLASSES = new HashSet<Class<? extends Item>>();
    private static final Component RESET_TOOLTIP;
    private static final Component SWAP_ALL;
    public static final Component GUI_FIND_WEAPONS;
    protected final Screen parentScreen;
    private ItemList combatPreferredItems;
    private ItemList miningPreferredItems;
    private Set<Item> combatItems = new HashSet<Item>();
    private Set<Item> miningItems = new HashSet<Item>();

    @SafeVarargs
    public static void registerWeaponCategorizedItemClasses(Class<? extends Item> ... weaponClasses) {
        WEAPON_CATEGORIZED_ITEM_CLASSES.addAll(Set.of(weaponClasses));
    }

    @SafeVarargs
    public static void registerToolCategorizedItemClasses(Class<? extends Item> ... toolClasses) {
        TOOL_CATEGORIZED_ITEM_CLASSES.addAll(Set.of(toolClasses));
    }

    private static boolean judgeItemPreference(Item item) {
        CapabilityItem itemCapability;
        boolean isweapon = false;
        boolean foundMatchingClass = false;
        for (Class<?> itemClass = item.getClass(); itemClass != Item.class; itemClass = itemClass.getSuperclass()) {
            if (WEAPON_CATEGORIZED_ITEM_CLASSES.contains(itemClass)) {
                isweapon = true;
                foundMatchingClass = true;
                break;
            }
            if (!TOOL_CATEGORIZED_ITEM_CLASSES.contains(itemClass)) continue;
            isweapon = false;
            foundMatchingClass = true;
            break;
        }
        if (!foundMatchingClass && (itemCapability = EpicFightCapabilities.getItemStackCapability(item.getDefaultInstance())) != null && itemCapability instanceof WeaponCapability) {
            isweapon = true;
        }
        return isweapon;
    }

    public static void resetItems() {
        ClientConfig.combatPreferredItems.clear();
        ClientConfig.miningPreferredItems.clear();
        BuiltInRegistries.ITEM.forEach(item -> {
            if (PreferredItemsScreen.judgeItemPreference(item)) {
                ClientConfig.combatPreferredItems.add((Item)item);
            } else {
                ClientConfig.miningPreferredItems.add((Item)item);
            }
        });
    }

    public static void addWeaponCategorizedItemClass(Class<? extends Item> cls) {
        WEAPON_CATEGORIZED_ITEM_CLASSES.add(cls);
    }

    public PreferredItemsScreen(Screen parentScreen) {
        super((Component)Component.translatable((String)"epicfight.gui.configuration.item_preferences"));
        this.parentScreen = parentScreen;
        BuiltInRegistries.ITEM.forEach(item -> {
            if (ClientConfig.combatPreferredItems.contains(item)) {
                this.combatItems.add((Item)item);
            } else if (ClientConfig.miningPreferredItems.contains(item)) {
                this.miningItems.add((Item)item);
            } else if (PreferredItemsScreen.judgeItemPreference(item)) {
                this.combatItems.add((Item)item);
            } else {
                this.miningItems.add((Item)item);
            }
        });
    }

    protected void init() {
        if (this.combatPreferredItems == null) {
            this.combatPreferredItems = new ItemList(200, this.height, true, Component.translatable((String)"epicfight.gui.combat_perferred"), (Component)Component.translatable((String)"epicfight.gui.combat_perferred.tooltip"), () -> this.miningPreferredItems);
            this.combatItems.stream().sorted(ItemList.ItemEntry::compare).forEach(item -> this.combatPreferredItems.addEntry((Item)item));
        } else {
            this.combatPreferredItems.resize(200, this.height);
            this.combatPreferredItems.setScrollAmount(this.combatPreferredItems.getScrollAmount());
        }
        if (this.miningPreferredItems == null) {
            this.miningPreferredItems = new ItemList(200, this.height, false, Component.translatable((String)"epicfight.gui.mining_preferred"), (Component)Component.translatable((String)"epicfight.gui.mining_preferred.tooltip"), () -> this.combatPreferredItems);
            this.miningItems.stream().sorted(ItemList.ItemEntry::compare).forEach(item -> this.miningPreferredItems.addEntry((Item)item));
        } else {
            this.miningPreferredItems.resize(200, this.height);
            this.combatPreferredItems.setScrollAmount(this.combatPreferredItems.getScrollAmount());
        }
        this.combatPreferredItems.setX(this.width / 2 - 204);
        this.miningPreferredItems.setX(this.width / 2 + 4);
        this.addRenderableWidget((GuiEventListener)this.combatPreferredItems);
        this.addRenderableWidget((GuiEventListener)this.miningPreferredItems);
        EditBox keywordEditBox = new EditBox(this.minecraft.font, this.width / 2 - 75, this.height - 50, 150, 15, (Component)Component.empty());
        keywordEditBox.setResponder(keyword -> {
            this.combatPreferredItems.filter((String)keyword);
            this.miningPreferredItems.filter((String)keyword);
            this.combatPreferredItems.setScrollAmount(this.combatPreferredItems.getScrollAmount());
            this.miningPreferredItems.setScrollAmount(this.miningPreferredItems.getScrollAmount());
        });
        this.addRenderableWidget((GuiEventListener)keywordEditBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), button -> {
            this.miningPreferredItems.children().removeIf(itemEntry -> {
                String name = Component.translatable((String)itemEntry.itemStack.getItem().getDescriptionId()).getString();
                if (ParseUtil.toLowerCase(name).contains(ParseUtil.toLowerCase(keywordEditBox.getValue()))) {
                    this.miningItems.remove(itemEntry.itemStack.getItem());
                    this.combatItems.add(itemEntry.itemStack.getItem());
                    this.combatPreferredItems.createOpponent((ItemList.ItemEntry)((Object)((Object)itemEntry)));
                    return true;
                }
                return false;
            });
            this.combatPreferredItems.setScrollAmount(this.combatPreferredItems.getScrollAmount());
            this.miningPreferredItems.setScrollAmount(this.miningPreferredItems.getScrollAmount());
        }).bounds(this.width / 2 - 92, this.height - 52, 15, 19).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), button -> {
            this.combatPreferredItems.children().removeIf(itemEntry -> {
                String name = Component.translatable((String)itemEntry.itemStack.getItem().getDescriptionId()).getString();
                if (ParseUtil.toLowerCase(name).contains(ParseUtil.toLowerCase(keywordEditBox.getValue()))) {
                    this.combatItems.remove(itemEntry.itemStack.getItem());
                    this.miningItems.add(itemEntry.itemStack.getItem());
                    this.miningPreferredItems.createOpponent((ItemList.ItemEntry)((Object)((Object)itemEntry)));
                    return true;
                }
                return false;
            });
            this.combatPreferredItems.setScrollAmount(this.combatPreferredItems.getScrollAmount());
            this.miningPreferredItems.setScrollAmount(this.miningPreferredItems.getScrollAmount());
        }).bounds(this.width / 2 + 77, this.height - 52, 15, 19).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            ClientConfig.combatPreferredItems.clear();
            ClientConfig.miningPreferredItems.clear();
            ClientConfig.combatPreferredItems.addAll(this.combatItems);
            ClientConfig.miningPreferredItems.addAll(this.miningItems);
            ClientConfig.saveChanges();
            this.onClose();
        }).bounds(this.width / 2 - 102, this.height - 28, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)GUI_FIND_WEAPONS, button -> {
            PreferredItemsScreen.resetItems();
            this.combatPreferredItems.children().clear();
            this.miningPreferredItems.children().clear();
            this.combatItems.clear();
            this.miningItems.clear();
            ClientConfig.combatPreferredItems.stream().sorted(ItemList.ItemEntry::compare).forEach(item -> {
                this.combatItems.add((Item)item);
                this.combatPreferredItems.addEntry((Item)item);
            });
            ClientConfig.miningPreferredItems.stream().sorted(ItemList.ItemEntry::compare).forEach(item -> {
                this.miningItems.add((Item)item);
                this.miningPreferredItems.addEntry((Item)item);
            });
            this.combatPreferredItems.setScrollAmount(0.0);
            this.miningPreferredItems.setScrollAmount(0.0);
        }).bounds(this.width / 2 + 2, this.height - 28, 100, 20).tooltip(Tooltip.create((Component)RESET_TOOLTIP)).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.combatPreferredItems.render(guiGraphics, mouseX, mouseY, partialTick);
        this.miningPreferredItems.render(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 16, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, SWAP_ALL, this.width / 2 - 120, this.height - 45, 0xFFFFFF);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }

    static {
        WEAPON_CATEGORIZED_ITEM_CLASSES.add(SwordItem.class);
        WEAPON_CATEGORIZED_ITEM_CLASSES.add(WeaponItem.class);
        WEAPON_CATEGORIZED_ITEM_CLASSES.add(BowItem.class);
        WEAPON_CATEGORIZED_ITEM_CLASSES.add(CrossbowItem.class);
        WEAPON_CATEGORIZED_ITEM_CLASSES.add(TridentItem.class);
        TOOL_CATEGORIZED_ITEM_CLASSES.add(AxeItem.class);
        TOOL_CATEGORIZED_ITEM_CLASSES.add(HoeItem.class);
        TOOL_CATEGORIZED_ITEM_CLASSES.add(PickaxeItem.class);
        TOOL_CATEGORIZED_ITEM_CLASSES.add(ShovelItem.class);
        RESET_TOOLTIP = Component.translatable((String)"gui.epicfight.item_preferences.tooltip.find_weapon");
        SWAP_ALL = Component.translatable((String)"epicfight.gui.item_preferences.swap_all");
        GUI_FIND_WEAPONS = Component.translatable((String)"gui.epicfight.find_weapon");
    }

    @OnlyIn(value=Dist.CLIENT)
    class ItemList
    extends ObjectSelectionList<ItemEntry> {
        private final Component title;
        private final Component tooltip;
        private final Supplier<ItemList> opponent;
        private final boolean left;

        public ItemList(int width, int height, boolean left, MutableComponent title, Component tooltip, Supplier<ItemList> opponent) {
            super(PreferredItemsScreen.this.minecraft, width, height - 87, 32, 22);
            this.title = title.withStyle(ChatFormatting.UNDERLINE);
            this.tooltip = tooltip;
            this.opponent = opponent;
            this.left = left;
            this.setRenderHeader(true, 13);
            if (this.getSelected() != null) {
                this.centerScrollOn((AbstractSelectionList.Entry)((ItemEntry)this.getSelected()));
            }
        }

        public void resize(int width, int height) {
            this.setY(32);
            this.setHeight(height - 87);
            this.setX(0);
            this.setWidth(width);
        }

        protected void renderHeader(GuiGraphics guiGraphics, int x, int y) {
            guiGraphics.drawString(this.minecraft.font, this.title, x + this.width / 2 - this.minecraft.font.width((FormattedText)this.title) / 2, Math.min(this.getY() + 3, y), 0xFFFFFF, false);
        }

        public int getRowWidth() {
            return this.width;
        }

        protected int getScrollbarPosition() {
            return this.getRight() - 6;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            int width = this.minecraft.font.width((FormattedText)this.title);
            int x = this.getRowLeft();
            int y = this.getY() + 4 - (int)this.getScrollAmount();
            x = x + this.width / 2 - width / 2;
            y = Math.min(this.getY() + 3, y);
            if (x < mouseX && y < mouseY && mouseX < x + width && mouseY < y + 15) {
                PreferredItemsScreen.this.setTooltipForNextRenderPass(this.tooltip);
            }
        }

        protected void addEntry(Item item) {
            this.children().add(new ItemEntry(item.getDefaultInstance(), this.left));
        }

        protected void removeEntryHaving(Item item) {
            this.children().removeIf(entry -> entry.itemStack.getItem().equals(item));
        }

        protected void createOpponent(ItemEntry itemEntry) {
            ItemEntry newEntry = new ItemEntry(itemEntry.itemStack, this.left);
            this.addEntry((AbstractSelectionList.Entry)newEntry);
            this.centerScrollOn((AbstractSelectionList.Entry)newEntry);
            this.setFocused((GuiEventListener)newEntry);
        }

        public void filter(String keyword) {
            this.children().clear();
            Set<Item> list = this.left ? PreferredItemsScreen.this.combatItems : PreferredItemsScreen.this.miningItems;
            list.stream().filter((? super T item) -> {
                String name = Component.translatable((String)item.getDescriptionId()).getString();
                return ParseUtil.toLowerCase(name).contains(ParseUtil.toLowerCase(keyword));
            }).sorted(ItemEntry::compare).forEach(this::addEntry);
        }

        @OnlyIn(value=Dist.CLIENT)
        class ItemEntry
        extends ObjectSelectionList.Entry<ItemEntry> {
            private static final Set<Item> UNRENDERABLE_ITEMS = Sets.newHashSet();
            private final ItemStack itemStack;
            private final Button switchButton;

            public static int compare(Item e1, Item e2) {
                String e1DisplayName = Component.translatable((String)e1.getDescriptionId()).getString();
                String e2DisplayName = Component.translatable((String)e2.getDescriptionId()).getString();
                return e1DisplayName.compareTo(e2DisplayName);
            }

            public ItemEntry(ItemStack itemStack, boolean left) {
                this.itemStack = itemStack;
                this.switchButton = Button.builder((Component)Component.literal((String)(left ? ">" : "<")), button -> {
                    ItemList.this.removeEntry((AbstractSelectionList.Entry)this);
                    ItemList.this.setScrollAmount(ItemList.this.getScrollAmount());
                    ItemList.this.opponent.get().createOpponent(this);
                    if (left) {
                        PreferredItemsScreen.this.combatItems.remove(itemStack.getItem());
                        PreferredItemsScreen.this.miningItems.add(itemStack.getItem());
                    } else {
                        PreferredItemsScreen.this.miningItems.remove(itemStack.getItem());
                        PreferredItemsScreen.this.combatItems.add(itemStack.getItem());
                    }
                }).bounds(0, 0, 20, 20).build();
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                try {
                    if (!UNRENDERABLE_ITEMS.contains(this.itemStack.getItem())) {
                        guiGraphics.renderItem(this.itemStack, left + 4, top + 1);
                    }
                }
                catch (Exception e) {
                    UNRENDERABLE_ITEMS.add(this.itemStack.getItem());
                }
                this.switchButton.setX(left + 170);
                this.switchButton.setY(top - 1);
                this.switchButton.render(guiGraphics, mouseX, mouseY, partialTick);
                Component component = this.itemStack.getHoverName();
                guiGraphics.drawString(((ItemList)ItemList.this).minecraft.font, component, left + 30, top + 5, 0xFFFFFF, false);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (this.switchButton.isMouseOver(mouseX, mouseY)) {
                        this.switchButton.playDownSound(PreferredItemsScreen.this.minecraft.getSoundManager());
                        this.switchButton.onPress();
                    }
                    ItemList.this.setSelected((AbstractSelectionList.Entry)this);
                    return true;
                }
                return false;
            }

            public boolean equals(Object obj) {
                if (obj instanceof ItemEntry) {
                    ItemEntry itemEntry = (ItemEntry)((Object)obj);
                    return this.itemStack.equals(itemEntry.itemStack);
                }
                return super.equals(obj);
            }

            public Component getNarration() {
                return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.itemStack.getHoverName()});
            }
        }
    }
}

