/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.physics.bezier.CubicBezierCurve;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.particle.AbstractTrailParticle;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

@OnlyIn(value=Dist.CLIENT)
public class AnimationTrailParticle
extends AbstractTrailParticle<LivingEntityPatch<?>> {
    protected final Joint joint;
    protected final AssetAccessor<? extends StaticAnimation> animation;
    protected final List<AbstractTrailParticle.TrailEdge> invisibleTrailEdges;
    protected Pose lastPose;
    protected JointTransform lastTransform;

    protected AnimationTrailParticle(ClientLevel level, LivingEntityPatch<?> owner, Joint joint, AssetAccessor<? extends StaticAnimation> animation, TrailInfo trailInfo) {
        super(level, owner, trailInfo);
        this.joint = joint;
        this.animation = animation;
        this.invisibleTrailEdges = Lists.newLinkedList();
        Pose prevPose = ((Animator)((LivingEntityPatch)this.owner).getAnimator()).getPose(0.0f);
        Pose middlePose = ((Animator)((LivingEntityPatch)this.owner).getAnimator()).getPose(0.5f);
        Pose currentPose = ((Animator)((LivingEntityPatch)this.owner).getAnimator()).getPose(1.0f);
        Vec3 posOld = ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).getPosition(0.0f);
        Vec3 posMid = ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).getPosition(0.5f);
        Vec3 posCur = ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).getPosition(1.0f);
        this.lastPose = currentPose;
        this.lastPos = posCur;
        this.lastTransform = JointTransform.fromMatrix(((LivingEntityPatch)this.owner).getModelMatrix(1.0f));
        OpenMatrix4f prvmodelTf = OpenMatrix4f.createTranslation((float)posOld.x, (float)posOld.y, (float)posOld.z).rotateDeg(180.0f, Vec3f.Y_AXIS).mulBack(((LivingEntityPatch)this.owner).getModelMatrix(0.0f));
        OpenMatrix4f middleModelTf = OpenMatrix4f.createTranslation((float)posMid.x, (float)posMid.y, (float)posMid.z).rotateDeg(180.0f, Vec3f.Y_AXIS).mulBack(((LivingEntityPatch)this.owner).getModelMatrix(0.5f));
        OpenMatrix4f curModelTf = OpenMatrix4f.createTranslation((float)posCur.x, (float)posCur.y, (float)posCur.z).rotateDeg(180.0f, Vec3f.Y_AXIS).mulBack(((LivingEntityPatch)this.owner).getModelMatrix(1.0f));
        OpenMatrix4f prevJointTf = ((LivingEntityPatch)this.owner).getArmature().getBoundTransformFor(prevPose, this.joint).mulFront(prvmodelTf);
        OpenMatrix4f middleJointTf = ((LivingEntityPatch)this.owner).getArmature().getBoundTransformFor(middlePose, this.joint).mulFront(middleModelTf);
        OpenMatrix4f currentJointTf = ((LivingEntityPatch)this.owner).getArmature().getBoundTransformFor(currentPose, this.joint).mulFront(curModelTf);
        Vec3 prevStartPos = OpenMatrix4f.transform(prevJointTf, trailInfo.start());
        Vec3 prevEndPos = OpenMatrix4f.transform(prevJointTf, trailInfo.end());
        Vec3 middleStartPos = OpenMatrix4f.transform(middleJointTf, trailInfo.start());
        Vec3 middleEndPos = OpenMatrix4f.transform(middleJointTf, trailInfo.end());
        Vec3 currentStartPos = OpenMatrix4f.transform(currentJointTf, trailInfo.start());
        Vec3 currentEndPos = OpenMatrix4f.transform(currentJointTf, trailInfo.end());
        this.invisibleTrailEdges.add(new AbstractTrailParticle.TrailEdge(prevStartPos, prevEndPos, this.trailInfo.trailLifetime()));
        this.invisibleTrailEdges.add(new AbstractTrailParticle.TrailEdge(middleStartPos, middleEndPos, this.trailInfo.trailLifetime()));
        this.invisibleTrailEdges.add(new AbstractTrailParticle.TrailEdge(currentStartPos, currentEndPos, this.trailInfo.trailLifetime()));
        this.rCol = Math.max(this.trailInfo.rCol(), 0.0f);
        this.gCol = Math.max(this.trailInfo.gCol(), 0.0f);
        this.bCol = Math.max(this.trailInfo.bCol(), 0.0f);
        if (this.trailInfo.texturePath() != null) {
            TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
            AbstractTexture abstracttexture = texturemanager.getTexture(this.trailInfo.texturePath());
            RenderSystem.bindTexture((int)abstracttexture.getId());
            RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
            RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
        }
    }

    @Deprecated
    protected AnimationTrailParticle(Armature armature, LivingEntityPatch<?> owner, Joint joint, AssetAccessor<? extends StaticAnimation> animation, TrailInfo trailInfo) {
        super(owner, trailInfo);
        Pose currentPose;
        this.joint = joint;
        this.animation = animation;
        this.invisibleTrailEdges = Lists.newLinkedList();
        Pose prevPose = ((LivingEntityPatch)this.owner).getClientAnimator().getPose(0.0f);
        Pose middlePose = ((LivingEntityPatch)this.owner).getClientAnimator().getPose(0.5f);
        this.lastPose = currentPose = ((LivingEntityPatch)this.owner).getClientAnimator().getPose(1.0f);
        this.lastPos = new Vec3(0.0, 0.0, 0.0);
        this.lastTransform = JointTransform.fromMatrix(((LivingEntityPatch)this.owner).getModelMatrix(1.0f));
        OpenMatrix4f prevJointTf = armature.getBoundTransformFor(prevPose, this.joint);
        OpenMatrix4f middleJointTf = armature.getBoundTransformFor(middlePose, this.joint);
        OpenMatrix4f currentJointTf = armature.getBoundTransformFor(currentPose, this.joint);
        Vec3 prevStartPos = OpenMatrix4f.transform(prevJointTf, trailInfo.start());
        Vec3 prevEndPos = OpenMatrix4f.transform(prevJointTf, trailInfo.end());
        Vec3 middleStartPos = OpenMatrix4f.transform(middleJointTf, trailInfo.start());
        Vec3 middleEndPos = OpenMatrix4f.transform(middleJointTf, trailInfo.end());
        Vec3 currentStartPos = OpenMatrix4f.transform(currentJointTf, trailInfo.start());
        Vec3 currentEndPos = OpenMatrix4f.transform(currentJointTf, trailInfo.end());
        this.invisibleTrailEdges.add(new AbstractTrailParticle.TrailEdge(prevStartPos, prevEndPos, this.trailInfo.trailLifetime()));
        this.invisibleTrailEdges.add(new AbstractTrailParticle.TrailEdge(middleStartPos, middleEndPos, this.trailInfo.trailLifetime()));
        this.invisibleTrailEdges.add(new AbstractTrailParticle.TrailEdge(currentStartPos, currentEndPos, this.trailInfo.trailLifetime()));
        this.rCol = Math.max(this.trailInfo.rCol(), 0.0f);
        this.gCol = Math.max(this.trailInfo.gCol(), 0.0f);
        this.bCol = Math.max(this.trailInfo.bCol(), 0.0f);
        if (this.trailInfo.texturePath() != null) {
            TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
            AbstractTexture abstracttexture = texturemanager.getTexture(this.trailInfo.texturePath());
            RenderSystem.bindTexture((int)abstracttexture.getId());
            RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
            RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
        }
    }

    @Override
    protected boolean canContinue() {
        AnimationPlayer animPlayer = ((Animator)((LivingEntityPatch)this.owner).getAnimator()).getPlayerFor(this.animation);
        return ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).isAlive() && this.animation == animPlayer.getRealAnimation() && animPlayer.getElapsedTime() <= this.trailInfo.endTime();
    }

    @Override
    protected boolean canCreateNextCurve() {
        AnimationPlayer animPlayer = ((Animator)((LivingEntityPatch)this.owner).getAnimator()).getPlayerFor(this.animation);
        if (TrailInfo.isValidTime(this.trailInfo.fadeTime()) && this.trailInfo.endTime() < animPlayer.getElapsedTime()) {
            return false;
        }
        return super.canCreateNextCurve();
    }

    @Override
    protected void createNextCurve() {
        boolean visibleTrail;
        List<Object> finalEndPositions;
        List<Object> finalStartPositions;
        boolean needCorrection;
        AnimationPlayer animPlayer = ((Animator)((LivingEntityPatch)this.owner).getAnimator()).getPlayerFor(this.animation);
        boolean isTrailInvisible = animPlayer.getAnimation().get().isLinkAnimation() || animPlayer.getElapsedTime() <= this.trailInfo.startTime();
        boolean isFirstTrail = this.trailEdges.isEmpty();
        boolean bl = needCorrection = !isTrailInvisible && isFirstTrail;
        if (needCorrection) {
            float startCorrection = Math.max((this.trailInfo.startTime() - animPlayer.getPrevElapsedTime()) / (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()), 0.0f);
            this.startEdgeCorrection = (float)(this.trailInfo.interpolateCount() * 2) * startCorrection;
        }
        TrailInfo trailInfo = this.trailInfo;
        Pose prevPose = this.lastPose;
        Pose currentPose = ((Animator)((LivingEntityPatch)this.owner).getAnimator()).getPose(1.0f);
        Pose middlePose = Pose.interpolatePose(prevPose, currentPose, 0.5f);
        Vec3 posOld = this.lastPos;
        Vec3 posCur = ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).getPosition(1.0f);
        Vec3 posMid = MathUtils.lerpVector(posOld, posCur, 0.5f);
        OpenMatrix4f prevModelMatrix = this.lastTransform.toMatrix();
        OpenMatrix4f curModelMatrix = ((LivingEntityPatch)this.owner).getModelMatrix(1.0f);
        JointTransform currentTransform = JointTransform.fromMatrix(curModelMatrix);
        OpenMatrix4f prvmodelTf = OpenMatrix4f.createTranslation((float)posOld.x, (float)posOld.y, (float)posOld.z).rotateDeg(180.0f, Vec3f.Y_AXIS).mulBack(prevModelMatrix);
        OpenMatrix4f middleModelTf = OpenMatrix4f.createTranslation((float)posMid.x, (float)posMid.y, (float)posMid.z).rotateDeg(180.0f, Vec3f.Y_AXIS).mulBack(JointTransform.interpolate(this.lastTransform, currentTransform, 0.5f).toMatrix());
        OpenMatrix4f curModelTf = OpenMatrix4f.createTranslation((float)posCur.x, (float)posCur.y, (float)posCur.z).rotateDeg(180.0f, Vec3f.Y_AXIS).mulBack(curModelMatrix);
        OpenMatrix4f prevJointTf = ((LivingEntityPatch)this.owner).getArmature().getBoundTransformFor(prevPose, this.joint).mulFront(prvmodelTf);
        OpenMatrix4f middleJointTf = ((LivingEntityPatch)this.owner).getArmature().getBoundTransformFor(middlePose, this.joint).mulFront(middleModelTf);
        OpenMatrix4f currentJointTf = ((LivingEntityPatch)this.owner).getArmature().getBoundTransformFor(currentPose, this.joint).mulFront(curModelTf);
        Vec3 prevStartPos = OpenMatrix4f.transform(prevJointTf, trailInfo.start());
        Vec3 prevEndPos = OpenMatrix4f.transform(prevJointTf, trailInfo.end());
        Vec3 middleStartPos = OpenMatrix4f.transform(middleJointTf, trailInfo.start());
        Vec3 middleEndPos = OpenMatrix4f.transform(middleJointTf, trailInfo.end());
        Vec3 currentStartPos = OpenMatrix4f.transform(currentJointTf, trailInfo.start());
        Vec3 currentEndPos = OpenMatrix4f.transform(currentJointTf, trailInfo.end());
        if (isTrailInvisible) {
            finalStartPositions = Lists.newArrayList();
            finalEndPositions = Lists.newArrayList();
            finalStartPositions.add(prevStartPos);
            finalStartPositions.add(middleStartPos);
            finalEndPositions.add(prevEndPos);
            finalEndPositions.add(middleEndPos);
            this.invisibleTrailEdges.clear();
            visibleTrail = false;
        } else {
            AbstractTrailParticle.TrailEdge edge2;
            AbstractTrailParticle.TrailEdge edge1;
            ArrayList startPosList = Lists.newArrayList();
            ArrayList endPosList = Lists.newArrayList();
            if (isFirstTrail) {
                int lastIdx = this.invisibleTrailEdges.size() - 1;
                edge1 = this.invisibleTrailEdges.get(lastIdx);
                edge2 = new AbstractTrailParticle.TrailEdge(prevStartPos, prevEndPos, -1);
            } else {
                edge1 = (AbstractTrailParticle.TrailEdge)this.trailEdges.get(this.trailEdges.size() - (this.trailInfo.interpolateCount() / 2 + 1));
                edge2 = (AbstractTrailParticle.TrailEdge)this.trailEdges.get(this.trailEdges.size() - 1);
                ++edge2.lifetime;
            }
            startPosList.add(edge1.start);
            endPosList.add(edge1.end);
            startPosList.add(edge2.start);
            endPosList.add(edge2.end);
            startPosList.add(middleStartPos);
            endPosList.add(middleEndPos);
            startPosList.add(currentStartPos);
            endPosList.add(currentEndPos);
            finalStartPositions = CubicBezierCurve.getBezierInterpolatedPoints(startPosList, 1, 3, this.trailInfo.interpolateCount());
            finalEndPositions = CubicBezierCurve.getBezierInterpolatedPoints(endPosList, 1, 3, this.trailInfo.interpolateCount());
            if (!isFirstTrail) {
                finalStartPositions.remove(0);
                finalEndPositions.remove(0);
            }
            visibleTrail = true;
        }
        this.makeTrailEdges((List<Vec3>)finalStartPositions, (List<Vec3>)finalEndPositions, visibleTrail ? this.trailEdges : this.invisibleTrailEdges);
        this.lastPos = posCur;
        this.lastPose = currentPose;
        this.lastTransform = currentTransform;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            int eid = (int)Double.doubleToRawLongBits(x);
            int animid = (int)Double.doubleToRawLongBits(z);
            int jointId = (int)Double.doubleToRawLongBits(xSpeed);
            int idx = (int)Double.doubleToRawLongBits(ySpeed);
            Entity entity = level.getEntity(eid);
            if (entity == null) {
                return null;
            }
            LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
            if (entitypatch == null) {
                return null;
            }
            AnimationManager.AnimationAccessor animation = AnimationManager.byId(animid);
            if (animation == null) {
                return null;
            }
            Optional<List<TrailInfo>> trailInfo = ((StaticAnimation)animation.get()).getProperty(ClientAnimationProperties.TRAIL_EFFECT);
            if (trailInfo.isEmpty()) {
                return null;
            }
            TrailInfo result = trailInfo.get().get(idx);
            if (result.hand() != null) {
                ItemStack stack = ((LivingEntity)entitypatch.getOriginal()).getItemInHand(result.hand());
                RenderItemBase renderItemBase = RenderEngine.getInstance().getItemRenderer(stack);
                if (renderItemBase != null && renderItemBase.trailInfo() != null) {
                    result = renderItemBase.trailInfo().overwrite(result);
                }
            }
            if ((result = entitypatch.getEntityDecorations().getModifiedTrailInfo(result, result.hand() == null ? CapabilityItem.EMPTY : entitypatch.getAdvancedHoldingItemCapability(result.hand()))).playable()) {
                return new AnimationTrailParticle(level, entitypatch, entitypatch.getArmature().searchJointById(jointId), animation, result);
            }
            return null;
        }
    }
}

