/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.particle;

import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.config.ClientConfig;

@OnlyIn(value=Dist.CLIENT)
public class BloodParticle
extends TextureSheetParticle {
    protected BloodParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.x = x + (this.random.nextDouble() - 0.5) * (double)this.bbWidth;
        this.y = y + (this.random.nextDouble() + (double)this.bbHeight) * 0.5;
        this.z = z + (this.random.nextDouble() - 0.5) * (double)this.bbWidth;
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BloodParticle particle = new BloodParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            Random random = new Random();
            particle.move(0.0, 0.5, 0.0);
            float mass = random.nextFloat() + 0.2f;
            particle.lifetime = 10 + (int)(mass * 10.0f);
            particle.gravity = mass * 4.0f;
            particle.yd = (0.9f - mass) * 0.4f;
            particle.setSize(mass, mass);
            particle.pickSprite(this.spriteSet);
            float green = ClientConfig.bloodEffects ? 0.0f : Mth.clamp((float)random.nextFloat(), (float)0.6f, (float)0.4f);
            particle.setColor(Mth.clamp((float)random.nextFloat(), (float)0.6f, (float)0.4f), green, 0.0f);
            return particle;
        }
    }
}

