/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public final class EpicFightRenderTypes
extends RenderType {
    private static final Map<String, Map<ResourceLocation, RenderType>> TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE = new HashMap<String, Map<ResourceLocation, RenderType>>();
    private static final Function<RenderType, RenderType> TRIANGULATED_RENDER_TYPES = Util.memoize(renderType -> {
        if (renderType.mode() == VertexFormat.Mode.TRIANGLES) {
            return renderType;
        }
        if (renderType instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
            if (TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE.containsKey(renderType.name)) {
                Map<ResourceLocation, RenderType> renderTypesByTexture = TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE.get(renderType.name);
                RenderStateShard.EmptyTextureStateShard patt0$temp = compositeRenderType.state.textureState;
                if (patt0$temp instanceof RenderStateShard.TextureStateShard) {
                    RenderStateShard.TextureStateShard texStateShard = (RenderStateShard.TextureStateShard)patt0$temp;
                    ResourceLocation texLocation = texStateShard.texture.orElse(null);
                    if (renderTypesByTexture.containsKey(texLocation)) {
                        return renderTypesByTexture.get(texLocation);
                    }
                }
            }
            return new RenderType.CompositeRenderType(renderType.name, renderType.format, VertexFormat.Mode.TRIANGLES, renderType.bufferSize(), renderType.affectsCrumbling(), renderType.sortOnUpload, compositeRenderType.state);
        }
        return renderType;
    });
    protected static final RenderStateShard.ShaderStateShard PARTICLE_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::getParticleShader);
    private static final RenderType ENTITY_UI_COLORED = EpicFightRenderTypes.create((String)"epicfight:ui_color", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(POSITION_COLOR_SHADER).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setOverlayState(NO_OVERLAY).createCompositeState(true));
    private static final Function<ResourceLocation, RenderType> ENTITY_UI_TEXTURE = Util.memoize(textureLocation -> EpicFightRenderTypes.create((String)"epicfight:ui_texture", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(POSITION_TEX_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false, false)).setTransparencyState(NO_TRANSPARENCY).setLightmapState(NO_LIGHTMAP).setOverlayState(NO_OVERLAY).createCompositeState(true)));
    private static final RenderType OBB = EpicFightRenderTypes.create((String)"epicfight:debug_collider", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINE_STRIP, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(POSITION_COLOR_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setWriteMaskState(COLOR_DEPTH_WRITE).setCullState(NO_CULL).createCompositeState(false));
    private static final RenderType DEBUG_QUADS = EpicFightRenderTypes.create((String)"epicfight:debug_quad", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(POSITION_COLOR_SHADER).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(NO_TRANSPARENCY).setWriteMaskState(COLOR_DEPTH_WRITE).setCullState(NO_CULL).createCompositeState(false));
    private static final RenderType GUI_TRIANGLE = EpicFightRenderTypes.create((String)"epicfight:gui_triangle", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_GUI_SHADER).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setDepthTestState(LEQUAL_DEPTH_TEST).createCompositeState(false));
    private static final Function<ResourceLocation, RenderType> OVERLAY_MODEL = Util.memoize(texLocation -> EpicFightRenderTypes.create((String)"epicfight:overlay_model", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texLocation, false, false)).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(LIGHTMAP).createCompositeState(false)));
    private static final RenderType ENTITY_AFTERIMAGE_WHITE = EpicFightRenderTypes.create((String)"epicfight:entity_afterimage", (VertexFormat)DefaultVertexFormat.PARTICLE, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(PARTICLE_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/common/white.png"), false, false)).setCullState(NO_CULL).setWriteMaskState(COLOR_WRITE).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(LIGHTMAP).createCompositeState(false));
    private static final RenderType ITEM_AFTERIMAGE_WHITE = EpicFightRenderTypes.create((String)"epicfight:item_afterimage", (VertexFormat)DefaultVertexFormat.PARTICLE, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(PARTICLE_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/common/white.png"), false, false)).setCullState(NO_CULL).setWriteMaskState(COLOR_WRITE).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(LIGHTMAP).createCompositeState(false));
    private static final Function<ResourceLocation, RenderType> ENTITY_PARTICLE = Util.memoize(texLocation -> EpicFightRenderTypes.create((String)"epicfight:entity_particle", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texLocation, false, false)).setWriteMaskState(COLOR_WRITE).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setLightmapState(LIGHTMAP).createCompositeState(false)));
    private static final RenderType ITEM_PARTICLE = EpicFightRenderTypes.create((String)"epicfight:entity_particle", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(InventoryMenu.BLOCK_ATLAS, false, false)).setWriteMaskState(COLOR_WRITE).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setLightmapState(LIGHTMAP).createCompositeState(false));
    private static final Function<ResourceLocation, RenderType> ENTITY_PARTICLE_STENCIL = Util.memoize(texLocation -> EpicFightRenderTypes.create((String)"epicfight:entity_particle_stencil", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(POSITION_TEX_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texLocation, false, false)).setWriteMaskState(DEPTH_WRITE).createCompositeState(false)));
    private static final RenderType ITEM_PARTICLE_STENCIL = EpicFightRenderTypes.create((String)"epicfight:item_particle_stencil", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(POSITION_TEX_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(InventoryMenu.BLOCK_ATLAS, false, false)).setWriteMaskState(DEPTH_WRITE).createCompositeState(false));
    private static final Map<Entity, RenderType.CompositeRenderType> WORLD_RENDERTYPES_COLORED_GLINT = new HashMap<Entity, RenderType.CompositeRenderType>();

    public static RenderType makeTriangulated(RenderType renderType) {
        if (renderType.mode() == VertexFormat.Mode.TRIANGLES) {
            return renderType;
        }
        if (renderType instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
            return new RenderType.CompositeRenderType(renderType.name, renderType.format, VertexFormat.Mode.TRIANGLES, renderType.bufferSize(), renderType.affectsCrumbling(), renderType.sortOnUpload, compositeRenderType.state);
        }
        return renderType;
    }

    public static RenderType getTriangulated(RenderType renderType) {
        return TRIANGULATED_RENDER_TYPES.apply(renderType);
    }

    public static void addRenderType(String name, ResourceLocation textureLocation, RenderType renderType) {
        Map renderTypesByTexture = TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE.computeIfAbsent(name, k -> Maps.newHashMap());
        renderTypesByTexture.put(textureLocation, renderType);
    }

    private static RenderType replaceTextureShard(ResourceLocation texToReplace, RenderType renderType) {
        if (renderType instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
            RenderStateShard.EmptyTextureStateShard emptyTextureStateShard = compositeRenderType.state.textureState;
            if (emptyTextureStateShard instanceof RenderStateShard.TextureStateShard) {
                RenderStateShard.TextureStateShard texStateShard = (RenderStateShard.TextureStateShard)emptyTextureStateShard;
                RenderType.CompositeState textureReplacedState = new RenderType.CompositeState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texToReplace, texStateShard.blur, texStateShard.mipmap), compositeRenderType.state.shaderState, compositeRenderType.state.transparencyState, compositeRenderType.state.depthTestState, compositeRenderType.state.cullState, compositeRenderType.state.lightmapState, compositeRenderType.state.overlayState, compositeRenderType.state.layeringState, compositeRenderType.state.outputState, compositeRenderType.state.texturingState, compositeRenderType.state.writeMaskState, compositeRenderType.state.lineState, compositeRenderType.state.colorLogicState, compositeRenderType.state.outlineProperty);
                return new RenderType.CompositeRenderType(renderType.name, renderType.format, compositeRenderType.mode, renderType.bufferSize(), renderType.affectsCrumbling(), renderType.sortOnUpload, textureReplacedState);
            }
        }
        return null;
    }

    public static RenderType replaceTexture(ResourceLocation texLocation, RenderType renderType) {
        Map<ResourceLocation, RenderType> renderTypesByTexture;
        if (TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE.containsKey(renderType.name) && (renderTypesByTexture = TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE.get(renderType.name)).containsKey(texLocation)) {
            return renderTypesByTexture.get(texLocation);
        }
        RenderType textureReplacedRenderType = EpicFightRenderTypes.replaceTextureShard(texLocation, renderType);
        if (textureReplacedRenderType == null) {
            return renderType;
        }
        Map renderTypesByTexture2 = TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE.computeIfAbsent(textureReplacedRenderType.name, k -> new HashMap());
        renderTypesByTexture2.put(texLocation, textureReplacedRenderType);
        return textureReplacedRenderType;
    }

    public static RenderType entityUIColor() {
        return ENTITY_UI_COLORED;
    }

    public static RenderType entityUITexture(ResourceLocation resourcelocation) {
        return ENTITY_UI_TEXTURE.apply(resourcelocation);
    }

    public static RenderType debugCollider() {
        return OBB;
    }

    public static RenderType debugQuads() {
        return DEBUG_QUADS;
    }

    public static RenderType guiTriangle() {
        return GUI_TRIANGLE;
    }

    public static RenderType overlayModel(ResourceLocation textureLocation) {
        return OVERLAY_MODEL.apply(textureLocation);
    }

    public static RenderType entityAfterimageStencil(ResourceLocation textureLocation) {
        return ENTITY_PARTICLE_STENCIL.apply(textureLocation);
    }

    public static RenderType itemAfterimageStencil() {
        return ITEM_PARTICLE_STENCIL;
    }

    public static RenderType entityAfterimageTranslucent(ResourceLocation textureLocation) {
        return ENTITY_PARTICLE.apply(textureLocation);
    }

    public static RenderType itemAfterimageTranslucent() {
        return ITEM_PARTICLE;
    }

    public static RenderType entityAfterimageWhite() {
        return ENTITY_AFTERIMAGE_WHITE;
    }

    public static RenderType itemAfterimageWhite() {
        return ITEM_AFTERIMAGE_WHITE;
    }

    public static void freeUnusedWorldRenderTypes() {
        WORLD_RENDERTYPES_COLORED_GLINT.entrySet().removeIf(entry -> ((Entity)entry.getKey()).isRemoved());
    }

    public static void clearWorldRenderTypes() {
        WORLD_RENDERTYPES_COLORED_GLINT.clear();
    }

    public static RenderType coloredGlintWorldRendertype(Entity owner, float r, float g, float b) {
        RenderType.CompositeRenderType glintRenderType = WORLD_RENDERTYPES_COLORED_GLINT.computeIfAbsent(owner, k -> EpicFightRenderTypes.create((String)"epicfight:colored_glint", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)MutableCompositeState.mutableStateBuilder().setShaderState(RENDERTYPE_ARMOR_ENTITY_GLINT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/entity/overlay/glint_white.png"), true, false)).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(GLINT_TRANSPARENCY).setTexturingState(ENTITY_GLINT_TEXTURING).createCompositeState(false)));
        ((MutableCompositeState)glintRenderType.state).setShaderColor(r, g, b, 1.0f);
        return glintRenderType;
    }

    public static RenderType coloredGlintWorldRendertype(Entity owner, int r, int g, int b) {
        return EpicFightRenderTypes.coloredGlintWorldRendertype(owner, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    private EpicFightRenderTypes() {
        super(null, null, null, -1, false, false, null, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MutableCompositeState
    extends RenderType.CompositeState {
        private ShaderColorStateShard shaderColorState = new ShaderColorStateShard(new Vector4f(1.0f));

        public MutableCompositeState(RenderStateShard.EmptyTextureStateShard pTextureState, RenderStateShard.ShaderStateShard pShaderState, RenderStateShard.TransparencyStateShard pTransparencyState, RenderStateShard.DepthTestStateShard pDepthState, RenderStateShard.CullStateShard pCullState, RenderStateShard.LightmapStateShard pLightmapState, RenderStateShard.OverlayStateShard pOverlayState, RenderStateShard.LayeringStateShard pLayeringState, RenderStateShard.OutputStateShard pOutputState, RenderStateShard.TexturingStateShard pTexturingState, RenderStateShard.WriteMaskStateShard pWriteMaskState, RenderStateShard.LineStateShard pLineState, RenderStateShard.ColorLogicStateShard pColorLogicState, RenderType.OutlineProperty pOutlineProperty) {
            super(pTextureState, pShaderState, pTransparencyState, pDepthState, pCullState, pLightmapState, pOverlayState, pLayeringState, pOutputState, pTexturingState, pWriteMaskState, pLineState, pColorLogicState, pOutlineProperty);
            ArrayList<ShaderColorStateShard> list = new ArrayList<ShaderColorStateShard>((Collection<ShaderColorStateShard>)this.states);
            list.add(this.shaderColorState);
            this.states = ImmutableList.copyOf(list);
        }

        public void setShaderColor(int r, int g, int b, int a) {
            this.shaderColorState.setColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        }

        public void setShaderColor(float r, float g, float b, float a) {
            this.shaderColorState.setColor(r, g, b, a);
        }

        public static MutableCompositeStateBuilder mutableStateBuilder() {
            return new MutableCompositeStateBuilder();
        }

        @OnlyIn(value=Dist.CLIENT)
        public static class MutableCompositeStateBuilder {
            private RenderStateShard.EmptyTextureStateShard textureState = RenderStateShard.NO_TEXTURE;
            private RenderStateShard.ShaderStateShard shaderState = RenderStateShard.NO_SHADER;
            private RenderStateShard.TransparencyStateShard transparencyState = RenderStateShard.NO_TRANSPARENCY;
            private RenderStateShard.DepthTestStateShard depthTestState = RenderStateShard.LEQUAL_DEPTH_TEST;
            private RenderStateShard.CullStateShard cullState = RenderStateShard.CULL;
            private RenderStateShard.LightmapStateShard lightmapState = RenderStateShard.NO_LIGHTMAP;
            private RenderStateShard.OverlayStateShard overlayState = RenderStateShard.NO_OVERLAY;
            private RenderStateShard.LayeringStateShard layeringState = RenderStateShard.NO_LAYERING;
            private RenderStateShard.OutputStateShard outputState = RenderStateShard.MAIN_TARGET;
            private RenderStateShard.TexturingStateShard texturingState = RenderStateShard.DEFAULT_TEXTURING;
            private RenderStateShard.WriteMaskStateShard writeMaskState = RenderStateShard.COLOR_DEPTH_WRITE;
            private RenderStateShard.LineStateShard lineState = RenderStateShard.DEFAULT_LINE;
            private RenderStateShard.ColorLogicStateShard colorLogicState = RenderStateShard.NO_COLOR_LOGIC;

            public MutableCompositeStateBuilder setTextureState(RenderStateShard.EmptyTextureStateShard pTextureState) {
                this.textureState = pTextureState;
                return this;
            }

            public MutableCompositeStateBuilder setShaderState(RenderStateShard.ShaderStateShard pShaderState) {
                this.shaderState = pShaderState;
                return this;
            }

            public MutableCompositeStateBuilder setTransparencyState(RenderStateShard.TransparencyStateShard pTransparencyState) {
                this.transparencyState = pTransparencyState;
                return this;
            }

            public MutableCompositeStateBuilder setDepthTestState(RenderStateShard.DepthTestStateShard pDepthTestState) {
                this.depthTestState = pDepthTestState;
                return this;
            }

            public MutableCompositeStateBuilder setCullState(RenderStateShard.CullStateShard pCullState) {
                this.cullState = pCullState;
                return this;
            }

            public MutableCompositeStateBuilder setLightmapState(RenderStateShard.LightmapStateShard pLightmapState) {
                this.lightmapState = pLightmapState;
                return this;
            }

            public MutableCompositeStateBuilder setOverlayState(RenderStateShard.OverlayStateShard pOverlayState) {
                this.overlayState = pOverlayState;
                return this;
            }

            public MutableCompositeStateBuilder setLayeringState(RenderStateShard.LayeringStateShard pLayerState) {
                this.layeringState = pLayerState;
                return this;
            }

            public MutableCompositeStateBuilder setOutputState(RenderStateShard.OutputStateShard pOutputState) {
                this.outputState = pOutputState;
                return this;
            }

            public MutableCompositeStateBuilder setTexturingState(RenderStateShard.TexturingStateShard pTexturingState) {
                this.texturingState = pTexturingState;
                return this;
            }

            public MutableCompositeStateBuilder setWriteMaskState(RenderStateShard.WriteMaskStateShard pWriteMaskState) {
                this.writeMaskState = pWriteMaskState;
                return this;
            }

            public MutableCompositeStateBuilder setLineState(RenderStateShard.LineStateShard pLineState) {
                this.lineState = pLineState;
                return this;
            }

            public MutableCompositeStateBuilder setColorLogicState(RenderStateShard.ColorLogicStateShard pColorLogicState) {
                this.colorLogicState = pColorLogicState;
                return this;
            }

            public MutableCompositeState createCompositeState(boolean pOutline) {
                return this.createCompositeState(pOutline ? RenderType.OutlineProperty.AFFECTS_OUTLINE : RenderType.OutlineProperty.NONE);
            }

            public MutableCompositeState createCompositeState(RenderType.OutlineProperty pOutlineState) {
                return new MutableCompositeState(this.textureState, this.shaderState, this.transparencyState, this.depthTestState, this.cullState, this.lightmapState, this.overlayState, this.layeringState, this.outputState, this.texturingState, this.writeMaskState, this.lineState, this.colorLogicState, pOutlineState);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ShaderColorStateShard
    extends RenderStateShard {
        private Vector4f color;

        public ShaderColorStateShard(Vector4f color) {
            super("shader_color", () -> RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)color.w), () -> RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
            this.color = color;
        }

        public void setColor(float r, float g, float b, float a) {
            this.color.set(r, g, b, a);
        }
    }
}

