/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class PatchedHeadLayer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends EntityModel<E>>
extends PatchedLayer<E, T, M, CustomHeadLayer<E, M>> {
    @Override
    protected void renderLayer(T entitypatch, E entityliving, CustomHeadLayer<E, M> vanillaLayer, PoseStack postStack, MultiBufferSource buffer, int packedLightIn, OpenMatrix4f[] poses, float bob, float yRot, float xRot, float partialTicks) {
        ItemStack itemstack = entityliving.getItemBySlot(EquipmentSlot.HEAD);
        if (!itemstack.isEmpty()) {
            ModelPart model = ((HeadedModel)vanillaLayer.getParentModel()).getHead();
            LivingEntity entity = (LivingEntity)((EntityPatch)entitypatch).getOriginal();
            OpenMatrix4f modelMatrix = new OpenMatrix4f();
            modelMatrix.scale(new Vec3f(-1.0f, -1.0f, 1.0f)).mulFront(poses[9]).translate(0.0f, 0.02f, 0.0f);
            model.x = 0.0f;
            model.y = 0.0f;
            model.z = 0.0f;
            model.xRot = 0.0f;
            model.yRot = 0.0f;
            model.zRot = 0.0f;
            postStack.pushPose();
            MathUtils.mulStack(postStack, modelMatrix);
            if (((LivingEntity)((EntityPatch)entitypatch).getOriginal()).isBaby()) {
                postStack.translate(0.0f, -1.2f, 0.0f);
                postStack.scale(1.6f, 1.6f, 1.6f);
            }
            vanillaLayer.render(postStack, buffer, packedLightIn, entity, entity.walkAnimation.position(), entity.walkAnimation.speed(), (float)packedLightIn, (float)entity.tickCount, yRot, xRot);
            postStack.popPose();
        }
    }
}

