/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import org.apache.commons.lang3.mutable.MutableBoolean;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.client.render.CuriosLayer;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.ModelRenderLayer;
import yesman.epicfight.compat.ICompatModule;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class CuriosCompat
implements ICompatModule {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onModEventBusClient(IEventBus eventBus) {
        eventBus.addListener(event -> {
            PatchedEntityRenderer patt0$temp = event.get(EntityType.PLAYER);
            if (patt0$temp instanceof PatchedLivingEntityRenderer) {
                PatchedLivingEntityRenderer patchedlivingrenderer = (PatchedLivingEntityRenderer)patt0$temp;
                patchedlivingrenderer.addPatchedLayerAlways(CuriosLayer.class, new PatchedCuriosLayerRenderer());
            }
        });
        eventBus.addListener(event -> {
            PatchedCuriosLayerRenderer.CURIO_MESHES.values().forEach(SkinnedMesh::destroy);
            PatchedCuriosLayerRenderer.CURIO_MESHES.clear();
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onGameEventBusClient(IEventBus eventBus) {
    }

    @Override
    public void onModEventBus(IEventBus eventBus) {
    }

    @Override
    public void onGameEventBus(IEventBus eventBus) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PatchedCuriosLayerRenderer
    extends ModelRenderLayer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityModel<LivingEntity>, CuriosLayer<LivingEntity, EntityModel<LivingEntity>>, SkinnedMesh> {
        private static final Map<HumanoidModel<LivingEntity>, SkinnedMesh> CURIO_MESHES = Maps.newHashMap();

        public PatchedCuriosLayerRenderer() {
            super(null);
        }

        @Override
        protected void renderLayer(LivingEntityPatch<LivingEntity> entitypatch, LivingEntity livingEntity, CuriosLayer<LivingEntity, EntityModel<LivingEntity>> vanillaLayer, PoseStack poseStack, MultiBufferSource buffers, int packedLight, OpenMatrix4f[] poses, float bob, float yRot, float xRot, float partialTicks) {
            MutableBoolean renderedEpicFightModel = new MutableBoolean(false);
            CuriosApi.getCuriosInventory((LivingEntity)livingEntity).ifPresent(handler -> handler.getCurios().forEach((id, stacksHandler) -> {
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStacksHandler = stacksHandler.getCosmeticStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    boolean renderable;
                    ItemStack stack = cosmeticStacksHandler.getStackInSlot(i);
                    boolean cosmetic = true;
                    NonNullList renderStates = stacksHandler.getRenders();
                    boolean bl = renderable = renderStates.size() > i && (Boolean)renderStates.get(i) != false;
                    if (stack.isEmpty() && renderable) {
                        stack = stackHandler.getStackInSlot(i);
                        cosmetic = false;
                    }
                    if (stack.isEmpty()) continue;
                    ItemStack finalStack = stack;
                    SlotContext slotContext = new SlotContext(id, livingEntity, i, cosmetic, renderable);
                    CuriosRendererRegistry.getRenderer((Item)stack.getItem()).ifPresent(curioRenderer -> {});
                }
            }));
            if (!renderedEpicFightModel.booleanValue()) {
                poseStack.pushPose();
                OpenMatrix4f modelMatrix = poses[entitypatch.getArmature().searchJointByName("Root").getId()];
                MathUtils.mulStack(poseStack, modelMatrix);
                poseStack.translate(0.0f, 0.75f, 0.0f);
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                vanillaLayer.render(poseStack, buffers, packedLight, livingEntity, livingEntity.walkAnimation.position(partialTicks), livingEntity.walkAnimation.speed(partialTicks), partialTicks, bob, yRot, xRot);
                poseStack.popPose();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface EpicFightCurioRenderer {
        public void draw(ItemStack var1, SlotContext var2, LivingEntityPatch<LivingEntity> var3, LivingEntity var4, CuriosLayer<LivingEntity, EntityModel<LivingEntity>> var5, PoseStack var6, MultiBufferSource var7, int var8, OpenMatrix4f[] var9, float var10, float var11, float var12, float var13);
    }
}

