/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.config;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.compress.utils.Lists;
import yesman.epicfight.api.client.online.EpicFightServerConnectionHelper;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.HealthBar;
import yesman.epicfight.client.gui.ScreenCalculations;
import yesman.epicfight.client.gui.widgets.ColorSlider;
import yesman.epicfight.main.AuthenticationHelper;

@EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class ClientConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.IntValue LONG_PRESS_COUNTER = BUILDER.defineInRange("ingame.long_press_count", 2, 1, 10);
    public static final ModConfigSpec.IntValue MAX_STUCK_PROJECTILES = BUILDER.defineInRange("ingame.max_hit_projectiles", 30, 0, 30);
    public static final ModConfigSpec.DoubleValue AIM_HELPER_COLOR = BUILDER.defineInRange("ingame.laser_pointer_color", 0.328125, 0.0, 1.0);
    public static final ModConfigSpec.BooleanValue ENABLE_AIM_HELPER = BUILDER.define("ingame.enable_laser_pointer", () -> true);
    public static final ModConfigSpec.BooleanValue AUTO_SWITCH_CAMERA = BUILDER.define("ingame.camera_auto_switch", () -> false);
    public static final ModConfigSpec.BooleanValue BLOOD_EFFECTS = BUILDER.define("ingame.blood_effects", () -> true);
    public static final ModConfigSpec.BooleanValue AIMING_POV_CORRECTION = BUILDER.define("ingame.aiming_correction", () -> true);
    public static final ModConfigSpec.BooleanValue SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP = BUILDER.define("ingame.show_epicfight_attributes", () -> true);
    public static final ModConfigSpec.BooleanValue ACTIVATE_COMPUTE_SHADER = BUILDER.define("ingame.use_compute_shader", () -> false);
    public static final ModConfigSpec.BooleanValue ENABLE_ANIMATED_FIRST_PERSON_MODEL = BUILDER.define("ingame.first_person_model", () -> true);
    public static final ModConfigSpec.BooleanValue ENABLE_POV_ACTION = BUILDER.define("ingame.enable_pov_action", () -> true);
    public static final ModConfigSpec.BooleanValue ENABLE_COSMETICS = BUILDER.define("ingame.enable_cosmetics", () -> true);
    public static final ModConfigSpec.ConfigValue<List<? extends String>> COMBAT_PREFERRED_ITEMS = BUILDER.defineListAllowEmpty("ingame.combat_preferred_items", (List)Lists.newArrayList(), null, element -> {
        if (element instanceof String) {
            String str = (String)element;
            return str.contains(":");
        }
        return false;
    });
    public static final ModConfigSpec.ConfigValue<List<? extends String>> MINING_PREFERRED_ITEMS = BUILDER.defineListAllowEmpty("ingame.mining_preferred_items", (List)Lists.newArrayList(), null, element -> {
        if (element instanceof String) {
            String str = (String)element;
            return str.contains(":");
        }
        return false;
    });
    public static final ModConfigSpec.BooleanValue SHOW_TARGET_INDICATOR = BUILDER.define("ingame.show_target_indicator", () -> true);
    public static final ModConfigSpec.EnumValue<HealthBar.HealthBarVisibility> HEALTH_BAR_VISIBILITY = BUILDER.defineEnum("ingame.health_bar_show_option", (Enum)HealthBar.HealthBarVisibility.HURT);
    public static final ModConfigSpec.ConfigValue<Integer> STAMINA_BAR_X = BUILDER.define("ingame.ui.stamina_bar_x", (Object)120);
    public static final ModConfigSpec.ConfigValue<Integer> STAMINA_BAR_Y = BUILDER.define("ingame.ui.stamina_bar_y", (Object)10);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.HorizontalBasis> STAMINA_BAR_BASE_X = BUILDER.defineEnum("ingame.ui.stamina_bar_x_base", (Enum)ScreenCalculations.HorizontalBasis.RIGHT);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.VerticalBasis> STAMINA_BAR_BASE_Y = BUILDER.defineEnum("ingame.ui.stamina_bar_y_base", (Enum)ScreenCalculations.VerticalBasis.BOTTOM);
    public static final ModConfigSpec.ConfigValue<Integer> WEAPON_INNATE_X = BUILDER.define("ingame.ui.weapon_innate_x", (Object)42);
    public static final ModConfigSpec.ConfigValue<Integer> WEAPON_INNATE_Y = BUILDER.define("ingame.ui.weapon_innate_y", (Object)48);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.HorizontalBasis> WEAPON_INNATE_BASE_X = BUILDER.defineEnum("ingame.ui.weapon_innate_x_base", (Enum)ScreenCalculations.HorizontalBasis.RIGHT);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.VerticalBasis> WEAPON_INNATE_BASE_Y = BUILDER.defineEnum("ingame.ui.weapon_innate_y_base", (Enum)ScreenCalculations.VerticalBasis.BOTTOM);
    public static final ModConfigSpec.ConfigValue<Integer> PASSIVE_X = BUILDER.define("ingame.ui.passives_x", (Object)70);
    public static final ModConfigSpec.ConfigValue<Integer> PASSIVE_Y = BUILDER.define("ingame.ui.passives_y", (Object)36);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.HorizontalBasis> PASSIVE_BASE_X = BUILDER.defineEnum("ingame.ui.passives_x_base", (Enum)ScreenCalculations.HorizontalBasis.RIGHT);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.VerticalBasis> PASSIVE_BASE_Y = BUILDER.defineEnum("ingame.ui.passives_y_base", (Enum)ScreenCalculations.VerticalBasis.BOTTOM);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.AlignDirection> PASSIVE_ALIGN_DIRECTION = BUILDER.defineEnum("ingame.ui.passives_align_direction", (Enum)ScreenCalculations.AlignDirection.HORIZONTAL);
    public static final ModConfigSpec.ConfigValue<Integer> CHARGING_BAR_X = BUILDER.define("ingame.ui.charging_bar_x", (Object)-119);
    public static final ModConfigSpec.ConfigValue<Integer> CHARGING_BAR_Y = BUILDER.define("ingame.ui.charging_bar_y", (Object)60);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.HorizontalBasis> CHARGING_BAR_BASE_X = BUILDER.defineEnum("ingame.ui.charging_bar_x_base", (Enum)ScreenCalculations.HorizontalBasis.CENTER);
    public static final ModConfigSpec.EnumValue<ScreenCalculations.VerticalBasis> CHARGING_BAR_BASE_Y = BUILDER.defineEnum("ingame.ui.charging_bar_y_base", (Enum)ScreenCalculations.VerticalBasis.CENTER);
    public static final ModConfigSpec.ConfigValue<String> ACCESS_TOKEN = BUILDER.comment("Login information for epic fight patron server. Do not change these values manually").define("access_token", (Object)"");
    public static final ModConfigSpec.ConfigValue<String> REFRESH_TOKNE = BUILDER.define("refresh_token", (Object)"");
    public static final ModConfigSpec.EnumValue<AuthenticationHelper.AuthenticationProvider> PROVIDER = BUILDER.defineEnum("provider", (Enum)AuthenticationHelper.AuthenticationProvider.NULL);
    public static final ModConfigSpec SPEC = BUILDER.build();
    public static int longPressCounter;
    public static int maxStuckProjectiles;
    public static double aimHelperColor;
    public static int aimHelperPackedColor;
    public static boolean enableAimHelper;
    public static boolean authSwitchCamera;
    public static boolean bloodEffects;
    public static boolean aimingPovCorrection;
    public static boolean showEpicFightAttributesInTooltip;
    public static boolean activateComputeShader;
    public static boolean enableAnimatedFirstPersonModel;
    public static boolean enablePovAction;
    public static boolean enableCosmetics;
    public static Set<Item> combatPreferredItems;
    public static Set<Item> miningPreferredItems;
    public static boolean showTargetIndicator;
    public static HealthBar.HealthBarVisibility healthBarVisibility;
    public static int staminaBarX;
    public static int staminaBarY;
    public static ScreenCalculations.HorizontalBasis staminaBarBaseX;
    public static ScreenCalculations.VerticalBasis staminaBarBaseY;
    public static int weaponInnateX;
    public static int weaponInnateY;
    public static ScreenCalculations.HorizontalBasis weaponInnateBaseX;
    public static ScreenCalculations.VerticalBasis weaponInnateBaseY;
    public static int passiveX;
    public static int passiveY;
    public static ScreenCalculations.HorizontalBasis passiveBaseX;
    public static ScreenCalculations.VerticalBasis passiveBaseY;
    public static ScreenCalculations.AlignDirection passiveAlignDirection;
    public static int chargingBarX;
    public static int chargingBarY;
    public static ScreenCalculations.HorizontalBasis chargingBarBaseX;
    public static ScreenCalculations.VerticalBasis chargingBarBaseY;

    @SubscribeEvent
    static void epicfight$modConfigLoading(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() != ModConfig.Type.CLIENT) {
            return;
        }
        longPressCounter = (Integer)LONG_PRESS_COUNTER.get();
        maxStuckProjectiles = (Integer)MAX_STUCK_PROJECTILES.get();
        aimHelperColor = (Double)AIM_HELPER_COLOR.get();
        aimHelperPackedColor = ColorSlider.rgbColor(aimHelperColor);
        enableAimHelper = (Boolean)ENABLE_AIM_HELPER.get();
        authSwitchCamera = (Boolean)AUTO_SWITCH_CAMERA.get();
        bloodEffects = (Boolean)BLOOD_EFFECTS.get();
        aimingPovCorrection = (Boolean)AIMING_POV_CORRECTION.get();
        showEpicFightAttributesInTooltip = (Boolean)SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP.get();
        activateComputeShader = (Boolean)ACTIVATE_COMPUTE_SHADER.get();
        enableAnimatedFirstPersonModel = (Boolean)ENABLE_ANIMATED_FIRST_PERSON_MODEL.get();
        enablePovAction = (Boolean)ENABLE_POV_ACTION.get();
        enableCosmetics = (Boolean)ENABLE_COSMETICS.get();
        combatPreferredItems = ((List)COMBAT_PREFERRED_ITEMS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
        miningPreferredItems = ((List)MINING_PREFERRED_ITEMS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
        showTargetIndicator = (Boolean)SHOW_TARGET_INDICATOR.get();
        healthBarVisibility = (HealthBar.HealthBarVisibility)((Object)HEALTH_BAR_VISIBILITY.get());
        staminaBarX = (Integer)STAMINA_BAR_X.get();
        staminaBarY = (Integer)STAMINA_BAR_Y.get();
        staminaBarBaseX = (ScreenCalculations.HorizontalBasis)((Object)STAMINA_BAR_BASE_X.get());
        staminaBarBaseY = (ScreenCalculations.VerticalBasis)((Object)STAMINA_BAR_BASE_Y.get());
        weaponInnateX = (Integer)WEAPON_INNATE_X.get();
        weaponInnateY = (Integer)WEAPON_INNATE_Y.get();
        weaponInnateBaseX = (ScreenCalculations.HorizontalBasis)((Object)WEAPON_INNATE_BASE_X.get());
        weaponInnateBaseY = (ScreenCalculations.VerticalBasis)((Object)WEAPON_INNATE_BASE_Y.get());
        passiveX = (Integer)PASSIVE_X.get();
        passiveY = (Integer)PASSIVE_Y.get();
        passiveBaseX = (ScreenCalculations.HorizontalBasis)((Object)PASSIVE_BASE_X.get());
        passiveBaseY = (ScreenCalculations.VerticalBasis)((Object)PASSIVE_BASE_Y.get());
        passiveAlignDirection = (ScreenCalculations.AlignDirection)((Object)PASSIVE_ALIGN_DIRECTION.get());
        chargingBarX = (Integer)CHARGING_BAR_X.get();
        chargingBarY = (Integer)CHARGING_BAR_Y.get();
        chargingBarBaseX = (ScreenCalculations.HorizontalBasis)((Object)CHARGING_BAR_BASE_X.get());
        chargingBarBaseY = (ScreenCalculations.VerticalBasis)((Object)CHARGING_BAR_BASE_Y.get());
        if (EpicFightServerConnectionHelper.init(event.getConfig().getFullPath().getParent().toString())) {
            try {
                Class.forName("yesman.epicfight.epicskins.user.AuthenticationHelperImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (EpicFightServerConnectionHelper.supported() && ClientEngine.getInstance().getAuthHelper().valid()) {
            ClientEngine.getInstance().getAuthHelper().initialize(ACCESS_TOKEN, REFRESH_TOKNE, PROVIDER);
        }
    }

    public static void saveChanges() {
        if (longPressCounter != (Integer)LONG_PRESS_COUNTER.get()) {
            LONG_PRESS_COUNTER.set((Object)longPressCounter);
            LONG_PRESS_COUNTER.save();
            LONG_PRESS_COUNTER.save();
        }
        if (maxStuckProjectiles != (Integer)MAX_STUCK_PROJECTILES.get()) {
            MAX_STUCK_PROJECTILES.set((Object)maxStuckProjectiles);
            MAX_STUCK_PROJECTILES.save();
        }
        if (aimHelperColor != (Double)AIM_HELPER_COLOR.get()) {
            AIM_HELPER_COLOR.set((Object)aimHelperColor);
            AIM_HELPER_COLOR.save();
            aimHelperPackedColor = ColorSlider.rgbColor(aimHelperColor);
        }
        if (enableAimHelper != (Boolean)ENABLE_AIM_HELPER.get()) {
            ENABLE_AIM_HELPER.set((Object)enableAimHelper);
            ENABLE_AIM_HELPER.save();
        }
        if (authSwitchCamera != (Boolean)AUTO_SWITCH_CAMERA.get()) {
            AUTO_SWITCH_CAMERA.set((Object)authSwitchCamera);
            AUTO_SWITCH_CAMERA.save();
        }
        if (bloodEffects != (Boolean)BLOOD_EFFECTS.get()) {
            BLOOD_EFFECTS.set((Object)bloodEffects);
            BLOOD_EFFECTS.save();
        }
        if (aimingPovCorrection != (Boolean)AIMING_POV_CORRECTION.get()) {
            AIMING_POV_CORRECTION.set((Object)aimingPovCorrection);
            AIMING_POV_CORRECTION.save();
        }
        if (showEpicFightAttributesInTooltip != (Boolean)SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP.get()) {
            SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP.set((Object)showEpicFightAttributesInTooltip);
            SHOW_EPICFIGHT_ATTRIBUTES_IN_TOOLTIP.save();
        }
        if (activateComputeShader != (Boolean)ACTIVATE_COMPUTE_SHADER.get()) {
            ACTIVATE_COMPUTE_SHADER.set((Object)activateComputeShader);
            ACTIVATE_COMPUTE_SHADER.save();
        }
        if (enableAnimatedFirstPersonModel != (Boolean)ENABLE_ANIMATED_FIRST_PERSON_MODEL.get()) {
            ENABLE_ANIMATED_FIRST_PERSON_MODEL.set((Object)enableAnimatedFirstPersonModel);
            ENABLE_ANIMATED_FIRST_PERSON_MODEL.save();
        }
        if (enablePovAction != (Boolean)ENABLE_POV_ACTION.get()) {
            ENABLE_POV_ACTION.set((Object)enablePovAction);
            ENABLE_POV_ACTION.save();
        }
        if (enableCosmetics != (Boolean)ENABLE_COSMETICS.get()) {
            ENABLE_COSMETICS.set((Object)enableCosmetics);
            ENABLE_COSMETICS.save();
        }
        if (!combatPreferredItems.equals(((List)COMBAT_PREFERRED_ITEMS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet()))) {
            COMBAT_PREFERRED_ITEMS.set(combatPreferredItems.stream().map(item -> BuiltInRegistries.ITEM.getKey(item).toString()).collect(Collectors.toList()));
            COMBAT_PREFERRED_ITEMS.save();
        }
        if (!miningPreferredItems.equals(((List)MINING_PREFERRED_ITEMS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet()))) {
            MINING_PREFERRED_ITEMS.set(miningPreferredItems.stream().map(item -> BuiltInRegistries.ITEM.getKey(item).toString()).collect(Collectors.toList()));
            MINING_PREFERRED_ITEMS.save();
        }
        if (showTargetIndicator != (Boolean)SHOW_TARGET_INDICATOR.get()) {
            SHOW_TARGET_INDICATOR.set((Object)showTargetIndicator);
            SHOW_TARGET_INDICATOR.save();
        }
        if (healthBarVisibility != HEALTH_BAR_VISIBILITY.get()) {
            HEALTH_BAR_VISIBILITY.set((Object)healthBarVisibility);
            HEALTH_BAR_VISIBILITY.save();
        }
        if (staminaBarX != (Integer)STAMINA_BAR_X.get()) {
            STAMINA_BAR_X.set((Object)staminaBarX);
            STAMINA_BAR_X.save();
        }
        if (staminaBarY != (Integer)STAMINA_BAR_Y.get()) {
            STAMINA_BAR_Y.set((Object)staminaBarY);
            STAMINA_BAR_Y.save();
        }
        if (staminaBarBaseX != STAMINA_BAR_BASE_X.get()) {
            STAMINA_BAR_BASE_X.set((Object)staminaBarBaseX);
            STAMINA_BAR_BASE_X.save();
        }
        if (staminaBarBaseY != STAMINA_BAR_BASE_Y.get()) {
            STAMINA_BAR_BASE_Y.set((Object)staminaBarBaseY);
            STAMINA_BAR_BASE_Y.save();
        }
        if (weaponInnateX != (Integer)WEAPON_INNATE_X.get()) {
            WEAPON_INNATE_X.set((Object)weaponInnateX);
            WEAPON_INNATE_X.save();
        }
        if (weaponInnateX != (Integer)WEAPON_INNATE_Y.get()) {
            WEAPON_INNATE_Y.set((Object)weaponInnateY);
            WEAPON_INNATE_Y.save();
        }
        if (weaponInnateBaseX != WEAPON_INNATE_BASE_X.get()) {
            WEAPON_INNATE_BASE_X.set((Object)weaponInnateBaseX);
            WEAPON_INNATE_BASE_X.save();
        }
        if (weaponInnateBaseY != WEAPON_INNATE_BASE_Y.get()) {
            WEAPON_INNATE_BASE_Y.set((Object)weaponInnateBaseY);
            WEAPON_INNATE_BASE_Y.save();
        }
        if (passiveX != (Integer)PASSIVE_X.get()) {
            PASSIVE_X.set((Object)passiveX);
            PASSIVE_X.save();
        }
        if (passiveY != (Integer)PASSIVE_Y.get()) {
            PASSIVE_Y.set((Object)passiveY);
            PASSIVE_Y.save();
        }
        if (passiveBaseX != PASSIVE_BASE_X.get()) {
            PASSIVE_BASE_X.set((Object)passiveBaseX);
            PASSIVE_BASE_X.save();
        }
        if (passiveBaseY != PASSIVE_BASE_Y.get()) {
            PASSIVE_BASE_Y.set((Object)passiveBaseY);
            PASSIVE_BASE_Y.save();
        }
        if (passiveAlignDirection != PASSIVE_ALIGN_DIRECTION.get()) {
            PASSIVE_ALIGN_DIRECTION.set((Object)passiveAlignDirection);
            PASSIVE_ALIGN_DIRECTION.save();
        }
        if (chargingBarX != (Integer)CHARGING_BAR_X.get()) {
            CHARGING_BAR_X.set((Object)chargingBarX);
            CHARGING_BAR_X.save();
        }
        if (chargingBarY != (Integer)CHARGING_BAR_Y.get()) {
            CHARGING_BAR_Y.set((Object)chargingBarY);
            CHARGING_BAR_Y.save();
        }
        if (chargingBarBaseX != CHARGING_BAR_BASE_X.get()) {
            CHARGING_BAR_BASE_X.set((Object)chargingBarBaseX);
            CHARGING_BAR_BASE_X.save();
        }
        if (chargingBarBaseY != CHARGING_BAR_BASE_Y.get()) {
            CHARGING_BAR_BASE_Y.set((Object)chargingBarBaseY);
            CHARGING_BAR_BASE_Y.save();
        }
    }

    public static Vec2i getStaminaPosition() {
        int posX = ClientConfig.staminaBarBaseX.positionGetter.apply(Minecraft.getInstance().getWindow().getGuiScaledWidth(), staminaBarX);
        int posY = ClientConfig.staminaBarBaseY.positionGetter.apply(Minecraft.getInstance().getWindow().getGuiScaledHeight(), staminaBarY);
        return new Vec2i(posX, posY);
    }

    public static Vec2i getWeaponInnatePosition() {
        int posX = ClientConfig.weaponInnateBaseX.positionGetter.apply(Minecraft.getInstance().getWindow().getGuiScaledWidth(), weaponInnateX);
        int posY = ClientConfig.weaponInnateBaseY.positionGetter.apply(Minecraft.getInstance().getWindow().getGuiScaledHeight(), weaponInnateY);
        return new Vec2i(posX, posY);
    }

    public static Vec2i getChargingBarPosition() {
        int posX = ClientConfig.chargingBarBaseX.positionGetter.apply(Minecraft.getInstance().getWindow().getGuiScaledWidth(), chargingBarX);
        int posY = ClientConfig.chargingBarBaseY.positionGetter.apply(Minecraft.getInstance().getWindow().getGuiScaledHeight(), chargingBarY);
        return new Vec2i(posX, posY);
    }

    static {
        aimHelperPackedColor = -1;
    }
}

