/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.gameasset;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EntityType;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.asset.JsonAssetLoader;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.model.armature.CreeperArmature;
import yesman.epicfight.model.armature.DragonArmature;
import yesman.epicfight.model.armature.EndermanArmature;
import yesman.epicfight.model.armature.HoglinArmature;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.model.armature.IronGolemArmature;
import yesman.epicfight.model.armature.PiglinArmature;
import yesman.epicfight.model.armature.RavagerArmature;
import yesman.epicfight.model.armature.SpiderArmature;
import yesman.epicfight.model.armature.VexArmature;
import yesman.epicfight.model.armature.WitherArmature;
import yesman.epicfight.registry.entries.EpicFightEntityTypes;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;

public class Armatures {
    public static final Armatures INSTANCE = new Armatures();
    private static ResourceManager resourceManager = null;
    private static final Map<ResourceLocation, ArmatureAccessor<? extends Armature>> ACCESSORS = new HashMap<ResourceLocation, ArmatureAccessor<? extends Armature>>();
    private static final Map<ArmatureAccessor<? extends Armature>, Armature> ARMATURES = new HashMap<ArmatureAccessor<? extends Armature>, Armature>();
    private static final Map<EntityType<?>, AssetAccessor<? extends Armature>> ENTITY_TYPE_ARMATURE_MAPPER = new HashMap();
    public static final ArmatureAccessor<HumanoidArmature> BIPED = ArmatureAccessor.create("epicfight", "entity/biped", HumanoidArmature::new);
    public static final ArmatureAccessor<CreeperArmature> CREEPER = ArmatureAccessor.create("epicfight", "entity/creeper", CreeperArmature::new);
    public static final ArmatureAccessor<EndermanArmature> ENDERMAN = ArmatureAccessor.create("epicfight", "entity/enderman", EndermanArmature::new);
    public static final ArmatureAccessor<HumanoidArmature> SKELETON = ArmatureAccessor.create("epicfight", "entity/skeleton", HumanoidArmature::new);
    public static final ArmatureAccessor<SpiderArmature> SPIDER = ArmatureAccessor.create("epicfight", "entity/spider", SpiderArmature::new);
    public static final ArmatureAccessor<IronGolemArmature> IRON_GOLEM = ArmatureAccessor.create("epicfight", "entity/iron_golem", IronGolemArmature::new);
    public static final ArmatureAccessor<RavagerArmature> RAVAGER = ArmatureAccessor.create("epicfight", "entity/ravager", RavagerArmature::new);
    public static final ArmatureAccessor<VexArmature> VEX = ArmatureAccessor.create("epicfight", "entity/vex", VexArmature::new);
    public static final ArmatureAccessor<PiglinArmature> PIGLIN = ArmatureAccessor.create("epicfight", "entity/piglin", PiglinArmature::new);
    public static final ArmatureAccessor<HoglinArmature> HOGLIN = ArmatureAccessor.create("epicfight", "entity/hoglin", HoglinArmature::new);
    public static final ArmatureAccessor<DragonArmature> DRAGON = ArmatureAccessor.create("epicfight", "entity/dragon", DragonArmature::new);
    public static final ArmatureAccessor<WitherArmature> WITHER = ArmatureAccessor.create("epicfight", "entity/wither", WitherArmature::new);

    public static void registerEntityTypes() {
        Armatures.registerEntityTypeArmature(EntityType.CAVE_SPIDER, SPIDER);
        Armatures.registerEntityTypeArmature(EntityType.CREEPER, CREEPER);
        Armatures.registerEntityTypeArmature(EntityType.DROWNED, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.ENDERMAN, ENDERMAN);
        Armatures.registerEntityTypeArmature(EntityType.EVOKER, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.HOGLIN, HOGLIN);
        Armatures.registerEntityTypeArmature(EntityType.HUSK, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.IRON_GOLEM, IRON_GOLEM);
        Armatures.registerEntityTypeArmature(EntityType.PIGLIN_BRUTE, PIGLIN);
        Armatures.registerEntityTypeArmature(EntityType.PIGLIN, PIGLIN);
        Armatures.registerEntityTypeArmature(EntityType.PILLAGER, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.RAVAGER, RAVAGER);
        Armatures.registerEntityTypeArmature(EntityType.SKELETON, SKELETON);
        Armatures.registerEntityTypeArmature(EntityType.SPIDER, SPIDER);
        Armatures.registerEntityTypeArmature(EntityType.STRAY, SKELETON);
        Armatures.registerEntityTypeArmature(EntityType.VEX, VEX);
        Armatures.registerEntityTypeArmature(EntityType.VINDICATOR, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.WITCH, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.WITHER_SKELETON, SKELETON);
        Armatures.registerEntityTypeArmature(EntityType.ZOGLIN, HOGLIN);
        Armatures.registerEntityTypeArmature(EntityType.ZOMBIE, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.ZOMBIE_VILLAGER, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.ZOMBIFIED_PIGLIN, PIGLIN);
        Armatures.registerEntityTypeArmature(EntityType.PLAYER, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.ENDER_DRAGON, DRAGON);
        Armatures.registerEntityTypeArmature(EntityType.WITHER, WITHER);
        Armatures.registerEntityTypeArmature((EntityType)EpicFightEntityTypes.WITHER_SKELETON_MINION.get(), SKELETON);
        Armatures.registerEntityTypeArmature((EntityType)EpicFightEntityTypes.WITHER_GHOST_CLONE.get(), WITHER);
    }

    public static void reload(ResourceManager resourceManager) {
        Armatures.resourceManager = resourceManager;
        ACCESSORS.entrySet().removeIf(entry -> !((ArmatureAccessor)entry.getValue()).inRegistry);
        ARMATURES.clear();
    }

    public static void registerEntityTypeArmature(EntityType<?> entityType, AssetAccessor<? extends Armature> armatureAccessor) {
        ENTITY_TYPE_ARMATURE_MAPPER.put(entityType, armatureAccessor);
    }

    public static void registerEntityTypeArmatureByPreset(EntityType<?> entityType, String presetName) {
        EntityType presetEntityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)presetName));
        ENTITY_TYPE_ARMATURE_MAPPER.put(entityType, ENTITY_TYPE_ARMATURE_MAPPER.get(presetEntityType));
    }

    public static <A extends Armature> A getArmatureFor(EntityPatch<?> entitypatch) {
        return (A)ENTITY_TYPE_ARMATURE_MAPPER.get(entitypatch.getOriginal().getType()).get().deepCopy();
    }

    @Nullable
    public static <A extends Armature> AssetAccessor<A> get(ResourceLocation id) {
        return ACCESSORS.get(id);
    }

    public static <A extends Armature> AssetAccessor<A> getOrCreate(ResourceLocation id, ArmatureContructor<A> armatureConstructor) {
        return ACCESSORS.containsKey(id) ? (ArmatureAccessor<A>)ACCESSORS.get(id) : ArmatureAccessor.create(id, armatureConstructor, false);
    }

    public static <A extends Armature> Set<Pair<ResourceLocation, AssetAccessor<A>>> entry() {
        HashSet newset = Sets.newHashSet();
        for (AssetAccessor assetAccessor : ACCESSORS.values()) {
            try {
                AssetAccessor casted = assetAccessor;
                newset.add(Pair.of((Object)casted.registryName(), (Object)casted));
            }
            catch (ClassCastException classCastException) {}
        }
        return newset;
    }

    public static ResourceLocation wrapLocation(ResourceLocation rl) {
        return rl.getPath().matches("animmodels/.*\\.json") ? rl : ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)("animmodels/" + rl.getPath() + ".json"));
    }

    public record ArmatureAccessor<A extends Armature>(ResourceLocation registryName, ArmatureContructor<A> armatureConstructor, boolean inRegistry) implements AssetAccessor<A>
    {
        public static <A extends Armature> ArmatureAccessor<A> create(String namespaceId, String path, ArmatureContructor<A> armatureConstructor) {
            return ArmatureAccessor.create(ResourceLocation.fromNamespaceAndPath((String)namespaceId, (String)path), armatureConstructor, true);
        }

        private static <A extends Armature> ArmatureAccessor<A> create(ResourceLocation id, ArmatureContructor<A> armatureConstructor, boolean inRegistry) {
            ArmatureAccessor<A> accessor = new ArmatureAccessor<A>(id, armatureConstructor, inRegistry);
            ACCESSORS.put(id, accessor);
            return accessor;
        }

        @Override
        public A get() {
            if (ARMATURES.get(this) == null) {
                JsonAssetLoader jsonAssetLoader = new JsonAssetLoader(resourceManager, Armatures.wrapLocation(this.registryName()));
                ARMATURES.put(this, (Armature)jsonAssetLoader.loadArmature(this.armatureConstructor));
            }
            return (A)ARMATURES.get(this);
        }

        @Override
        public String toString() {
            return this.registryName.toString();
        }

        @Override
        public int hashCode() {
            return this.registryName.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ArmatureAccessor) {
                ArmatureAccessor armatureAccessor = (ArmatureAccessor)obj;
                return this.registryName.equals((Object)armatureAccessor.registryName());
            }
            if (obj instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)obj;
                return this.registryName.equals((Object)rl);
            }
            if (obj instanceof String) {
                String name = (String)obj;
                return this.registryName.toString().equals(name);
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface ArmatureContructor<T extends Armature> {
        public T invoke(String var1, int var2, Joint var3, Map<String, Joint> var4);
    }
}

