/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPAnimatorControl;
import yesman.epicfight.network.client.CPChangePlayerMode;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.network.client.CPHandleSkillData;
import yesman.epicfight.network.client.CPModifyEntityModelYRot;
import yesman.epicfight.network.client.CPPairingAnimationRegistry;
import yesman.epicfight.network.client.CPSetPlayerTarget;
import yesman.epicfight.network.client.CPSetStamina;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.network.client.CPUpdatePlayerInput;
import yesman.epicfight.network.common.BiDirectionalAnimationVariable;
import yesman.epicfight.network.common.BiDirectionalSyncAnimationPositionPacket;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.network.server.SPModifyPlayerData;
import yesman.epicfight.network.server.SPSetRemotePlayerSkill;
import yesman.epicfight.network.server.SPUpdatePlayerInput;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public interface EpicFightServerBoundPayloadHandler {
    public static <T> void handleAnimationVariablePacket(BiDirectionalAnimationVariable data, IPayloadContext context) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)context.player(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            data.commonProcess((LivingEntityPatch<?>)playerpatch);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(data, playerpatch.getOriginal(), new CustomPacketPayload[0]);
        });
    }

    public static void handleAnimatorControl(CPAnimatorControl data, IPayloadContext context) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)context.player(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            if (!data.isClientOnly()) {
                data.animationVariables().forEach(animationVariable -> EpicFightServerBoundPayloadHandler.handleAnimationVariablePacket(animationVariable, context));
                data.commonProcess((LivingEntityPatch<?>)playerpatch);
            }
            SPAnimatorControl payload = new SPAnimatorControl(data.action(), data.animation(), ((ServerPlayer)playerpatch.getOriginal()).getId(), data.transitionTimeModifier(), data.pause());
            payload.animationVariables().addAll(data.animationVariables());
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(payload, playerpatch.getOriginal(), new CustomPacketPayload[0]);
            if (data.responseToSender()) {
                payload.animationVariables().clear();
                EpicFightNetworkManager.sendToPlayer(payload, (ServerPlayer)playerpatch.getOriginal(), new CustomPacketPayload[0]);
            }
        });
    }

    public static void handleChangePlayerMode(CPChangePlayerMode data, IPayloadContext context) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)context.player(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            playerpatch.toMode(data.mode(), false);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(SPModifyPlayerData.setPlayerMode(((ServerPlayer)playerpatch.getOriginal()).getId(), playerpatch.getPlayerMode()), playerpatch.getOriginal(), new CustomPacketPayload[0]);
        });
    }

    public static void handleChangeSkill(CPChangeSkill data, IPayloadContext context) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)context.player(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            Skill skill = Skill.skillOrNull(data.skill());
            playerpatch.getSkill(data.skillSlot()).setSkill(skill);
            if (skill != null) {
                if (skill.getCategory().learnable()) {
                    playerpatch.getPlayerSkills().addLearnedSkill(skill);
                }
                if (data.consumeXp()) {
                    ((ServerPlayer)playerpatch.getOriginal()).giveExperienceLevels(-skill.getRequiredXp());
                } else if (!((ServerPlayer)playerpatch.getOriginal()).isCreative()) {
                    ((ServerPlayer)playerpatch.getOriginal()).getInventory().removeItem(((ServerPlayer)playerpatch.getOriginal()).getInventory().getItem(data.itemSlotIndex()));
                }
            }
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPSetRemotePlayerSkill(data.skillSlot(), ((ServerPlayer)playerpatch.getOriginal()).getId(), data.skill()), playerpatch.getOriginal(), new CustomPacketPayload[0]);
        });
    }

    public static void handlePairingAnimationRegistry(CPPairingAnimationRegistry data, IPayloadContext context) {
        AnimationManager.getInstance().validateClientAnimationRegistry(data, ((ServerPlayer)context.player()).connection);
    }

    public static void handleExecuteSkill(CPSkillRequest data, IPayloadContext context) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)context.player(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            SkillContainer skillContainer = playerpatch.getSkill(data.skillSlot());
            switch (data.workType()) {
                case CAST: {
                    skillContainer.requestCasting((ServerPlayerPatch)playerpatch, data.arguments());
                    break;
                }
                case CANCEL: {
                    skillContainer.requestCancel((ServerPlayerPatch)playerpatch, data.arguments());
                    break;
                }
                case HOLD_START: {
                    skillContainer.requestHold((ServerPlayerPatch)playerpatch, data.arguments());
                }
            }
        });
    }

    public static void handleModifyPlayerModelYRot(CPModifyEntityModelYRot data, IPayloadContext context) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)context.player(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            if (data.disable()) {
                playerpatch.disableModelYRot(false);
                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(SPModifyPlayerData.disablePlayerYRot(((ServerPlayer)playerpatch.getOriginal()).getId()), playerpatch.getOriginal(), new CustomPacketPayload[0]);
            } else {
                playerpatch.setModelYRot(data.modelYRot(), false);
                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(SPModifyPlayerData.setPlayerYRot(((ServerPlayer)playerpatch.getOriginal()).getId(), data.modelYRot()), playerpatch.getOriginal(), new CustomPacketPayload[0]);
            }
        });
    }

    public static void handleSkillData(CPHandleSkillData data, IPayloadContext context) {
        Player player = context.player();
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)player, PlayerPatch.class).ifPresent(playerpatch -> {
            SkillDataManager dataManager = playerpatch.getSkill(data.skillSlot()).getDataManager();
            Object value = ((SkillDataKey)data.skillDataKey().value()).decode((ByteBuf)data.buffer());
            dataManager.setDataRawtype(data.skillDataKey(), value);
        });
    }

    public static void handleSetPlayerTarget(CPSetPlayerTarget data, IPayloadContext context) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)context.player(), ServerPlayerPatch.class).ifPresent(entitypatch -> {
            Entity entity = ((ServerPlayer)entitypatch.getOriginal()).level().getEntity(data.targetEntityId());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                entitypatch.setAttackTarget(livingEntity);
            } else if (entity == null) {
                entitypatch.setAttackTarget(null);
            }
        });
    }

    public static void handleSetStamina(CPSetStamina data, IPayloadContext context) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)context.player(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            playerpatch.setStamina(data.consumption());
            if (data.resetActionTick()) {
                playerpatch.resetActionTick();
            }
        });
    }

    public static void handleUpdatePlayerInput(CPUpdatePlayerInput data, IPayloadContext context) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)context.player(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            playerpatch.dx = data.strafe();
            playerpatch.dz = data.forward();
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPUpdatePlayerInput(data.entityId(), data.forward(), data.strafe()), playerpatch.getOriginal(), new CustomPacketPayload[0]);
        });
    }

    public static void handleSyncAnimationPosition(BiDirectionalSyncAnimationPositionPacket data, IPayloadContext context) {
        Entity entity = context.player().level().getEntity(data.entityId());
        if (entity != null && entity instanceof Player) {
            Player player = (Player)entity;
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new BiDirectionalSyncAnimationPositionPacket(entity.getId(), data.elapsedTime(), data.position(), data.lerpSteps()), (Entity)player, new CustomPacketPayload[0]);
        }
    }
}

