/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.mover;

import net.minecraft.client.KeyMapping;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.neoevent.playerpatch.TakeDamageEvent;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.server.SPSkillFeedback;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.registry.entries.EpicFightSkillDataKeys;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.modules.ChargeableSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class DemolitionLeapSkill
extends Skill
implements ChargeableSkill {
    private AnimationManager.AnimationAccessor<? extends StaticAnimation> chargingAnimation = Animations.BIPED_DEMOLITION_LEAP_CHARGING;
    private AnimationManager.AnimationAccessor<? extends StaticAnimation> shootAnimation = Animations.BIPED_DEMOLITION_LEAP;

    public DemolitionLeapSkill(SkillBuilder<?> builder) {
        super(builder);
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.CLIENT)
    public void movementInputEvent(MovementInputUpdateEvent event, SkillContainer skillContainer) {
        if (skillContainer.getExecutor().isHoldingSkill(this)) {
            event.getInput().jumping = false;
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER, priority=1)
    public void takeDamagePost(TakeDamageEvent.Pre event, SkillContainer container) {
        if (event.getDamageSource().is(DamageTypeTags.IS_FALL) && container.getDataManager().getDataValue(EpicFightSkillDataKeys.PROTECT_NEXT_FALL).booleanValue()) {
            event.attachValueModifier(ValueModifier.multiplier(0.5f));
            container.getDataManager().setData(EpicFightSkillDataKeys.PROTECT_NEXT_FALL, false);
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void livingFall(LivingFallEvent event, SkillContainer skillContainer) {
        if (LevelUtil.calculateLivingEntityFallDamage(event.getEntity(), event.getDamageMultiplier(), event.getDistance()) == 0) {
            skillContainer.getDataManager().setData(EpicFightSkillDataKeys.PROTECT_NEXT_FALL, false);
        }
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executor) {
        return super.isExecutableState(executor) && ((Player)executor.getOriginal()).onGround();
    }

    @Override
    public void cancelOnClient(SkillContainer container, CompoundTag arguments) {
        super.cancelOnClient(container, arguments);
        container.getExecutor().resetHolding();
        container.getExecutor().playAnimationSynchronized(Animations.BIPED_IDLE, 0.0f);
    }

    @Override
    public void executeOnClient(SkillContainer container, CompoundTag arguments) {
        int ticks = arguments.getInt("rawChargingTicks");
        int modifiedTicks = (int)((double)7.4668f * Math.log10((float)ticks + 1.0f) / Math.log10(2.0));
        Vec3f jumpDirection = new Vec3f(0.0f, (float)modifiedTicks * 0.05f, 0.0f);
        float xRot = Mth.clamp((float)(70.0f + Mth.clamp((float)container.getExecutor().getCameraXRot(), (float)-90.0f, (float)0.0f)), (float)0.0f, (float)70.0f);
        jumpDirection.add(0.0f, xRot / 70.0f * 0.05f, 0.0f);
        jumpDirection.rotate(xRot, Vec3f.X_AXIS);
        jumpDirection.rotate(-container.getExecutor().getCameraYRot(), Vec3f.Y_AXIS);
        ((Player)container.getExecutor().getOriginal()).setDeltaMovement(jumpDirection.toDoubleVector());
        container.getExecutor().resetHolding();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void gatherHoldArguments(SkillContainer container, ControlEngine controlEngine, CompoundTag arguments) {
        controlEngine.setHoldingKey(SkillSlots.MOVER, this.getKeyMapping());
        container.getExecutor().startSkillHolding(this);
    }

    @Override
    public void startHolding(SkillContainer caster) {
        if (!caster.getExecutor().isLogicalClient()) {
            caster.getExecutor().playAnimationSynchronized(this.chargingAnimation, 0.0f);
        }
    }

    @Override
    public void onStopHolding(SkillContainer container, SPSkillFeedback feedback) {
        if (container.getExecutor().getSkillChargingTicks(1.0f) > (float)this.getAllowedMaxChargingTicks()) {
            feedback.setFeedbackType(SPSkillFeedback.FeedbackType.EXPIRED);
        } else {
            container.getExecutor().playSound((SoundEvent)EpicFightSounds.ROCKET_JUMP.get(), 1.0f, 0.0f, 0.0f);
            container.getExecutor().playSound((SoundEvent)EpicFightSounds.ENTITY_MOVE.get(), 1.0f, 0.0f, 0.0f);
            int accumulatedTicks = container.getExecutor().getChargingTicks();
            LevelUtil.circleSlamFracture(null, ((Player)container.getExecutor().getOriginal()).level(), ((Player)container.getExecutor().getOriginal()).position().subtract(0.0, 1.0, 0.0), (double)accumulatedTicks * 0.05, true, false, false);
            Vec3 entityEyepos = ((Player)container.getExecutor().getOriginal()).getEyePosition();
            ((HitParticleType)((Object)EpicFightParticles.AIR_BURST.get())).spawnParticleWithArgument(((ServerPlayer)container.getServerExecutor().getOriginal()).serverLevel(), entityEyepos.x, entityEyepos.y, entityEyepos.z, 0.0, 0.0, 2.0 + 0.05 * (double)container.getExecutor().getAccumulatedChargeTicks());
            container.getExecutor().playAnimationSynchronized(this.shootAnimation, 0.0f);
            feedback.arguments().putInt("rawChargingTicks", accumulatedTicks);
            container.getDataManager().setData(EpicFightSkillDataKeys.PROTECT_NEXT_FALL, true);
        }
    }

    @Override
    public int getAllowedMaxChargingTicks() {
        return 80;
    }

    @Override
    public int getMaxChargingTicks() {
        return 40;
    }

    @Override
    public int getMinChargingTicks() {
        return 12;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public KeyMapping getKeyMapping() {
        return EpicFightKeyMappings.MOVER_SKILL;
    }

    @Override
    public void holdTick(SkillContainer container) {
        int chargingTicks = container.getExecutor().getSkillChargingTicks();
        if (chargingTicks % 5 == 0 && container.getExecutor().getAccumulatedChargeTicks() < this.getMaxChargingTicks() && container.getExecutor().consumeForSkill((Skill)this, Skill.Resource.STAMINA, this.consumption)) {
            container.getExecutor().setChargingTicks(container.getExecutor().getChargingTicks() + 5);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.translatable((String)"attribute.name.epicfight.stamina.consume.tooltip"), (Component)Component.translatable((String)"attribute.name.epicfight.stamina_per_second.consume", (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.consumption), "0.25"}), SkillBookScreen.STAMINA_TEXTURE_INFO);
        return true;
    }
}

