/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.projectile;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import yesman.epicfight.world.capabilities.projectile.ProjectilePatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

public class DragonFireballPatch
extends ProjectilePatch<DragonFireball> {
    public DragonFireballPatch(DragonFireball original) {
        super(original);
    }

    @Override
    public void onJoinWorld(DragonFireball projectileEntity, EntityJoinLevelEvent event) {
        super.onJoinWorld(projectileEntity, event);
        this.impact = 1.0f;
        projectileEntity.accelerationPower *= 2.0;
    }

    @Override
    protected void setMaxStrikes(DragonFireball projectileEntity, int maxStrikes) {
    }

    @Override
    public boolean onProjectileImpact(ProjectileImpactEvent event) {
        EntityHitResult entityHitResult;
        Entity entity;
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult && !(entity = (entityHitResult = (EntityHitResult)hitResult).getEntity()).level().isClientSide() && !entity.is(event.getProjectile().getOwner())) {
            entity.hurt(entity.level().damageSources().indirectMagic((Entity)event.getProjectile(), event.getProjectile().getOwner()), 8.0f);
        }
        return false;
    }

    @Override
    public EpicFightDamageSource createEpicFightDamageSource() {
        return null;
    }
}

