/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.AnimationVariables;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.animation.types.MainFrameAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.TimePairList;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPSyncPlayerAnimationPosition;
import yesman.epicfight.network.server.SPSyncAnimationPosition;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class ActionAnimation
extends MainFrameAnimation {
    public static final AnimationVariables.SharedAnimationVariableKey<TransformSheet> ACTION_ANIMATION_COORD = AnimationVariables.shared(animator -> new TransformSheet(), false);
    public static final AnimationVariables.IndependentAnimationVariableKey<Vec3> BEGINNING_LOCATION = AnimationVariables.independent(animator -> ((LivingEntity)animator.getEntityPatch().getOriginal()).m_20182_(), true);
    public static final AnimationVariables.IndependentAnimationVariableKey<Float> INITIAL_LOOK_VEC_DOT = AnimationVariables.independent(animator -> Float.valueOf(1.0f), true);

    public ActionAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends ActionAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(transitionTime, Float.MAX_VALUE, accessor, armature);
    }

    public ActionAnimation(float transitionTime, float postDelay, AnimationManager.AnimationAccessor<? extends ActionAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, accessor, armature);
        this.stateSpectrumBlueprint.clear().newTimePair(0.0f, postDelay).addState(EntityState.MOVEMENT_LOCKED, true).addState(EntityState.UPDATE_LIVING_MOTION, false).addState(EntityState.CAN_BASIC_ATTACK, false).addState(EntityState.CAN_SKILL_EXECUTION, false).addState(EntityState.TURNING_LOCKED, true).newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.INACTION, true);
        this.addProperty(AnimationProperty.StaticAnimationProperty.FIXED_HEAD_ROTATION, true);
    }

    public ActionAnimation(float transitionTime, float postDelay, String path, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, path, armature);
        this.stateSpectrumBlueprint.clear().newTimePair(0.0f, postDelay).addState(EntityState.MOVEMENT_LOCKED, true).addState(EntityState.UPDATE_LIVING_MOTION, false).addState(EntityState.CAN_BASIC_ATTACK, false).addState(EntityState.CAN_SKILL_EXECUTION, false).addState(EntityState.TURNING_LOCKED, true).newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.INACTION, true);
        this.addProperty(AnimationProperty.StaticAnimationProperty.FIXED_HEAD_ROTATION, true);
    }

    @Override
    public void putOnPlayer(AnimationPlayer animationPlayer, LivingEntityPatch<?> entitypatch) {
        if (entitypatch.shouldMoveOnCurrentSide(this)) {
            MoveCoordFunctions.MoveCoordSetter moveCoordSetter = this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN).orElse(MoveCoordFunctions.RAW_COORD);
            moveCoordSetter.set(this, entitypatch, ((Animator)entitypatch.getAnimator()).getVariables().getOrDefaultSharedVariable(ACTION_ANIMATION_COORD));
        }
        super.putOnPlayer(animationPlayer, entitypatch);
    }

    protected void initCoordVariables(LivingEntityPatch<?> entitypatch) {
        Vec3 start = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
        if (entitypatch.getTarget() != null) {
            Vec3 targetTracePosition = entitypatch.getTarget().m_20182_();
            Vec3 toDestWorld = targetTracePosition.m_82546_(start);
            float dot = Mth.m_14036_((float)((float)toDestWorld.m_82541_().m_82526_(MathUtils.getVectorForRotation(0.0f, entitypatch.getYRot()))), (float)0.0f, (float)1.0f);
            ((Animator)entitypatch.getAnimator()).getVariables().put(INITIAL_LOOK_VEC_DOT, this.getAccessor(), Float.valueOf(dot));
        }
        ((Animator)entitypatch.getAnimator()).getVariables().put(BEGINNING_LOCATION, this.getAccessor(), start);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        entitypatch.cancelItemUse();
        super.begin(entitypatch);
        if (entitypatch.shouldMoveOnCurrentSide(this)) {
            entitypatch.beginAction(this);
            this.initCoordVariables(entitypatch);
            if (this.getProperty(AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT).orElse(false).booleanValue()) {
                ((LivingEntity)entitypatch.getOriginal()).m_20334_(0.0, ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82480_, 0.0);
                ((LivingEntity)entitypatch.getOriginal()).f_20900_ = 0.0f;
                ((LivingEntity)entitypatch.getOriginal()).f_20901_ = 0.0f;
                ((LivingEntity)entitypatch.getOriginal()).f_20902_ = 0.0f;
            }
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (this.getProperty(AnimationProperty.ActionAnimationProperty.REMOVE_DELTA_MOVEMENT).orElse(false).booleanValue()) {
            double gravity = this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false) != false ? 0.0 : ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82480_;
            ((LivingEntity)entitypatch.getOriginal()).m_20334_(0.0, gravity, 0.0);
        }
        this.move(entitypatch, this.getAccessor());
    }

    @Override
    public void linkTick(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> linkAnimation) {
        if (this.getProperty(AnimationProperty.ActionAnimationProperty.REMOVE_DELTA_MOVEMENT).orElse(false).booleanValue()) {
            double gravity = this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false) != false ? 0.0 : ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82480_;
            ((LivingEntity)entitypatch.getOriginal()).m_20334_(0.0, gravity, 0.0);
        }
        this.move(entitypatch, linkAnimation);
    }

    protected void move(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> animation) {
        if (!this.validateMovement(entitypatch, animation)) {
            return;
        }
        float elapsedTime = ((Animator)entitypatch.getAnimator()).getPlayerFor(this.getAccessor()).getElapsedTime();
        if (this.getState(EntityState.INACTION, entitypatch, elapsedTime).booleanValue()) {
            LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
            Vec3 vec3 = this.getCoordVector(entitypatch, animation);
            livingentity.m_6478_(MoverType.SELF, vec3);
            if (entitypatch.isLogicalClient()) {
                EpicFightNetworkManager.sendToServer(new CPSyncPlayerAnimationPosition(livingentity.m_19879_(), elapsedTime, livingentity.m_20182_(), animation.get().isLinkAnimation() ? 2 : 1));
            } else {
                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPSyncAnimationPosition(livingentity.m_19879_(), elapsedTime, livingentity.m_20182_(), animation.get().isLinkAnimation() ? 2 : 1), (Entity)livingentity, new Object[0]);
            }
        }
    }

    protected boolean validateMovement(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> animation) {
        if (!entitypatch.shouldMoveOnCurrentSide(this)) {
            return false;
        }
        if (animation.get().isLinkAnimation()) {
            if (!this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_ON_LINK).orElse(true).booleanValue()) {
                return false;
            }
            return this.shouldMove(0.0f);
        }
        return this.shouldMove(((Animator)entitypatch.getAnimator()).getPlayerFor(animation).getElapsedTime());
    }

    protected boolean shouldMove(float currentTime) {
        if (this.properties.containsKey(AnimationProperty.ActionAnimationProperty.MOVE_TIME)) {
            TimePairList moveTimes = this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_TIME).get();
            return moveTimes.isTimeInPairs(currentTime);
        }
        return true;
    }

    @Override
    public void modifyPose(DynamicAnimation animation, Pose pose, LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        if (this.getProperty(AnimationProperty.ActionAnimationProperty.COORD).isEmpty()) {
            this.correctRootJoint(animation, pose, entitypatch, time, partialTicks);
        }
        super.modifyPose(animation, pose, entitypatch, time, partialTicks);
    }

    public void correctRootJoint(DynamicAnimation animation, Pose pose, LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        JointTransform jt = pose.orElseEmpty("Root");
        Vec3f jointPosition = jt.translation();
        OpenMatrix4f toRootTransformApplied = entitypatch.getArmature().searchJointByName("Root").getLocalTransform().removeTranslation();
        OpenMatrix4f toOrigin = OpenMatrix4f.invert(toRootTransformApplied, null);
        Vec3f worldPosition = OpenMatrix4f.transform3v(toRootTransformApplied, jointPosition, null);
        worldPosition.x = 0.0f;
        worldPosition.y = this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false) != false && worldPosition.y > 0.0f ? 0.0f : worldPosition.y;
        worldPosition.z = 0.0f;
        OpenMatrix4f.transform3v(toOrigin, worldPosition, worldPosition);
        jointPosition.x = worldPosition.x;
        jointPosition.y = worldPosition.y;
        jointPosition.z = worldPosition.z;
    }

    @Override
    public void setLinkAnimation(AssetAccessor<? extends DynamicAnimation> fromAnimation, Pose startPose, boolean isOnSameLayer, float transitionTimeModifier, LivingEntityPatch<?> entitypatch, LinkAnimation dest) {
        dest.resetNextStartTime();
        float playTime = this.getPlaySpeed(entitypatch, dest);
        AnimationProperty.PlaybackSpeedModifier playSpeedModifier = ((StaticAnimation)this.getRealAnimation().get()).getProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER).orElse(null);
        if (playSpeedModifier != null) {
            playTime = playSpeedModifier.modify(this, entitypatch, playTime, 0.0f, playTime);
        }
        playTime = Math.abs(playTime) * 0.05f;
        float linkTime = transitionTimeModifier > 0.0f ? transitionTimeModifier + this.transitionTime : this.transitionTime;
        float totalTime = playTime * (float)((int)Math.ceil(linkTime / playTime));
        float nextStartTime = Math.max(0.0f, -transitionTimeModifier);
        dest.setNextStartTime(nextStartTime += totalTime - linkTime);
        dest.getTransfroms().clear();
        dest.setTotalTime(totalTime);
        dest.setConnectedAnimations(fromAnimation, this.getAccessor());
        Pose nextStartPose = this.getPoseByTime(entitypatch, nextStartTime, 1.0f);
        if (entitypatch.shouldMoveOnCurrentSide(this) && this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_ON_LINK).orElse(true).booleanValue()) {
            this.correctRawZCoord(entitypatch, nextStartPose, nextStartTime);
        }
        Map<String, JointTransform> data1 = startPose.getJointTransformData();
        Map<String, JointTransform> data2 = nextStartPose.getJointTransformData();
        HashSet<String> joint1 = new HashSet<String>(isOnSameLayer ? data1.keySet() : Set.of());
        HashSet<String> joint2 = new HashSet<String>(data2.keySet());
        if (entitypatch.isLogicalClient()) {
            JointMaskEntry entry = fromAnimation.get().getJointMaskEntry(entitypatch, false).orElse(null);
            JointMaskEntry entry2 = this.getJointMaskEntry(entitypatch, true).orElse(null);
            if (entry != null && entitypatch.isLogicalClient()) {
                joint1.removeIf(jointName -> entry.isMasked(((DynamicAnimation)fromAnimation.get()).getProperty(ClientAnimationProperties.LAYER_TYPE).orElse(Layer.LayerType.BASE_LAYER) == Layer.LayerType.BASE_LAYER ? entitypatch.getClientAnimator().currentMotion() : entitypatch.getClientAnimator().currentCompositeMotion(), (String)jointName));
            }
            if (entry2 != null && entitypatch.isLogicalClient()) {
                joint2.removeIf(jointName -> entry2.isMasked(this.getProperty(ClientAnimationProperties.LAYER_TYPE).orElse(Layer.LayerType.BASE_LAYER) == Layer.LayerType.BASE_LAYER ? entitypatch.getCurrentLivingMotion() : entitypatch.currentCompositeMotion, (String)jointName));
            }
        }
        joint1.addAll(joint2);
        if (linkTime != totalTime) {
            Pose pose = this.getPoseByTime(entitypatch, 0.0f, 0.0f);
            Map<String, JointTransform> poseData = pose.getJointTransformData();
            if (entitypatch.shouldMoveOnCurrentSide(this) && this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_ON_LINK).orElse(true).booleanValue()) {
                this.correctRawZCoord(entitypatch, pose, 0.0f);
            }
            for (String jointName2 : joint1) {
                Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, data1.getOrDefault(jointName2, JointTransform.empty())), new Keyframe(linkTime, poseData.getOrDefault(jointName2, JointTransform.empty())), new Keyframe(totalTime, data2.getOrDefault(jointName2, JointTransform.empty()))};
                TransformSheet sheet = new TransformSheet(keyframes);
                dest.getAnimationClip().addJointTransform(jointName2, sheet);
            }
        } else {
            for (String jointName3 : joint1) {
                Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, data1.getOrDefault(jointName3, JointTransform.empty())), new Keyframe(totalTime, data2.getOrDefault(jointName3, JointTransform.empty()))};
                TransformSheet sheet = new TransformSheet(keyframes);
                dest.getAnimationClip().addJointTransform(jointName3, sheet);
            }
        }
        this.getProperty(AnimationProperty.ActionAnimationProperty.COORD).ifPresent(coord -> {
            Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, JointTransform.empty()), new Keyframe(totalTime, coord.getKeyframes()[0].transform())};
            TransformSheet sheet = new TransformSheet(keyframes);
            dest.getTransfroms().put("Coord", sheet);
        });
        if (entitypatch.shouldMoveOnCurrentSide(this)) {
            MoveCoordFunctions.MoveCoordSetter moveCoordSetter = this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN).orElse(MoveCoordFunctions.RAW_COORD);
            moveCoordSetter.set(dest, entitypatch, ((Animator)entitypatch.getAnimator()).getVariables().getOrDefaultSharedVariable(ACTION_ANIMATION_COORD));
        }
    }

    public void correctRawZCoord(LivingEntityPatch<?> entitypatch, Pose pose, float poseTime) {
        JointTransform jt = pose.orElseEmpty("Root");
        if (this.getProperty(AnimationProperty.ActionAnimationProperty.COORD).isEmpty()) {
            TransformSheet coordTransform = this.getTransfroms().get("Root");
            jt.translation().add(0.0f, 0.0f, coordTransform.getInterpolatedTranslation((float)poseTime).z);
        }
    }

    public Vec3 getExpectedMovement(LivingEntityPatch<?> entitypatch, float elapseTime) {
        this.initCoordVariables(entitypatch);
        TransformSheet coordTransform = new TransformSheet();
        MoveCoordFunctions.MoveCoordSetter moveCoordSetter = this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN).orElse(MoveCoordFunctions.RAW_COORD);
        moveCoordSetter.set(this, entitypatch, coordTransform);
        MoveCoordFunctions.MoveCoordGetter moveGetter = this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_GET).orElse(MoveCoordFunctions.MODEL_COORD);
        Vec3f move = moveGetter.get(this, entitypatch, coordTransform, 0.0f, elapseTime);
        return move.toDoubleVector();
    }

    protected Vec3 getCoordVector(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> animation) {
        MoveCoordFunctions.MoveCoordSetter moveCoordsetter;
        AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(animation);
        TimePairList coordUpdateTime = this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_UPDATE_TIME).orElse(null);
        boolean inUpdateTime = coordUpdateTime == null || coordUpdateTime.isTimeInPairs(player.getElapsedTime());
        boolean getRawCoord = this.getProperty(AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(!inUpdateTime);
        TransformSheet transformSheet = ((Animator)entitypatch.getAnimator()).getVariables().getOrDefaultSharedVariable(ACTION_ANIMATION_COORD);
        MoveCoordFunctions.MoveCoordSetter moveCoordSetter = moveCoordsetter = getRawCoord ? MoveCoordFunctions.RAW_COORD : (MoveCoordFunctions.MoveCoordSetter)this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK).orElse(null);
        if (moveCoordsetter != null) {
            moveCoordsetter.set(animation.get(), entitypatch, transformSheet);
        }
        boolean hasNoGravity = ((LivingEntity)entitypatch.getOriginal()).m_20068_();
        boolean moveVertical = this.getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(this.getProperty(AnimationProperty.ActionAnimationProperty.COORD).isPresent());
        MoveCoordFunctions.MoveCoordGetter moveGetter = getRawCoord ? MoveCoordFunctions.MODEL_COORD : this.getProperty(AnimationProperty.ActionAnimationProperty.COORD_GET).orElse(MoveCoordFunctions.MODEL_COORD);
        Vec3f move = moveGetter.get(animation.get(), entitypatch, transformSheet, player.getPrevElapsedTime(), player.getElapsedTime());
        LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
        Vec3 motion = livingentity.m_20184_();
        this.getProperty(AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME).ifPresentOrElse(noGravityTime -> {
            if (noGravityTime.isTimeInPairs(((DynamicAnimation)animation.get()).isLinkAnimation() ? 0.0f : player.getElapsedTime())) {
                livingentity.m_20334_(motion.f_82479_, 0.0, motion.f_82481_);
            } else {
                move.y = 0.0f;
            }
        }, () -> {
            if (moveVertical && move.y > 0.0f && !hasNoGravity) {
                double gravity = livingentity.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22135_();
                livingentity.m_20334_(motion.f_82479_, motion.f_82480_ < 0.0 ? motion.f_82480_ + gravity : 0.0, motion.f_82481_);
            }
        });
        if (!moveVertical) {
            move.y = 0.0f;
        }
        if (inUpdateTime) {
            this.getProperty(AnimationProperty.ActionAnimationProperty.ENTITY_YROT_PROVIDER).ifPresent(entityYRotProvider -> {
                float yRot = entityYRotProvider.get((DynamicAnimation)animation.get(), entitypatch);
                entitypatch.setYRot(yRot);
            });
        }
        return move.toDoubleVector();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldPlayerMove(LocalPlayerPatch playerpatch) {
        return playerpatch.isLogicalClient();
    }
}

