/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.physics.bezier;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.Vec3;

public class CubicBezierCurve {
    private static final DoubleList MATRIX_CONSTANTS = new DoubleArrayList();

    private static void getBezierEquationCoefficients(DoubleList points, DoubleList aList, DoubleList bList) {
        int idx;
        DoubleArrayList results = new DoubleArrayList();
        int size = points.size();
        results.add(points.getDouble(0) + points.getDouble(1) * 2.0);
        for (int idx2 = 1; idx2 < size - 2; ++idx2) {
            results.add(points.getDouble(idx2) * 4.0 + points.getDouble(idx2 + 1) * 2.0);
        }
        results.add(points.getDouble(size - 2) * 8.0 + points.getDouble(size - 1));
        int storedConstsSize = MATRIX_CONSTANTS.size();
        int coordSize = results.size();
        if (storedConstsSize < coordSize - 1) {
            for (int i = 0; i < coordSize - 1 - storedConstsSize; ++i) {
                double lastConst = MATRIX_CONSTANTS.getDouble(MATRIX_CONSTANTS.size() - 1);
                MATRIX_CONSTANTS.add(1.0 / (4.0 - lastConst));
            }
        }
        DoubleArrayList convertedResults = new DoubleArrayList();
        for (idx = 0; idx < coordSize; ++idx) {
            if (idx == 0) {
                convertedResults.add(results.getDouble(idx) * 0.5);
                continue;
            }
            if (idx == coordSize - 1) {
                convertedResults.add((results.getDouble(idx) - 2.0 * convertedResults.getDouble(idx - 1)) / (7.0 - 2.0 * MATRIX_CONSTANTS.getDouble(idx - 1)));
                continue;
            }
            convertedResults.add((results.getDouble(idx) - convertedResults.getDouble(idx - 1)) / (4.0 - MATRIX_CONSTANTS.getDouble(idx - 1)));
        }
        for (idx = coordSize - 1; idx >= 0; --idx) {
            if (idx == coordSize - 1) {
                aList.add(0, convertedResults.getDouble(idx));
                continue;
            }
            aList.add(0, convertedResults.getDouble(idx) - aList.getDouble(0) * MATRIX_CONSTANTS.getDouble(idx));
        }
        for (int i = 0; i < coordSize; ++i) {
            if (i == coordSize - 1) {
                bList.add((aList.getDouble(i) + points.getDouble(i + 1)) * 0.5);
                continue;
            }
            bList.add(2.0 * points.getDouble(i + 1) - aList.getDouble(i + 1));
        }
    }

    private static double cubicBezier(double start, double end, double a, double b, double t) {
        return Math.pow(1.0 - t, 3.0) * start + 3.0 * t * Math.pow(1.0 - t, 2.0) * a + 3.0 * t * t * (1.0 - t) * b + t * t * t * end;
    }

    public static List<Vec3> getBezierInterpolatedPoints(List<Vec3> points, int interpolatedResults) {
        return CubicBezierCurve.getBezierInterpolatedPoints(points, 0, points.size() - 1, interpolatedResults);
    }

    public static List<Vec3> getBezierInterpolatedPoints(List<Vec3> points, int sliceBegin, int sliceEnd, int interpolatedResults) {
        if (points.size() < 3) {
            return null;
        }
        sliceBegin = Math.max(sliceBegin, 0);
        sliceEnd = Math.min(sliceEnd, points.size() - 1);
        int size = points.size();
        ArrayList interpolatedPoints = Lists.newArrayList();
        DoubleArrayList x = new DoubleArrayList();
        DoubleArrayList y = new DoubleArrayList();
        DoubleArrayList z = new DoubleArrayList();
        for (int idx = 0; idx < size; ++idx) {
            x.add(points.get((int)idx).f_82479_);
            y.add(points.get((int)idx).f_82480_);
            z.add(points.get((int)idx).f_82481_);
        }
        DoubleArrayList x_a = new DoubleArrayList();
        DoubleArrayList x_b = new DoubleArrayList();
        DoubleArrayList y_a = new DoubleArrayList();
        DoubleArrayList y_b = new DoubleArrayList();
        DoubleArrayList z_a = new DoubleArrayList();
        DoubleArrayList z_b = new DoubleArrayList();
        CubicBezierCurve.getBezierEquationCoefficients((DoubleList)x, (DoubleList)x_a, (DoubleList)x_b);
        CubicBezierCurve.getBezierEquationCoefficients((DoubleList)y, (DoubleList)y_a, (DoubleList)y_b);
        CubicBezierCurve.getBezierEquationCoefficients((DoubleList)z, (DoubleList)z_a, (DoubleList)z_b);
        for (int i = sliceBegin; i < sliceEnd; ++i) {
            if (!interpolatedPoints.isEmpty()) {
                interpolatedPoints.remove(interpolatedPoints.size() - 1);
            }
            Vec3 start = points.get(i);
            Vec3 end = points.get(i + 1);
            double x_av = x_a.getDouble(i);
            double x_bv = x_b.getDouble(i);
            double y_av = y_a.getDouble(i);
            double y_bv = y_b.getDouble(i);
            double z_av = z_a.getDouble(i);
            double z_bv = z_b.getDouble(i);
            for (int j = 0; j < interpolatedResults + 1; ++j) {
                double t = (double)j / (double)interpolatedResults;
                interpolatedPoints.add(new Vec3(CubicBezierCurve.cubicBezier(start.f_82479_, end.f_82479_, x_av, x_bv, t), CubicBezierCurve.cubicBezier(start.f_82480_, end.f_82480_, y_av, y_bv, t), CubicBezierCurve.cubicBezier(start.f_82481_, end.f_82481_, z_av, z_bv, t)));
            }
        }
        return interpolatedPoints;
    }

    static {
        MATRIX_CONSTANTS.add(0.5);
    }
}

