/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.client.physics.cloth.ClothSimulator;
import yesman.epicfight.api.physics.SimulationTypes;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.PatchedCapeLayer;
import yesman.epicfight.client.renderer.patched.layer.WearableItemLayer;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class EntitySnapshot<T extends LivingEntityPatch<?>> {
    private static final InteractionHand[] HANDS = InteractionHand.values();
    protected final T entitypatch;
    protected final RenderableFigure entityFigure;
    protected final OpenMatrix4f[] poseMatrices;
    protected final OpenMatrix4f modelMatrix;
    protected final Vec3 position;
    protected final List<RenderableFigure> armorMeshes;
    protected final List<Pair<InteractionHand, ItemStack>> handItems;
    protected final float yRot;
    protected final float heightHalf;

    public static EntitySnapshot<LivingEntityPatch<?>> captureLivingEntity(LivingEntityPatch<?> entitypatch) {
        if (ClientEngine.getInstance().renderEngine.hasRendererFor((Entity)entitypatch.getOriginal())) {
            return new EntitySnapshot(entitypatch);
        }
        return null;
    }

    public static PlayerSnapshot capturePlayer(AbstractClientPlayerPatch<?> playerpatch) {
        if (ClientEngine.getInstance().renderEngine.hasRendererFor((Entity)playerpatch.getOriginal())) {
            return new PlayerSnapshot(playerpatch);
        }
        return null;
    }

    public EntitySnapshot(T entitypatch) {
        LivingEntityRenderer vanillarenderer = (LivingEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)((LivingEntity)((EntityPatch)entitypatch).getOriginal()));
        PatchedEntityRenderer patchedrenderer = ClientEngine.getInstance().renderEngine.getEntityRenderer((Entity)((EntityPatch)entitypatch).getOriginal());
        AssetAccessor meshAccessor = patchedrenderer.getMeshProvider(entitypatch);
        ResourceLocation textureLocation = vanillarenderer.m_5478_((Entity)((LivingEntity)((EntityPatch)entitypatch).getOriginal()));
        if (textureLocation == null) {
            EpicFightMod.logAndStacktraceIfDevSide(Logger::warn, "No texture for " + ((EntityPatch)entitypatch).getOriginal(), NullPointerException::new, "No texture is provided by vanilla renderer " + vanillarenderer.getClass().getSimpleName());
        }
        if (meshAccessor == null || meshAccessor.isEmpty()) {
            EpicFightMod.logAndStacktraceIfDevSide(Logger::warn, "No mesh for " + ((EntityPatch)entitypatch).getOriginal(), NullPointerException::new, "No mesh is provided by patched renderer " + patchedrenderer.getClass().getSimpleName());
        }
        this.entityFigure = new RenderableFigure((Mesh)meshAccessor.get(), textureLocation);
        Pose pose = ((Animator)((LivingEntityPatch)entitypatch).getAnimator()).getPose(1.0f);
        patchedrenderer.setJointTransforms(entitypatch, ((LivingEntityPatch)entitypatch).getArmature(), pose, 1.0f);
        this.poseMatrices = ((LivingEntityPatch)entitypatch).getArmature().getPoseAsTransformMatrix(pose, false);
        this.modelMatrix = ((LivingEntityPatch)entitypatch).getModelMatrix(1.0f);
        ImmutableList.Builder builder = ImmutableList.builder();
        ((LivingEntity)((EntityPatch)entitypatch).getOriginal()).m_6168_().forEach(itemstack -> {
            if (!(itemstack.m_41720_() instanceof ArmorItem)) {
                return;
            }
            EquipmentSlot armorSlot = itemstack.getEquipmentSlot();
            SkinnedMesh armor = WearableItemLayer.getCachedModel(itemstack.m_41720_());
            ResourceLocation texture = WearableItemLayer.getArmorResource(entitypatch.getOriginal(), itemstack, armorSlot, null);
            if (armor != null) {
                builder.add((Object)new RenderableFigure(armor, texture));
            }
        });
        this.armorMeshes = builder.build();
        ImmutableList.Builder builder$2 = ImmutableList.builder();
        for (InteractionHand hand : HANDS) {
            ItemStack itemstack2 = ((LivingEntityPatch)entitypatch).getAdvancedHoldingItemStack(hand);
            if (itemstack2.m_41619_()) continue;
            builder$2.add((Object)Pair.of((Object)hand, (Object)itemstack2));
        }
        this.handItems = builder$2.build();
        this.position = ((LivingEntity)((EntityPatch)entitypatch).getOriginal()).m_20182_();
        this.yRot = Mth.m_14177_((float)((LivingEntityPatch)entitypatch).getYRot());
        this.heightHalf = ((LivingEntity)((EntityPatch)entitypatch).getOriginal()).m_20206_() * 0.5f;
        this.entitypatch = entitypatch;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffers, RenderType rendertype, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a) {
        if (this.entityFigure.mesh == null || this.entityFigure.texture == null) {
            return;
        }
        this.entityFigure.mesh.initialize();
        this.entityFigure.mesh.draw(poseStack, buffers, rendertype, drawingFunction, packedLight, r, g, b, a, OverlayTexture.f_118083_, ((LivingEntityPatch)this.entitypatch).getArmature(), this.poseMatrices);
        for (RenderableFigure armorFigures : this.armorMeshes) {
            armorFigures.mesh.initialize();
            armorFigures.mesh.draw(poseStack, buffers, rendertype, drawingFunction, packedLight, r, g, b, a, OverlayTexture.f_118083_, ((LivingEntityPatch)this.entitypatch).getArmature(), this.poseMatrices);
        }
    }

    public void renderTextured(PoseStack poseStack, MultiBufferSource buffers, Function<ResourceLocation, RenderType> rendertypeFunction, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a) {
        if (this.entityFigure.mesh == null || this.entityFigure.texture == null) {
            return;
        }
        this.entityFigure.mesh.initialize();
        this.entityFigure.mesh.draw(poseStack, buffers, rendertypeFunction.apply(this.entityFigure.texture), drawingFunction, packedLight, r, g, b, a, OverlayTexture.f_118083_, ((LivingEntityPatch)this.entitypatch).getArmature(), this.poseMatrices);
        for (RenderableFigure armorFigures : this.armorMeshes) {
            armorFigures.mesh.initialize();
            armorFigures.mesh.draw(poseStack, buffers, rendertypeFunction.apply(armorFigures.texture), drawingFunction, packedLight, r, g, b, a, OverlayTexture.f_118083_, ((LivingEntityPatch)this.entitypatch).getArmature(), this.poseMatrices);
        }
    }

    public void renderItems(PoseStack poseStack, MultiBufferSource buffers, RenderType rendertype, Mesh.DrawingFunction drawingFunction, int packedLight, float alpha) {
        for (Pair<InteractionHand, ItemStack> items : this.handItems) {
            ItemStack itemstack = (ItemStack)items.getSecond();
            if (!ClientEngine.getInstance().renderEngine.getItemRenderer(itemstack).appearedInAfterimage()) continue;
            poseStack.m_85836_();
            BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(itemstack, ((LivingEntity)((EntityPatch)this.entitypatch).getOriginal()).m_9236_(), (LivingEntity)((EntityPatch)this.entitypatch).getOriginal(), ((LivingEntity)((EntityPatch)this.entitypatch).getOriginal()).m_19879_() + ItemDisplayContext.THIRD_PERSON_RIGHT_HAND.ordinal());
            if (!bakedmodel.m_7521_()) {
                MathUtils.mulStack(poseStack, ClientEngine.getInstance().renderEngine.getItemRenderer(itemstack).getCorrectionMatrix((LivingEntityPatch<?>)this.entitypatch, (InteractionHand)items.getFirst(), this.poseMatrices));
                bakedmodel = ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)bakedmodel, (ItemDisplayContext)ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, (boolean)false);
                poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
                for (BakedModel model : bakedmodel.getRenderPasses(itemstack, true)) {
                    EntitySnapshot.renderModelLists(model, itemstack, packedLight, OverlayTexture.f_118083_, alpha, poseStack, buffers.m_6299_(rendertype), drawingFunction);
                }
            }
            poseStack.m_85849_();
        }
    }

    public OpenMatrix4f[] poseMatrices() {
        return this.poseMatrices;
    }

    public OpenMatrix4f getModelMatrix() {
        return this.modelMatrix;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getHeightHalf() {
        return this.heightHalf;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public static void renderModelLists(BakedModel pModel, ItemStack pStack, int pCombinedLight, int pCombinedOverlay, float alpha, PoseStack pPoseStack, VertexConsumer pBuffer, Mesh.DrawingFunction drawingFunction) {
        RandomSource randomsource = RandomSource.m_216327_();
        for (Direction direction : Direction.values()) {
            randomsource.m_188584_(42L);
            EntitySnapshot.renderQuadList(pPoseStack, pBuffer, pModel.m_213637_((BlockState)null, direction, randomsource), pStack, pCombinedLight, pCombinedOverlay, alpha, drawingFunction);
        }
        randomsource.m_188584_(42L);
        EntitySnapshot.renderQuadList(pPoseStack, pBuffer, pModel.m_213637_((BlockState)null, (Direction)null, randomsource), pStack, pCombinedLight, pCombinedOverlay, alpha, drawingFunction);
    }

    public static void renderQuadList(PoseStack pPoseStack, VertexConsumer pBuffer, List<BakedQuad> pQuads, ItemStack pItemStack, int pCombinedLight, int pCombinedOverlay, float alpha, Mesh.DrawingFunction drawingFunction) {
        boolean flag = !pItemStack.m_41619_();
        PoseStack.Pose posestack$pose = pPoseStack.m_85850_();
        for (BakedQuad bakedquad : pQuads) {
            int i = -1;
            if (flag && bakedquad.m_111304_()) {
                i = Minecraft.m_91087_().getItemColors().m_92676_(pItemStack, bakedquad.m_111305_());
            }
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            drawingFunction.putBulkData(posestack$pose, bakedquad, pBuffer, f, f1, f2, alpha, pCombinedLight, pCombinedOverlay, true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PlayerSnapshot
    extends EntitySnapshot<AbstractClientPlayerPatch<?>> {
        protected final Matrix4f localMatrix;
        protected final OpenMatrix4f[] unboundPoseMatrices;
        protected RenderableFigure capeFigure;

        public PlayerSnapshot(AbstractClientPlayerPatch<?> entitypatch) {
            super(entitypatch);
            PatchedLivingEntityRenderer patchedrenderer = (PatchedLivingEntityRenderer)ClientEngine.getInstance().renderEngine.getEntityRenderer((Entity)entitypatch.getOriginal());
            PoseStack poseStack = new PoseStack();
            patchedrenderer.mulPoseStack(poseStack, entitypatch.getArmature(), (LivingEntity)entitypatch.getOriginal(), entitypatch, 1.0f);
            this.localMatrix = poseStack.m_85850_().m_252922_();
            this.unboundPoseMatrices = new OpenMatrix4f[entitypatch.getArmature().getPoseMatrices().length];
            for (int i = 0; i < entitypatch.getArmature().getPoseMatrices().length; ++i) {
                this.unboundPoseMatrices[i] = new OpenMatrix4f(entitypatch.getArmature().getPoseMatrices()[i]);
            }
            if (((AbstractClientPlayer)entitypatch.getOriginal()).m_36170_(PlayerModelPart.CAPE) && ((AbstractClientPlayer)entitypatch.getOriginal()).m_108561_() != null) {
                entitypatch.getSimulator(SimulationTypes.CLOTH).ifPresent(clohtSimulator -> clohtSimulator.getRunningObject(ClothSimulator.PLAYER_CLOAK).ifPresent(clothObj -> {
                    ClothSimulator.ClothObject capturedClothObj = clothObj.captureMyself();
                    Function<Float, OpenMatrix4f> partialColliderTransformProvider = partialFrame -> {
                        Vec3 pos = ((AbstractClientPlayer)entitypatch.getOriginal()).m_20318_(partialFrame.floatValue());
                        float yRotLerp = Mth.m_14189_((float)partialFrame.floatValue(), (float)entitypatch.getYRotO(), (float)entitypatch.getYRot());
                        return OpenMatrix4f.createTranslation((float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).rotateDeg(180.0f - yRotLerp, Vec3f.Y_AXIS);
                    };
                    capturedClothObj.tick(entitypatch, partialColliderTransformProvider, 1.0f, entitypatch.getArmature(), this.unboundPoseMatrices);
                    this.capeFigure = new RenderableFigure(capturedClothObj, ((AbstractClientPlayer)entitypatch.getOriginal()).m_108561_());
                }));
            }
        }

        @Override
        public void render(PoseStack poseStack, MultiBufferSource buffers, RenderType rendertype, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a) {
            if (this.capeFigure != null) {
                PatchedCapeLayer.renderSimulatingCape(poseStack, buffers, rendertype, drawingFunction, (ClothSimulator.ClothObject)this.capeFigure.mesh, this.position.f_82479_, this.position.f_82480_, this.position.f_82481_, r, g, b, a, (AbstractClientPlayerPatch)this.entitypatch, this.unboundPoseMatrices, packedLight, this.localMatrix, this.yRot);
            }
            super.render(poseStack, buffers, rendertype, drawingFunction, packedLight, r, g, b, a);
        }

        @Override
        public void renderTextured(PoseStack poseStack, MultiBufferSource buffers, Function<ResourceLocation, RenderType> rendertypeFunction, Mesh.DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a) {
            super.renderTextured(poseStack, buffers, rendertypeFunction, drawingFunction, packedLight, r, g, b, a);
            if (this.capeFigure != null) {
                PatchedCapeLayer.renderSimulatingCape(poseStack, buffers, rendertypeFunction.apply(this.capeFigure.texture), drawingFunction, (ClothSimulator.ClothObject)this.capeFigure.mesh, this.position.f_82479_, this.position.f_82480_, this.position.f_82481_, r, g, b, a, (AbstractClientPlayerPatch)this.entitypatch, this.unboundPoseMatrices, packedLight, this.localMatrix, this.yRot);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record RenderableFigure(Mesh mesh, ResourceLocation texture) {
    }
}

