/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.shader.compute.iris;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.vertices.IrisVertexFormats;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL20C;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.client.model.VertexBuilder;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.shader.compute.ComputeShaderSetup;
import yesman.epicfight.client.renderer.shader.compute.backend.buffers.DynamicSSBO;
import yesman.epicfight.client.renderer.shader.compute.backend.buffers.IArrayBufferProxy;
import yesman.epicfight.client.renderer.shader.compute.backend.buffers.OutputSSBO;
import yesman.epicfight.client.renderer.shader.compute.backend.buffers.StaticSSBO;
import yesman.epicfight.client.renderer.shader.compute.backend.program.ComputeProgram;
import yesman.epicfight.client.renderer.shader.compute.loader.ComputeShaderProvider;

@OnlyIn(value=Dist.CLIENT)
public class IrisComputeShaderSetup
implements ComputeShaderSetup {
    private final StaticSSBO<Float> uvsBO;
    private final StaticSSBO<ComputeShaderSetup.VertexObj> vObjBO;
    private final StaticSSBO<Integer> jointBO;
    private final StaticSSBO<Float> weightBO;
    private final StaticSSBO<ComputeShaderSetup.ElemInfo> elementsBO;
    private final StaticSSBO<Float> midUVBO;
    private final OutputSSBO outPos;
    private final OutputSSBO outNormal;
    private final OutputSSBO outColor;
    private final OutputSSBO outUv0;
    private final OutputSSBO outUv1;
    private final OutputSSBO outUv2;
    private final OutputSSBO outEntityId;
    private final OutputSSBO outTangent;
    private final IArrayBufferProxy hiddenFlagsBO;
    private final Integer[] hiddenFlags;
    private final int arrayObjectId;
    private final int vcount;

    public IrisComputeShaderSetup(SkinnedMesh skinnedMesh) {
        int i;
        HashMap<VertexBuilder, Integer> vertexBuilderMap = new HashMap<VertexBuilder, Integer>();
        ArrayList elements = new ArrayList();
        this.arrayObjectId = GlStateManager._glGenVertexArrays();
        int currentBoundVao = GlStateManager._getInteger((int)34229);
        int currentBoundVbo = GlStateManager._getInteger((int)34966);
        GlStateManager._glBindVertexArray((int)this.arrayObjectId);
        ArrayList uvList = Lists.newArrayList();
        this.hiddenFlags = new Integer[(skinnedMesh.getAllParts().size() + 31) / 32];
        this.hiddenFlagsBO = ComputeShaderProvider.createDynamicBuffer(this.hiddenFlags, 1, (v, b) -> b.put(Float.intBitsToFloat(v)));
        MutableInt partIdx = new MutableInt(0);
        skinnedMesh.getAllParts().forEach(skinnedMeshPart -> {
            skinnedMeshPart.initVBO(new ComputeShaderSetup.PartBuffer(skinnedMeshPart.getVertices(), vertexBuilderMap, skinnedMesh.uvs(), uvList, elements, partIdx.intValue()));
            partIdx.add(1);
        });
        Object[] vertexObjs = new ComputeShaderSetup.VertexObj[vertexBuilderMap.size()];
        ArrayList jointList = new ArrayList();
        ArrayList weightList = new ArrayList();
        vertexBuilderMap.forEach((arg_0, arg_1) -> IrisComputeShaderSetup.lambda$new$2(jointList, skinnedMesh, weightList, (ComputeShaderSetup.VertexObj[])vertexObjs, arg_0, arg_1));
        ArrayList midUVList = Lists.newArrayList();
        float[] midUVs = new float[elements.size() / 3 * 2];
        this.vcount = elements.size();
        for (i = 0; i < elements.size(); ++i) {
            int vertPoolIdx = ((ComputeShaderSetup.ElemInfo)elements.get(i)).poolId();
            float u = ((Float)uvList.get(vertPoolIdx * 2)).floatValue();
            float v2 = ((Float)uvList.get(vertPoolIdx * 2 + 1)).floatValue();
            int faceIdx = i / 3;
            if (i % 3 == 0) {
                midUVs[faceIdx * 2] = u / 3.0f;
                midUVs[faceIdx * 2 + 1] = v2 / 3.0f;
                continue;
            }
            int n = faceIdx * 2;
            midUVs[n] = midUVs[n] + u / 3.0f;
            int n2 = faceIdx * 2 + 1;
            midUVs[n2] = midUVs[n2] + v2 / 3.0f;
        }
        for (i = 0; i < elements.size(); ++i) {
            int faceIdx = i / 3;
            midUVList.add(Float.valueOf(midUVs[faceIdx * 2]));
            midUVList.add(Float.valueOf(midUVs[faceIdx * 2 + 1]));
        }
        this.elementsBO = new StaticSSBO<ComputeShaderSetup.ElemInfo>(elements, 2, ComputeShaderSetup.ElemInfo::store);
        this.uvsBO = new StaticSSBO<Float>(uvList, 1, (v, b) -> b.put(v.floatValue()));
        this.midUVBO = new StaticSSBO<Float>(midUVList, 1, (v, b) -> b.put(v.floatValue()));
        this.vObjBO = new StaticSSBO<ComputeShaderSetup.VertexObj>(Lists.newArrayList((Object[])vertexObjs), 8, ComputeShaderSetup.VertexObj::store);
        this.jointBO = new StaticSSBO<Integer>(jointList, 1, (v, b) -> b.put(Float.intBitsToFloat(v)));
        this.weightBO = new StaticSSBO<Float>(weightList, 1, (v, b) -> b.put(v.floatValue()));
        this.outPos = new OutputSSBO(3, elements.size(), DynamicSSBO.DataMode.STREAM);
        this.outNormal = new OutputSSBO(1, elements.size(), DynamicSSBO.DataMode.STREAM);
        this.outColor = new OutputSSBO(4, elements.size(), DynamicSSBO.DataMode.STREAM);
        this.outUv0 = new OutputSSBO(2, elements.size(), DynamicSSBO.DataMode.STREAM);
        this.outUv1 = new OutputSSBO(1, elements.size(), DynamicSSBO.DataMode.STREAM);
        this.outUv2 = new OutputSSBO(1, elements.size(), DynamicSSBO.DataMode.STREAM);
        this.outEntityId = new OutputSSBO(2, elements.size(), DynamicSSBO.DataMode.STREAM);
        this.outTangent = new OutputSSBO(1, elements.size(), DynamicSSBO.DataMode.STREAM);
        GlStateManager._glBindVertexArray((int)currentBoundVao);
        GlStateManager._glBindBuffer((int)34962, (int)currentBoundVbo);
    }

    @Override
    public void bindBufferFormat(VertexFormat vertexFormat, int ... buffers) {
        ImmutableList elems = vertexFormat.m_86023_();
        for (int i = 0; i < elems.size(); ++i) {
            VertexFormatElement elem = (VertexFormatElement)elems.get(i);
            if (elem == DefaultVertexFormat.f_85804_) {
                ComputeShaderSetup.bindAttrPointer(buffers[0], 3, i, 5126);
                continue;
            }
            if (elem == DefaultVertexFormat.f_166849_) {
                ComputeShaderSetup.bindAttrPointer(buffers[3], 2, i, 5126);
                continue;
            }
            if (elem == DefaultVertexFormat.f_85805_) {
                GL15C.glBindBuffer((int)34962, (int)buffers[2]);
                GL20C.glVertexAttribPointer((int)i, (int)4, (int)5126, (boolean)true, (int)0, (long)0L);
                GL20C.glEnableVertexAttribArray((int)i);
                continue;
            }
            if (elem == DefaultVertexFormat.f_85809_) {
                GL15C.glBindBuffer((int)34962, (int)buffers[1]);
                GL20C.glVertexAttribPointer((int)i, (int)3, (int)5120, (boolean)true, (int)4, (long)0L);
                GL20C.glEnableVertexAttribArray((int)i);
                continue;
            }
            if (elem == DefaultVertexFormat.f_85807_) {
                ComputeShaderSetup.bindIntAttrPointer(buffers[4], 2, i, 5123, 0);
                continue;
            }
            if (elem == DefaultVertexFormat.f_85808_) {
                ComputeShaderSetup.bindIntAttrPointer(buffers[5], 2, i, 5123, 0);
                continue;
            }
            if (elem == IrisVertexFormats.ENTITY_ID_ELEMENT) {
                ComputeShaderSetup.bindIntAttrPointer(buffers[6], 3, i, 5123, 4);
                continue;
            }
            if (elem == IrisVertexFormats.MID_TEXTURE_ELEMENT) {
                ComputeShaderSetup.bindAttrPointer(buffers[7], 2, i, 5126);
                continue;
            }
            if (elem != IrisVertexFormats.TANGENT_ELEMENT) continue;
            GL15C.glBindBuffer((int)34962, (int)buffers[8]);
            GL20C.glVertexAttribPointer((int)i, (int)4, (int)5120, (boolean)false, (int)0, (long)0L);
            GL20C.glEnableVertexAttribArray((int)i);
        }
        GL15C.glBindBuffer((int)34962, (int)0);
    }

    @Override
    public void applyComputeShader(PoseStack poseStack, OpenMatrix4f partTransform, float r, float g, float b, float a, int overlay, int light, int jointCount) {
        ComputeProgram shader = ComputeShaderProvider.meshComputeIris;
        shader.useProgram();
        shader.getUniform("colorIn").uploadVec4(r, g, b, a);
        shader.getUniform("uv1In").uploadUnsignedInt(overlay);
        shader.getUniform("uv2In").uploadUnsignedInt(light);
        shader.getUniform("part_offset").uploadUnsignedInt(jointCount);
        shader.getUniform("entity_id_0").uploadUnsignedInt(this.getEntity() << 16 & 0xFFFF0000 | this.getBlock() & 0xFFFF);
        shader.getUniform("entity_id_1").uploadUnsignedInt(this.getItem() << 16);
        shader.getUniform("model_view_matrix").uploadMatrix4f(poseStack.m_85850_().m_252922_());
        shader.getUniform("normal_matrix").uploadMatrix3f(poseStack.m_85850_().m_252943_());
        ComputeShaderSetup.POSE_BO.bindBufferBase(0);
        this.elementsBO.bindBufferBase(1);
        this.vObjBO.bindBufferBase(2);
        this.jointBO.bindBufferBase(3);
        this.weightBO.bindBufferBase(4);
        this.uvsBO.bindBufferBase(5);
        this.outPos.bindBufferBase(6);
        this.outNormal.bindBufferBase(7);
        this.outColor.bindBufferBase(8);
        this.outUv0.bindBufferBase(9);
        this.outUv1.bindBufferBase(10);
        this.outUv2.bindBufferBase(11);
        this.outEntityId.bindBufferBase(12);
        this.outTangent.bindBufferBase(13);
        this.hiddenFlagsBO.bindBufferBase(14);
        int workGroupCount = (this.vcount / 3 + 128 - 1) / 128;
        shader.dispatch(workGroupCount, 1, 1);
        shader.waitBarriers();
        ComputeShaderSetup.POSE_BO.unbind();
        this.elementsBO.unbind();
        this.vObjBO.unbind();
        this.jointBO.unbind();
        this.weightBO.unbind();
        this.uvsBO.unbind();
        this.outPos.unbind();
        this.outNormal.unbind();
        this.outColor.unbind();
        this.outUv0.unbind();
        this.outUv1.unbind();
        this.outUv2.unbind();
        this.outEntityId.unbind();
        this.outTangent.unbind();
        this.hiddenFlagsBO.unbind();
    }

    @Override
    public void drawWithShader(SkinnedMesh skinnedMesh, PoseStack poseStack, MultiBufferSource buffers, RenderType renderType, int packedLight, float r, float g, float b, float a, int overlay, @Nullable Armature armature, OpenMatrix4f[] poses) {
        for (int i = 0; i < poses.length; ++i) {
            TOTAL_POSES[i].load(poses[i]);
            if (armature == null) continue;
            TOTAL_POSES[i].mulBack(armature.searchJointById(i).getToOrigin());
        }
        Arrays.fill((Object[])this.hiddenFlags, (Object)0);
        for (SkinnedMesh.SkinnedMeshPart part : skinnedMesh.getAllParts()) {
            OpenMatrix4f mat = part.getVanillaPartTransform();
            if (mat == null) {
                mat = OpenMatrix4f.IDENTITY;
            }
            TOTAL_POSES[poses.length + part.getPartVBO().partIdx()].load(mat);
            if (!part.isHidden()) continue;
            int flagPos = part.getPartVBO().partIdx() / 32;
            int flagOffset = part.getPartVBO().partIdx() % 32;
            int flag = this.hiddenFlags[flagPos];
            this.hiddenFlags[flagPos] = flag | (part.isHidden() ? 1 : 0) << flagOffset;
        }
        this.hiddenFlagsBO.updateAll();
        POSE_BO.updateFromTo(0, poses.length + skinnedMesh.getAllParts().size());
        int currentBoundVao = GlStateManager._getInteger((int)34229);
        int currentBoundVbo = GlStateManager._getInteger((int)34966);
        GlStateManager._glBindVertexArray((int)this.arrayObjectId);
        renderType.m_110185_();
        VertexFormat.Mode mode = renderType.m_173186_();
        ShaderInstance shader = RenderSystem.getShader();
        VertexFormat format = shader.m_173364_();
        this.bindBufferFormat(format, this.outPos.glSSBO, this.outNormal.glSSBO, this.outColor.glSSBO, this.outUv0.glSSBO, this.outUv1.glSSBO, this.outUv2.glSSBO, this.outEntityId.glSSBO, this.midUVBO.glSSBO, this.outTangent.glSSBO);
        ComputeShaderSetup.setShaderDefaultUniforms(shader, mode, Minecraft.m_91087_().m_91268_());
        shader.m_173363_();
        this.applyComputeShader(poseStack, null, r, g, b, a, overlay, packedLight, poses.length);
        GL20C.glUseProgram((int)RenderSystem.getShader().m_108943_());
        GL11C.glDrawArrays((int)VertexFormat.Mode.TRIANGLES.f_166946_, (int)0, (int)this.vcount);
        RenderSystem.getShader().m_173362_();
        renderType.m_110188_();
        if (buffers instanceof OutlineBufferSource) {
            OutlineBufferSource outlineBufferSource = (OutlineBufferSource)buffers;
            renderType.m_7280_().ifPresent(outlineRendertype -> {
                outlineRendertype.m_110185_();
                VertexFormat.Mode outlinemode = outlineRendertype.m_173186_();
                ShaderInstance outlineshader = RenderSystem.getShader();
                VertexFormat outlineformat = outlineshader.m_173364_();
                this.bindBufferFormat(outlineformat, this.outPos.glSSBO, this.outNormal.glSSBO, this.outColor.glSSBO, this.outUv0.glSSBO, this.outUv1.glSSBO, this.outUv2.glSSBO, this.outEntityId.glSSBO, this.midUVBO.glSSBO, this.outTangent.glSSBO);
                ComputeShaderSetup.setShaderDefaultUniforms(outlineshader, outlinemode, Minecraft.m_91087_().m_91268_());
                outlineshader.m_173363_();
                this.applyComputeShader(poseStack, null, (float)outlineBufferSource.f_109922_ / 255.0f, (float)outlineBufferSource.f_109923_ / 255.0f, (float)outlineBufferSource.f_109924_ / 255.0f, (float)outlineBufferSource.f_109925_ / 255.0f, overlay, packedLight, poses.length);
                GL20C.glUseProgram((int)RenderSystem.getShader().m_108943_());
                GL11C.glDrawArrays((int)VertexFormat.Mode.TRIANGLES.f_166946_, (int)0, (int)this.vcount);
                RenderSystem.getShader().m_173362_();
                outlineRendertype.m_110188_();
            });
        }
        format.m_86024_();
        GlStateManager._glBindVertexArray((int)currentBoundVao);
        GlStateManager._glBindBuffer((int)34962, (int)currentBoundVbo);
    }

    @Override
    public int vaoId() {
        return this.arrayObjectId;
    }

    @Override
    public int vertexCount() {
        return this.vcount;
    }

    @Override
    public void destroyBuffers() {
        this.uvsBO.close();
        this.vObjBO.close();
        this.jointBO.close();
        this.weightBO.close();
        this.elementsBO.close();
        this.midUVBO.close();
        this.outPos.close();
        this.outNormal.close();
        this.outColor.close();
        this.outUv0.close();
        this.outUv1.close();
        this.outUv2.close();
        this.outEntityId.close();
        this.outTangent.close();
        this.hiddenFlagsBO.close();
        RenderSystem.glDeleteVertexArrays((int)this.arrayObjectId);
    }

    public short getBlock() {
        return (short)CapturedRenderingState.INSTANCE.getCurrentRenderedBlockEntity();
    }

    public short getEntity() {
        return (short)CapturedRenderingState.INSTANCE.getCurrentRenderedEntity();
    }

    public short getItem() {
        return (short)CapturedRenderingState.INSTANCE.getCurrentRenderedItem();
    }

    private static /* synthetic */ void lambda$new$2(List jointList, SkinnedMesh skinnedMesh, List weightList, ComputeShaderSetup.VertexObj[] vertexObjs, VertexBuilder vb, Integer idx) {
        int startPos = jointList.size();
        for (int i = 0; i < skinnedMesh.affectingJointCounts()[vb.position]; ++i) {
            int jointIndex = skinnedMesh.affectingJointIndices()[vb.position][i];
            int weightIndex = skinnedMesh.affectingWeightIndices()[vb.position][i];
            float weight = skinnedMesh.weights()[weightIndex];
            jointList.add(jointIndex);
            weightList.add(Float.valueOf(weight));
        }
        vertexObjs[idx.intValue()] = new ComputeShaderSetup.VertexObj(skinnedMesh.positions()[vb.position * 3], skinnedMesh.positions()[vb.position * 3 + 1], skinnedMesh.positions()[vb.position * 3 + 2], skinnedMesh.normals()[vb.normal * 3], skinnedMesh.normals()[vb.normal * 3 + 1], skinnedMesh.normals()[vb.normal * 3 + 2], startPos, startPos + skinnedMesh.affectingJointCounts()[vb.position]);
    }
}

