/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.gameasset;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.asset.JsonAssetLoader;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.model.armature.CreeperArmature;
import yesman.epicfight.model.armature.DragonArmature;
import yesman.epicfight.model.armature.EndermanArmature;
import yesman.epicfight.model.armature.HoglinArmature;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.model.armature.IronGolemArmature;
import yesman.epicfight.model.armature.PiglinArmature;
import yesman.epicfight.model.armature.RavagerArmature;
import yesman.epicfight.model.armature.SpiderArmature;
import yesman.epicfight.model.armature.VexArmature;
import yesman.epicfight.model.armature.WitherArmature;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.entity.EpicFightEntities;

public class Armatures {
    public static final Armatures INSTANCE = new Armatures();
    private static ResourceManager resourceManager = null;
    private static final Map<ResourceLocation, ArmatureAccessor<? extends Armature>> ACCESSORS = Maps.newHashMap();
    private static final Map<ArmatureAccessor<? extends Armature>, Armature> ARMATURES = Maps.newHashMap();
    private static final Map<EntityType<?>, AssetAccessor<? extends Armature>> ENTITY_TYPE_ARMATURE_MAPPER = Maps.newHashMap();
    public static final ArmatureAccessor<HumanoidArmature> BIPED = ArmatureAccessor.create("epicfight", "entity/biped", HumanoidArmature::new);
    public static final ArmatureAccessor<CreeperArmature> CREEPER = ArmatureAccessor.create("epicfight", "entity/creeper", CreeperArmature::new);
    public static final ArmatureAccessor<EndermanArmature> ENDERMAN = ArmatureAccessor.create("epicfight", "entity/enderman", EndermanArmature::new);
    public static final ArmatureAccessor<HumanoidArmature> SKELETON = ArmatureAccessor.create("epicfight", "entity/skeleton", HumanoidArmature::new);
    public static final ArmatureAccessor<SpiderArmature> SPIDER = ArmatureAccessor.create("epicfight", "entity/spider", SpiderArmature::new);
    public static final ArmatureAccessor<IronGolemArmature> IRON_GOLEM = ArmatureAccessor.create("epicfight", "entity/iron_golem", IronGolemArmature::new);
    public static final ArmatureAccessor<RavagerArmature> RAVAGER = ArmatureAccessor.create("epicfight", "entity/ravager", RavagerArmature::new);
    public static final ArmatureAccessor<VexArmature> VEX = ArmatureAccessor.create("epicfight", "entity/vex", VexArmature::new);
    public static final ArmatureAccessor<PiglinArmature> PIGLIN = ArmatureAccessor.create("epicfight", "entity/piglin", PiglinArmature::new);
    public static final ArmatureAccessor<HoglinArmature> HOGLIN = ArmatureAccessor.create("epicfight", "entity/hoglin", HoglinArmature::new);
    public static final ArmatureAccessor<DragonArmature> DRAGON = ArmatureAccessor.create("epicfight", "entity/dragon", DragonArmature::new);
    public static final ArmatureAccessor<WitherArmature> WITHER = ArmatureAccessor.create("epicfight", "entity/wither", WitherArmature::new);

    public static void registerEntityTypes() {
        Armatures.registerEntityTypeArmature(EntityType.f_20554_, SPIDER);
        Armatures.registerEntityTypeArmature(EntityType.f_20558_, CREEPER);
        Armatures.registerEntityTypeArmature(EntityType.f_20562_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20566_, ENDERMAN);
        Armatures.registerEntityTypeArmature(EntityType.f_20568_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20456_, HOGLIN);
        Armatures.registerEntityTypeArmature(EntityType.f_20458_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20460_, IRON_GOLEM);
        Armatures.registerEntityTypeArmature(EntityType.f_20512_, PIGLIN);
        Armatures.registerEntityTypeArmature(EntityType.f_20511_, PIGLIN);
        Armatures.registerEntityTypeArmature(EntityType.f_20513_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20518_, RAVAGER);
        Armatures.registerEntityTypeArmature(EntityType.f_20524_, SKELETON);
        Armatures.registerEntityTypeArmature(EntityType.f_20479_, SPIDER);
        Armatures.registerEntityTypeArmature(EntityType.f_20481_, SKELETON);
        Armatures.registerEntityTypeArmature(EntityType.f_20491_, VEX);
        Armatures.registerEntityTypeArmature(EntityType.f_20493_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20495_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20497_, SKELETON);
        Armatures.registerEntityTypeArmature(EntityType.f_20500_, HOGLIN);
        Armatures.registerEntityTypeArmature(EntityType.f_20501_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20530_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20531_, PIGLIN);
        Armatures.registerEntityTypeArmature(EntityType.f_20532_, BIPED);
        Armatures.registerEntityTypeArmature(EntityType.f_20565_, DRAGON);
        Armatures.registerEntityTypeArmature(EntityType.f_20496_, WITHER);
        Armatures.registerEntityTypeArmature((EntityType)EpicFightEntities.WITHER_SKELETON_MINION.get(), SKELETON);
        Armatures.registerEntityTypeArmature((EntityType)EpicFightEntities.WITHER_GHOST_CLONE.get(), WITHER);
    }

    public static void reload(ResourceManager resourceManager) {
        Armatures.resourceManager = resourceManager;
        ACCESSORS.entrySet().removeIf(entry -> !((ArmatureAccessor)entry.getValue()).inRegistry);
        ARMATURES.clear();
    }

    public static void registerEntityTypeArmature(EntityType<?> entityType, AssetAccessor<? extends Armature> armatureAccessor) {
        ENTITY_TYPE_ARMATURE_MAPPER.put(entityType, armatureAccessor);
    }

    public static void registerEntityTypeArmatureByPreset(EntityType<?> entityType, String presetName) {
        EntityType presetEntityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.parse((String)presetName));
        ENTITY_TYPE_ARMATURE_MAPPER.put(entityType, ENTITY_TYPE_ARMATURE_MAPPER.get(presetEntityType));
    }

    public static <A extends Armature> A getArmatureFor(EntityPatch<?> entitypatch) {
        return (A)ENTITY_TYPE_ARMATURE_MAPPER.get(entitypatch.getOriginal().m_6095_()).get().deepCopy();
    }

    @Nullable
    public static <A extends Armature> AssetAccessor<A> get(ResourceLocation id) {
        return ACCESSORS.get(id);
    }

    public static <A extends Armature> AssetAccessor<A> getOrCreate(ResourceLocation id, ArmatureContructor<A> armatureConstructor) {
        return ACCESSORS.containsKey(id) ? (ArmatureAccessor<A>)ACCESSORS.get(id) : ArmatureAccessor.create(id, armatureConstructor, false);
    }

    public static <A extends Armature> Set<Pair<ResourceLocation, AssetAccessor<A>>> entry() {
        HashSet newset = Sets.newHashSet();
        for (AssetAccessor assetAccessor : ACCESSORS.values()) {
            try {
                AssetAccessor casted = assetAccessor;
                newset.add(Pair.of((Object)casted.registryName(), (Object)casted));
            }
            catch (ClassCastException classCastException) {}
        }
        return newset;
    }

    public static ResourceLocation wrapLocation(ResourceLocation rl) {
        return rl.m_135815_().matches("animmodels/.*\\.json") ? rl : ResourceLocation.fromNamespaceAndPath((String)rl.m_135827_(), (String)("animmodels/" + rl.m_135815_() + ".json"));
    }

    public record ArmatureAccessor<A extends Armature>(ResourceLocation registryName, ArmatureContructor<A> armatureConstructor, boolean inRegistry) implements AssetAccessor<A>
    {
        public static <A extends Armature> ArmatureAccessor<A> create(String namespaceId, String path, ArmatureContructor<A> armatureConstructor) {
            return ArmatureAccessor.create(ResourceLocation.fromNamespaceAndPath((String)namespaceId, (String)path), armatureConstructor, true);
        }

        private static <A extends Armature> ArmatureAccessor<A> create(ResourceLocation id, ArmatureContructor<A> armatureConstructor, boolean inRegistry) {
            ArmatureAccessor<A> accessor = new ArmatureAccessor<A>(id, armatureConstructor, inRegistry);
            ACCESSORS.put(id, accessor);
            return accessor;
        }

        @Override
        public A get() {
            if (ARMATURES.get(this) == null) {
                JsonAssetLoader jsonAssetLoader = new JsonAssetLoader(resourceManager, Armatures.wrapLocation(this.registryName()));
                ARMATURES.put(this, (Armature)jsonAssetLoader.loadArmature(this.armatureConstructor));
            }
            return (A)ARMATURES.get(this);
        }

        @Override
        public String toString() {
            return this.registryName.toString();
        }

        @Override
        public int hashCode() {
            return this.registryName.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ArmatureAccessor) {
                ArmatureAccessor armatureAccessor = (ArmatureAccessor)obj;
                return this.registryName.equals((Object)armatureAccessor.registryName());
            }
            if (obj instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)obj;
                return this.registryName.equals((Object)rl);
            }
            if (obj instanceof String) {
                String name = (String)obj;
                return this.registryName.toString().equals(name);
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface ArmatureContructor<T extends Armature> {
        public T invoke(String var1, int var2, Joint var3, Map<String, Joint> var4);
    }
}

