/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.Entity;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.network.common.AnimatorControlPacket;
import yesman.epicfight.server.commands.arguments.AnimationArgument;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class AnimatorCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"epicfight").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"animator").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"play").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"animation", (ArgumentType)AnimationArgument.animation()).executes(commandContext -> AnimatorCommand.playAnimation(EntityArgument.m_91461_((CommandContext)commandContext, (String)"targets"), AnimationArgument.getAnimation((CommandContext<CommandSourceStack>)commandContext, "animation"), 0.0f))).then(Commands.m_82129_((String)"transitionTimeModifier", (ArgumentType)FloatArgumentType.floatArg()).executes(commandContext -> AnimatorCommand.playAnimation(EntityArgument.m_91461_((CommandContext)commandContext, (String)"targets"), AnimationArgument.getAnimation((CommandContext<CommandSourceStack>)commandContext, "animation"), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"transitionTimeModifier")))))))).then(Commands.m_82127_((String)"soft_pause").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"paused", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> AnimatorCommand.softPause(EntityArgument.m_91461_((CommandContext)commandContext, (String)"targets"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"paused"))))))).then(Commands.m_82127_((String)"hard_pause").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"paused", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> AnimatorCommand.hardPause(EntityArgument.m_91461_((CommandContext)commandContext, (String)"targets"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"paused"))))))));
    }

    public static int playAnimation(Collection<? extends Entity> targetEntities, AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        int successEntityNum = 0;
        for (Entity entity : targetEntities) {
            LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
            if (entitypatch == null) continue;
            ++successEntityNum;
            entitypatch.playAnimationSynchronized(animation, transitionTimeModifier);
        }
        return successEntityNum;
    }

    public static int softPause(Collection<? extends Entity> targetEntities, boolean paused) {
        int successEntityNum = 0;
        for (Entity entity : targetEntities) {
            LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
            if (entitypatch == null) continue;
            ++successEntityNum;
            entitypatch.pauseAnimator(AnimatorControlPacket.Action.SOFT_PAUSE, paused);
        }
        return successEntityNum;
    }

    public static int hardPause(Collection<? extends Entity> targetEntities, boolean paused) {
        int successEntityNum = 0;
        for (Entity entity : targetEntities) {
            LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
            if (entitypatch == null) continue;
            ++successEntityNum;
            entitypatch.pauseAnimator(AnimatorControlPacket.Action.HARD_PAUSE, paused);
        }
        return successEntityNum;
    }
}

