/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.weaponinnate;

import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationVariables;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.SynchedAnimationVariableKeys;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.animation.types.grappling.GrapplingAttackAnimation;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BladeRushSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("444a1a6a-c2f1-11eb-8529-0242ac130003");
    private final List<AnimationManager.AnimationAccessor<? extends StaticAnimation>> comboAnimations = new ArrayList<AnimationManager.AnimationAccessor<? extends StaticAnimation>>(3);
    private final Map<EntityType<?>, AnimationManager.AnimationAccessor<? extends StaticAnimation>> tryAnimations;

    public static Builder createBladeRushBuilder() {
        Builder builder = (Builder)((SkillBuilder)new Builder().setCategory(SkillCategories.WEAPON_INNATE)).setResource(Skill.Resource.WEAPON_CHARGE);
        builder.putTryAnimation(EntityType.f_20501_, Animations.BLADE_RUSH_TRY).putTryAnimation(EntityType.f_20458_, Animations.BLADE_RUSH_TRY).putTryAnimation(EntityType.f_20562_, Animations.BLADE_RUSH_TRY).putTryAnimation(EntityType.f_20524_, Animations.BLADE_RUSH_TRY).putTryAnimation(EntityType.f_20481_, Animations.BLADE_RUSH_TRY).putTryAnimation(EntityType.f_20558_, Animations.BLADE_RUSH_TRY);
        return builder;
    }

    public BladeRushSkill(Builder builder) {
        super(builder);
        this.comboAnimations.add(Animations.BLADE_RUSH_COMBO1);
        this.comboAnimations.add(Animations.BLADE_RUSH_COMBO2);
        this.comboAnimations.add(Animations.BLADE_RUSH_COMBO3);
        this.tryAnimations = builder.tryAnimations;
    }

    @Override
    public FriendlyByteBuf gatherArguments(SkillContainer container, ControlEngine controlEngine) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeBoolean(true);
        return buf;
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            if (event.getDamageSource().getAnimation().idBetween(Animations.BLADE_RUSH_COMBO1, Animations.BLADE_RUSH_COMBO3) && this.tryAnimations.containsKey(event.getTarget().m_6095_())) {
                MobEffectInstance effectInstance = event.getTarget().m_21124_((MobEffect)EpicFightMobEffects.INSTABILITY.get());
                int amp = effectInstance == null ? 0 : effectInstance.m_19564_() + 1;
                event.getTarget().m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.INSTABILITY.get(), 100, amp));
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
    }

    @Override
    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        LivingEntity target = container.getExecutor().getTarget();
        boolean instaKill = false;
        if (target != null) {
            if (target.m_21023_((MobEffect)EpicFightMobEffects.INSTABILITY.get()) && target.m_21124_((MobEffect)EpicFightMobEffects.INSTABILITY.get()).m_19564_() >= 2) {
                instaKill = true;
            } else {
                LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)target, LivingEntityPatch.class);
                if (entitypatch != null && entitypatch.getEntityState().hurtLevel() > 1 && this.tryAnimations.containsKey(target.m_6095_())) {
                    instaKill = true;
                }
            }
        } else {
            return;
        }
        if (instaKill) {
            container.getDataManager().setData((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get(), 0);
            ((Animator)container.getExecutor().getAnimator()).getVariables().put((AnimationVariables.IndependentAnimationVariableKey)SynchedAnimationVariableKeys.TARGET_ENTITY.get(), Animations.BLADE_RUSH_TRY, target.m_19879_());
            container.getExecutor().playAnimationSynchronized(Animations.BLADE_RUSH_TRY, 0.0f);
        } else {
            int counter = (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get());
            AnimationManager.AnimationAccessor<? extends StaticAnimation> animation = this.comboAnimations.get(counter);
            container.getDataManager().setDataF((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get(), v -> (v + 1) % this.comboAnimations.size());
            ((Animator)container.getExecutor().getAnimator()).getVariables().put((AnimationVariables.IndependentAnimationVariableKey)SynchedAnimationVariableKeys.TARGET_ENTITY.get(), animation, target.m_19879_());
            container.getExecutor().playAnimationSynchronized(animation, 0.0f);
        }
        super.executeOnServer(container, args);
    }

    @Override
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List<Component> list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Each Strike:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Execution:");
        return list;
    }

    @Override
    public WeaponInnateSkill registerPropertiesToAnimation() {
        ((AttackAnimation)Animations.BLADE_RUSH_COMBO1.get()).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)Animations.BLADE_RUSH_COMBO2.get()).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)Animations.BLADE_RUSH_COMBO3.get()).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((GrapplingAttackAnimation)Animations.BLADE_RUSH_EXECUTE_BIPED.get()).phases[0].addProperties(((Map)this.properties.get(1)).entrySet());
        return this;
    }

    @Override
    public boolean checkExecuteCondition(SkillContainer container) {
        return container.getExecutor().getTarget() != null && container.getExecutor().getTarget().m_6084_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onScreen(LocalPlayerPatch playerpatch, float resolutionX, float resolutionY) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void validationFeedback(SkillContainer container) {
        Skill skill = container.getExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND).getInnateSkill(container.getExecutor(), ((Player)container.getExecutor().getOriginal()).m_21120_(InteractionHand.MAIN_HAND));
        if (this.equals(skill) && !this.checkExecuteCondition(container)) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"gui.epicfight.warn.no_target"), false);
        }
    }

    public static class Builder
    extends SkillBuilder<BladeRushSkill> {
        private final Map<EntityType<?>, AnimationManager.AnimationAccessor<? extends StaticAnimation>> tryAnimations = Maps.newHashMap();

        public Builder putTryAnimation(EntityType<?> entityType, AnimationManager.AnimationAccessor<? extends StaticAnimation> tryAnimation) {
            this.tryAnimations.put(entityType, tryAnimation);
            return this;
        }
    }
}

