/*
 * Decompiled with CFR 0.152.
 */
package pet.blahaj.highlandmod.effectsystem;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Set;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import pet.blahaj.highlandmod.effectsystem.EffectSettings;
import pet.blahaj.highlandmod.effectsystem.EffectTimer;
import pet.blahaj.highlandmod.effectsystem.HighlandEffect;
import pet.blahaj.highlandmod.effectsystem.SaveUtil;
import pet.blahaj.highlandmod.effectsystem.effects.BlockSwapper;
import pet.blahaj.highlandmod.effectsystem.effects.EntityDespawner;
import pet.blahaj.highlandmod.effectsystem.effects.FallingBlocks;
import pet.blahaj.highlandmod.effectsystem.effects.HostileSpawner;
import pet.blahaj.highlandmod.effectsystem.effects.InventoryShuffler;
import pet.blahaj.highlandmod.effectsystem.effects.ItemSpawner;
import pet.blahaj.highlandmod.effectsystem.effects.Passengers;
import pet.blahaj.highlandmod.effectsystem.effects.PassiveSpawner;
import pet.blahaj.highlandmod.effectsystem.effects.PotionEffects;
import pet.blahaj.highlandmod.effectsystem.effects.VelocityRandomizer;

public class EffectManager {
    public static boolean running = false;
    private static HashMap<String, EffectSettings> currentEffectSettings = new HashMap();

    public static void initialize_effects() {
        EffectManager.add(new VelocityRandomizer());
        EffectManager.add(new HostileSpawner());
        EffectManager.add(new PassiveSpawner());
        EffectManager.add(new ItemSpawner());
        EffectManager.add(new EntityDespawner());
        EffectManager.add(new InventoryShuffler());
        EffectManager.add(new BlockSwapper());
        EffectManager.add(new FallingBlocks());
        EffectManager.add(new PotionEffects());
        EffectManager.add(new Passengers());
        EffectManager.register_commands();
    }

    public static void set_effect_enabled(String name, boolean enabled) {
        EffectManager.get((String)name).enabled = enabled;
    }

    public static boolean get_effect_enabled(String name) {
        return EffectManager.get((String)name).enabled;
    }

    public static void set_effect_parameters(String name, float probability, float minDelay, float maxDelay) {
        EffectSettings settings = currentEffectSettings.get(name);
        settings.probability = probability;
        settings.minDelayTicks = (int)(minDelay * 20.0f);
        settings.maxDelayTicks = (int)(maxDelay * 20.0f);
    }

    public static boolean toggle_effect(String name) {
        EffectManager.set_effect_enabled(name, !EffectManager.get_effect_enabled(name));
        return EffectManager.get_effect_enabled(name);
    }

    public static EffectSettings get(String name) {
        return currentEffectSettings.get(name);
    }

    public static EffectTimer new_timer(String name) {
        return new EffectTimer(EffectManager.get(name));
    }

    private static void add(HighlandEffect effect) {
        EffectSettings settings = effect.load_settings();
        currentEffectSettings.put(settings.name, settings);
        effect.initialize();
    }

    private static void register_commands() {
        Set<String> effectNames = currentEffectSettings.keySet();
        DecimalFormat floatStringFormat = new DecimalFormat("0.0");
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"highlandPreset").requires(source -> source.method_9259(2));
            builder.then(class_2170.method_9247((String)"save").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                try {
                    SaveUtil.save_preset(name, currentEffectSettings);
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Saved preset!"), false);
                    return 1;
                }
                catch (IOException e) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Failed to save preset - file error :("), false);
                    return 0;
                }
            })));
            builder.then(class_2170.method_9247((String)"load").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                try {
                    SaveUtil.load_preset(name);
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Loaded preset!"), false);
                    return 1;
                }
                catch (IOException | ClassNotFoundException e) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Failed to load preset - are you sure it exists?"), false);
                    return 0;
                }
            })));
            dispatcher.register(builder);
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"highlandToggle").requires(source -> source.method_9259(2));
            for (String s : effectNames) {
                builder.then(class_2170.method_9247((String)s).executes(context -> {
                    boolean enabled = EffectManager.toggle_effect(s);
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Toggled \u00a79" + s + "\u00a77 (now " + (enabled ? "\u00a72enabled" : "\u00a74disabled") + "\u00a77)")), true);
                    return 1;
                }));
            }
            dispatcher.register(builder);
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"highlandStart").requires(source -> source.method_9259(2));
            builder.executes(context -> {
                running = true;
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Highland effects enabled!"), true);
                return 1;
            });
            dispatcher.register(builder);
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"highlandStop").requires(source -> source.method_9259(2));
            builder.executes(context -> {
                running = false;
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Highland effects disabled."), true);
                return 1;
            });
            dispatcher.register(builder);
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"highlandSettings").requires(source -> source.method_9259(2));
            for (String s : effectNames) {
                builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)s).then(class_2170.method_9244((String)"probability", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(class_2170.method_9244((String)"min delay", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).then(class_2170.method_9244((String)"max delay", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> {
                    float probability = FloatArgumentType.getFloat((CommandContext)context, (String)"probability");
                    float minDelay = FloatArgumentType.getFloat((CommandContext)context, (String)"min delay");
                    float maxDelay = FloatArgumentType.getFloat((CommandContext)context, (String)"max delay");
                    EffectManager.set_effect_parameters(s, probability, minDelay, maxDelay);
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Set parameters for \u00a79" + s + "\u00a77 (new parameters: \u00a76" + floatStringFormat.format(probability) + "\u00a77 probability per tick, \u00a76" + floatStringFormat.format(minDelay) + "\u00a77 min delay, \u00a76" + floatStringFormat.format(maxDelay) + "\u00a77 max delay)")), true);
                    return 1;
                }))))).executes(context -> {
                    EffectSettings instance = EffectManager.get(s);
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a79" + s + "\u00a77: " + (instance.enabled ? "\u00a72Enabled" : "\u00a74Disabled") + ". \u00a77Probability: \u00a76" + floatStringFormat.format(instance.probability) + "\u00a77, Min Delay: \u00a76" + floatStringFormat.format(instance.minDelayTicks / 20) + "\u00a77, Max Delay: \u00a76" + floatStringFormat.format(instance.maxDelayTicks / 20))), true);
                    return 1;
                }));
            }
            dispatcher.register(builder);
        });
    }
}

