/*
 * Decompiled with CFR 0.152.
 */
package pet.blahaj.highlandmod.effectsystem;

import java.util.Random;
import pet.blahaj.highlandmod.effectsystem.EffectManager;
import pet.blahaj.highlandmod.effectsystem.EffectSettings;

public class EffectTimer {
    public int delayCounter;
    public int delayTime;
    public static final Random random = new Random();
    public final EffectSettings settings;

    public EffectTimer(EffectSettings settings) {
        this.settings = settings;
        this.delayTime = this.delayCounter = random.nextInt(settings.minDelayTicks, settings.maxDelayTicks + 1);
    }

    public static float random() {
        return random.nextFloat();
    }

    public static float random(float min, float max) {
        if (max <= min) {
            return min;
        }
        return random.nextFloat(min, max);
    }

    public static int random_int(int bound) {
        if (bound <= 0) {
            return 0;
        }
        return random.nextInt(bound);
    }

    public static int random_int(int min, int max) {
        return random.nextInt(min, max + 1);
    }

    public boolean tick_and_check() {
        if (!this.settings.enabled || !EffectManager.running) {
            return false;
        }
        --this.delayCounter;
        if (this.delayCounter <= 0 && random.nextFloat() < this.settings.probability) {
            this.delayTime = this.delayCounter = random.nextInt(this.settings.minDelayTicks, this.settings.maxDelayTicks + 1);
            return true;
        }
        return false;
    }
}

