/*
 * Decompiled with CFR 0.152.
 */
package pet.blahaj.highlandmod.effectsystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.NoSuchElementException;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import pet.blahaj.highlandmod.effectsystem.EffectManager;
import pet.blahaj.highlandmod.effectsystem.EffectSettings;

public class SaveUtil {
    public static void save_preset(String name, HashMap<String, EffectSettings> settingsList) throws IOException {
        File file = new File("highland-presets/" + name + ".preset");
        SaveUtil.createFile(file);
        FileOutputStream of = new FileOutputStream(file);
        ObjectOutputStream os = new ObjectOutputStream(of);
        settingsList.forEach((key, value) -> {
            try {
                os.writeObject(new SettingContainer((String)key, (EffectSettings)value));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        os.close();
        of.close();
    }

    public static void load_preset(String name) throws IOException, ClassNotFoundException {
        FileInputStream fi = new FileInputStream("highland-presets/" + name + ".preset");
        ObjectInputStream os = new ObjectInputStream(fi);
        try {
            while (true) {
                SettingContainer setting = (SettingContainer)os.readObject();
                EffectManager.set_effect_parameters(setting.name, setting.settings.probability, (float)setting.settings.minDelayTicks / 20.0f, (float)setting.settings.maxDelayTicks / 20.0f);
                EffectManager.set_effect_enabled(setting.name, setting.settings.enabled);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            return;
        }
    }

    public static boolean createFile(File file) {
        try {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                return false;
            }
            if (file.createNewFile()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void copy_out_preset(String builtin_preset) throws IOException {
        InputStream is = SaveUtil.getResourceStream(new class_2960("highland", builtin_preset + ".preset"));
        if (is == null) {
            return;
        }
        File file = new File("highland-presets/" + builtin_preset + ".preset");
        SaveUtil.createFile(file);
        FileOutputStream of = new FileOutputStream(file);
        of.write(is.readAllBytes());
        of.close();
        is.close();
    }

    public static InputStream getResourceStream(class_2960 resource) {
        try {
            return ((class_3298)class_310.method_1551().method_1478().method_14486(resource).orElseThrow()).method_14482();
        }
        catch (IOException | NoSuchElementException e) {
            return null;
        }
    }

    record SettingContainer(String name, EffectSettings settings) implements Serializable
    {
    }
}

