/*
 * Decompiled with CFR 0.152.
 */
package pet.blahaj.highlandmod.effectsystem.effects;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import pet.blahaj.highlandmod.effectsystem.EffectManager;
import pet.blahaj.highlandmod.effectsystem.EffectSettings;
import pet.blahaj.highlandmod.effectsystem.EffectTimer;
import pet.blahaj.highlandmod.effectsystem.EffectUtils;
import pet.blahaj.highlandmod.effectsystem.HighlandEffect;

public class ItemSpawner
implements HighlandEffect {
    private EffectTimer itemSpawnTimer;

    @Override
    public EffectSettings load_settings() {
        return new EffectSettings("ItemSpawner", 0.1f, 0.5f, 11.0f);
    }

    @Override
    public void initialize() {
        this.itemSpawnTimer = EffectManager.new_timer("ItemSpawner");
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            if (this.itemSpawnTimer.tick_and_check()) {
                this.spawnItem(world);
            }
        });
    }

    private void spawnItem(class_3218 world) {
        class_1542 item = (class_1542)class_1299.field_6052.method_5883((class_1937)world);
        class_1799 stack = new class_1799((class_1935)((class_6880.class_6883)class_7923.field_41178.method_10240(class_5819.method_43053()).get()).comp_349(), (int)(Math.pow(EffectTimer.random(), 5.0) * 63.0) + 1);
        if (stack.method_7947() > stack.method_7914()) {
            stack.method_7939(stack.method_7914());
        }
        if (stack.method_41406((class_6880)class_1802.field_8574.method_40131()) || stack.method_41406((class_6880)class_1802.field_8436.method_40131()) || stack.method_41406((class_6880)class_1802.field_8150.method_40131())) {
            this.setPotionEffect(stack);
        }
        if ((double)EffectTimer.random() < 0.5) {
            this.setEnchantments(stack);
        }
        item.method_6979(stack);
        EffectUtils.updateSpawnPos(world, (class_1297)item, 5, 1, true);
        world.method_8649((class_1297)item);
    }

    private void setEnchantments(class_1799 stack) {
        List<class_1889> effects = this.createEnchantments(stack);
        for (class_1889 entry : effects) {
            stack.method_7978(entry.field_9093, entry.field_9094);
        }
    }

    private List<class_1889> createEnchantments(class_1799 stack) {
        int count = EffectTimer.random_int(1, 3);
        ArrayList<class_1889> effects = new ArrayList<class_1889>();
        ArrayList<class_1887> availableEffects = new ArrayList<class_1887>(class_7923.field_41176.method_10220().filter(enchant -> enchant.method_8192(stack)).toList());
        if (availableEffects.isEmpty()) {
            return effects;
        }
        for (int i = 0; i < count; ++i) {
            int level = EffectTimer.random_int(1, 9);
            class_1887 effect = (class_1887)availableEffects.get(EffectTimer.random_int(availableEffects.size()));
            availableEffects.remove(effect);
            effects.add(new class_1889(effect, level));
            if (availableEffects.isEmpty()) break;
        }
        return effects;
    }

    private void setPotionEffect(class_1799 stack) {
        class_1293[] effects = this.createPotionEffects();
        stack.method_7977(class_2561.method_30163((String)"\u00a79Highland Potion"));
        class_1844.method_8056((class_1799)stack, List.of(effects));
        class_2487 nbtCompound = stack.method_7911("display");
        class_2499 list = new class_2499();
        class_2519 text = class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_30163((String)"\u00a75\u00a7oHolds random powers...")));
        class_2519 textl2 = class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_30163((String)("\u00a7l\u00a76" + effects.length + " effects"))));
        list.add((Object)text);
        list.add((Object)textl2);
        nbtCompound.method_10566("Lore", (class_2520)list);
        stack.method_7948().method_10569("HideFlags", 32);
    }

    private class_1293[] createPotionEffects() {
        int count = EffectTimer.random_int(1, 5);
        class_1293[] effects = new class_1293[count];
        for (int i = 0; i < count; ++i) {
            class_1293 instance;
            int duration = EffectTimer.random_int(20, 1200);
            int level = EffectTimer.random_int(9);
            effects[i] = instance = new class_1293((class_1291)((class_6880.class_6883)class_7923.field_41174.method_10240(class_5819.method_43047()).get()).comp_349(), duration, level);
        }
        return effects;
    }
}

