/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.compat;

import appeng.api.config.Actionable;
import appeng.api.exceptions.FailedConnection;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergyGridProvider;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEColoredItemDefinition;
import appeng.api.util.DimensionalCoord;
import appeng.core.Api;
import appeng.core.api.definitions.ApiParts;
import cyb0124.curvy_pipes.common.BuiltInPipeItem;
import cyb0124.curvy_pipes.common.CommonHandler;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.IntConsumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class AEPlugin {
    private static native void addCable(int var0, int var1, String var2, Item var3, short var4);

    private static native void markBlock(World var0, int var1, int var2, int var3, int var4);

    public static void markBlock(IGridNode node) {
        DimensionalCoord loc = node.getGridBlock().getLocation();
        World level = loc.getWorld();
        if (loc.y < 0 || loc.y >= 256) {
            return;
        }
        AEPlugin.markBlock(level, System.identityHashCode(level), loc.x, loc.y, loc.z);
    }

    private static void addCable(int type, AEColor color, AEColoredItemDefinition item) {
        ItemStack stack = item.stack(color, 1);
        AEPlugin.addCable(type, color.whiteVariant, color.name(), stack.func_77973_b(), (short)stack.func_77960_j());
    }

    private static void addCables(int type, AEColoredItemDefinition item) {
        for (AEColor color : AEColor.values()) {
            AEPlugin.addCable(type, color, item);
        }
    }

    private static void addCables() {
        ApiParts parts = Api.INSTANCE.definitions().parts();
        ItemStack fiber = (ItemStack)parts.quartzFiber().maybeStack(1).get();
        AEPlugin.addCable(0, 0, "Transparent", fiber.func_77973_b(), (short)fiber.func_77960_j());
        AEPlugin.addCables(1, parts.cableGlass());
        AEPlugin.addCables(2, parts.cableCovered());
        AEPlugin.addCables(3, parts.cableSmart());
        AEPlugin.addCables(5, parts.cableDense());
        AEPlugin.addCables(4, parts.cableDenseCovered());
    }

    private static IGridNode addNode(WorldServer level, Item pipe, IntConsumer setOverlayIdx, byte capacity, short meta, boolean joint) {
        IGridNode node = new NodeOwner((WorldServer)level, (ItemStack)BuiltInPipeItem.INST.makeIcon((Item)pipe, (short)meta, (boolean)joint), (IntConsumer)setOverlayIdx, (GridFlags)(capacity == 0 ? GridFlags.CANNOT_CARRY : (capacity == 1 ? GridFlags.PREFERRED : GridFlags.DENSE_CAPACITY))).node;
        node.updateState();
        return node;
    }

    private static IGridNode[] addEnergyPair(WorldServer level, Item pipe, short meta) {
        ItemStack icon = BuiltInPipeItem.INST.makeIcon(pipe, meta, false);
        EnergyNodeOwner x = new EnergyNodeOwner(level, icon);
        EnergyNodeOwner y = new EnergyNodeOwner(level, icon);
        x.peer = y.node;
        y.peer = x.node;
        x.node.updateState();
        y.node.updateState();
        return new IGridNode[]{x.node, y.node};
    }

    private static void addNodeConn(IGridNode x, IGridNode y) {
        for (IGridConnection c : x.getConnections()) {
            if (c.a() != y && c.b() != y) continue;
            return;
        }
        try {
            Api.INSTANCE.createGridConnection(x, y);
        }
        catch (FailedConnection failedConnection) {
            // empty catch block
        }
    }

    private static void addBlockConn(IGridNode node, WorldServer level, int cx, int cz, int x, int y, int z, byte rawDir, boolean ext) {
        IPartHost host;
        Object tile = CommonHandler.getTile(level, cx, cz, x, y, z);
        if (tile instanceof IPartHost) {
            host = (IPartHost)tile;
            IPart part = host.getPart(ForgeDirection.VALID_DIRECTIONS[rawDir]);
            if (part == null) {
                part = host.getPart(ForgeDirection.UNKNOWN);
            }
            if (part != null) {
                IGridNode peer;
                IGridNode iGridNode = peer = ext ? part.getExternalFacingNode() : part.getGridNode();
                if (peer != null) {
                    AEPlugin.addNodeConn(node, peer);
                    return;
                }
            }
        }
        if (tile instanceof IGridHost) {
            host = (IGridHost)tile;
            IGridNode peer = host.getGridNode(ForgeDirection.VALID_DIRECTIONS[rawDir]);
            if (peer == null) {
                peer = host.getGridNode(ForgeDirection.UNKNOWN);
            }
            if (peer != null) {
                AEPlugin.addNodeConn(node, peer);
            }
        }
    }

    public static class EnergyNodeOwner
    extends NodeOwner
    implements IEnergyGridProvider {
        private IGridNode peer;
        private WeakReference<IEnergyGrid> lastSuccessful = null;

        private EnergyNodeOwner(WorldServer level, ItemStack icon) {
            super(level, icon, null, GridFlags.CANNOT_CARRY);
        }

        public double extractAEPower(double limit, Actionable mode, Set<IEnergyGrid> seen) {
            IEnergyGrid g;
            double total = 0.0;
            IEnergyGrid iEnergyGrid = g = this.lastSuccessful == null ? null : (IEnergyGrid)this.lastSuccessful.get();
            if (g != null && !seen.contains(g)) {
                double result = g.extractAEPower(limit - total, mode, seen);
                if (result < 1.0E-8) {
                    this.lastSuccessful = null;
                } else {
                    total += result;
                }
            }
            for (int i = 0; i != 2 && total < limit; ++i) {
                double result;
                g = (IEnergyGrid)(i == 0 ? this.node : this.peer).getGrid().getCache(IEnergyGrid.class);
                if (seen.contains(g) || (result = g.extractAEPower(limit - total, mode, seen)) < 1.0E-8) continue;
                this.lastSuccessful = new WeakReference<IEnergyGrid>(g);
                total += result;
            }
            return total;
        }

        public double injectAEPower(double remain, Actionable mode, Set<IEnergyGrid> seen) {
            for (int i = 0; i != 2 && remain > 0.0; ++i) {
                IEnergyGrid g = (IEnergyGrid)(i == 0 ? this.node : this.peer).getGrid().getCache(IEnergyGrid.class);
                if (seen.contains(g)) continue;
                remain = g.injectAEPower(remain, mode, seen);
            }
            return remain;
        }

        public double getEnergyDemand(double limit, Set<IEnergyGrid> seen) {
            double total = 0.0;
            for (int i = 0; i != 2 && total < limit; ++i) {
                IEnergyGrid g = (IEnergyGrid)(i == 0 ? this.node : this.peer).getGrid().getCache(IEnergyGrid.class);
                if (seen.contains(g)) continue;
                total += g.getEnergyDemand(limit - total, seen);
            }
            return total;
        }

        public boolean calculateInfiniteStore(boolean result, Set<IEnergyGrid> seen) {
            for (int i = 0; i != 2 && !result; ++i) {
                IEnergyGrid g = (IEnergyGrid)(i == 0 ? this.node : this.peer).getGrid().getCache(IEnergyGrid.class);
                if (seen.contains(g)) continue;
                result = g.calculateInfiniteStore(result, seen);
            }
            return result;
        }
    }

    public static class NodeOwner
    implements IGridBlock,
    IGridHost {
        private final EnumSet<GridFlags> flags;
        private final DimensionalCoord coord;
        private final ItemStack icon;
        private final IntConsumer setOverlayIdx;
        protected final IGridNode node;
        private int lastOverlayIdx;

        private NodeOwner(WorldServer level, ItemStack icon, IntConsumer setOverlayIdx, GridFlags flag) {
            this.flags = EnumSet.of(flag);
            this.coord = new DimensionalCoord((World)level, 0, -268435456, 0);
            this.icon = icon;
            this.setOverlayIdx = setOverlayIdx;
            this.node = Api.INSTANCE.createGridNode((IGridBlock)this);
        }

        private void updateOverlay() {
            if (this.setOverlayIdx == null) {
                return;
            }
            int overlayIdx = 0;
            IEnergyGrid energy = (IEnergyGrid)this.node.getGrid().getCache(IEnergyGrid.class);
            if (energy.isNetworkPowered()) {
                for (IGridConnection c : this.node.getConnections()) {
                    overlayIdx = Math.max(overlayIdx, c.getUsedChannels());
                }
            }
            if (this.lastOverlayIdx == overlayIdx) {
                return;
            }
            this.lastOverlayIdx = overlayIdx;
            this.setOverlayIdx.accept(overlayIdx);
        }

        @MENetworkEventSubscribe
        public void channelChanged(MENetworkChannelsChanged ignored) {
            this.updateOverlay();
        }

        @MENetworkEventSubscribe
        public void powerChanged(MENetworkPowerStatusChange ignored) {
            this.updateOverlay();
        }

        public double getIdlePowerUsage() {
            return 0.0;
        }

        public EnumSet<GridFlags> getFlags() {
            return this.flags;
        }

        public boolean isWorldAccessible() {
            return false;
        }

        public DimensionalCoord getLocation() {
            return this.coord;
        }

        public AEColor getGridColor() {
            return AEColor.Transparent;
        }

        public void onGridNotification(GridNotification notification) {
        }

        public void setNetworkStatus(IGrid grid, int count) {
        }

        public EnumSet<ForgeDirection> getConnectableSides() {
            return EnumSet.noneOf(ForgeDirection.class);
        }

        public IGridHost getMachine() {
            return this;
        }

        public void gridChanged() {
        }

        public ItemStack getMachineRepresentation() {
            return this.icon;
        }

        public IGridNode getGridNode(ForgeDirection location) {
            return this.node;
        }

        public AECableType getCableConnectionType(ForgeDirection location) {
            return AECableType.NONE;
        }

        public void securityBreak() {
        }
    }
}

