/*
 * Decompiled with CFR 0.152.
 */
package seasonsoflololoshkamod.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import seasonsoflololoshkamod.SeasonsOfLololoshkaModMod;
import seasonsoflololoshkamod.procedures.Air1Procedure;
import seasonsoflololoshkamod.procedures.Earst1Procedure;
import seasonsoflololoshkamod.procedures.Fire1Procedure;
import seasonsoflololoshkamod.procedures.Water1Procedure;
import seasonsoflololoshkamod.world.inventory.SpellbarMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpellbarButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SpellbarButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SpellbarButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SpellbarButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SpellbarButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SpellbarButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = SpellbarMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Air1Procedure.execute((LevelAccessor)world);
        }
        if (buttonID == 1) {
            Earst1Procedure.execute((LevelAccessor)world);
        }
        if (buttonID == 2) {
            Fire1Procedure.execute((LevelAccessor)world);
        }
        if (buttonID == 3) {
            Water1Procedure.execute((LevelAccessor)world);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SeasonsOfLololoshkaModMod.addNetworkMessage(SpellbarButtonMessage.class, SpellbarButtonMessage::buffer, SpellbarButtonMessage::new, SpellbarButtonMessage::handler);
    }
}

