/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.command;

import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.structure.grid.SpecialPointIds;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class MineCellsTeleportCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"minecells:tp").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)StringArgumentType.string()).suggests(MineCellsTeleportCommand.suggestDimension()).executes(MineCellsTeleportCommand.teleport(false, false, false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"to_exit", (ArgumentType)BoolArgumentType.bool()).executes(MineCellsTeleportCommand.teleport(false, false, true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(MineCellsTeleportCommand.teleport(true, false, true))).then(class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).executes(MineCellsTeleportCommand.teleport(true, true, true)))))));
    }

    private static Command<class_2168> teleport(boolean specifiedPlayer, boolean specifiedPosition, boolean specifiedToExit) {
        return ctx -> {
            boolean toExit;
            Optional<MineCellsDimension> dimensionType = MineCellsTeleportCommand.getDimensionFromString((CommandContext<class_2168>)ctx, "dimension");
            class_3222 player = specifiedPlayer ? class_2186.method_9315((CommandContext)ctx, (String)"player") : ((class_2168)ctx.getSource()).method_9207();
            class_2338 position = specifiedPosition ? class_2262.method_48299((CommandContext)ctx, (String)"position") : null;
            boolean bl = toExit = specifiedToExit && BoolArgumentType.getBool((CommandContext)ctx, (String)"to_exit");
            if (dimensionType.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9213(class_2561.method_30163((String)"Invalid dimension"));
                return 0;
            }
            dimensionType.get().teleportPlayer(player, ((class_2168)ctx.getSource()).method_9225(), position, toExit ? SpecialPointIds.EXIT : SpecialPointIds.ENTRANCE);
            return 0;
        };
    }

    public static Optional<MineCellsDimension> getDimensionFromString(CommandContext<class_2168> ctx, String key) {
        String dimension = StringArgumentType.getString(ctx, (String)key);
        MineCellsDimension dimensionType = null;
        for (MineCellsDimension type : MineCellsDimension.values()) {
            if (!type.key.method_29177().method_12832().equals(dimension)) continue;
            dimensionType = type;
            break;
        }
        if (dimensionType == null) {
            return Optional.empty();
        }
        return Optional.of(dimensionType);
    }

    public static SuggestionProvider<class_2168> suggestDimension() {
        return (ctx, builder) -> {
            for (MineCellsDimension type : MineCellsDimension.values()) {
                builder.suggest(type.key.method_29177().method_12832());
            }
            return builder.buildFuture();
        };
    }
}

