/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.block.portal;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.block.portal.DoorwayPortalBlockEntity;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.registry.MineCellsBlockEntities;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.screen.ScreenUtils;
import com.github.mim1q.minecells.util.ModelUtils;
import dev.mim1q.gimm1q.interpolation.Easing;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class DoorwayPortalBlock
extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 CLOSED = class_2746.method_11825((String)"closed");
    private static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 COLLISION_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    public final DoorwayType type;

    public DoorwayPortalBlock(class_4970.class_2251 settings, DoorwayType type) {
        super(settings);
        this.type = type;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING});
        builder.method_11667(new class_2769[]{CLOSED});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.method_8608()) {
            DoorwayPortalBlockEntity doorway;
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof DoorwayPortalBlockEntity && (doorway = (DoorwayPortalBlockEntity)entity).canEdit(player)) {
                ScreenUtils.openDoorwaySelectionScreen(pos, doorway.getOverridePos());
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5812;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return ModelUtils.rotateShape(class_2350.field_11043, (class_2350)state.method_11654((class_2769)FACING), SHAPE);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (context instanceof class_3727) {
            class_3727 entityShapeContext = (class_3727)context;
            class_1297 entity = entityShapeContext.method_32480();
            DoorwayPortalBlockEntity blockEntity = world.method_35230(pos, MineCellsBlockEntities.DOORWAY).orElse(null);
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (blockEntity != null && (!blockEntity.canPlayerEnter(player) || ((Boolean)state.method_11654((class_2769)CLOSED)).booleanValue())) {
                    return this.method_9530(state, world, pos, context);
                }
            }
        }
        return ModelUtils.rotateShape(class_2350.field_11043, (class_2350)state.method_11654((class_2769)FACING), COLLISION_SHAPE);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new DoorwayPortalBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (!((Boolean)state.method_11654((class_2769)CLOSED)).booleanValue()) {
                class_238 box = ModelUtils.rotateShape(class_2350.field_11043, (class_2350)state.method_11654((class_2769)FACING), COLLISION_SHAPE).method_1107().method_996(pos).method_1014(0.01);
                if (entity.method_5829().method_994(box) && entity instanceof class_3222) {
                    class_3222 player = (class_3222)entity;
                    class_2586 blockentity = world.method_8321(pos);
                    if (blockentity instanceof DoorwayPortalBlockEntity) {
                        DoorwayPortalBlockEntity doorway = (DoorwayPortalBlockEntity)blockentity;
                        doorway.teleportPlayer(player, serverWorld, this.type.dimension);
                    }
                }
            }
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_243 rotatedVector = class_243.method_24954((class_2382)direction.method_10170().method_10163());
        for (int i = 0; i < 3; ++i) {
            double dx = rotatedVector.method_10216() * (random.method_43058() * 1.4 - 0.7);
            double dy = random.method_43058() * 2.4 - 1.5;
            double dz = rotatedVector.method_10215() * (random.method_43058() * 1.4 - 0.7);
            class_243 particlePos = class_243.method_24953((class_2382)pos).method_1019(class_243.method_24954((class_2382)direction.method_10153().method_10163()).method_1021(0.48)).method_1031(dx, dy, dz);
            world.method_8406(MineCellsParticles.SPECKLE.get(this.type.color), particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, (random.method_43058() * 0.02 + 0.03) * (double)direction.method_10148(), random.method_43058() * 0.02 - 0.01, (random.method_43058() * 0.02 + 0.03) * (double)direction.method_10165());
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (entityWorld, entityPos, entityState, entity) -> {
            if (entityWorld.method_8510() % 5L == 0L && entity instanceof DoorwayPortalBlockEntity) {
                DoorwayPortalBlockEntity doorway = (DoorwayPortalBlockEntity)entity;
                if (entityWorld.method_8608()) {
                    Boolean closed = (Boolean)doorway.method_11010().method_11654((class_2769)CLOSED);
                    doorway.closedBarsAnimation.transitionTo(closed != false ? 1.0f : 0.0f, 10.0f, closed != false ? Easing::easeOutBounce : Easing::easeOutCubic);
                    return;
                }
                class_243 dir = class_243.method_24954((class_2382)((class_2350)entityState.method_11654((class_2769)FACING)).method_10163().method_35862(2));
                List players = entityWorld.method_8390(class_1657.class, class_238.method_30048((class_243)entityPos.method_46558(), (double)3.0, (double)2.0, (double)3.0).method_997(dir.method_1021(0.5)), it -> true);
                boolean closed = players.isEmpty() || players.stream().anyMatch(it -> !doorway.canPlayerEnter((class_1657)it));
                entityWorld.method_8501(entityPos, (class_2680)entityState.method_11657((class_2769)CLOSED, (Comparable)Boolean.valueOf(closed)));
            }
        };
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)mirror.method_10343((class_2350)state.method_11654((class_2769)FACING)));
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (world.method_8608()) {
            return;
        }
        if (newState.method_26204() instanceof DoorwayPortalBlock) {
            return;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        int x = facing.method_10170().method_10148();
        int z = facing.method_10170().method_10165();
        for (int xz = -1; xz <= 1; ++xz) {
            for (int y = -1; y <= 1; ++y) {
                world.method_22352(pos.method_10069(x * xz, y, z * xz), true);
            }
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        MineCellsBlocks.DOORWAY_FRAME.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List stacks = super.method_9560(state, builder);
        return stacks;
    }

    public static enum DoorwayType {
        OVERWORLD(MineCellsDimension.OVERWORLD, 9369965),
        PRISON(MineCellsDimension.PRISONERS_QUARTERS, 5566344),
        PROMENADE(MineCellsDimension.PROMENADE_OF_THE_CONDEMNED, 9699319),
        INSUFFERABLE_CRYPT(MineCellsDimension.INSUFFERABLE_CRYPT, 0xFF4CF4),
        RAMPARTS(MineCellsDimension.RAMPARTS, 16762176),
        BLACK_BRIDGE(MineCellsDimension.BLACK_BRIDGE, 6438089);

        public final MineCellsDimension dimension;
        public final class_2960 texture;
        public final class_2960 backgroundTexture;
        public final int color;

        private DoorwayType(MineCellsDimension dimension, int color) {
            this.dimension = dimension;
            this.texture = MineCells.createId("textures/block/doorway/" + dimension.key.method_29177().method_12832() + ".png");
            this.backgroundTexture = MineCells.createId("textures/block/doorway/" + dimension.key.method_29177().method_12832() + "_background.png");
            this.color = color;
        }
    }

    public static class Frame
    extends class_2248 {
        private static final class_2754<FillerType> TYPE = class_2754.method_11850((String)"type", FillerType.class);

        public Frame(class_4970.class_2251 settings) {
            super(settings);
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            super.method_9515(builder);
            builder.method_11667(new class_2769[]{FACING, TYPE});
        }

        public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            return ModelUtils.rotateShape(class_2350.field_11043, (class_2350)state.method_11654((class_2769)FACING), ((FillerType)((Object)state.method_11654(Frame.TYPE))).outlineShape);
        }

        public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            return ModelUtils.rotateShape(class_2350.field_11043, (class_2350)state.method_11654((class_2769)FACING), ((FillerType)((Object)state.method_11654(Frame.TYPE))).collisionShape);
        }

        public class_2680 getState(FillerType type, class_2350 direction) {
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction)).method_11657(TYPE, (Comparable)((Object)type));
        }

        public class_2680 method_9598(class_2680 state, class_2470 rotation) {
            return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
        }

        public class_2680 method_9569(class_2680 state, class_2415 mirror) {
            return (class_2680)state.method_11657((class_2769)FACING, (Comparable)mirror.method_10343((class_2350)state.method_11654((class_2769)FACING)));
        }

        public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
            if (MineCellsDimension.of(world) == MineCellsDimension.OVERWORLD && sourcePos.equals((Object)pos.method_10059(((class_2350)state.method_11654((class_2769)FACING)).method_10163())) && !world.method_8320(sourcePos).method_26206((class_1922)world, sourcePos, (class_2350)state.method_11654((class_2769)FACING))) {
                this.method_9585((class_1936)world, pos, state);
                world.method_22352(pos, true);
            }
        }

        public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
            super.method_9536(state, world, pos, newState, moved);
            if (world.method_8608()) {
                return;
            }
            class_2338 breakPos = this.getBreakPos(state, pos);
            world.method_8320(breakPos).method_26204().method_9585((class_1936)world, breakPos, world.method_8320(breakPos));
            world.method_22352(breakPos, true);
        }

        public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
            class_2338 portalPos = this.getBreakPos(state, pos);
            class_2680 portal = world.method_8320(portalPos);
            if (portal.method_26204() instanceof DoorwayPortalBlock || portal.method_26204() instanceof Frame) {
                return portal.method_26204().method_9534(portal, world, portalPos, player, hand, hit);
            }
            return class_1269.field_5811;
        }

        private class_2338 getBreakPos(class_2680 state, class_2338 pos) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
            class_2382 offset = ((FillerType)((Object)state.method_11654(Frame.TYPE))).breakOffset;
            int x = direction.method_10160().method_10148();
            int z = direction.method_10160().method_10165();
            return pos.method_10069(offset.method_10263() * x, offset.method_10264(), offset.method_10263() * z);
        }

        public static enum FillerType implements class_3542
        {
            MIDDLE(SHAPE, COLLISION_SHAPE, "middle", new class_2382(0, 1, 0)),
            RIGHT(class_2248.method_9541((double)4.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0), "right", new class_2382(-1, 0, 0)),
            LEFT(class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0), class_2248.method_9541((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0), "left", new class_2382(1, 0, 0)),
            TOP_RIGHT(class_2248.method_9541((double)4.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0), (class_265)class_2248.method_9541((double)12.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0)), "top_right", new class_2382(-1, 0, 0)),
            TOP_LEFT(class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0), class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0), (class_265)class_2248.method_9541((double)0.0, (double)8.0, (double)8.0, (double)4.0, (double)16.0, (double)16.0)), "top_left", new class_2382(1, 0, 0)),
            TOP(SHAPE, class_2248.method_9541((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), "top", new class_2382(0, -1, 0));

            public final class_265 outlineShape;
            public final class_265 collisionShape;
            private final String name;
            private final class_2382 breakOffset;

            private FillerType(class_265 outlineShape, class_265 collisionShape, String name, class_2382 breakOffset) {
                this.outlineShape = outlineShape;
                this.collisionShape = collisionShape;
                this.name = name;
                this.breakOffset = breakOffset;
            }

            public String method_15434() {
                return this.name;
            }
        }
    }
}

