/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.cc;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.util.MathUtils;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.scoreboard.ScoreboardComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.scoreboard.ScoreboardComponentInitializer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;

public class MineCellsLevelCC
implements ScoreboardComponentInitializer {
    public static final ComponentKey<PortalsCC> PORTALS = ComponentRegistry.getOrCreate((class_2960)MineCells.createId("portals"), PortalsCC.class);
    public static final ComponentKey<OverworldEntriesCC> OVERWORLD_ENTRIES = ComponentRegistry.getOrCreate((class_2960)MineCells.createId("overworld_entries"), OverworldEntriesCC.class);

    public void registerScoreboardComponentFactories(ScoreboardComponentFactoryRegistry registry) {
        registry.registerScoreboardComponent(PORTALS, PortalsCC::new);
        registry.registerScoreboardComponent(OVERWORLD_ENTRIES, (sb, sv) -> new OverworldEntriesCC());
    }

    public static class OverworldEntriesCC
    implements Component {
        private final HashMap<UUID, Data> entries = new HashMap();

        public static Optional<Data> getPlayerEntrancePoint(class_3222 player, class_2338 pos, class_3218 world) {
            OverworldEntriesCC entries = (OverworldEntriesCC)OVERWORLD_ENTRIES.get((Object)world.method_14170());
            Data entry = entries.entries.get(player.method_5667());
            if (entry == null || !entry.entrancePos.equals((Object)pos)) {
                return Optional.empty();
            }
            return Optional.of(entry);
        }

        public static void setPlayerEntrancePoint(class_3222 player, class_2338 portalPos, class_2338 entrancePos, float entranceRot, class_3218 world) {
            OverworldEntriesCC entries = (OverworldEntriesCC)OVERWORLD_ENTRIES.get((Object)world.method_14170());
            entries.entries.put(player.method_5667(), new Data(portalPos, entrancePos, entranceRot));
        }

        public static class_3545<class_2338, Float> getPlayerEntrancePos(class_3222 player) {
            class_3218 world = player.method_51469();
            OverworldEntriesCC entries = (OverworldEntriesCC)OVERWORLD_ENTRIES.get((Object)world.method_14170());
            Data entry = entries.entries.get(player.method_5667());
            if (entry != null) {
                return new class_3545((Object)entry.posOverride, (Object)Float.valueOf(entry.entranceRotation));
            }
            if (player.method_26281() == MineCellsDimension.OVERWORLD.key) {
                class_2338 spawnPoint = player.method_26280();
                float spawnRot = player.method_30631();
                if (spawnPoint != null) {
                    return new class_3545((Object)spawnPoint, (Object)Float.valueOf(spawnRot));
                }
            }
            return new class_3545((Object)world.method_8503().method_30002().method_43126(), (Object)Float.valueOf(world.method_8503().method_30002().method_43127()));
        }

        public void readFromNbt(class_2487 tag) {
            this.entries.clear();
            for (String key : tag.method_10541()) {
                long[] data = tag.method_10565(key);
                this.entries.put(UUID.fromString(key), new Data(class_2338.method_10092((long)data[0]), class_2338.method_10092((long)data[1]), data[2]));
            }
        }

        public void writeToNbt(class_2487 tag) {
            this.entries.forEach((k, v) -> tag.method_10564(k.toString(), new long[]{v.posOverride.method_10063(), v.entrancePos.method_10063(), (long)v.entranceRotation}));
        }

        public record Data(class_2338 posOverride, class_2338 entrancePos, float entranceRotation) {
        }
    }

    public static class PortalsCC
    implements AutoSyncedComponent {
        private final ArrayList<PortalData> portals = new ArrayList();
        private final HashMap<UUID, List<PortalData>> portalMap = new HashMap();
        private final class_269 provider;

        public PortalsCC(class_269 provider, MinecraftServer server) {
            this.provider = provider;
        }

        public void readFromNbt(class_2487 nbt) {
            this.portals.clear();
            this.portalMap.clear();
            class_2499 list = nbt.method_10554("portals", 10);
            for (class_2520 compound : list) {
                this.addPortal(PortalData.fromNbt((class_2487)compound));
            }
        }

        public void writeToNbt(class_2487 nbt) {
            class_2499 list = new class_2499();
            for (PortalData portal : this.portals) {
                list.add((Object)portal.createNbt());
            }
            nbt.method_10566("portals", (class_2520)list);
        }

        public boolean shouldSyncWith(class_3222 player) {
            return this.portalMap.containsKey(player.method_5667());
        }

        public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
            List<PortalData> list = this.portalMap.get(recipient.method_5667());
            if (list == null) {
                list = List.of();
            }
            buf.method_10804(list.size());
            for (PortalData portal : list) {
                buf.method_10794(portal.createNbt());
            }
        }

        public void applySyncPacket(class_2540 buf) {
            this.portals.clear();
            this.portalMap.clear();
            int size = buf.method_10816();
            for (int i = 0; i < size; ++i) {
                class_2487 portalNbt = buf.method_10798();
                if (portalNbt == null) continue;
                this.addPortal(PortalData.fromNbt(portalNbt));
            }
        }

        private Optional<PortalData> createPortalDataForPlayer(class_3222 player) {
            int maxPortals = 1;
            List<PortalData> list = this.portalMap.get(player.method_5667());
            if (list != null && list.size() > maxPortals) {
                return Optional.empty();
            }
            int index = this.portals.size();
            class_2382 pos = MathUtils.getSpiralPosition(index).method_35862(1024);
            PortalData portal = new PortalData(player.method_5667(), new class_2338(pos), EnumSet.noneOf(MineCellsDimension.class));
            this.addPortal(portal);
            PORTALS.sync((Object)this.provider);
            return Optional.of(portal);
        }

        private void addPortal(PortalData portal) {
            this.portals.add(portal);
            this.portalMap.computeIfAbsent(portal.owner, k -> new ArrayList()).add(portal);
        }

        public static List<PortalData> getPortals(class_3222 player) {
            return ((PortalsCC)MineCellsLevelCC.PORTALS.get((Object)player.field_13995.method_3845())).portalMap.get(player.method_5667());
        }

        public static boolean createPortal(class_3222 player) {
            PortalsCC component = (PortalsCC)PORTALS.get((Object)player.field_13995.method_3845());
            return component.createPortalDataForPlayer(player).isPresent();
        }

        public static PortalData getOrCreatePortal(class_3222 player) {
            PortalsCC component = (PortalsCC)PORTALS.get((Object)player.field_13995.method_3845());
            List<PortalData> list = component.portalMap.get(player.method_5667());
            if (list == null || list.isEmpty()) {
                return component.createPortalDataForPlayer(player).get();
            }
            return list.get(0);
        }

        public static Optional<PortalData> findDataOfPosition(class_1937 world, class_2338 pos) {
            class_2338 centerPos = new class_2338(MathUtils.getClosestMultiplePosition((class_2382)pos, 1024));
            return ((PortalsCC)MineCellsLevelCC.PORTALS.get((Object)world.method_8428())).portals.stream().filter(p -> p.runCenter.equals((Object)centerPos)).findFirst();
        }

        public static void visitDimension(class_3218 world, class_2338 posOverride, MineCellsDimension dimension) {
            Optional<PortalData> data = PortalsCC.findDataOfPosition((class_1937)world, posOverride);
            data.ifPresent(it -> it.visitedDimensions.add(dimension));
            PORTALS.sync((Object)world.method_14170());
        }
    }

    public record PortalData(UUID owner, class_2338 runCenter, EnumSet<MineCellsDimension> visitedDimensions) {
        public class_2487 createNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10582("owner", this.owner.toString());
            nbt.method_10544("run_center", this.runCenter.method_10063());
            class_2499 list = new class_2499();
            for (MineCellsDimension dimension : this.visitedDimensions) {
                list.add((Object)class_2519.method_23256((String)dimension.key.method_29177().toString()));
            }
            nbt.method_10566("visited_dimensions", (class_2520)list);
            return nbt;
        }

        public static PortalData fromNbt(class_2487 nbt) {
            EnumSet<MineCellsDimension> set = EnumSet.noneOf(MineCellsDimension.class);
            class_2499 dimensions = nbt.method_10554("visited_dimensions", 8);
            for (class_2520 dim : dimensions) {
                set.add(MineCellsDimension.of(class_2960.method_12829((String)dim.method_10714())));
            }
            return new PortalData(UUID.fromString(nbt.method_10558("owner")), class_2338.method_10092((long)nbt.method_10537("run_center")), set);
        }
    }
}

