/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.compat.rei;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.recipe.CellForgeRecipe;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import com.github.mim1q.minecells.registry.MineCellsRecipeTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class MineCellsReiPlugin
implements REIClientPlugin {
    public static final class_2960 ARROW_TEXTURE = MineCells.createId("textures/gui/cell_crafter/emi_arrow.png");
    private static final CategoryIdentifier<CellCrafterDisplay> CELL_CRAFTER_CATEGORY_ID = CategoryIdentifier.of((class_2960)MineCells.createId("cell_crafter"));
    private static final DisplayCategory<CellCrafterDisplay> CELL_CRAFTER_CATEGORY = new DisplayCategory<CellCrafterDisplay>(){

        public CategoryIdentifier<? extends CellCrafterDisplay> getCategoryIdentifier() {
            return CELL_CRAFTER_CATEGORY_ID;
        }

        public class_2561 getTitle() {
            return class_2561.method_43471((String)"emi.category.minecells.cell_crafter");
        }

        public Renderer getIcon() {
            return EntryStacks.of((class_1935)MineCellsBlocks.CELL_CRAFTER);
        }

        public List<Widget> setupDisplay(CellCrafterDisplay display, Rectangle bounds) {
            ArrayList<Widget> widgets = new ArrayList<Widget>();
            widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
            int startX = bounds.x;
            int startY = bounds.y + 5;
            int widgetX = startX + bounds.width / 2 - display.getInputEntries().size() * 10 + 2;
            for (EntryIngredient input : display.getInputEntries()) {
                widgets.add((Widget)Widgets.createSlot((Point)new Point(widgetX, startY)).entries((Collection)input));
                widgetX += 20;
            }
            boolean hasAdvancement = display.recipe.requiredAdvancement().isPresent();
            Widget arrow = Widgets.createTexturedWidget((class_2960)ARROW_TEXTURE, (int)(startX + bounds.width / 2 - 8), (int)(startY + 21), (float)0.0f, (float)0.0f, (int)(hasAdvancement ? 24 : 16), (int)16, (int)(hasAdvancement ? 24 : 16), (int)16, (int)32, (int)32);
            widgets.add(arrow);
            if (hasAdvancement) {
                String advancementKey = class_156.method_646((String)"advancements", (class_2960)display.recipe.requiredAdvancement().orElseThrow()) + ".description";
                widgets.add(Widgets.createTooltip((Rectangle)new Rectangle(startX + bounds.width / 2 - 8, startY + 21, 24, 16), (class_2561[])new class_2561[]{class_2561.method_43471((String)"block.minecells.cell_crafter.requirement").method_27692(class_124.field_1061), class_2561.method_43471((String)advancementKey).method_27692(class_124.field_1080)}));
            }
            widgets.add((Widget)Widgets.createSlot((Point)new Point(startX + bounds.width / 2 - 8, startY + 40)).entry(EntryStacks.of((class_1799)display.recipe.method_8110(null))));
            return widgets;
        }
    };

    public void registerCategories(CategoryRegistry registry) {
        registry.add(CELL_CRAFTER_CATEGORY);
        registry.addWorkstations(CELL_CRAFTER_CATEGORY_ID, new EntryStack[]{EntryStacks.of((class_1935)MineCellsBlocks.CELL_CRAFTER)});
    }

    public void registerDisplays(DisplayRegistry registry) {
        List<CellForgeRecipe> recipes = registry.getRecipeManager().method_30027(MineCellsRecipeTypes.CELL_FORGE_RECIPE_TYPE).stream().sorted(Comparator.comparingInt(a -> a.category().ordinal()).thenComparing((a, b) -> b.priority() - a.priority())).toList();
        for (CellForgeRecipe recipe : recipes) {
            registry.add((Display)new CellCrafterDisplay(recipe));
        }
    }

    private static class CellCrafterDisplay
    extends BasicDisplay {
        public final CellForgeRecipe recipe;

        public CellCrafterDisplay(CellForgeRecipe recipe) {
            super(CellCrafterDisplay.mapStacksToIngredient(recipe.method_8117()), List.of(EntryIngredient.of((EntryStack)EntryStacks.of((class_1799)recipe.method_8110(null)))));
            this.recipe = recipe;
        }

        private static List<EntryIngredient> mapStacksToIngredient(List<class_1856> ingredients) {
            ArrayList<EntryIngredient> result = new ArrayList<EntryIngredient>();
            for (class_1856 ingredient : ingredients) {
                List<EntryStack> stacks = Arrays.stream(ingredient.method_8105()).map(EntryStacks::of).toList();
                result.add(EntryIngredient.of(stacks));
            }
            return result;
        }

        public CategoryIdentifier<?> getCategoryIdentifier() {
            return CELL_CRAFTER_CATEGORY_ID;
        }
    }
}

