/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.dimension;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.cc.MineCellsLevelCC;
import com.github.mim1q.minecells.dimension.DimensionRequirement;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.structure.grid.GridBasedStructureUtils;
import com.github.mim1q.minecells.structure.grid.GridPiecesGenerator;
import com.github.mim1q.minecells.structure.grid.generator.BetterPromenadeGridGenerator;
import com.github.mim1q.minecells.structure.grid.generator.BlackBridgeGridGenerator;
import com.github.mim1q.minecells.structure.grid.generator.InsufferableCryptGridGenerator;
import com.github.mim1q.minecells.structure.grid.generator.PrisonGridGenerator;
import com.github.mim1q.minecells.structure.grid.generator.RampartsGridGenerator;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.TeleportUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5195;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public enum MineCellsDimension {
    OVERWORLD(new class_2960("overworld"), 0.0, null),
    PRISONERS_QUARTERS(MineCells.createId("prison"), 1024.0, new PrisonGridGenerator(0, 0)),
    INSUFFERABLE_CRYPT(MineCells.createId("insufferable_crypt"), 1024.0, new InsufferableCryptGridGenerator(0, 0)),
    PROMENADE_OF_THE_CONDEMNED(MineCells.createId("promenade"), 1024.0, new BetterPromenadeGridGenerator(0, 0)),
    RAMPARTS(MineCells.createId("ramparts"), -384.0, new RampartsGridGenerator(0, 0)),
    BLACK_BRIDGE(MineCells.createId("black_bridge"), 384.0, new BlackBridgeGridGenerator(0, 0));

    public final class_5321<class_1937> key;
    private final class_2960 id;
    public final String translationKey;
    public final double borderSize;
    public final GridPiecesGenerator.RoomGridGenerator baseGenerator;
    private static final Map<MineCellsDimension, List<DimensionRequirement>> requirements;

    private MineCellsDimension(class_2960 id, double borderSize, GridPiecesGenerator.RoomGridGenerator baseGenerator) {
        this.key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
        this.id = id;
        this.translationKey = id.method_42093("dimension");
        this.borderSize = borderSize;
        this.baseGenerator = baseGenerator;
    }

    public class_3545<class_243, Integer> getNonOverworldTeleportPosition(class_2338 pos, class_3218 world, class_2960 specialPoint) {
        return this.getNonOverworldTeleportPosition(pos, world, specialPoint, true);
    }

    public class_3545<class_243, Integer> getNonOverworldTeleportPosition(class_2338 pos, class_3218 destination, class_2960 specialPoint, boolean applySafeOffset) {
        Optional<Object> point = Optional.empty();
        try {
            point = GridBasedStructureUtils.getSpecialPoint(destination, (class_2382)pos, specialPoint);
        }
        catch (Exception e) {
            MineCells.LOGGER.error("Failed to get entrance point", (Throwable)e);
        }
        class_2338 runCenter = new class_2338(MathUtils.getClosestMultiplePosition((class_2382)pos, 1024));
        if (point.isPresent()) {
            class_243 tpPos = class_243.method_24955((class_2382)runCenter.method_10081(((GridPiecesGenerator.RoomGridGenerator.SpecialPoint)point.get()).offset()));
            if (applySafeOffset) {
                tpPos = tpPos.method_1019(class_243.method_24954((class_2382)((GridPiecesGenerator.RoomGridGenerator.SpecialPoint)point.get()).facing().method_10503(class_2350.field_11043).method_10163()).method_1021(-0.5));
            }
            return new class_3545((Object)tpPos, (Object)((GridPiecesGenerator.RoomGridGenerator.SpecialPoint)point.get()).facing().method_10502(0, 360));
        }
        class_3545<class_2382, Float> spawnOffset = this.getOffset();
        class_2338 tpPos = runCenter.method_10081((class_2382)spawnOffset.method_15442());
        return new class_3545((Object)class_243.method_24955((class_2382)tpPos), (Object)((Float)spawnOffset.method_15441()).intValue());
    }

    public void teleportPlayer(class_3222 player, class_3218 world, @Nullable class_2338 posOverride, class_2960 specialPoint) {
        class_3545<class_243, Integer> teleportPos = this.getNonOverworldTeleportPosition(player, posOverride == null ? new class_2338(MathUtils.getClosestMultiplePosition((class_2382)player.method_24515(), 1024)) : posOverride, world, specialPoint);
        class_3218 destination = this.getWorld(world);
        TeleportUtils.teleportToDimension((class_1297)player, destination, (class_243)teleportPos.method_15442(), ((Integer)teleportPos.method_15441()).intValue());
    }

    private class_3545<class_243, Integer> getNonOverworldTeleportPosition(class_3222 player, class_2338 pos, class_3218 world, class_2960 specialPoint) {
        class_3218 destination = this.getWorld(world);
        if (this == OVERWORLD) {
            Optional<MineCellsLevelCC.OverworldEntriesCC.Data> data = MineCellsLevelCC.OverworldEntriesCC.getPlayerEntrancePoint(player, pos, world);
            if (data.isPresent()) {
                return new class_3545((Object)class_243.method_24953((class_2382)data.get().posOverride()), (Object)((int)data.get().entranceRotation()));
            }
            if (player.method_26281() == MineCellsDimension.OVERWORLD.key && player.method_26280() != null) {
                return new class_3545((Object)class_243.method_24953((class_2382)player.method_26280()), (Object)((int)player.method_30631()));
            }
            return new class_3545((Object)class_243.method_24955((class_2382)destination.method_43126()), (Object)0);
        }
        return this.getNonOverworldTeleportPosition(pos, destination, specialPoint);
    }

    private class_3545<class_2382, Float> getOffset() {
        return new class_3545((Object)class_2382.field_11176, (Object)Float.valueOf(0.0f));
    }

    public class_3218 getWorld(class_3218 world) {
        return world.method_8503().method_3847(this.key);
    }

    public static MineCellsDimension of(class_5321<class_1937> key) {
        for (MineCellsDimension dimension : MineCellsDimension.values()) {
            if (!dimension.key.equals(key)) continue;
            return dimension;
        }
        return null;
    }

    public static MineCellsDimension of(class_1937 world) {
        return MineCellsDimension.of((class_5321<class_1937>)world.method_27983());
    }

    public static class_1937 getWorld(class_1937 world, class_5321<class_1937> key) {
        MinecraftServer server = world.method_8503();
        if (server == null) {
            return null;
        }
        return server.method_3847(key);
    }

    public static boolean isMineCellsDimension(class_1937 world) {
        return world != null && world.method_27983().method_29177().method_12836().equals("minecells");
    }

    public static String getTranslationKey(class_5321<class_1937> dimension) {
        class_2960 id = dimension.method_29177();
        return "dimension." + id.method_12836() + "." + id.method_12832();
    }

    public static String getTranslationKey(String key) {
        class_2960 id = new class_2960(key);
        return "dimension." + id.method_12836() + "." + id.method_12832();
    }

    public static MineCellsDimension of(class_2960 id) {
        return Arrays.stream(MineCellsDimension.values()).filter(value -> value.id.equals((Object)id)).findFirst().orElse(null);
    }

    public static Double getFallResetHeight(class_1937 world) {
        if (!MineCellsDimension.isMineCellsDimension(world)) {
            return null;
        }
        return switch (MineCellsDimension.of(world).ordinal()) {
            case 4 -> 180.0;
            default -> null;
        };
    }

    public int getDimensionLevel() {
        return switch (this.ordinal()) {
            case 3 -> 1;
            case 4 -> 2;
            default -> 0;
        };
    }

    public class_5195 getMusic() {
        return switch (this.ordinal()) {
            case 1 -> MineCellsSounds.PRISONERS_QUARTERS;
            case 3 -> MineCellsSounds.PROMENADE;
            case 4 -> MineCellsSounds.RAMPARTS;
            case 2 -> MineCellsSounds.INSUFFERABLE_CRYPT;
            default -> null;
        };
    }

    public int getColor() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> 9369965;
            case 1 -> 5566344;
            case 3 -> 9699319;
            case 2 -> 0xFF4CF4;
            case 4 -> 16762176;
            case 5 -> 6438089;
        };
    }

    public static int getColor(@Nullable class_1937 world, int defaultColor) {
        if (world == null) {
            return defaultColor;
        }
        MineCellsDimension dim = MineCellsDimension.of(world);
        if (dim == null) {
            return defaultColor;
        }
        return dim.getColor();
    }

    public List<DimensionRequirement> getRequirements() {
        return requirements.getOrDefault((Object)this, List.of());
    }

    public boolean canEnter(class_1657 player, @Nullable MineCellsLevelCC.PortalData portal) {
        return this.getRequirements().stream().allMatch(requirement -> requirement.isMet(this, player, portal));
    }

    static {
        requirements = ImmutableMap.builder().put((Object)OVERWORLD, List.of()).put((Object)PRISONERS_QUARTERS, List.of()).put((Object)PROMENADE_OF_THE_CONDEMNED, List.of(new DimensionRequirement.AccessFromDimension(PRISONERS_QUARTERS))).put((Object)INSUFFERABLE_CRYPT, List.of(new DimensionRequirement.GetAdvancement(MineCells.createId("vine_rune")))).put((Object)RAMPARTS, List.of(new DimensionRequirement.AccessFromDimension(PROMENADE_OF_THE_CONDEMNED))).put((Object)BLACK_BRIDGE, List.of(new DimensionRequirement.AccessFromDimension(RAMPARTS))).build();
    }
}

