/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity;

import com.github.mim1q.minecells.entity.MineCellsEntity;
import com.github.mim1q.minecells.entity.ai.goal.AuraGoal;
import com.github.mim1q.minecells.entity.interfaces.IAuraEntity;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.ParticleUtils;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1315;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class ShockerEntity
extends MineCellsEntity
implements IAuraEntity {
    public static final class_2940<Integer> AURA_COOLDOWN = class_2945.method_12791(ShockerEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> AURA_CHARGING = class_2945.method_12791(ShockerEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> AURA_RELEASING = class_2945.method_12791(ShockerEntity.class, (class_2941)class_2943.field_13323);

    public ShockerEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_5985 = true;
    }

    @Override
    public void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(AURA_COOLDOWN, (Object)50);
        this.field_6011.method_12784(AURA_CHARGING, (Object)false);
        this.field_6011.method_12784(AURA_RELEASING, (Object)false);
    }

    @Override
    public void method_5959() {
        this.field_6201.method_6277(0, new AuraGoal<ShockerEntity>(this, 6.0, 15, 60, 1.0f));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.decrementCooldown(AURA_COOLDOWN);
        this.handleStates();
    }

    private void handleStates() {
        if (this.method_37908().method_8608()) {
            class_243 pos = this.method_19538().method_1031(0.0, (double)this.method_17682() * 0.5, 0.0);
            if (this.isAuraCharging()) {
                for (int i = 0; i < 10; ++i) {
                    ParticleUtils.addParticle(this.method_37908(), (class_2394)MineCellsParticles.CHARGE, pos, class_243.field_1353);
                }
            } else if (this.isAuraReleasing()) {
                ParticleUtils.addAura(this.method_37908(), pos, (class_2394)MineCellsParticles.AURA, 100, 5.5, 0.01);
                ParticleUtils.addAura(this.method_37908(), pos, (class_2394)MineCellsParticles.AURA, 10, 1.0, 0.3);
                class_243 direction = class_243.field_1353.method_49272(this.field_5974, 1.0f);
                this.method_37908().method_8406((class_2394)MineCellsParticles.ELECTRICITY.get(direction, 4, -942187, 1.0f), pos.method_10216(), pos.method_10214(), pos.method_10215(), 0.0, 0.0, 0.0);
            }
        }
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.method_5875(true);
        this.method_33574(this.method_19538().method_1031(0.0, 1.5, 0.0));
        float yaw = this.field_5974.method_43057() * 360.0f;
        this.method_36456(yaw);
        this.method_5847(yaw);
        this.method_5636(yaw);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_48789(class_8103.field_42246) || source.method_48789(class_8103.field_42248)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42247)) {
            amount *= 0.2f;
        }
        return super.method_5643(source, amount);
    }

    @Override
    public boolean isAuraCharging() {
        return (Boolean)this.field_6011.method_12789(AURA_CHARGING);
    }

    @Override
    public void setAuraCharging(boolean charging) {
        this.field_6011.method_12778(AURA_CHARGING, (Object)charging);
    }

    @Override
    public boolean isAuraReleasing() {
        return (Boolean)this.field_6011.method_12789(AURA_RELEASING);
    }

    @Override
    public void setAuraReleasing(boolean releasing) {
        this.field_6011.method_12778(AURA_RELEASING, (Object)releasing);
    }

    @Override
    public int getAuraCooldown() {
        return (Integer)this.field_6011.method_12789(AURA_COOLDOWN);
    }

    @Override
    public void setAuraCooldown(int cooldown) {
        this.field_6011.method_12778(AURA_COOLDOWN, (Object)cooldown);
    }

    @Override
    public int getAuraMaxCooldown() {
        return 60 + this.field_5974.method_43048(40);
    }

    @Override
    public float getAuraDamage() {
        return 5.0f;
    }

    @Override
    public class_3414 getAuraChargeSoundEvent() {
        return MineCellsSounds.SHOCKER_CHARGE;
    }

    @Override
    public class_3414 getAuraReleaseSoundEvent() {
        return MineCellsSounds.SHOCKER_RELEASE;
    }

    @Override
    public class_3414 method_6002() {
        return MineCellsSounds.SHOCKER_DEATH;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("auraCooldown", this.getAuraCooldown());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setAuraCooldown(nbt.method_10550("auraCooldown"));
    }

    public static class_5132.class_5133 createShockerAttributes() {
        return ShockerEntity.method_26827().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23724, 10.0).method_26868(class_5134.field_23718, 1.0);
    }
}

