/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.network;

import com.github.mim1q.minecells.block.ShockwaveBlock;
import com.github.mim1q.minecells.block.blockentity.SpawnerRuneBlockEntity;
import com.github.mim1q.minecells.client.gui.ConjunctiviusClientBossBar;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.entity.nonliving.SpawnerRuneEntity;
import com.github.mim1q.minecells.entity.nonliving.obelisk.ObeliskEntity;
import com.github.mim1q.minecells.network.PacketIdentifiers;
import com.github.mim1q.minecells.network.ServerPacketHandler;
import com.github.mim1q.minecells.network.s2c.ObeliskActivationS2CPacket;
import com.github.mim1q.minecells.network.s2c.OpenDoorwayScreenS2CPacket;
import com.github.mim1q.minecells.network.s2c.SendUnlockedCellCrafterRecipesS2CPacket;
import com.github.mim1q.minecells.network.s2c.ShockwaveClientEventS2CPacket;
import com.github.mim1q.minecells.network.s2c.SpawnRuneParticlesS2CPacket;
import com.github.mim1q.minecells.network.s2c.SpawnerRuneUpdateS2CPacket;
import com.github.mim1q.minecells.network.s2c.UpdateConjunctiviusBossBarS2CPacket;
import com.github.mim1q.minecells.recipe.CellForgeRecipe;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.screen.ScreenUtils;
import com.github.mim1q.minecells.screen.cellcrafter.CellCrafterRecipeList;
import com.github.mim1q.minecells.screen.cellcrafter.CellCrafterScreen;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.ParticleUtils;
import io.wispforest.owo.network.OwoNetChannel;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_345;
import net.minecraft.class_437;
import net.minecraft.class_5819;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ClientPacketHandler {
    public static final OwoNetChannel CHANNEL = ServerPacketHandler.CLIENT_CHANNEL;

    public static void init() {
        CHANNEL.registerClientbound(SpawnerRuneUpdateS2CPacket.class, (msg, handler) -> {
            class_638 world = handler.netHandler().method_2890();
            class_2586 blockEntity = world.method_8321(msg.pos());
            if (blockEntity instanceof SpawnerRuneBlockEntity) {
                SpawnerRuneBlockEntity spawner = (SpawnerRuneBlockEntity)blockEntity;
                spawner.controller.setLastActivationTime(msg.lastActivationTime());
                spawner.controller.setDummyData(msg.cooldown());
                return;
            }
            class_238 box = class_238.method_30048((class_243)class_243.method_24953((class_2382)msg.pos()), (double)1.5, (double)1.5, (double)1.5);
            Optional entity = world.method_8390(SpawnerRuneEntity.class, box, it -> it.method_24515().equals((Object)msg.pos())).stream().findFirst();
            entity.ifPresent(it -> {
                it.controller.setLastActivationTime(msg.lastActivationTime());
                it.controller.setDummyData(msg.cooldown());
            });
        });
        CHANNEL.registerClientbound(OpenDoorwayScreenS2CPacket.class, (msg, handler) -> ScreenUtils.openDoorwaySelectionScreen(msg.pos(), msg.posOverride()));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.CRIT, ClientPacketHandler::handleCrit);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.EXPLOSION, ClientPacketHandler::handleExplosion);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.CONNECT, ClientPacketHandler::handleConnect);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.ELEVATOR_DESTROYED, ClientPacketHandler::handleElevatorDestroyed);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpawnRuneParticlesS2CPacket.ID, ClientPacketHandler::applySpawnRuneParticles);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ObeliskActivationS2CPacket.ID, ClientPacketHandler::applyObeliskActivation);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ShockwaveClientEventS2CPacket.ID, ClientPacketHandler::applyShockwaveClientEvent);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SendUnlockedCellCrafterRecipesS2CPacket.ID, ClientPacketHandler::applySendUnlockedCellCrafterRecipes);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)UpdateConjunctiviusBossBarS2CPacket.ID, ClientPacketHandler::handleUpdateConjunctiviusBossBar);
    }

    private static void handleCrit(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_243 pos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        client.execute(() -> {
            if (client.field_1724 != null) {
                ParticleUtils.addAura((class_1937)client.field_1687, pos, (class_2394)class_2398.field_11205, 8, 0.0, 1.0);
            }
        });
    }

    private static void handleExplosion(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_243 pos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        double radius = buf.readDouble();
        client.execute(() -> {
            if (client.field_1724 != null && client.field_1687 != null) {
                client.field_1687.method_8466((class_2394)MineCellsParticles.EXPLOSION, true, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
                client.field_1687.method_8466((class_2394)class_2398.field_11236, true, pos.field_1352 + 0.01, pos.field_1351 + 0.01, pos.field_1350 + 0.01, 0.0, 0.0, 0.0);
                class_5819 random = client.field_1687.field_9229;
                for (int i = 0; i < 20; ++i) {
                    double vx = (random.method_43058() - 0.5) * radius;
                    double vy = (random.method_43058() - 0.5) * radius;
                    double vz = (random.method_43058() - 0.5) * radius;
                    client.field_1687.method_8466((class_2394)class_2398.field_11205, true, pos.field_1352, pos.field_1351, pos.field_1350, vx, vy, vz);
                }
            }
        });
    }

    private static void handleConnect(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_243 pos0 = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        class_243 pos1 = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        client.execute(() -> {
            if (client.field_1724 != null && client.field_1687 != null) {
                double amount = pos0.method_1022(pos1);
                class_243 vel = pos1.method_1020(pos0).method_1029();
                int i = 0;
                while ((double)i < amount) {
                    class_243 pos = MathUtils.lerp(pos0, pos1, (float)i / (float)amount);
                    ParticleUtils.addParticle((class_1937)client.field_1687, (class_2394)class_2398.field_11208, pos, vel);
                    ++i;
                }
            }
        });
    }

    private static void handleElevatorDestroyed(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_243 pos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        client.execute(() -> {
            if (client.field_1687 != null) {
                class_2388 particle = new class_2388(class_2398.field_11217, class_2246.field_10161.method_9564());
                class_238 box = new class_238(pos.method_1031(-1.0, 0.0, -1.0), pos.method_1031(1.0, 0.5, 1.0));
                ParticleUtils.addInBox((class_1937)client.field_1687, (class_2394)particle, box, 25, new class_243(0.1, 0.1, 0.1));
            }
        });
    }

    private static void handleUpdateConjunctiviusBossBar(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        UUID barUuid = buf.method_10790();
        short tentacleCount = buf.readShort();
        short maxTentacleCount = buf.readShort();
        client.execute(() -> {
            class_345 bar = (class_345)client.field_1705.method_1740().field_2060.get(barUuid);
            if (bar instanceof ConjunctiviusClientBossBar) {
                ConjunctiviusClientBossBar conjunctiviusBar = (ConjunctiviusClientBossBar)bar;
                conjunctiviusBar.setTentacleCount(tentacleCount, maxTentacleCount);
            }
        });
    }

    public static void applySpawnRuneParticles(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        double minX = buf.readDouble();
        double minY = buf.readDouble();
        double minZ = buf.readDouble();
        double maxX = buf.readDouble();
        double maxY = buf.readDouble();
        double maxZ = buf.readDouble();
        class_238 box = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
        client.execute(() -> {
            class_638 world = handler.method_2890();
            int color = 16738816;
            MineCellsDimension dimension = MineCellsDimension.of((class_1937)world);
            if (dimension != null) {
                color = dimension.getColor();
            }
            ParticleUtils.addInBox((class_1937)world, MineCellsParticles.SPECKLE.get(color), box, 10, new class_243(-0.1, -0.1, -0.1).method_1021(world.field_9229.method_43058() * 0.5 + 0.5));
            ParticleUtils.addInBox((class_1937)world, (class_2394)class_2398.field_11204, box.method_1002(0.1, 0.1, 0.1), 10, new class_243(-0.02, -0.02, -0.02).method_1021(world.field_9229.method_43058() * 0.5 + 0.5));
        });
    }

    public static void applyObeliskActivation(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.readInt();
        client.execute(() -> {
            class_1297 entity = handler.method_2890().method_8469(entityId);
            if (entity instanceof ObeliskEntity) {
                ObeliskEntity obelisk = (ObeliskEntity)entity;
                obelisk.resetActivatedTicks();
            }
        });
    }

    public static void applyShockwaveClientEvent(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int blockId = buf.readInt();
        class_2338 blockPos = buf.method_10811();
        boolean end = buf.readBoolean();
        client.execute(() -> {
            Object patt0$temp;
            class_638 world = client.field_1687;
            if (world == null) {
                return;
            }
            Optional block = class_7923.field_41175.method_40265(blockId);
            if (block.isPresent() && (patt0$temp = ((class_6880.class_6883)block.get()).comp_349()) instanceof ShockwaveBlock) {
                ShockwaveBlock shockwaveBlock = (ShockwaveBlock)((Object)((Object)patt0$temp));
                if (end) {
                    shockwaveBlock.onClientEndShockwave((class_1937)world, blockPos);
                } else {
                    shockwaveBlock.onClientStartShockwave((class_1937)world, blockPos);
                }
            }
        });
    }

    public static void applySendUnlockedCellCrafterRecipes(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int size = buf.readInt();
        ArrayList<CellCrafterRecipeList.DisplayedRecipe> recipes = new ArrayList<CellCrafterRecipeList.DisplayedRecipe>();
        class_1863 recipeManager = handler.method_2877();
        for (int i = 0; i < size; ++i) {
            class_2960 recipeId = buf.method_10810();
            CellForgeRecipe recipe = (CellForgeRecipe)recipeManager.method_8130(recipeId).orElseThrow();
            boolean isUnlocked = buf.readBoolean();
            recipes.add(new CellCrafterRecipeList.DisplayedRecipe(recipe, isUnlocked));
        }
        client.execute(() -> {
            class_437 screen = client.field_1755;
            if (screen instanceof CellCrafterScreen) {
                CellCrafterScreen cellCrafterScreen = (CellCrafterScreen)screen;
                cellCrafterScreen.updateRecipes(recipes);
            }
        });
    }
}

