/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.screen.cellcrafter;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.client.gui.toast.SurfaceUtil;
import com.github.mim1q.minecells.recipe.CellForgeRecipe;
import com.github.mim1q.minecells.screen.cellcrafter.CellCrafterScreen;
import com.github.mim1q.minecells.screen.cellcrafter.CellCrafterScreenHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_6880;

public class CellCrafterRecipeList {
    public static final class_2960 RECIPES_SCREEN_TEXTURE = MineCells.createId("textures/gui/cell_crafter/recipes.png");
    private final CellCrafterScreen parent;
    private final List<DisplayedRecipe> allRecipes = new ArrayList<DisplayedRecipe>();
    private final List<DisplayedRecipe> currentRecipes = new ArrayList<DisplayedRecipe>();
    private final List<DisplayedRecipe> visibleRecipes = new ArrayList<DisplayedRecipe>();
    private DisplayedRecipe selectedRecipe = null;
    private CellForgeRecipe.Category selectedCategory = CellForgeRecipe.Category.GEAR;
    private final GridLayout grid;
    private final CellCrafterScreen.TexturedButton downButton;
    private final CellCrafterScreen.TexturedButton upButton;
    private final CellCrafterScreen.TexturedButton applyButton;
    private final LabelComponent label;
    private final TextBoxComponent textBox;
    private FlowLayout container;
    private CellCrafterScreen.IngredientDisplay ingredientDisplay = null;
    private String search = "";
    private int scrollOffset = 0;

    public CellCrafterRecipeList(CellCrafterScreen parent) {
        this.parent = parent;
        this.grid = Containers.grid((Sizing)Sizing.content(), (Sizing)Sizing.content(), (int)5, (int)6);
        this.upButton = new CellCrafterScreen.TexturedButton(it -> this.scrollUp(), RECIPES_SCREEN_TEXTURE, 208, 48);
        this.upButton.tooltip((class_2561)class_2561.method_43471((String)"block.minecells.cell_crafter.scroll_up"));
        this.downButton = new CellCrafterScreen.TexturedButton(it -> this.scrollDown(), RECIPES_SCREEN_TEXTURE, 224, 48);
        this.downButton.tooltip((class_2561)class_2561.method_43471((String)"block.minecells.cell_crafter.scroll_down"));
        this.applyButton = new CellCrafterScreen.TexturedButton(it -> {
            this.parent.setSelectedRecipe(this.selectedRecipe.recipe());
            this.parent.toggleRecipeList();
        }, RECIPES_SCREEN_TEXTURE, 224, 0);
        this.label = Components.label((class_2561)this.selectedCategory.getName());
        this.label.shadow(false).color(Color.BLACK).positioning(Positioning.absolute((int)44, (int)4));
        this.textBox = new NoShadowTextBox(Sizing.fixed((int)70));
    }

    public void build(FlowLayout rootComponent) {
        this.container = Containers.verticalFlow((Sizing)Sizing.fixed((int)200), (Sizing)Sizing.fixed((int)176));
        this.container.surface(SurfaceUtil.backgroundTexture(RECIPES_SCREEN_TEXTURE, 160, 176)).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.TOP).padding(Insets.of((int)8)).allowOverflow(true);
        this.textBox.method_1858(false);
        this.textBox.method_1854((string, firstCharacterIndex) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360.method_27706(class_124.field_1074)));
        this.textBox.positioning(Positioning.absolute((int)98, (int)18));
        this.textBox.onChanged().subscribe(it -> {
            this.search = it.toLowerCase();
            this.updateRecipes();
        });
        this.container.child((Component)this.textBox);
        this.container.child(new CellCrafterScreen.TexturedButton(it -> this.parent.toggleRecipeList(), RECIPES_SCREEN_TEXTURE, 208, 0).sizing(Sizing.fixed((int)16)).positioning(Positioning.absolute((int)44, (int)16)).tooltip((class_2561)class_2561.method_43471((String)"block.minecells.cell_crafter.return")));
        this.container.child(this.applyButton.sizing(Sizing.fixed((int)16)).positioning(Positioning.absolute((int)152, (int)138)).tooltip((class_2561)class_2561.method_43471((String)"block.minecells.cell_crafter.select_recipe")));
        this.container.child(this.upButton.sizing(Sizing.fixed((int)16)).positioning(Positioning.absolute((int)152, (int)36)));
        this.container.child(this.downButton.sizing(Sizing.fixed((int)16)).positioning(Positioning.absolute((int)152, (int)52)));
        this.container.child((Component)this.label);
        this.grid.positioning(Positioning.absolute((int)43, (int)34)).allowOverflow(true);
        this.container.child((Component)this.grid);
        rootComponent.child((Component)this.container);
        FlowLayout categoryContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)48), (Sizing)Sizing.fixed((int)160));
        categoryContainer.allowOverflow(true).positioning(Positioning.absolute((int)0, (int)16));
        for (CellForgeRecipe.Category category : CellForgeRecipe.Category.values()) {
            categoryContainer.child(new CategoryButton(category).sizing(Sizing.fixed((int)40), Sizing.fixed((int)25)).tooltip(category.getName()));
        }
        this.container.child((Component)categoryContainer);
        this.updateButtons();
        this.updateSelectedRecipeDisplay();
    }

    void updateButtons() {
        this.upButton.active(this.scrollOffset > 0);
        this.downButton.active(this.scrollOffset < this.getMaxYOffset());
        this.applyButton.active(this.selectedRecipe != null);
    }

    public void updateRecipes(List<DisplayedRecipe> recipes) {
        this.allRecipes.clear();
        this.allRecipes.addAll(recipes);
        this.allRecipes.sort((a, b) -> {
            if (a.isUnlocked() && !b.isUnlocked()) {
                return -1;
            }
            if (!a.isUnlocked() && b.isUnlocked()) {
                return 1;
            }
            int priority = b.recipe().priority() - a.recipe().priority();
            if (priority != 0) {
                return priority;
            }
            String aName = a.recipe().output().method_7909().method_7848().getString();
            String bName = b.recipe().output().method_7909().method_7848().getString();
            return aName.compareTo(bName);
        });
        this.updateRecipes();
    }

    public void clearSearch() {
        this.search = "";
        this.textBox.method_1852("");
        this.updateRecipes();
    }

    public void updateRecipes() {
        this.currentRecipes.clear();
        this.visibleRecipes.clear();
        this.allRecipes.stream().filter(it -> this.search.isBlank() || it.isUnlocked && it.recipe().output().method_7909().method_7848().getString().toLowerCase().contains(this.search)).filter(it -> it.recipe().category() == this.selectedCategory).forEach(this.currentRecipes::add);
        for (int i = this.scrollOffset * 6; i < this.currentRecipes.size(); ++i) {
            this.visibleRecipes.add(this.currentRecipes.get(i));
        }
        if (!this.currentRecipes.contains(this.selectedRecipe)) {
            this.selectedRecipe = null;
        }
        for (int r = 0; r < 5; ++r) {
            for (int c = 0; c < 6; ++c) {
                this.grid.removeChild(r, c);
                int index = r * 6 + c;
                if (index >= this.visibleRecipes.size()) continue;
                DisplayedRecipe recipe = this.visibleRecipes.get(index);
                BaseComponent component = new RecipeComponent(recipe, class_310.method_1551().field_1772, this).margins(Insets.of((int)1));
                this.grid.child((Component)component, r, c);
            }
        }
        this.label.text(this.selectedCategory.getName());
        this.updateButtons();
        this.updateSelectedRecipeDisplay();
    }

    private void updateSelectedRecipeDisplay() {
        if (this.container == null) {
            return;
        }
        if (this.ingredientDisplay != null && this.ingredientDisplay.parent() == this.container) {
            this.container.removeChild((Component)this.ingredientDisplay);
        }
        if (this.selectedRecipe == null) {
            return;
        }
        this.ingredientDisplay = new CellCrafterScreen.IngredientDisplay(((CellCrafterScreenHandler)this.parent.method_17577()).player().method_31548(), this.selectedRecipe.recipe(), Sizing.fixed((int)96), Sizing.fixed((int)16));
        this.ingredientDisplay.positioning(Positioning.absolute((int)50, (int)128));
        this.container.child((Component)this.ingredientDisplay);
    }

    public void scrollDown() {
        int newYOffset = Math.min(this.getMaxYOffset(), this.scrollOffset + 1);
        if (newYOffset != this.scrollOffset) {
            this.scrollOffset = newYOffset;
            this.updateRecipes();
            this.updateButtons();
        }
    }

    public void scrollUp() {
        int newYOffset = Math.max(0, this.scrollOffset - 1);
        if (newYOffset != this.scrollOffset) {
            this.scrollOffset = newYOffset;
            this.updateRecipes();
            this.updateButtons();
        }
    }

    private int getMaxYOffset() {
        return Math.max(0, (int)Math.ceil((double)this.currentRecipes.size() / 6.0) - 5);
    }

    public record DisplayedRecipe(CellForgeRecipe recipe, boolean isUnlocked) {
    }

    private static class NoShadowTextBox
    extends TextBoxComponent {
        protected NoShadowTextBox(Sizing horizontalSizing) {
            super(horizontalSizing);
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579((class_332)new DisableShadowDrawContext(context), mouseX, mouseY, delta);
        }
    }

    private class CategoryButton
    extends CellCrafterScreen.TexturedButton {
        public CategoryButton(CellForgeRecipe.Category category) {
            super(it -> {
                com$github$mim1q$minecells$screen$cellcrafter$CellCrafterRecipeList$this.selectedCategory = category;
                com$github$mim1q$minecells$screen$cellcrafter$CellCrafterRecipeList$this.scrollOffset = 0;
                CellCrafterRecipeList.this.clearSearch();
            }, RECIPES_SCREEN_TEXTURE, 160, 0);
            this.renderer = (context, button, delta) -> {
                int renderV = 0;
                if (button.method_49606() || CellCrafterRecipeList.this.selectedCategory == category) {
                    renderV += button.height();
                }
                int x = button.method_46426();
                if (CellCrafterRecipeList.this.selectedCategory != category) {
                    x += 8;
                }
                class_4587 matrices = context.method_51448();
                matrices.method_22903();
                matrices.method_46416(0.0f, 0.0f, -3.0f);
                RenderSystem.enableDepthTest();
                context.method_25290(RECIPES_SCREEN_TEXTURE, x, button.method_46427(), 160.0f, (float)renderV, button.width(), button.height(), 256, 256);
                context.method_51427(category.displayItem.method_7854(), x + 12, this.y() + 6);
                matrices.method_22909();
            };
        }
    }

    private static class RecipeComponent
    extends ItemComponent {
        private final DisplayedRecipe recipe;
        private final class_327 textRenderer;
        private final CellCrafterRecipeList parent;

        public RecipeComponent(DisplayedRecipe recipe, class_327 textRenderer, CellCrafterRecipeList parent) {
            super(recipe.recipe().output());
            this.recipe = recipe;
            this.textRenderer = textRenderer;
            this.parent = parent;
            this.showOverlay(true);
            if (recipe.isUnlocked) {
                this.mouseDownEvents.source().subscribe((mouseX, mouseY, button) -> {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                    parent.selectedRecipe = this.recipe;
                    parent.updateButtons();
                    parent.updateSelectedRecipeDisplay();
                    return true;
                });
                this.cursorStyle(CursorStyle.HAND);
            }
            this.sizing(Sizing.fixed((int)16));
        }

        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            class_4587 matrices = context.method_51448();
            if (this.recipe.isUnlocked) {
                super.draw(context, mouseX, mouseY, partialTicks, delta);
            }
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            if (this.recipe.isUnlocked) {
                if (this.hovered || this.parent.selectedRecipe == this.recipe) {
                    matrices.method_22903();
                    matrices.method_46416(0.0f, 0.0f, 200.0f);
                    context.method_25302(RECIPES_SCREEN_TEXTURE, this.x() - 3, this.y() - 3, 160, 96, 22, 22);
                    matrices.method_22909();
                }
                if (this.hovered) {
                    context.method_51446(this.textRenderer, this.recipe.recipe().output(), mouseX, mouseY);
                }
            } else {
                matrices.method_22903();
                matrices.method_46416(0.0f, 0.0f, 300.0f);
                context.method_25302(RECIPES_SCREEN_TEXTURE, this.x(), this.y(), 192, 64, 16, 16);
                matrices.method_22909();
                if (this.hovered) {
                    String advancementKey = class_156.method_646((String)"advancements", (class_2960)this.recipe.recipe().requiredAdvancement().orElseThrow()) + ".description";
                    String advancementName = class_2561.method_43471((String)advancementKey).getString();
                    context.method_51447(this.textRenderer, List.of(class_5481.method_30747((String)"Locked", (class_2583)class_2583.field_24360.method_27706(class_124.field_1061)), class_5481.method_30747((String)advancementName, (class_2583)class_2583.field_24360.method_27706(class_124.field_1080))), mouseX, mouseY);
                }
            }
            RenderSystem.disableDepthTest();
            RenderSystem.disableBlend();
        }
    }

    private static class DisableShadowDrawContext
    extends class_332 {
        public DisableShadowDrawContext(class_332 parent) {
            super(class_310.method_1551(), parent.method_51450());
            this.method_51448().method_34425(parent.method_51448().method_23760().method_23761());
        }

        public int method_35720(class_327 textRenderer, class_5481 text, int x, int y, int color) {
            return this.method_51430(textRenderer, text, x, y, color, false);
        }
    }
}

