/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.structure.grid;

import com.github.mim1q.minecells.structure.grid.GridPiece;
import com.github.mim1q.minecells.util.MathUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5819;

public class GridPiecesGenerator {
    public static List<GridPiece> generatePieces(class_2338 startPos, Optional<class_2902.class_2903> projectStartToHeightmap, class_3195.class_7149 context, int size, RoomGridGenerator generator) {
        List<RoomData> roomDataList = generator.generate(context);
        ArrayList<GridPiece> pieces = new ArrayList<GridPiece>();
        for (RoomData data : roomDataList) {
            if (data.terrainFit) {
                pieces.add(GridPiecesGenerator.getTerrainFitPiece(data, startPos, projectStartToHeightmap, context, size));
                continue;
            }
            pieces.add(new GridPiece(context, data.poolId, startPos.method_10081(data.pos.method_35862(size)).method_10081(data.offset), data.rotation, size));
        }
        return pieces;
    }

    public static GridPiece getTerrainFitPiece(RoomData data, class_2338 startPos, Optional<class_2902.class_2903> projectStartToHeightmap, class_3195.class_7149 context, int size) {
        class_2338 pos = startPos.method_10081(data.terrainSamplePos.method_35862(size));
        class_2338 heightmapPos = pos.method_10081(data.terrainSampleOffset);
        int heightmapY = context.comp_562().method_20402(heightmapPos.method_10263(), heightmapPos.method_10260(), projectStartToHeightmap.orElse(class_2902.class_2903.field_13203), context.comp_569(), context.comp_564());
        int heightDiff = heightmapY - startPos.method_10264();
        return new GridPiece(context, data.poolId, startPos.method_10081(data.pos.method_35862(size)).method_10081(data.offset).method_10069(0, heightDiff, 0), data.rotation, size);
    }

    public static abstract class RoomGridGenerator {
        protected static final class_2960 EMPTY = class_2960.method_43902((String)"minecraft", (String)"empty");
        protected final List<RoomData> rooms = new ArrayList<RoomData>();
        protected final Set<class_2382> usedPositions = new HashSet<class_2382>();
        protected final List<SpecialPoint> specialPoints = new ArrayList<SpecialPoint>();

        protected abstract void addRooms(class_5819 var1);

        public List<RoomData> generate(class_3195.class_7149 context) {
            long seed = (long)MathUtils.getClosestMultiplePosition((class_2382)context.comp_568().method_8323(), 1024).hashCode() ^ context.comp_567();
            context.comp_566().method_43052(seed);
            this.rooms.clear();
            this.usedPositions.clear();
            this.specialPoints.clear();
            this.addRooms((class_5819)context.comp_566());
            return this.rooms;
        }

        void generateForTesting(class_5819 random) {
            this.rooms.clear();
            this.usedPositions.clear();
            this.specialPoints.clear();
            this.addRooms(random);
        }

        public List<SpecialPoint> generateSpecialPoints(class_3195.class_7149 context) {
            this.generate(context);
            return this.specialPoints;
        }

        protected final void addRoom(class_2382 pos, class_2470 rotation, class_2960 poolId, class_2382 offset, boolean terrainFit) {
            RoomData builder = RoomData.create(pos, poolId).rotation(rotation).offset(offset);
            if (terrainFit) {
                builder.terrainFit();
            }
            this.addRoom(builder);
        }

        protected final void addRoom(class_2382 pos, class_2470 rotation, class_2960 poolId, class_2382 offset) {
            this.addRoom(pos, rotation, poolId, offset, false);
        }

        protected final void addRoom(class_2382 pos, class_2470 rotation, class_2960 poolId) {
            this.addRoom(pos, rotation, poolId, class_2382.field_11176);
        }

        protected final void addTerrainFitRoom(class_2382 pos, class_2470 rotation, class_2960 poolId, class_2382 offset) {
            this.addRoom(pos, rotation, poolId, offset, true);
        }

        protected final void addTerrainFitRoom(class_2382 pos, class_2470 rotation, class_2960 poolId) {
            this.addTerrainFitRoom(pos, rotation, poolId, class_2382.field_11176);
        }

        protected void addRoom(RoomData roomData) {
            this.rooms.add(roomData);
            this.usedPositions.add(roomData.pos);
            if (roomData.specialPoint != null) {
                this.specialPoints.add(new SpecialPoint(roomData.specialPoint.id(), roomData.pos.method_35862(16).method_35853(MathUtils.getRotatedOffsetWithinChunk(roomData.specialPoint.offset, roomData.rotation)), roomData.specialPoint.facing().method_10501(roomData.rotation)));
            }
        }

        protected boolean isPositionUsed(class_2382 pos) {
            return this.usedPositions.contains(pos);
        }

        public abstract int getVersion();

        public static RoomGridGenerator single(class_2960 roomId, int version) {
            return RoomGridGenerator.single(roomId, class_2382.field_11176, version);
        }

        public static RoomGridGenerator single(class_2960 roomId, class_2382 offset, int version) {
            return new Single(roomId, offset, version);
        }

        protected static RoomData room(int x, int y, int z, class_2960 poolId) {
            return RoomData.create(x, y, z, poolId);
        }

        protected static RoomData room(class_2382 pos, class_2960 poolId) {
            return RoomData.create(pos, poolId);
        }

        public record SpecialPoint(class_2960 id, class_2382 offset, class_2470 facing) {
        }

        public static final class Single
        extends RoomGridGenerator {
            private final class_2960 roomId;
            private final class_2382 offset;
            private final int version;

            Single(class_2960 roomId, class_2382 offset, int version) {
                this.roomId = roomId;
                this.offset = offset;
                this.version = version;
            }

            @Override
            protected void addRooms(class_5819 random) {
                this.addRoom(class_2382.field_11176, class_2470.method_16548((class_5819)random), this.roomId, this.offset);
            }

            @Override
            public int getVersion() {
                return this.version;
            }
        }
    }

    public static class RoomData {
        public final class_2382 pos;
        public final class_2960 poolId;
        public class_2470 rotation = class_2470.field_11467;
        public class_2382 offset = class_2382.field_11176;
        public boolean terrainFit = false;
        public class_2382 terrainSamplePos;
        public class_2382 terrainSampleOffset = new class_2382(8, 0, 8);
        public RoomGridGenerator.SpecialPoint specialPoint = null;

        public RoomData(class_2382 pos, class_2960 poolId) {
            this.pos = pos;
            this.poolId = poolId;
            this.terrainSamplePos = pos;
        }

        public static RoomData create(class_2382 pos, class_2960 poolId) {
            return new RoomData(pos, poolId);
        }

        public static RoomData create(int x, int y, int z, class_2960 poolId) {
            return RoomData.create(new class_2382(x, y, z), poolId);
        }

        public RoomData rotation(class_2470 rotation) {
            this.rotation = rotation;
            return this;
        }

        public RoomData offset(class_2382 offset) {
            this.offset = offset;
            return this;
        }

        public RoomData offset(int x, int y, int z) {
            return this.offset(new class_2382(x, y, z));
        }

        public RoomData terrainFitOffset(int x, int y, int z) {
            this.offset(x, y, z);
            this.terrainSampleOffset = this.offset;
            this.terrainFit();
            return this;
        }

        public RoomData terrainFit() {
            this.terrainFit = true;
            return this;
        }

        public RoomData terrainFit(class_2382 pos) {
            this.terrainFit = true;
            this.terrainSamplePos = pos;
            return this;
        }

        public RoomData terrainFit(int x, int y, int z) {
            return this.terrainFit(new class_2382(x, y, z));
        }

        public RoomData terrainSampleOffset(int x, int y, int z) {
            this.terrainSampleOffset = new class_2382(x, y, z);
            return this;
        }

        public RoomData specialPoint(class_2960 id, class_2382 offset, class_2470 facing) {
            if (id == null) {
                return this;
            }
            this.specialPoint = new RoomGridGenerator.SpecialPoint(id, offset, facing);
            return this;
        }
    }
}

