/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.zipline.item;

import dev.doublekekse.zipline.Cable;
import dev.doublekekse.zipline.Cables;
import dev.doublekekse.zipline.client.ZiplineClient;
import dev.doublekekse.zipline.registry.ZiplineSoundEvents;
import java.util.Collection;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class ZiplineItem
extends class_1792 {
    public Cable cable = null;
    private int directionFactor;
    private boolean actuallyUsing = false;
    private class_243 lastDir = null;
    private double speed = 0.0;
    private double progress;
    private static final double HANG_OFFSET = 2.12;
    private static final double TOP_VERTICAL_SNAP_FACTOR = 0.3;
    private static final double SNAP_RADIUS = 3.0;
    private static final double MAX_TURN_ANGLE = 0.707;

    public ZiplineItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public int method_7881(class_1799 itemStack, class_1309 livingEntity) {
        return Integer.MAX_VALUE;
    }

    public void method_7852(class_1937 level, class_1309 livingEntity, class_1799 itemStack, int i) {
        class_1657 player;
        super.method_7852(level, livingEntity, itemStack, i);
        if (!(level.field_9236 && livingEntity instanceof class_1657 && (player = (class_1657)livingEntity).method_7340())) {
            return;
        }
        if (!this.actuallyUsing) {
            class_243 playerPos = player.method_19538();
            class_243 offsetPlayerPos = playerPos.method_1031(0.0, 2.12, 0.0);
            this.cable = Cables.getClosestCable(offsetPlayerPos, 3.0);
            if (this.cable == null || !this.cable.isValid()) {
                return;
            }
            class_243 closestPoint = this.cable.getClosestPoint(offsetPlayerPos);
            class_243 playerAttachPos = closestPoint.method_1031(0.0, -2.12, 0.0);
            if (closestPoint.field_1351 > playerPos.field_1351 + 0.636 && !this.isInvalidPosition(player, playerAttachPos.method_1020(playerPos))) {
                this.enable(player, offsetPlayerPos);
            }
        }
        if (this.actuallyUsing) {
            this.ziplineTick(player, itemStack);
        }
    }

    void enable(class_1657 player, class_243 offsetPlayerPos) {
        this.actuallyUsing = true;
        this.speed = player.method_18798().method_1033();
        this.progress = this.cable.getProgress(offsetPlayerPos);
        this.directionFactor = player.method_5720().method_1026(this.cable.direction(this.progress)) >= 0.0 ? 1 : -1;
        double futureT = this.progress + (double)this.directionFactor * 0.1 / this.cable.length();
        class_243 delta = this.cable.getPoint(futureT).method_1020(offsetPlayerPos);
        float yaw = (float)(class_3532.method_15349((double)delta.field_1350, (double)delta.field_1352) * 57.2957763671875 - (double)player.method_36454());
        ZiplineClient.ziplineTilt(yaw);
        player.method_5783(ZiplineSoundEvents.ZIPLINE_ATTACH, 0.6f, 1.0f);
    }

    void disable() {
        this.cable = null;
        this.actuallyUsing = false;
        this.speed = 0.0;
    }

    void updateSpeed() {
        if (this.speed < 1.6) {
            this.speed = class_3532.method_16436((double)0.03, (double)this.speed, (double)1.6);
        }
    }

    void updateProgress() {
        this.progress += (double)this.directionFactor * this.speed / this.cable.length();
        this.progress = class_3532.method_15350((double)this.progress, (double)0.0, (double)1.0);
    }

    boolean hasCollision(Iterable<class_265> shapes) {
        for (class_265 shape : shapes) {
            if (shape.method_1110()) continue;
            return true;
        }
        return false;
    }

    boolean isInvalidPosition(class_1657 player, class_243 deltaPos) {
        class_238 collisionBox = player.method_5829().method_997(deltaPos);
        Iterable blockCollisions = player.method_37908().method_20812((class_1297)player, collisionBox);
        return this.hasCollision(blockCollisions);
    }

    void ziplineTick(class_1657 player, class_1799 itemStack) {
        if (!this.cable.isValid()) {
            this.interruptUsing(player, itemStack);
            return;
        }
        class_243 closestPoint = this.cable.getPoint(this.progress);
        this.updateSpeed();
        this.updateProgress();
        class_243 newPosition = this.cable.getPoint(this.progress);
        class_243 newOffsetPosition = new class_243(newPosition.field_1352, newPosition.field_1351 - 2.12, newPosition.field_1350);
        this.lastDir = newPosition.method_1020(closestPoint);
        if (this.isInvalidPosition(player, this.lastDir)) {
            this.interruptUsing(player, itemStack);
            return;
        }
        player.method_33574(newOffsetPosition);
        player.method_18800(0.0, 0.0, 0.0);
        player.method_5783(ZiplineSoundEvents.ZIPLINE_USE, 1.0f, 0.3f + (float)this.speed);
        if (this.progress >= 1.0 || this.progress <= 0.0) {
            Collection<Cable> nextCables = this.cable.getNext(this.directionFactor == 1);
            class_243 playerDir = player.method_5720();
            class_243 cableDir = this.lastDir.method_1029();
            double highestDotProduct = -1.0;
            Cable nextCable = null;
            for (Cable next : nextCables) {
                if (this.cable.equals(next)) continue;
                double lookDotProduct = next.direction(0.0).method_1026(playerDir);
                double cableDotProduct = next.direction(0.0).method_1026(cableDir);
                if (!(lookDotProduct > highestDotProduct) || !(cableDotProduct > 0.707)) continue;
                highestDotProduct = lookDotProduct;
                nextCable = next;
            }
            if (nextCable == null) {
                this.interruptUsing(player, itemStack);
                return;
            }
            this.cable = nextCable;
            this.directionFactor = 1;
            this.progress = 0.0;
        }
    }

    void interruptUsing(class_1657 player, class_1799 itemStack) {
        player.method_6021();
        this.applyExitMomentum((class_1309)player);
        player.method_7357().method_62835(itemStack, 20);
        player.method_5783(ZiplineSoundEvents.ZIPLINE_INTERRUPT, 0.5f, 1.0f);
        this.disable();
    }

    void applyExitMomentum(class_1309 livingEntity) {
        livingEntity.method_45319(this.lastDir.method_1021(0.5));
        livingEntity.method_45319(livingEntity.method_5720().method_38499(class_2350.class_2351.field_11052, 0.0).method_1021(0.5));
    }

    public boolean method_7840(class_1799 itemStack, class_1937 level, class_1309 livingEntity, int i) {
        if (!(livingEntity instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)livingEntity;
        player.method_7357().method_62835(itemStack, 10);
        if (!level.field_9236) {
            return false;
        }
        if (this.actuallyUsing) {
            livingEntity.method_45319(new class_243(0.0, 0.8, 0.0));
            this.applyExitMomentum(livingEntity);
            this.disable();
            return true;
        }
        return false;
    }

    @NotNull
    public class_1269 method_7836(class_1937 level, class_1657 player, class_1268 interactionHand) {
        player.method_6019(interactionHand);
        if (!level.field_9236) {
            return class_1269.field_21466;
        }
        if (player.method_7340()) {
            this.actuallyUsing = false;
            this.speed = 0.0;
        }
        return class_1269.field_21466;
    }
}

