/*
 * Decompiled with CFR 0.152.
 */
package hibi.boathud;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static String speedFormat = "%03.0f km/h";
    public static final String angleFormat = "%03.0f \u00b0";
    public static final String gFormat = "%+.1f g";
    public static boolean enabled = true;
    public static boolean extended = true;
    public static double speedRate = 3.6;
    public static int configSpeedType = 1;
    public static int barType = 0;

    private Config() {
    }

    public static void load() {
        File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "boathud.properties");
        if (!file.exists()) {
            return;
        }
        try {
            String val;
            BufferedReader br = new BufferedReader(new FileReader(file));
            Properties prop = new Properties();
            prop.load(br);
            br.close();
            Object object = prop.get("enabled");
            if (object instanceof String) {
                val = (String)object;
                enabled = Boolean.parseBoolean(val);
            }
            if ((object = prop.get("extended")) instanceof String) {
                val = (String)object;
                extended = Boolean.parseBoolean(val);
            }
            if ((object = prop.get("barType")) instanceof String) {
                val = (String)object;
                barType = Integer.parseInt(val);
            }
            if ((object = prop.get("speedUnit")) instanceof String) {
                val = (String)object;
                Config.setUnit(Integer.parseInt(val));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (barType > 2 || barType < 0) {
            barType = 0;
        }
    }

    public static void save() {
        File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "boathud.properties");
        try {
            FileWriter writer = new FileWriter(file);
            writer.write("enabled " + Boolean.toString(enabled) + "\n");
            writer.write("extended " + Boolean.toString(extended) + "\n");
            writer.write("barType " + Integer.toString(barType) + "\n");
            writer.write("speedUnit " + Integer.toString(configSpeedType) + "\n");
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setUnit(int type) {
        switch (type) {
            case 0: {
                speedRate = 1.0;
                speedFormat = "%03.0f m/s";
                configSpeedType = 0;
                break;
            }
            case 2: {
                speedRate = 2.236936;
                speedFormat = "%03.0f mph";
                configSpeedType = 2;
                break;
            }
            case 3: {
                speedRate = 1.943844;
                speedFormat = "%03.0f kt";
                configSpeedType = 3;
                break;
            }
            default: {
                speedRate = 3.6;
                speedFormat = "%03.0f km/h";
                configSpeedType = 1;
            }
        }
    }
}

