/*
 * Decompiled with CFR 0.152.
 */
package hibi.boathud;

import com.mojang.blaze3d.systems.RenderSystem;
import hibi.boathud.Common;
import hibi.boathud.Config;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class HudRenderer {
    private static final class_2960 WIDGETS_TEXTURE = new class_2960("boathud", "textures/widgets.png");
    private final class_310 client;
    private int scaledWidth;
    private int scaledHeight;
    private static final double[] MIN_V = new double[]{0.0, 8.0, 40.0};
    private static final double[] MAX_V = new double[]{40.0, 70.0, 70.0};
    private static final double[] SCALE_V = new double[]{4.55, 2.935483870967742, 6.066666666666666};
    private static final int[] BAR_OFF = new int[]{0, 10, 20};
    private static final int[] BAR_ON = new int[]{5, 15, 25};
    private double displayedSpeed = 0.0;

    public HudRenderer(class_310 client) {
        this.client = client;
    }

    public void render(class_332 graphics, float tickDelta) {
        this.scaledWidth = this.client.method_22683().method_4486();
        this.scaledHeight = this.client.method_22683().method_4502();
        int i = this.scaledWidth / 2;
        int nameLen = this.client.field_1772.method_1727(Common.hudData.name);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.displayedSpeed = class_3532.method_16436((double)tickDelta, (double)this.displayedSpeed, (double)Common.hudData.speed);
        if (Config.extended) {
            graphics.method_25302(WIDGETS_TEXTURE, i - 91, this.scaledHeight - 83, 0, 70, 182, 33);
            this.renderBar(graphics, i - 91, this.scaledHeight - 83);
            if (Common.hudData.isDriver) {
                graphics.method_25302(WIDGETS_TEXTURE, i - 86, this.scaledHeight - 65, 61, this.client.field_1690.field_1913.method_1434() ? 38 : 30, 17, 8);
                graphics.method_25302(WIDGETS_TEXTURE, i - 63, this.scaledHeight - 65, 79, this.client.field_1690.field_1849.method_1434() ? 38 : 30, 17, 8);
                graphics.method_25302(WIDGETS_TEXTURE, i, this.scaledHeight - 55, 0, this.client.field_1690.field_1894.method_1434() ? 45 : 40, 61, 5);
                graphics.method_25302(WIDGETS_TEXTURE, i - 61, this.scaledHeight - 55, 0, this.client.field_1690.field_1881.method_1434() ? 35 : 30, 61, 5);
            }
            this.renderPing(graphics, i + 75 - nameLen, this.scaledHeight - 65);
            this.typeCentered(graphics, String.format(Config.speedFormat, this.displayedSpeed * Config.speedRate), i - 58, this.scaledHeight - 76, 0xFFFFFF);
            this.typeCentered(graphics, String.format("%03.0f \u00b0", Common.hudData.driftAngle), i, this.scaledHeight - 76, 0xFFFFFF);
            this.typeCentered(graphics, String.format("%+.1f g", Common.hudData.g), i + 58, this.scaledHeight - 76, 0xFFFFFF);
            graphics.method_25303(this.client.field_1772, Common.hudData.name, i + 88 - nameLen, this.scaledHeight - 65, 0xFFFFFF);
        } else {
            graphics.method_25302(WIDGETS_TEXTURE, i - 91, this.scaledHeight - 83, 0, 50, 182, 20);
            this.renderBar(graphics, i - 91, this.scaledHeight - 83);
            this.typeCentered(graphics, String.format(Config.speedFormat, this.displayedSpeed * Config.speedRate), i - 58, this.scaledHeight - 76, 0xFFFFFF);
            this.typeCentered(graphics, String.format("%03.0f \u00b0", Common.hudData.driftAngle), i + 58, this.scaledHeight - 76, 0xFFFFFF);
        }
        RenderSystem.disableBlend();
    }

    private void renderBar(class_332 graphics, int x, int y) {
        graphics.method_25302(WIDGETS_TEXTURE, x, y, 0, BAR_OFF[Config.barType], 182, 5);
        if (Common.hudData.speed < MIN_V[Config.barType]) {
            return;
        }
        if (Common.hudData.speed > MAX_V[Config.barType]) {
            if (this.client.field_1687.method_8510() % 2L == 0L) {
                return;
            }
            graphics.method_25302(WIDGETS_TEXTURE, x, y, 0, BAR_ON[Config.barType], 182, 5);
            return;
        }
        graphics.method_25302(WIDGETS_TEXTURE, x, y, 0, BAR_ON[Config.barType], (int)((this.displayedSpeed - MIN_V[Config.barType]) * SCALE_V[Config.barType]), 5);
    }

    private void renderPing(class_332 graphics, int x, int y) {
        int offset = 0;
        offset = Common.hudData.ping < 0 ? 40 : (Common.hudData.ping < 150 ? 0 : (Common.hudData.ping < 300 ? 8 : (Common.hudData.ping < 600 ? 16 : (Common.hudData.ping < 1000 ? 24 : 32))));
        graphics.method_25302(WIDGETS_TEXTURE, x, y, 246, offset, 10, 8);
    }

    private void typeCentered(class_332 graphics, String text, int centerX, int y, int color) {
        graphics.method_25303(this.client.field_1772, text, centerX - this.client.field_1772.method_1727(text) / 2, y, color);
    }
}

