/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client;

import DaoOfModding.mlmanimator.Client.ClientReflection;
import DaoOfModding.mlmanimator.Client.MultiLimbedRenderer;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPoseHandler;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import DaoOfModding.mlmanimator.Common.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientListeners {
    protected static boolean collision = false;

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            return;
        }
        PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler(event.player.m_20148_());
        if (handler == null) {
            return;
        }
        collision = handler.collision;
        handler.collision = false;
        if (event.phase == TickEvent.Phase.START) {
            if (collision && handler.wasCrouching()) {
                ClientListeners.setCrouch(event.player, true);
                handler.setCrouching(event.player.m_6047_());
            }
            handler.doDefaultPoses(event.player);
            handler.tick((AbstractClientPlayer)event.player);
        } else if (event.phase == TickEvent.Phase.END) {
            handler.updateRenderPose();
            if (event.player.m_217003_(Pose.SWIMMING) && !event.player.m_6069_()) {
                Boolean crawlNoCollision = event.player.f_19853_.m_45756_((Entity)event.player, event.player.m_20191_());
                if (crawlNoCollision.booleanValue() && !handler.isCrawling()) {
                    handler.setCrawling(false);
                    if (event.player.m_6144_()) {
                        ClientListeners.setCrouch(event.player, true);
                    } else {
                        event.player.m_20124_(Pose.STANDING);
                    }
                } else {
                    handler.setCrawling(true);
                }
            } else {
                handler.setCrawling(false);
            }
            handler.setCrouching(event.player.m_6047_());
            handler.getPlayerModel().handleBBChange(event.player, !handler.isCrawling());
        }
    }

    protected static void setCrouch(Player player, boolean on) {
        if (player instanceof LocalPlayer) {
            ClientReflection.setCrouch((LocalPlayer)player, on);
        } else if (on) {
            player.m_20124_(Pose.CROUCHING);
        } else {
            player.m_20124_(Pose.STANDING);
        }
    }

    @SubscribeEvent
    public static void movement(MovementInputUpdateEvent event) {
        if (event.getEntity() instanceof Player) {
            PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler(event.getEntity().m_20148_());
            if (handler == null) {
                return;
            }
            if (event.getEntity().m_6047_() && !handler.wasCrouching() && !event.getEntity().m_6144_()) {
                ClientListeners.setCrouch(event.getEntity(), false);
            }
            if (!(event.getEntity().m_6047_() || handler.wasCrouching() || handler.isCrawling())) {
                event.getInput().m_214106_(false, 1.0f);
            } else {
                float f = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)event.getEntity())), (float)0.0f, (float)1.0f);
                event.getInput().m_214106_(true, f);
            }
        }
    }

    @SubscribeEvent
    public static void resize(EntityEvent.Size event) {
        if (event.getEntity() instanceof Player) {
            event.setNewSize(event.getOldSize());
            event.setNewEyeHeight(event.getOldEyeHeight());
        }
    }

    @SubscribeEvent
    public static void entityTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_() == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ != null) {
            for (Player player : Minecraft.m_91087_().f_91073_.m_6907_()) {
                if (!player.m_20159_()) continue;
                player.m_20343_(player.m_20182_().f_82479_, player.m_20182_().f_82480_ - player.m_6049_(), player.m_20182_().f_82481_);
            }
        }
    }

    @SubscribeEvent
    public static void renderFirstPerson(RenderHandEvent event) {
        MultiLimbedRenderer.enableFirstPersonHands = Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof MapItem ? true : Config.Client.vanillaHands();
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            if (!MultiLimbedRenderer.shouldRenderHands()) {
                event.setCanceled(true);
            }
            return;
        }
        if (!PoseHandler.setupPoseHandler((AbstractClientPlayer)Minecraft.m_91087_().f_91074_)) {
            return;
        }
        event.setCanceled(MultiLimbedRenderer.renderFirstPerson((AbstractClientPlayer)Minecraft.m_91087_().f_91074_, event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight()));
    }

    @SubscribeEvent
    public static void renderPlayer(RenderPlayerEvent.Pre event) {
        if (!PoseHandler.setupPoseHandler((AbstractClientPlayer)event.getEntity())) {
            return;
        }
        MultiLimbedRenderer.handleLayers((AbstractClientPlayer)event.getEntity(), event.getRenderer());
        event.setCanceled(MultiLimbedRenderer.render((AbstractClientPlayer)event.getEntity(), event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), ClientReflection.isRenderingInventory()));
    }

    @SubscribeEvent
    public static void renderWorldLast(RenderLevelLastEvent event) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        MultiLimbedRenderer.fakeThirdPersonOff();
    }

    @SubscribeEvent
    public static void cameraSetup(ViewportEvent.ComputeCameraAngles event) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        if (MultiLimbedRenderer.fakeThirdPersonOn()) {
            // empty if block
        }
        MultiLimbedRenderer.rotateCamera(event);
        event.getCamera().m_90565_();
    }

    @SubscribeEvent
    public static void playerDisconnects(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_20148_().compareTo(Minecraft.m_91087_().f_91074_.m_20148_()) == 0) {
            PoseHandler.clear();
        }
    }
}

