/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client.Models;

import DaoOfModding.mlmanimator.Client.Models.ExtendableCube;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class ExtendableModelLayer {
    protected String name;
    protected UVPair textureOffset;
    protected UVPair textureSize;
    protected float extended = 0.0f;
    protected ExtendableCube layerCube;
    protected boolean mirr;
    protected HashMap<Direction, Boolean> visability = new HashMap();
    protected float textureResize;
    protected UVPair UVlock = null;
    protected boolean useSmall = false;

    public ExtendableModelLayer(UVPair texOffset, UVPair texSize, float extend, String newName) {
        this(texOffset, texSize, extend, newName, false, 1.0f);
    }

    public ExtendableModelLayer(UVPair texOffset, UVPair texSize, float extend, String newName, UVPair lockedUV) {
        this(texOffset, texSize, extend, newName, false, 1.0f);
        this.lockUV(lockedUV);
    }

    public ExtendableModelLayer(UVPair texOffset, UVPair texSize, float extend, String newName, boolean mirror, float texResize) {
        this.textureOffset = new UVPair(texOffset.m_171612_(), texOffset.m_171613_());
        this.textureSize = new UVPair(texSize.m_171612_(), texSize.m_171613_());
        this.extended = extend;
        this.name = newName;
        this.mirr = mirror;
        this.textureResize = texResize;
    }

    public ExtendableModelLayer(UVPair texOffset, UVPair texSize, float extend, String newName, boolean mirror, float texResize, UVPair lockedUV) {
        this(texOffset, texSize, extend, newName, mirror, texResize);
        this.lockUV(lockedUV);
    }

    public void setSmall() {
        this.useSmall = true;
    }

    public boolean useSmall() {
        return this.useSmall;
    }

    public void lockUV(UVPair lock) {
        this.UVlock = lock;
    }

    public UVPair getUVlock() {
        return this.UVlock;
    }

    public UVPair getTextureOffset() {
        return this.textureOffset;
    }

    public String getName() {
        return this.name;
    }

    public void makeCube(float posX, float posY, float posZ, float width, float height, float depth, Vec3 fullSize) {
        this.layerCube = new ExtendableCube((int)this.textureOffset.m_171612_(), (int)this.textureOffset.m_171613_(), posX, posY, posZ, width, height, depth, this.extended, this.extended, this.extended, this.mirr, this.textureSize.m_171612_(), this.textureSize.m_171613_(), fullSize, this.textureResize);
        this.updateCubeVisability();
    }

    public void setVisable(Direction dir, Boolean on) {
        this.visability.put(dir, on);
        if (this.layerCube != null) {
            this.updateCubeVisability();
        }
    }

    protected void updateCubeVisability() {
        for (Map.Entry<Direction, Boolean> set : this.visability.entrySet()) {
            this.layerCube.setVisable(set.getKey(), set.getValue());
        }
    }

    public ExtendableModelLayer clone() {
        return new ExtendableModelLayer(this.textureOffset, this.textureSize, this.extended, this.name, this.mirr, this.textureResize);
    }
}

