/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client.Models;

import DaoOfModding.mlmanimator.Client.AnimationFramework.resizeModule;
import DaoOfModding.mlmanimator.Client.Models.ExtendableModelLayer;
import DaoOfModding.mlmanimator.Client.Models.MultiLimbedDimensions;
import DaoOfModding.mlmanimator.Client.Models.Quads.Quad;
import DaoOfModding.mlmanimator.Client.Models.Quads.QuadLinkage;
import DaoOfModding.mlmanimator.Client.Models.TextureHandler;
import DaoOfModding.mlmanimator.Client.MultiLimbedRenderer;
import DaoOfModding.mlmanimator.Common.PlayerUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class ExtendableModelRenderer {
    protected ModelPart mPart;
    protected ArrayList<ExtendableModelLayer> layers = new ArrayList();
    protected ExtendableModelRenderer parent = null;
    protected ArrayList<ExtendableModelRenderer> child = new ArrayList();
    protected ArrayList<Quad> quads = new ArrayList();
    protected ArrayList<QuadLinkage> quadLinkage = new ArrayList();
    protected Vector3f[] points = new Vector3f[8];
    protected MultiLimbedDimensions dimensions = new MultiLimbedDimensions();
    protected boolean look = false;
    protected float notLookingPitch = 0.0f;
    protected float oldNotLookingPitch = 0.0f;
    protected Vec3 rotationOffset = new Vec3(0.0, 0.0, 0.0);
    protected Vec3 rotationPoint = new Vec3(0.0, 0.0, 0.0);
    protected boolean renderFirstPerson = true;
    protected Vec3 thisSize = new Vec3(1.0, 1.0, 1.0);
    protected Vec3 defaultResize = new Vec3(1.0, 1.0, 1.0);
    protected Vec3 defaultSize;
    protected float thisDelta;
    protected Vec3 relativePosition = new Vec3(0.0, 0.0, 0.0);
    protected Vec3 fixedPosition = new Vec3(0.0, 0.0, 0.0);
    protected boolean dontResize = false;
    protected int rotationDepth = 0;
    protected String name;
    protected boolean oldVisability;
    protected boolean hasHitbox = true;
    protected Vec3 usedSize;
    protected boolean lockBBAnimation = false;
    protected Vec3 lockedAnimation = new Vec3(0.0, 0.0, 0.0);
    protected boolean areHands = false;

    public ExtendableModelRenderer(String limbName) {
        this.name = limbName;
        this.mPart = new ModelPart(new ArrayList(), new HashMap());
    }

    public ExtendableModelRenderer clone() {
        return this.clone("");
    }

    public ExtendableModelRenderer clone(String nameAddition) {
        ExtendableModelRenderer copy = new ExtendableModelRenderer(this.name.concat(nameAddition));
        this.copy(copy, nameAddition);
        return copy;
    }

    public void setHands(boolean on) {
        this.areHands = on;
    }

    public ModelPart getModelPart() {
        return this.mPart;
    }

    public Vec3 getSize() {
        return this.thisSize;
    }

    public Vec3 getResize() {
        return this.defaultResize.m_82559_(this.thisSize);
    }

    public void addLayer(UVPair tex, UVPair texSize, float extend, String name) {
        this.layers.add(new ExtendableModelLayer(tex, texSize, extend, name));
    }

    public void addLayer(UVPair tex, UVPair texSize, float extend, String name, boolean mirror) {
        this.layers.add(new ExtendableModelLayer(tex, texSize, extend, name, mirror, 1.0f));
    }

    public void addLayer(UVPair tex, UVPair texSize, float extend, String name, boolean mirror, float textureResize) {
        this.layers.add(new ExtendableModelLayer(tex, texSize, extend, name, mirror, textureResize));
    }

    public void addLayer(UVPair tex, UVPair texSize, float extend, String name, boolean mirror, float textureResize, Direction invisibleDirection) {
        ExtendableModelLayer layer = new ExtendableModelLayer(tex, texSize, extend, name, mirror, textureResize);
        layer.setVisable(invisibleDirection, false);
        this.layers.add(layer);
    }

    public void addLayer(UVPair tex, UVPair texSize, float extend, String name, Direction invisibleDirection) {
        ExtendableModelLayer layer = new ExtendableModelLayer(tex, texSize, extend, name);
        layer.setVisable(invisibleDirection, false);
        this.layers.add(layer);
    }

    public void copy(ExtendableModelRenderer copy, String nameAddition) {
        copy.dimensions = this.dimensions;
        copy.look = this.look;
        copy.rotationOffset = this.rotationOffset;
        copy.rotationPoint = this.rotationPoint;
        copy.renderFirstPerson = this.renderFirstPerson;
        copy.relativePosition = this.relativePosition;
        copy.fixedPosition = this.fixedPosition;
        copy.defaultSize = this.defaultSize;
        copy.thisSize = this.thisSize;
        copy.defaultResize = this.defaultResize;
        copy.thisDelta = this.thisDelta;
        copy.hasHitbox = this.hasHitbox;
        copy.usedSize = this.usedSize;
        copy.areHands = this.areHands;
        for (ExtendableModelLayer layer : this.layers) {
            copy.layers.add(layer.clone());
        }
        copy.generateCube();
        for (ExtendableModelRenderer children : this.child) {
            copy.addChild(children.clone(nameAddition));
        }
        for (Quad quad : this.quads) {
            copy.addQuad(quad);
        }
        for (QuadLinkage link : this.quadLinkage) {
            copy.addQuadLinkage(link);
        }
    }

    public void lockHitboxAnimation(Vec3 animation) {
        if (animation == null) {
            this.lockBBAnimation = false;
        } else {
            this.lockBBAnimation = true;
            this.lockedAnimation = animation;
        }
    }

    public void setHitbox(boolean on) {
        this.hasHitbox = on;
    }

    public Vec3 getDefaultSize() {
        return this.defaultSize;
    }

    public void setNotLookingPitch(float pitch) {
        this.oldNotLookingPitch = this.notLookingPitch;
        this.notLookingPitch = pitch;
    }

    public void addQuad(Quad newQuad) {
        this.quads.add(newQuad);
    }

    public void removeQuad(Quad quad) {
        if (this.quads.contains(quad)) {
            this.quads.remove(quad);
        }
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public void addQuadLinkage(QuadLinkage link) {
        if (!this.hasQuadLinkage(link)) {
            this.quadLinkage.add(link);
        }
    }

    public void removeQuadLinkage(QuadLinkage link) {
        if (this.hasQuadLinkage(link)) {
            this.quadLinkage.remove(link);
        }
    }

    public boolean hasQuadLinkage(QuadLinkage link) {
        return this.quadLinkage.contains(link);
    }

    public void transferQuadLinkages(ExtendableModelRenderer model) {
        for (QuadLinkage link : this.quadLinkage) {
            model.addQuadLinkage(link);
        }
    }

    public void setRotationPoint(Vec3 newRotation) {
        this.rotationPoint = new Vec3(1.0, 1.0, 1.0).m_82546_(newRotation);
    }

    public Vec3 getRotationPoint() {
        return this.rotationPoint;
    }

    public float getNotLookingPitch() {
        return this.notLookingPitch;
    }

    public float getOldNotLookingPitch() {
        return this.oldNotLookingPitch;
    }

    public void setFirstPersonRender(boolean render) {
        this.renderFirstPerson = render;
    }

    public void setFirstPersonRenderForSelfAndChildren(boolean render) {
        this.renderFirstPerson = render;
        for (ExtendableModelRenderer children : this.child) {
            children.setFirstPersonRenderForSelfAndChildren(render);
        }
    }

    public void setRotationOffset(Vec3 offset) {
        this.rotationOffset = offset;
    }

    public void fosterChildren(ExtendableModelRenderer toMove) {
        for (ExtendableModelRenderer fosterChild : (ArrayList)this.child.clone()) {
            toMove.addChild(fosterChild);
        }
        for (Quad fosterQuad : this.quads) {
            toMove.addQuad(fosterQuad);
        }
        this.child.clear();
    }

    public void setLooking(boolean isLooking) {
        this.look = isLooking;
    }

    public Boolean isLooking() {
        return this.look;
    }

    public ExtendableModelRenderer getParent() {
        return this.parent;
    }

    public void setParent(ExtendableModelRenderer parent) {
        if (this.parent == parent) {
            return;
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = parent;
    }

    public void setRotationDepth(int newDepth) {
        this.rotationDepth = newDepth;
    }

    public void rotate(float xRotation, float yRotation, float zRotation) {
        this.mPart.f_104203_ = xRotation /= (float)this.rotationDepth + 1.0f;
        this.mPart.f_104204_ = yRotation /= (float)this.rotationDepth + 1.0f;
        this.mPart.f_104205_ = zRotation /= (float)this.rotationDepth + 1.0f;
        ExtendableModelRenderer traversing = this;
        for (int traverse = this.rotationDepth; traverse > 0; --traverse) {
            traversing = traversing.getParent();
            traversing.rotate(xRotation, yRotation, zRotation);
        }
    }

    public ArrayList<ExtendableModelRenderer> getChildren() {
        return this.child;
    }

    public void extend(resizeModule resizer) {
        this.usedSize = resizer.getOriginalSize();
        this.defaultSize = resizer.getSize();
        this.thisDelta = resizer.getDelta();
        Vec2 texModifier = resizer.getTextureModifier();
        this.generateCube();
        if (this.usedSize.m_82553_() > 0.0) {
            this.setVisibleDirection(resizer.getTop(), false);
        }
        if (!resizer.continueResizing()) {
            return;
        }
        this.setVisibleDirection(resizer.getBottom(), false);
        ExtendableModelRenderer newModel = new ExtendableModelRenderer(this.name + "+");
        newModel.setRotationPoint(resizer.getRotationPoint());
        newModel.setPos((float)resizer.getPosition().f_82479_, (float)resizer.getPosition().f_82480_, (float)resizer.getPosition().f_82481_);
        newModel.setFixedPosAdjustment((float)resizer.getSpacing().f_82479_, (float)resizer.getSpacing().f_82480_, (float)resizer.getSpacing().f_82481_);
        for (ExtendableModelLayer layer : this.layers) {
            newModel.addLayer(new UVPair(layer.textureOffset.m_171612_() + (float)((int)texModifier.f_82470_), layer.textureOffset.m_171613_() + (float)((int)texModifier.f_82471_)), layer.textureSize, layer.extended + resizer.getDelta(), layer.name);
        }
        this.addChild(newModel);
        newModel.extend(resizer.nextLevel());
    }

    public void setVisibleDirection(@Nullable Direction dir, boolean on) {
        if (dir == null) {
            return;
        }
        for (ExtendableModelLayer layer : this.layers) {
            layer.setVisable(dir, on);
        }
    }

    public void setDefaultResize(Vec3 newSize) {
        this.defaultResize = newSize;
    }

    public void resetResize() {
        this.resize(new Vec3(1.0, 1.0, 1.0));
        for (ExtendableModelRenderer children : this.child) {
            children.resetResize();
        }
    }

    public void setNoResize(Boolean on) {
        this.dontResize = on;
    }

    public void setNoResizeForSelfAndChildren(Boolean on) {
        this.dontResize = on;
        for (ExtendableModelRenderer children : this.child) {
            children.setNoResizeForSelfAndChildren(on);
        }
    }

    public void addToResizeForThisAndChildren(Vec3 addTo) {
        this.resize(this.thisSize.m_82549_(addTo));
        for (ExtendableModelRenderer children : this.child) {
            children.addToResizeForThisAndChildren(addTo);
        }
    }

    public void resize(Vec3 newSize) {
        if (!this.dontResize) {
            this.thisSize = newSize;
        }
    }

    public void addChild(ExtendableModelRenderer c) {
        this.child.add(c);
        c.setParent(this);
    }

    public void removeChild(ExtendableModelRenderer toRemove) {
        this.child.remove(toRemove);
    }

    public void generateCube() {
        Vec3 pos = this.getRotationPoint();
        pos = this.defaultSize.m_82490_(-1.0).m_82559_(pos);
        float width = (float)this.defaultSize.f_82479_;
        float height = (float)this.defaultSize.f_82480_;
        float depth = (float)this.defaultSize.f_82481_;
        float x1 = (float)pos.f_82479_;
        float y1 = (float)pos.f_82480_;
        float z1 = (float)pos.f_82481_;
        float x2 = x1 + width;
        float y2 = y1 + height;
        float z2 = z1 + depth;
        this.points[0] = new Vector3f(x1, y1, z1);
        this.points[1] = new Vector3f(x1, y1, z2);
        this.points[2] = new Vector3f(x1, y2, z1);
        this.points[3] = new Vector3f(x1, y2, z2);
        this.points[4] = new Vector3f(x2, y1, z1);
        this.points[5] = new Vector3f(x2, y1, z2);
        this.points[6] = new Vector3f(x2, y2, z1);
        this.points[7] = new Vector3f(x2, y2, z2);
        for (ExtendableModelLayer layer : this.layers) {
            layer.makeCube((float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_, width, height, depth, this.usedSize);
        }
    }

    public void setUsedSize(Vec3 newUsed) {
        this.usedSize = newUsed;
        this.generateCube();
    }

    public void toggleFirstPersonVisability(boolean on) {
        if (!this.renderFirstPerson) {
            if (on) {
                this.oldVisability = this.mPart.f_104207_;
                this.mPart.f_104207_ = false;
            } else {
                this.mPart.f_104207_ = this.oldVisability;
            }
        }
        for (ExtendableModelRenderer childSearch : this.getChildren()) {
            childSearch.toggleFirstPersonVisability(on);
        }
    }

    public void render(PoseStack PoseStackIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, TextureHandler textures) {
        this.mPart.f_104203_ = (float)((double)this.mPart.f_104203_ + this.rotationOffset.f_82479_);
        this.mPart.f_104204_ = (float)((double)this.mPart.f_104204_ + this.rotationOffset.f_82480_);
        this.mPart.f_104205_ = (float)((double)this.mPart.f_104205_ + this.rotationOffset.f_82481_);
        if (MultiLimbedRenderer.isFakeThirdPerson() && (!this.renderFirstPerson || MultiLimbedRenderer.shouldRenderHands() && this.areHands)) {
            this.fakerender(PoseStackIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, textures);
        } else {
            if (MultiLimbedRenderer.isFakeThirdPerson()) {
                this.toggleFirstPersonVisability(true);
            }
            this.renderCube(PoseStackIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, textures);
            if (MultiLimbedRenderer.isFakeThirdPerson()) {
                this.toggleFirstPersonVisability(false);
            }
            this.renderQuads(PoseStackIn, packedLightIn, packedOverlayIn, textures);
        }
        this.mPart.f_104203_ = (float)((double)this.mPart.f_104203_ - this.rotationOffset.f_82479_);
        this.mPart.f_104204_ = (float)((double)this.mPart.f_104204_ - this.rotationOffset.f_82480_);
        this.mPart.f_104205_ = (float)((double)this.mPart.f_104205_ - this.rotationOffset.f_82481_);
    }

    public void renderQuads(PoseStack PoseStackIn, int packedLightIn, int packedOverlayIn, TextureHandler textures) {
        for (Quad quad : this.quads) {
            quad.render(PoseStackIn, packedLightIn, packedOverlayIn, textures);
        }
    }

    public void renderCube(PoseStack PoseStackIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, TextureHandler textures) {
        if (this.mPart.f_104207_) {
            PoseStackIn.m_85836_();
            this.mPart.m_104299_(PoseStackIn);
            for (ExtendableModelLayer layer : this.layers) {
                ResourceLocation tex = textures.getTexture(layer.name);
                if (tex == null) continue;
                VertexConsumer bufferIn = MultiLimbedRenderer.getVertexBuilder(tex);
                Vec3 color = textures.getColor(layer.name);
                if (color != null) {
                    layer.layerCube.compile(PoseStackIn.m_85850_(), bufferIn, packedLightIn, packedOverlayIn, (float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_, alpha, this.getResize());
                    continue;
                }
                layer.layerCube.compile(PoseStackIn.m_85850_(), bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, this.getResize());
            }
            for (ExtendableModelRenderer child : this.getChildren()) {
                child.render(PoseStackIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, textures);
            }
            PoseStackIn.m_85849_();
        }
    }

    public void setPos(float xPos, float yPos, float zPos) {
        this.relativePosition = new Vec3((double)xPos, (double)yPos, (double)zPos);
    }

    public void setFixedPosAdjustment(float xPos, float yPos, float zPos) {
        this.fixedPosition = new Vec3((double)xPos, (double)yPos, (double)zPos);
    }

    public void updatePosition() {
        if (this.getParent() == null) {
            this.mPart.f_104200_ = (float)this.relativePosition.f_82479_;
            this.mPart.f_104201_ = (float)this.relativePosition.f_82480_;
            this.mPart.f_104202_ = (float)this.relativePosition.f_82481_;
        } else {
            Vec3 pos = this.getParent().translateRelativePosition(this.relativePosition);
            this.mPart.f_104200_ = (float)pos.f_82479_;
            this.mPart.f_104201_ = (float)pos.f_82480_;
            this.mPart.f_104202_ = (float)pos.f_82481_;
        }
        Vec3 rsize = this.getResize();
        this.mPart.f_104200_ = (float)((double)this.mPart.f_104200_ + this.fixedPosition.f_82479_ * rsize.f_82479_);
        this.mPart.f_104201_ = (float)((double)this.mPart.f_104201_ + this.fixedPosition.f_82480_ * rsize.f_82480_);
        this.mPart.f_104202_ = (float)((double)this.mPart.f_104202_ + this.fixedPosition.f_82481_ * rsize.f_82481_);
    }

    public void fakerender(PoseStack PoseStackIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, TextureHandler textures) {
        if (this.mPart.f_104207_ && this.child.size() > 0) {
            PoseStackIn.m_85836_();
            this.mPart.m_104299_(PoseStackIn);
            for (ExtendableModelRenderer children : this.child) {
                children.render(PoseStackIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, textures);
            }
            PoseStackIn.m_85849_();
        }
    }

    public void translatePoseStackToThis(PoseStack PoseStackIn) {
        if (this.parent != null) {
            this.parent.translatePoseStackToThis(PoseStackIn);
        }
        this.mPart.m_104299_(PoseStackIn);
    }

    public float getMinHeight() {
        return this.dimensions.getMinHeight();
    }

    public MultiLimbedDimensions calculateMinHeight(PoseStack PoseStackIn, double yRot) {
        this.updatePosition();
        PoseStackIn.m_85836_();
        if (this.lockBBAnimation) {
            this.rotateMatrixToValue(PoseStackIn, this.lockedAnimation);
        } else {
            this.rotateMatrix(PoseStackIn);
        }
        Matrix4f rotator = PoseStackIn.m_85850_().m_85861_();
        float min = -3.4028235E38f;
        Vec3 resize = this.getResize();
        this.dimensions.reset();
        for (Vector3f point : this.points) {
            Vector4f vector4f = new Vector4f(point.m_122239_() * (float)resize.f_82479_, point.m_122260_() * (float)resize.f_82480_, point.m_122269_() * (float)resize.f_82481_, 1.0f);
            vector4f.m_123607_(rotator);
            point = new Vector3f(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_());
            point = PlayerUtils.rotateAroundY(point, yRot);
            this.dimensions.updateSize(point);
            if (!(point.m_122260_() > min)) continue;
            min = point.m_122260_();
        }
        this.updateQuadLinkages(rotator);
        MultiLimbedDimensions totalDimensions = new MultiLimbedDimensions(this.dimensions);
        for (ExtendableModelRenderer testChild : this.child) {
            totalDimensions.combine(testChild.calculateMinHeight(PoseStackIn, yRot));
        }
        PoseStackIn.m_85849_();
        if (!this.hasHitbox) {
            return new MultiLimbedDimensions();
        }
        return totalDimensions;
    }

    public MultiLimbedDimensions getDimensions() {
        return this.dimensions;
    }

    public Vec3 translateRelativePosition(Vec3 relativePos) {
        Vec3 minPos = new Vec3((double)this.points[0].m_122239_(), (double)this.points[0].m_122260_(), (double)this.points[0].m_122269_());
        Vec3 maxPos = new Vec3((double)this.points[7].m_122239_(), (double)this.points[7].m_122260_(), (double)this.points[7].m_122269_());
        Vec3 resize = this.getResize();
        minPos = minPos.m_82559_(resize);
        maxPos = maxPos.m_82559_(resize);
        Vec3 translatedPos = minPos.m_82559_(new Vec3(1.0, 1.0, 1.0).m_82546_(relativePos)).m_82549_(maxPos.m_82559_(relativePos));
        return translatedPos;
    }

    public void updateQuadLinkages(Matrix4f rotator) {
        for (QuadLinkage link : this.quadLinkage) {
            Vec3 relativePos = link.getRelativePos();
            Vec3 position = this.translateRelativePosition(relativePos);
            Vector4f position4f = new Vector4f((float)position.f_82479_, (float)position.f_82480_, (float)position.f_82481_, 1.0f);
            position4f.m_123607_(rotator);
            link.updatePos(new Vec3((double)position4f.m_123601_(), (double)position4f.m_123615_(), (double)position4f.m_123616_()));
        }
    }

    public float getMidPoint(PoseStack PoseStackIn) {
        Matrix4f rotator = PoseStackIn.m_85850_().m_85861_();
        Vec3 modelMidPoint = new Vec3((double)this.mPart.f_104200_, (double)this.mPart.f_104201_, (double)this.mPart.f_104202_);
        modelMidPoint = modelMidPoint.m_82546_(this.getDefaultSize().m_82559_(this.getResize().m_82490_(0.5)));
        Vector4f vector4f = new Vector4f((float)modelMidPoint.m_7096_(), (float)modelMidPoint.m_7098_(), (float)modelMidPoint.m_7094_(), 1.0f);
        vector4f.m_123607_(rotator);
        return vector4f.m_123615_();
    }

    public float getTopPoint(PoseStack PoseStackIn) {
        Matrix4f rotator = PoseStackIn.m_85850_().m_85861_();
        Vector4f vector4f = new Vector4f(this.mPart.f_104200_, this.mPart.f_104201_, this.mPart.f_104202_, 1.0f);
        vector4f.m_123607_(rotator);
        return vector4f.m_123615_();
    }

    public void moveToThisModel(PoseStack PoseStackIn, Vec3 position) {
        this.rotateAroundParents(PoseStackIn);
        Vec3 resizeVec = this.getDefaultSize().m_82559_(this.getResize());
        PoseStackIn.m_85837_(resizeVec.f_82479_ / 16.0 * position.f_82479_, resizeVec.f_82480_ / 16.0 * position.f_82480_, resizeVec.f_82481_ / 16.0 * position.f_82481_);
    }

    public void rotateAroundParents(PoseStack PoseStackIn) {
        if (this.parent != null) {
            this.parent.rotateAroundParents(PoseStackIn);
        }
        this.mPart.m_104299_(PoseStackIn);
    }

    public void rotateMatrix(PoseStack PoseStackIn) {
        this.mPart.f_104203_ = (float)((double)this.mPart.f_104203_ + this.rotationOffset.f_82479_);
        this.mPart.f_104204_ = (float)((double)this.mPart.f_104204_ + this.rotationOffset.f_82480_);
        this.mPart.f_104205_ = (float)((double)this.mPart.f_104205_ + this.rotationOffset.f_82481_);
        PoseStackIn.m_85837_((double)this.mPart.f_104200_, (double)this.mPart.f_104201_, (double)this.mPart.f_104202_);
        if (this.mPart.f_104205_ != 0.0f) {
            PoseStackIn.m_85845_(Vector3f.f_122227_.m_122270_(this.mPart.f_104205_));
        }
        if (this.mPart.f_104204_ != 0.0f) {
            PoseStackIn.m_85845_(Vector3f.f_122225_.m_122270_(this.mPart.f_104204_));
        }
        if (this.mPart.f_104203_ != 0.0f) {
            PoseStackIn.m_85845_(Vector3f.f_122223_.m_122270_(this.mPart.f_104203_));
        }
        this.mPart.f_104203_ = (float)((double)this.mPart.f_104203_ - this.rotationOffset.f_82479_);
        this.mPart.f_104204_ = (float)((double)this.mPart.f_104204_ - this.rotationOffset.f_82480_);
        this.mPart.f_104205_ = (float)((double)this.mPart.f_104205_ - this.rotationOffset.f_82481_);
    }

    public void rotateMatrixToValue(PoseStack PoseStackIn, Vec3 rotation) {
        this.mPart.f_104203_ = (float)((double)this.mPart.f_104203_ + this.rotationOffset.f_82479_);
        this.mPart.f_104204_ = (float)((double)this.mPart.f_104204_ + this.rotationOffset.f_82480_);
        this.mPart.f_104205_ = (float)((double)this.mPart.f_104205_ + this.rotationOffset.f_82481_);
        PoseStackIn.m_85837_((double)this.mPart.f_104200_, (double)this.mPart.f_104201_, (double)this.mPart.f_104202_);
        if (rotation.f_82481_ != 0.0) {
            PoseStackIn.m_85845_(Vector3f.f_122227_.m_122270_((float)rotation.f_82481_));
        }
        if (rotation.f_82480_ != 0.0) {
            PoseStackIn.m_85845_(Vector3f.f_122225_.m_122270_((float)rotation.f_82480_));
        }
        if (rotation.f_82479_ != 0.0) {
            PoseStackIn.m_85845_(Vector3f.f_122223_.m_122270_((float)rotation.f_82479_));
        }
        this.mPart.f_104203_ = (float)((double)this.mPart.f_104203_ - this.rotationOffset.f_82479_);
        this.mPart.f_104204_ = (float)((double)this.mPart.f_104204_ - this.rotationOffset.f_82480_);
        this.mPart.f_104205_ = (float)((double)this.mPart.f_104205_ - this.rotationOffset.f_82481_);
    }

    public void tick(AbstractClientPlayer player) {
        for (ExtendableModelRenderer thisChild : this.getChildren()) {
            thisChild.tick(player);
        }
    }
}

