/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client.Models;

import DaoOfModding.mlmanimator.Common.PlayerUtils;
import com.mojang.math.Vector3f;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MultiLimbedDimensions
extends EntityDimensions {
    static final float sizeIncrement = 0.1f;
    Vector3f minSize;
    Vector3f maxSize;
    protected final float clearance = 0.0f;

    public MultiLimbedDimensions() {
        super(0.0f, 0.0f, true);
        this.reset();
    }

    public MultiLimbedDimensions(Vector3f min, Vector3f max) {
        super(0.0f, 0.0f, true);
        this.minSize = min;
        this.maxSize = max;
    }

    public MultiLimbedDimensions(MultiLimbedDimensions copy) {
        super(copy.getSmallestWidth(), copy.getHeight(), true);
        this.minSize = copy.minSize.m_122281_();
        this.maxSize = copy.maxSize.m_122281_();
    }

    public void increaseHeight(float amount) {
        this.maxSize = new Vector3f(this.maxSize.m_122239_(), this.maxSize.m_122260_() - amount, this.maxSize.m_122269_());
    }

    public AABB m_20393_(Vec3 position) {
        float size = this.getSmallestWidth() / 2.0f;
        return new AABB(position.f_82479_ + (double)size, position.f_82480_, (double)size + position.f_82481_, position.f_82479_ - (double)size, position.f_82480_ + (double)this.getHeight(), position.f_82481_ - (double)size);
    }

    public void reset() {
        this.minSize = new Vector3f(-4.8f, 0.0f, -4.8f);
        this.maxSize = new Vector3f(4.8f, 0.0f, 4.8f);
    }

    public float getSmallestWidth() {
        float depth;
        float width2 = this.getWidth();
        if (width2 < (depth = this.getDepth())) {
            return width2;
        }
        return depth;
    }

    public float getWidth() {
        return (float)((int)((this.maxSize.m_122239_() - this.minSize.m_122239_()) / 0.1f)) * 0.1f;
    }

    public float getHeight() {
        return (this.maxSize.m_122260_() - this.minSize.m_122260_()) * -1.0f - 0.0f;
    }

    public float getDepth() {
        return (float)((int)((this.maxSize.m_122269_() - this.minSize.m_122269_()) / 0.1f)) * 0.1f;
    }

    public void updateSize(Vector3f point) {
        if (this.minSize.m_122239_() > point.m_122239_()) {
            this.minSize.setX(point.m_122239_());
        }
        if (this.minSize.m_122260_() < point.m_122260_()) {
            this.minSize.setY(point.m_122260_());
        }
        if (this.minSize.m_122269_() > point.m_122269_()) {
            this.minSize.setZ(point.m_122269_());
        }
        if (this.maxSize.m_122239_() < point.m_122239_()) {
            this.maxSize.setX(point.m_122239_());
        }
        if (this.maxSize.m_122260_() > point.m_122260_()) {
            this.maxSize.setY(point.m_122260_());
        }
        if (this.maxSize.m_122269_() < point.m_122269_()) {
            this.maxSize.setZ(point.m_122269_());
        }
    }

    public float getMinHeight() {
        return this.minSize.m_122260_();
    }

    public void combine(MultiLimbedDimensions d2) {
        this.updateSize(d2.minSize);
        this.updateSize(d2.maxSize);
    }

    public void scaleValues(float value) {
        this.maxSize.m_122261_(value);
        this.minSize.m_122261_(value);
    }

    public void scaleValuesExceptY(float value) {
        this.maxSize.setX(this.maxSize.m_122239_() * value);
        this.maxSize.setZ(this.maxSize.m_122269_() * value);
        this.minSize.setX(this.minSize.m_122239_() * value);
        this.minSize.setZ(this.minSize.m_122269_() * value);
    }

    public Vec3 getMidPoint() {
        return new Vec3((double)((this.maxSize.m_122239_() + this.minSize.m_122239_()) / 2.0f), (double)((this.maxSize.m_122260_() + this.minSize.m_122260_()) / 2.0f), (double)((this.maxSize.m_122269_() + this.minSize.m_122269_()) / 2.0f));
    }

    public void rotate(float value) {
        this.maxSize = PlayerUtils.rotateAroundY(this.maxSize, (double)value);
        this.minSize = PlayerUtils.rotateAroundY(this.minSize, (double)value);
    }
}

