/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client.Models;

import DaoOfModding.mlmanimator.Client.Models.ExtendableCloakRenderer;
import DaoOfModding.mlmanimator.Client.Models.ExtendableElytraRenderer;
import DaoOfModding.mlmanimator.Client.Models.ExtendableModelRenderer;
import DaoOfModding.mlmanimator.Client.Models.GenericResizers;
import DaoOfModding.mlmanimator.Client.Models.GenericTextureValues;
import DaoOfModding.mlmanimator.Client.Models.MultiLimbedDimensions;
import DaoOfModding.mlmanimator.Client.Models.ParticleEmitter;
import DaoOfModding.mlmanimator.Client.Models.TextureHandler;
import DaoOfModding.mlmanimator.Client.MultiLimbedRenderer;
import DaoOfModding.mlmanimator.Common.Reflection;
import DaoOfModding.mlmanimator.Network.PacketHandler;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ParrotModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.ParrotRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MultiLimbedModel {
    protected float sizeScale = 1.0f;
    protected double defaultHeight = 1.5;
    protected float eyeHeightAdjustment = 0.15f;
    protected Vec3 lookVector = new Vec3(0.0, 0.0, 0.0);
    protected MultiLimbedDimensions size = null;
    protected boolean slim = false;
    PlayerModel baseModel;
    ExtendableModelRenderer body;
    HashMap<String, ExtendableModelRenderer> limbs = new HashMap();
    ExtendableModelRenderer leftShoulderModel;
    ExtendableModelRenderer rightShoulderModel;
    ExtendableModelRenderer viewPoint;
    HashMap<String, ExtendableModelRenderer> firstPersonLimbs = new HashMap();
    HashMap<String, ExtendableModelRenderer> allLimbs = new HashMap();
    HashMap<String, ParticleEmitter> emitters = new HashMap();
    protected boolean lock = false;
    ExtendableModelRenderer[] hands = new ExtendableModelRenderer[2];
    TextureHandler textures = new TextureHandler();
    ParrotModel parrot = null;
    RenderType leftShoulder = null;
    RenderType rightShoulder = null;
    SkullModelBase skullmodelbase = null;
    RenderType skullrendertype = null;
    protected boolean bbchange = false;
    protected int bbecho = -1;
    float eyeHeight = 0.0f;

    public MultiLimbedModel(PlayerModel model) {
        this(model, true);
    }

    public MultiLimbedModel(PlayerModel model, boolean withLimbs) {
        this.baseModel = model;
        this.slim = MultiLimbedRenderer.isSlim(model);
        if (withLimbs) {
            this.setupDefaultLimbs();
        }
    }

    public TextureHandler getTextureHandler() {
        return this.textures;
    }

    public void setTextureHandler(TextureHandler handler) {
        this.textures = handler;
    }

    protected void setupDefaultLimbs() {
        ExtendableModelRenderer body = new ExtendableModelRenderer("Body");
        GenericTextureValues.addGenericBodyLayers(body);
        body.setPos(0.0f, 0.0f, 0.0f);
        body.setRotationPoint(new Vec3(0.5, 0.5, 0.5));
        body.extend(GenericResizers.getBodyResizer());
        ExtendableModelRenderer head = new ExtendableModelRenderer("Head");
        GenericTextureValues.addGenericHeadLayers(head);
        head.setRotationPoint(new Vec3(0.5, 0.0, 0.5));
        head.setPos(0.5f, 0.0f, 0.5f);
        head.extend(GenericResizers.getHeadResizer());
        head.setLooking(true);
        head.setFirstPersonRender(false);
        head.setHitbox(false);
        ExtendableModelRenderer rightArm = new ExtendableModelRenderer("Right_Arm");
        GenericTextureValues.addGenericRightArmLayers(rightArm);
        rightArm.setRotationPoint(new Vec3(0.5, 0.66, 0.5));
        rightArm.setPos(0.0f, 0.0f, 0.5f);
        if (this.slim) {
            rightArm.setFixedPosAdjustment(-1.5f, 2.0f, 0.0f);
            rightArm.extend(GenericResizers.getSlimArmResizer());
        } else {
            rightArm.setFixedPosAdjustment(-2.0f, 2.0f, 0.0f);
            rightArm.extend(GenericResizers.getArmResizer());
        }
        rightArm.setHitbox(false);
        rightArm.setHands(true);
        rightArm.getChildren().get(0).setHands(true);
        ExtendableModelRenderer leftArm = new ExtendableModelRenderer("Left_Arm");
        GenericTextureValues.addGenericLeftArmLayers(leftArm);
        leftArm.setRotationPoint(new Vec3(0.5, 0.66, 0.5));
        leftArm.setPos(1.0f, 0.0f, 0.5f);
        if (this.slim) {
            leftArm.setFixedPosAdjustment(1.5f, 2.0f, 0.0f);
            leftArm.extend(GenericResizers.getSlimArmResizer());
        } else {
            leftArm.setFixedPosAdjustment(2.0f, 2.0f, 0.0f);
            leftArm.extend(GenericResizers.getArmResizer());
        }
        leftArm.setHitbox(false);
        leftArm.setHands(true);
        leftArm.getChildren().get(0).setHands(true);
        ExtendableModelRenderer rightLeg = new ExtendableModelRenderer("Right_Leg");
        GenericTextureValues.addGenericRightLegLayers(rightLeg);
        rightLeg.setPos(0.25f, 1.0f, 0.5f);
        rightLeg.setRotationPoint(new Vec3(0.5, 0.66, 0.5));
        rightLeg.setFixedPosAdjustment(0.0f, 2.0f, 0.0f);
        rightLeg.extend(GenericResizers.getLegResizer());
        ExtendableModelRenderer leftLeg = new ExtendableModelRenderer("Left_Leg");
        GenericTextureValues.addGenericLeftLegLayers(leftLeg);
        leftLeg.setPos(0.75f, 1.0f, 0.5f);
        leftLeg.setRotationPoint(new Vec3(0.5, 0.66, 0.5));
        leftLeg.setFixedPosAdjustment(0.0f, 2.0f, 0.0f);
        leftLeg.extend(GenericResizers.getLegResizer());
        this.addBody(body);
        this.addLimb("Head", head);
        this.addLimb("Left_Arm", leftArm);
        this.addLimb("Right_Arm", rightArm);
        this.addLimb("Left_Leg", leftLeg);
        this.addLimb("Right_Leg", rightLeg);
        this.addLimbReference("Lower_Left_Arm", leftArm.getChildren().get(0));
        this.addLimbReference("Lower_Right_Arm", rightArm.getChildren().get(0));
        this.addLimbReference("Lower_Left_Leg", leftLeg.getChildren().get(0));
        this.addLimbReference("Lower_Right_Leg", rightLeg.getChildren().get(0));
        ExtendableElytraRenderer leftWing = new ExtendableElytraRenderer("Left_Wing_Elytra");
        leftWing.addLayer(GenericTextureValues.elytra, GenericTextureValues.armor_Size, 0.0f, "ELYTRA");
        leftWing.setRotationPoint(new Vec3(0.0, 1.0, 1.0));
        leftWing.setDefaultResize(new Vec3(1.0, 1.0, 2.0));
        leftWing.setPos(1.0f, 0.0f, 1.0f);
        leftWing.setFixedPosAdjustment(0.0f, 0.0f, 0.01f);
        leftWing.extend(GenericResizers.getElytraResizer());
        leftWing.setHitbox(false);
        leftWing.mPart.f_104207_ = false;
        ExtendableElytraRenderer rightWing = new ExtendableElytraRenderer("Right_Wing_Elytra");
        rightWing.addLayer(GenericTextureValues.elytra, GenericTextureValues.armor_Size, 0.0f, "ELYTRA", true);
        rightWing.setRotationPoint(new Vec3(1.0, 1.0, 1.0));
        rightWing.setDefaultResize(new Vec3(1.0, 1.0, 2.0));
        rightWing.setPos(0.0f, 0.0f, 1.0f);
        rightWing.extend(GenericResizers.getElytraResizer());
        rightWing.setHitbox(false);
        rightWing.mPart.f_104207_ = false;
        ExtendableCloakRenderer cloak = new ExtendableCloakRenderer("Cloak");
        cloak.addLayer(GenericTextureValues.cloak, GenericTextureValues.armor_Size, 0.0f, "CLOAK");
        cloak.setRotationPoint(new Vec3(0.5, 1.0, 1.0));
        cloak.setDefaultResize(new Vec3(1.0, 1.0, 1.0));
        cloak.setPos(0.5f, 0.0f, 1.0f);
        cloak.extend(GenericResizers.getCloakResizer());
        leftWing.setFixedPosAdjustment(0.0f, 0.0f, 0.01f);
        cloak.setHitbox(false);
        cloak.mPart.f_104207_ = false;
        this.addLimb("Left_Wing_Elytra", leftWing);
        this.addLimb("Right_Wing_Elytra", rightWing);
        this.addLimb("Cloak", cloak);
        this.setViewPoint(head);
        this.setHand(0, rightArm.getChildren().get(0));
        this.setHand(1, leftArm.getChildren().get(0));
        this.setLeftShoulder(leftArm);
        this.setRightShoulder(rightArm);
    }

    public void setLeftShoulder(ExtendableModelRenderer lShoulder) {
        this.leftShoulderModel = lShoulder;
    }

    public void setRightShoulder(ExtendableModelRenderer rShoulder) {
        this.rightShoulderModel = rShoulder;
    }

    public PlayerModel getBaseModel() {
        return this.baseModel;
    }

    public void setHand(int slot, ExtendableModelRenderer hand) {
        if (this.hands.length < slot) {
            this.expandHands(slot);
        }
        this.hands[slot] = hand;
    }

    protected void expandHands(int size) {
        ExtendableModelRenderer[] newHands = new ExtendableModelRenderer[size];
        for (int i = 0; i < this.hands.length; ++i) {
            newHands[i] = this.hands[i];
        }
        this.hands = newHands;
    }

    public ExtendableModelRenderer getHand(int slot) {
        return this.hands[slot];
    }

    public ExtendableModelRenderer[] getHands() {
        return this.hands;
    }

    public void setViewPoint(ExtendableModelRenderer model) {
        this.viewPoint = model;
    }

    public void lock() {
        while (this.lock) {
        }
        this.lock = true;
    }

    public void unlock() {
        this.lock = false;
    }

    public ParrotModel getParrotModel() {
        return this.parrot;
    }

    public void setParrotModel(ParrotModel parrotModel) {
        this.parrot = parrotModel;
    }

    public void updateSkull(AbstractClientPlayer player, PlayerRenderer renderer) {
        CompoundTag compoundtag;
        ItemStack itemstack = player.m_6844_(EquipmentSlot.HEAD);
        SkullBlock.Type skullType = null;
        if (!itemstack.m_41619_() && itemstack.m_41720_() instanceof BlockItem && ((BlockItem)itemstack.m_41720_()).m_40614_() instanceof AbstractSkullBlock) {
            skullType = ((AbstractSkullBlock)((BlockItem)itemstack.m_41720_()).m_40614_()).m_48754_();
        }
        if (skullType == null) {
            this.skullmodelbase = null;
            this.skullrendertype = null;
            return;
        }
        GameProfile gameprofile = null;
        if (itemstack.m_41782_() && (compoundtag = itemstack.m_41783_()).m_128425_("SkullOwner", 10)) {
            gameprofile = NbtUtils.m_129228_((CompoundTag)compoundtag.m_128469_("SkullOwner"));
        }
        this.skullmodelbase = MultiLimbedRenderer.getSkullModel(renderer, skullType);
        this.skullrendertype = SkullBlockRenderer.m_112523_(skullType, gameprofile);
    }

    public ExtendableModelRenderer getViewPoint() {
        return this.viewPoint;
    }

    public Set<String> getLimbs() {
        return this.limbs.keySet();
    }

    public Set<String> getAllLimbs() {
        return this.allLimbs.keySet();
    }

    public ExtendableModelRenderer getBody() {
        return this.body;
    }

    public void rotateLimb(String limb, Vec3 angles) {
        if (!this.hasLimb(limb)) {
            return;
        }
        ExtendableModelRenderer limbModel = this.getLimb(limb);
        if (limbModel == null) {
            limbModel = this.getFirstPersonLimb(limb);
        }
        limbModel.rotate((float)angles.f_82479_, (float)angles.f_82480_, (float)angles.f_82481_);
    }

    public boolean hasLimb(String limb) {
        return this.allLimbs.containsKey(limb);
    }

    public ExtendableModelRenderer getLimb(String limb) {
        return this.limbs.get(limb);
    }

    public void addBody(ExtendableModelRenderer bodyModel) {
        this.lock();
        ExtendableModelRenderer newBody = bodyModel.clone();
        this.limbs.put("Body", newBody);
        this.allLimbs.put("Body", newBody);
        if (this.body != null) {
            this.body.fosterChildren(newBody);
        }
        this.body = newBody;
        this.unlock();
    }

    public void tick(AbstractClientPlayer player) {
        this.lock();
        this.body.tick(player);
        this.updateShoulder((Player)player);
        this.unlock();
    }

    protected void updateShoulder(Player player) {
        if (this.parrot == null) {
            return;
        }
        this.leftShoulder = player.m_36331_().m_128461_("id").equals("minecraft:parrot") ? this.parrot.m_103119_(ParrotRenderer.f_115648_[player.m_36331_().m_128451_("Variant")]) : null;
        this.rightShoulder = player.m_36332_().m_128461_("id").equals("minecraft:parrot") ? this.parrot.m_103119_(ParrotRenderer.f_115648_[player.m_36332_().m_128451_("Variant")]) : null;
    }

    public void addLimb(String limb, ExtendableModelRenderer limbModel) {
        this.addLimb(limb, limbModel, "Body");
    }

    public void updateArmorsTextures(AbstractClientPlayer player) {
        this.textures.updateArmorTextures(player);
    }

    public void addLimb(String limb, ExtendableModelRenderer limbModel, String addTo) {
        this.lock();
        ExtendableModelRenderer toAdd = this.getLimb(addTo);
        if (toAdd == null) {
            toAdd = this.getFirstPersonLimb(addTo);
        }
        if (toAdd != null) {
            toAdd.addChild(limbModel);
            this.addLimbReference(limb, limbModel);
        }
        this.unlock();
    }

    public void removeLimb(String limb) {
        this.lock();
        this.body.removeChild(this.limbs.get(limb));
        this.limbs.remove(limb);
        this.allLimbs.remove(limb);
        this.unlock();
    }

    public void addFirstPersonLimb(String limb, ExtendableModelRenderer limbModel) {
        this.firstPersonLimbs.put(limb, limbModel);
        this.allLimbs.put(limb, limbModel);
    }

    public ExtendableModelRenderer getFirstPersonLimb(String limb) {
        return this.firstPersonLimbs.get(limb);
    }

    public HashMap<String, ExtendableModelRenderer> getFirstPersonLimbs() {
        return this.firstPersonLimbs;
    }

    public void addLimbReference(String limb, ExtendableModelRenderer limbModel) {
        this.limbs.put(limb, limbModel);
        this.allLimbs.put(limb, limbModel);
    }

    public void setupAnim(float netHeadYaw, float headPitch) {
        this.lookVector = new Vec3((double)(headPitch * ((float)Math.PI / 180)), (double)(netHeadYaw * ((float)Math.PI / 180)), 0.0);
    }

    public void setupLookVector(Vec3 newLookVector) {
        this.lookVector = newLookVector;
    }

    public Vec3 getLookVector() {
        return this.lookVector;
    }

    public Vec3 getHoldingVector() {
        return new Vec3(this.getLookVector().m_7096_() / 1.5, this.getLookVector().m_7098_(), this.getLookVector().m_7094_());
    }

    public void handleBBChange(Player player, boolean handleCollisions) {
        --this.bbecho;
        if (this.bbchange) {
            this.bbecho = 20;
        }
        if (handleCollisions && this.bbchange && !player.f_19853_.m_45756_((Entity)player, player.m_20191_())) {
            VoxelShape voxelshape = Shapes.m_83064_((AABB)player.m_20191_());
            Vec3 vec3 = player.m_20182_().m_82520_(0.0, (double)this.size.getHeight() / 2.0, 0.0);
            player.f_19853_.m_151418_((Entity)player, voxelshape, vec3, (double)this.size.getWidth(), (double)this.size.getHeight(), (double)this.size.getDepth()).ifPresent(p_185956_ -> player.m_146884_(p_185956_.m_82520_(0.0, (double)(-this.size.getHeight()) / 2.0, 0.0)));
        }
        if (this.bbecho == 0) {
            PacketHandler.sendBoundingBoxToServer(this.size.minSize, this.size.maxSize);
            this.bbecho = 20;
            return;
        }
        if (!this.bbchange) {
            return;
        }
        PacketHandler.sendBoundingBoxToServer(this.size.minSize, this.size.maxSize);
        this.bbchange = false;
    }

    public RenderType renderType(ResourceLocation resourcelocation) {
        return this.baseModel.m_103119_(resourcelocation);
    }

    public void renderFirstPerson(PoseStack PoseStackIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.lock();
        PoseStackIn.m_85836_();
        for (ExtendableModelRenderer model : this.firstPersonLimbs.values()) {
            model.render(PoseStackIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, this.textures);
        }
        PoseStackIn.m_85849_();
        this.unlock();
    }

    public void hideHands(Boolean on) {
        for (ExtendableModelRenderer hand : this.hands) {
            hand.setFirstPersonRender(on == false);
        }
    }

    public void render(PoseStack PoseStackIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        PoseStackIn.m_85836_();
        PoseStackIn.m_85837_(0.0, (double)(1.0f - this.sizeScale) * this.defaultHeight, 0.0);
        PoseStackIn.m_85841_(this.sizeScale, this.sizeScale, this.sizeScale);
        this.body.render(PoseStackIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, this.textures);
        PoseStackIn.m_85849_();
    }

    public void renderHead(PoseStack PoseStackIn, MultiBufferSource renderTypeBuffer, int packedLightIn, float red, float green, float blue, float alpha, int ticks) {
        if (this.skullmodelbase == null) {
            this.getViewPoint().mPart.f_104207_ = true;
            return;
        }
        this.getViewPoint().mPart.f_104207_ = false;
        PoseStackIn.m_85836_();
        this.getViewPoint().translatePoseStackToThis(PoseStackIn);
        Vec3 size = this.getViewPoint().getSize();
        PoseStackIn.m_85841_((float)size.m_7096_() + 0.1875f, (float)size.m_7098_() + 0.1875f, (float)size.m_7094_() + 0.1875f);
        Vec3 pos = this.getViewPoint().translateRelativePosition(new Vec3(-0.5, 1.5, 1.5));
        PoseStackIn.m_85837_(pos.f_82479_ / 16.0, pos.f_82480_ / 16.0, pos.f_82481_ / 16.0);
        PoseStackIn.m_85845_(Vector3f.f_122227_.m_122270_((float)Math.toRadians(180.0)));
        PoseStackIn.m_85845_(Vector3f.f_122225_.m_122270_((float)Math.toRadians(180.0)));
        SkullBlockRenderer.m_173663_(null, (float)180.0f, (float)red, (PoseStack)PoseStackIn, (MultiBufferSource)renderTypeBuffer, (int)packedLightIn, (SkullModelBase)this.skullmodelbase, (RenderType)this.skullrendertype);
        PoseStackIn.m_85849_();
    }

    public void renderShoulder(PoseStack PoseStackIn, MultiBufferSource renderTypeBuffer, int packedLightIn, float red, float green, float blue, float alpha, int ticks) {
        VertexConsumer vertexconsumer;
        Vec3 move;
        if (this.leftShoulder != null && this.leftShoulderModel != null) {
            PoseStackIn.m_85836_();
            this.leftShoulderModel.translatePoseStackToThis(PoseStackIn);
            move = this.leftShoulderModel.translateRelativePosition(new Vec3(0.5, -1.0, 0.5)).m_82490_((double)(this.sizeScale / 6.0f));
            PoseStackIn.m_85837_(move.f_82479_, move.f_82480_ - 0.125, move.f_82481_);
            vertexconsumer = renderTypeBuffer.m_6299_(this.leftShoulder);
            this.parrot.m_103223_(PoseStackIn, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, red, green, blue, alpha, ticks);
            PoseStackIn.m_85849_();
        }
        if (this.rightShoulder != null && this.rightShoulderModel != null) {
            PoseStackIn.m_85836_();
            this.leftShoulderModel.translatePoseStackToThis(PoseStackIn);
            move = this.rightShoulderModel.translateRelativePosition(new Vec3(0.5, -1.0, 0.5)).m_82490_((double)(this.sizeScale / 6.0f));
            PoseStackIn.m_85837_(move.f_82479_, move.f_82480_ - 0.125, move.f_82481_);
            vertexconsumer = renderTypeBuffer.m_6299_(this.rightShoulder);
            this.parrot.m_103223_(PoseStackIn, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, red, green, blue, alpha, ticks);
            PoseStackIn.m_85849_();
        }
    }

    public void renderHandItem(boolean left, int slot, LivingEntity entityIn, ItemStack item, PoseStack PoseStackIn, MultiBufferSource renderTypeBuffer, int packedLightIn) {
        if (item.m_41619_()) {
            return;
        }
        ExtendableModelRenderer hand = this.hands[slot];
        if (hand == null) {
            return;
        }
        PoseStackIn.m_85836_();
        ItemTransforms.TransformType cameraTransform = ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
        if (left) {
            cameraTransform = ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
        }
        if (entityIn.m_21212_() > 0 && item.m_41780_() == UseAnim.SPYGLASS) {
            this.getViewPoint().moveToThisModel(PoseStackIn, new Vec3(-0.25, -0.5, -1.0));
        } else {
            hand.moveToThisModel(PoseStackIn, new Vec3(0.0, 1.0, -1.0));
        }
        PoseStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        PoseStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        Minecraft.m_91087_().f_91063_.f_109055_.m_109322_(entityIn, item, cameraTransform, left, PoseStackIn, renderTypeBuffer, packedLightIn);
        PoseStackIn.m_85849_();
    }

    public void calculateEyeHeight() {
        PoseStack stack2 = new PoseStack();
        this.getViewPoint().parent.translatePoseStackToThis(stack2);
        Vec3 move = this.getViewPoint().parent.translateRelativePosition(this.getViewPoint().relativePosition);
        move = move.m_82546_(this.getViewPoint().fixedPosition);
        move = move.m_82490_((double)(this.sizeScale / 16.0f));
        stack2.m_85837_(move.f_82479_, move.f_82480_, move.f_82481_);
        Vector4f testVec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        testVec.m_123607_(stack2.m_85850_().m_85861_());
        this.eyeHeight = testVec.m_123615_() - this.getHeightAdjustment() - (float)(this.getViewPoint().getSize().m_7098_() * (double)0.3f);
        float height = this.getHeight();
        if (this.eyeHeight < height) {
            this.eyeHeight = height;
        }
        if (this.eyeHeight > -0.1f) {
            this.eyeHeight = -0.1f;
        }
        this.eyeHeight -= this.eyeHeightAdjustment;
    }

    public float getEyeHeight() {
        return this.eyeHeight;
    }

    public void setEyeHeightAdjustment(float value) {
        this.eyeHeightAdjustment = value;
    }

    public void calculateHeightAdjustment(Player player) {
        float rotation = (int)((Mth.m_14177_((float)player.f_20883_) + 45.0f) / 90.0f) * 90;
        float oldWidth = player.m_20205_();
        float oldHeight = player.m_20206_();
        this.size = this.body.calculateMinHeight(new PoseStack(), rotation * -1.0f);
        this.size.scaleValues(this.sizeScale / 16.0f);
        this.size = new MultiLimbedDimensions(this.size);
        for (ExtendableModelRenderer model : this.firstPersonLimbs.values()) {
            model.calculateMinHeight(new PoseStack(), 0.0);
        }
        float heightSpacing = 0.0625f;
        this.calculateEyeHeight();
        if (this.getEyeHeight() < this.getHeight() + heightSpacing) {
            this.size.increaseHeight((this.eyeHeight - this.getHeight()) * -1.0f + heightSpacing);
        }
        Reflection.setDimensions(player, new EntityDimensions(this.size.getSmallestWidth(), this.size.getHeight(), false));
        player.m_20011_(this.size.m_20393_(player.m_20182_()));
        if (player.m_7578_() && (oldWidth != player.m_20205_() || oldHeight != player.m_20206_())) {
            this.bbchange = true;
        }
    }

    public MultiLimbedDimensions getSize() {
        return this.size;
    }

    public Vec3 getMidPos() {
        return this.getViewPoint().getDimensions().getMidPoint().m_82490_((double)(this.sizeScale / 8.0f));
    }

    public float getHeight() {
        if (this.size != null) {
            return this.size.maxSize.m_122260_() - this.size.minSize.m_122260_();
        }
        return 0.0f;
    }

    public float getHeightAdjustment() {
        if (this.size != null) {
            return this.size.minSize.m_122260_();
        }
        return 0.0f;
    }
}

