/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client.Models;

import DaoOfModding.mlmanimator.Client.Models.ExtendableModelRenderer;
import DaoOfModding.mlmanimator.Client.Models.MultiLimbedDimensions;
import DaoOfModding.mlmanimator.Client.Models.Quads.Quad;
import DaoOfModding.mlmanimator.Client.Models.Quads.QuadLinkage;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import DaoOfModding.mlmanimator.Common.PlayerUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class ParticleEmitter
extends ExtendableModelRenderer {
    protected ParticleOptions particle;
    protected int interval = 0;
    protected Vec3 Velocity = new Vec3(0.0, 0.0, 0.0);
    protected Vec3 spawnPos = new Vec3(0.0, 0.0, 0.0);
    protected int tick = 0;

    public ParticleEmitter(ParticleOptions particleType, String name) {
        super(name);
        this.particle = particleType;
    }

    public void setInterval(int tickInterval) {
        this.interval = tickInterval;
    }

    public void setVelocity(Vec3 newVelocity) {
        this.Velocity = newVelocity;
    }

    @Override
    public void tick(AbstractClientPlayer player) {
        if (!this.mPart.f_104207_) {
            return;
        }
        if (this.tick >= this.interval) {
            this.spawnParticle((Player)player, this.particle);
            this.tick = 0;
        } else {
            ++this.tick;
        }
    }

    public void spawnParticle(Player player, ParticleOptions toSpawn) {
        Vec3 pos = PlayerUtils.rotateAroundY(this.spawnPos.m_82490_(0.0625), (double)(360.0f - player.f_20883_));
        pos = pos.m_82549_(player.m_20182_());
        pos = new Vec3(pos.f_82479_, pos.f_82480_ + (double)PoseHandler.getPlayerPoseHandler(player.m_20148_()).getPlayerModel().getHeightAdjustment(), pos.f_82481_);
        Vec3 vel = PlayerUtils.rotateAroundY(this.Velocity, (double)(360.0f - player.f_20883_));
        Minecraft.m_91087_().f_91061_.m_107370_(toSpawn, pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
    }

    @Override
    public MultiLimbedDimensions calculateMinHeight(PoseStack PoseStackIn, double yRot) {
        this.updatePosition();
        PoseStackIn.m_85836_();
        this.rotateMatrix(PoseStackIn);
        Matrix4f rotator = PoseStackIn.m_85850_().m_85861_();
        Vector4f vector4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vector4f.m_123607_(rotator);
        this.spawnPos = new Vec3((double)vector4f.m_123601_(), (double)(-vector4f.m_123615_()), (double)(-vector4f.m_123616_()));
        for (ExtendableModelRenderer testChild : this.child) {
            testChild.calculateMinHeight(PoseStackIn, yRot);
        }
        PoseStackIn.m_85849_();
        return this.dimensions;
    }

    @Override
    public ExtendableModelRenderer clone() {
        ParticleEmitter copy = new ParticleEmitter(this.particle, this.name);
        copy.setParent(this.parent);
        copy.Velocity = this.Velocity;
        copy.spawnPos = this.spawnPos;
        copy.interval = this.interval;
        copy.tick = this.tick;
        copy.dimensions = new MultiLimbedDimensions(this.dimensions);
        copy.look = this.look;
        copy.rotationOffset = this.rotationOffset;
        copy.rotationPoint = this.rotationPoint;
        copy.renderFirstPerson = this.renderFirstPerson;
        copy.relativePosition = this.relativePosition;
        copy.fixedPosition = this.fixedPosition;
        copy.defaultSize = this.defaultSize;
        copy.thisSize = this.thisSize;
        copy.defaultResize = this.defaultResize;
        copy.thisDelta = this.thisDelta;
        for (ExtendableModelRenderer children : this.child) {
            copy.addChild(children.clone());
        }
        for (Quad quad : this.quads) {
            copy.addQuad(quad);
        }
        for (QuadLinkage link : this.quadLinkage) {
            copy.addQuadLinkage(link);
        }
        return copy;
    }
}

