/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client.Models.Quads;

import DaoOfModding.mlmanimator.Client.Models.ExtendableModelLayer;
import DaoOfModding.mlmanimator.Client.Models.TextureHandler;
import DaoOfModding.mlmanimator.Client.MultiLimbedRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class Quad {
    protected static final UVPair[] texUV = new UVPair[]{new UVPair(0.0f, 0.0f), new UVPair(1.0f, 0.0f), new UVPair(1.0f, 1.0f), new UVPair(0.0f, 1.0f)};
    protected Vec3[] quadPos = new Vec3[4];
    protected Vec3[] normal = new Vec3[4];
    protected ArrayList<ExtendableModelLayer> layers = new ArrayList();
    protected float alpha = 1.0f;
    protected boolean renderFirstPerson = false;

    public Quad(Vec3 topLeft, Vec3 topRight, Vec3 bottomRight, Vec3 bottomLeft) {
        this.setPos(topLeft, topRight, bottomRight, bottomLeft);
    }

    public void setPos(Vec3 topLeft, Vec3 topRight, Vec3 bottomRight, Vec3 bottomLeft) {
        this.quadPos[0] = topLeft;
        this.quadPos[1] = topRight;
        this.quadPos[2] = bottomRight;
        this.quadPos[3] = bottomLeft;
        this.calculateNormals();
    }

    public void setAlpha(float value) {
        this.alpha = value;
    }

    public void setRenderFirstPerson(boolean on) {
        this.renderFirstPerson = on;
    }

    public boolean getRenderFirstPerson() {
        return this.renderFirstPerson;
    }

    public Vec3 getPos(QuadVertex vertex) {
        return this.quadPos[vertex.ordinal()];
    }

    public void setPos(QuadVertex vertex, Vec3 newPos) {
        this.quadPos[vertex.ordinal()] = newPos;
        this.calculateNormals();
    }

    public void addLayer(UVPair tex, UVPair texSize, float extend, String name) {
        ExtendableModelLayer layer = new ExtendableModelLayer(tex, texSize, extend, name);
        this.layers.add(layer);
    }

    public void addLayer(UVPair tex, UVPair texSize, float extend, String name, UVPair UVLock) {
        ExtendableModelLayer layer = new ExtendableModelLayer(tex, texSize, extend, name, UVLock);
        this.layers.add(layer);
    }

    public void addLayer(UVPair tex, UVPair texSize, float extend, String name, boolean mirror) {
        ExtendableModelLayer layer = new ExtendableModelLayer(tex, texSize, extend, name, mirror, 1.0f);
        this.layers.add(layer);
    }

    public void addLayer(UVPair tex, UVPair texSize, float extend, String name, boolean mirror, float textureResize) {
        ExtendableModelLayer layer = new ExtendableModelLayer(tex, texSize, extend, name, mirror, textureResize);
        this.layers.add(layer);
    }

    public void addLayer(UVPair tex, UVPair texSize, float extend, String name, boolean mirror, float textureResize, Direction invisibleDirection) {
        ExtendableModelLayer layer = new ExtendableModelLayer(tex, texSize, extend, name, mirror, textureResize);
        layer.setVisable(invisibleDirection, false);
        this.layers.add(layer);
    }

    public void addSmallLayer(UVPair tex, UVPair texSize, float extend, String name) {
        ExtendableModelLayer layer = new ExtendableModelLayer(tex, texSize, extend, name);
        layer.setSmall();
        this.layers.add(layer);
    }

    public void addSmallLayer(UVPair tex, UVPair texSize, float extend, String name, UVPair UVLock) {
        ExtendableModelLayer layer = new ExtendableModelLayer(tex, texSize, extend, name, UVLock);
        layer.setSmall();
        this.layers.add(layer);
    }

    public void addSmallLayer(UVPair tex, UVPair texSize, float extend, String name, boolean mirror) {
        ExtendableModelLayer layer = new ExtendableModelLayer(tex, texSize, extend, name, mirror, 1.0f);
        layer.setSmall();
        this.layers.add(layer);
    }

    public void addSmallLayer(UVPair tex, UVPair texSize, float extend, String name, boolean mirror, float textureResize) {
        ExtendableModelLayer layer = new ExtendableModelLayer(tex, texSize, extend, name, mirror, textureResize);
        layer.setSmall();
        this.layers.add(layer);
    }

    public void addSmallLayer(UVPair tex, UVPair texSize, float extend, String name, boolean mirror, float textureResize, Direction invisibleDirection) {
        ExtendableModelLayer layer = new ExtendableModelLayer(tex, texSize, extend, name, mirror, textureResize);
        layer.setSmall();
        layer.setVisable(invisibleDirection, false);
        this.layers.add(layer);
    }

    protected void calculateNormals() {
        this.normal[0] = this.calculateNormal(this.quadPos[0], this.quadPos[3], this.quadPos[1]);
        this.normal[1] = this.calculateNormal(this.quadPos[1], this.quadPos[0], this.quadPos[2]);
        this.normal[2] = this.calculateNormal(this.quadPos[2], this.quadPos[1], this.quadPos[3]);
        this.normal[3] = this.calculateNormal(this.quadPos[3], this.quadPos[2], this.quadPos[0]);
    }

    protected Vec3 calculateNormal(Vec3 point, Vec3 leftPoint, Vec3 rightPoint) {
        return leftPoint.m_82546_(point).m_82537_(rightPoint.m_82546_(point)).m_82541_();
    }

    public void render(PoseStack PoseStackIn, int packedLightIn, int packedOverlayIn, TextureHandler textures) {
        if (MultiLimbedRenderer.isFakeThirdPerson() && !this.renderFirstPerson) {
            return;
        }
        for (ExtendableModelLayer layer : this.layers) {
            ResourceLocation tex = layer.useSmall() ? textures.getSmallTexture(layer.getName()) : textures.getTexture(layer.getName());
            if (tex == null) continue;
            VertexConsumer vertexBuilder = MultiLimbedRenderer.getVertexBuilder(tex);
            Vec3 color = textures.getColor(layer.getName());
            Matrix4f stackPose = PoseStackIn.m_85850_().m_85861_();
            Matrix3f stackNormal = PoseStackIn.m_85850_().m_85864_();
            for (int i = 0; i < 4; ++i) {
                UVPair UV = layer.getUVlock();
                UV = UV == null ? texUV[i] : new UVPair(UV.m_171612_() + texUV[i].m_171612_() * 0.001f, UV.m_171613_() + texUV[i].m_171613_() * 0.001f);
                Vector3f floatingNormal = new Vector3f((float)this.normal[i].f_82479_, (float)this.normal[i].f_82480_, (float)this.normal[i].f_82481_);
                floatingNormal.m_122249_(stackNormal);
                Vector4f floatingPos = new Vector4f((float)this.quadPos[i].f_82479_ / 16.0f, (float)this.quadPos[i].f_82480_ / 16.0f, (float)this.quadPos[i].f_82481_ / 16.0f, 1.0f);
                floatingPos.m_123607_(stackPose);
                vertexBuilder.m_5954_(floatingPos.m_123601_(), floatingPos.m_123615_(), floatingPos.m_123616_(), (float)color.m_7096_(), (float)color.m_7098_(), (float)color.m_7094_(), this.alpha, UV.m_171612_(), UV.m_171613_(), packedOverlayIn, packedLightIn, floatingNormal.m_122239_(), floatingNormal.m_122260_(), floatingNormal.m_122269_());
            }
        }
    }

    public static enum QuadVertex {
        TopLeft,
        TopRight,
        BottomRight,
        BottomLeft;

    }
}

