/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client.Models;

import java.util.HashMap;
import java.util.Locale;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;

public class TextureHandler {
    public static final String PLAYER_SKIN = "PLAYERSKIN";
    public static final String HEAD_ARMOR = "HEADARMOR";
    public static final String CHEST_ARMOR = "CHESTARMOR";
    public static final String LEG_ARMOR = "LEGARMOR";
    public static final String FOOT_ARMOR = "FOOTARMOR";
    public static final String ELYTRA = "ELYTRA";
    public static final String CLOAK = "CLOAK";
    public static final String BLANK = "BLANK";
    protected static final ResourceLocation ELYTRA_WINGS_LOCATION = new ResourceLocation("textures/entity/elytra.png");
    protected static final ResourceLocation BLANK_LOCATION = new ResourceLocation("mlmanimator", "textures/blank.png");
    protected static final Vec3 blankColor = new Vec3(1.0, 1.0, 1.0);
    HashMap<String, ResourceLocation> textures = new HashMap();
    HashMap<String, Vec3> textureColor = new HashMap();

    public void addTexture(String name, ResourceLocation location) {
        this.textures.put(name, location);
    }

    public ResourceLocation getTexture(String name) {
        if (this.textures.containsKey(name)) {
            return this.textures.get(name);
        }
        return null;
    }

    public ResourceLocation getSmallTexture(String name) {
        ResourceLocation bigTex = this.getTexture(name);
        if (bigTex == null) {
            return null;
        }
        Object location = bigTex.m_135815_();
        int slash = ((String)location).lastIndexOf(47) + 1;
        location = ((String)location).substring(0, slash) + "small" + ((String)location).substring(slash);
        return new ResourceLocation(bigTex.m_135827_(), (String)location);
    }

    public void clearTextures() {
        this.textures.clear();
        this.textureColor.clear();
        this.addTexture(BLANK, BLANK_LOCATION);
    }

    public void updateArmorTextures(AbstractClientPlayer player) {
        this.addTexture(PLAYER_SKIN, player.m_108560_());
        this.addTexture(HEAD_ARMOR, TextureHandler.getArmorResource((Player)player, EquipmentSlot.HEAD));
        this.addColor(HEAD_ARMOR, this.getArmorColor(player, EquipmentSlot.HEAD));
        this.addTexture(CHEST_ARMOR, TextureHandler.getArmorResource((Player)player, EquipmentSlot.CHEST));
        this.addColor(CHEST_ARMOR, this.getArmorColor(player, EquipmentSlot.CHEST));
        this.addTexture(LEG_ARMOR, TextureHandler.getArmorResource((Player)player, EquipmentSlot.LEGS));
        this.addColor(LEG_ARMOR, this.getArmorColor(player, EquipmentSlot.LEGS));
        this.addTexture(FOOT_ARMOR, TextureHandler.getArmorResource((Player)player, EquipmentSlot.FEET));
        this.addColor(FOOT_ARMOR, this.getArmorColor(player, EquipmentSlot.FEET));
        this.updateCloakTextures(player);
        this.updateElytraTextures(player);
    }

    protected void updateElytraTextures(AbstractClientPlayer player) {
        ResourceLocation elytraTexture = player.m_108562_() && player.m_108563_() != null ? player.m_108563_() : (player.m_108555_() && player.m_108561_() != null && player.m_36170_(PlayerModelPart.CAPE) ? player.m_108561_() : ELYTRA_WINGS_LOCATION);
        this.addTexture(ELYTRA, elytraTexture);
    }

    protected void updateCloakTextures(AbstractClientPlayer player) {
        if (player.m_108561_() != null) {
            this.addTexture(CLOAK, player.m_108561_());
        }
    }

    public void addColor(String name, Vec3 color) {
        if (color == null) {
            this.textureColor.remove(name);
        } else {
            this.textureColor.put(name, color);
        }
    }

    public Vec3 getColor(String name) {
        if (this.textureColor.containsKey(name)) {
            return this.textureColor.get(name);
        }
        return blankColor;
    }

    public Vec3 getArmorColor(AbstractClientPlayer player, EquipmentSlot slot) {
        ItemStack stack = player.m_6844_(slot);
        if (stack.m_41720_() instanceof DyeableLeatherItem) {
            int color = ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            return new Vec3((double)r, (double)g, (double)b);
        }
        return null;
    }

    public static ResourceLocation getArmorResource(Player entity, EquipmentSlot slot) {
        ItemStack stack = entity.m_6844_(slot);
        if (!(stack.m_41720_() instanceof ArmorItem)) {
            return null;
        }
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        int inner = 1;
        if (slot == EquipmentSlot.LEGS) {
            inner = 2;
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, inner, "");
        try {
            s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)"");
        }
        catch (NullPointerException e) {
            return null;
        }
        return new ResourceLocation(s1);
    }
}

