/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client.Models;

import DaoOfModding.mlmanimator.Client.AnimationFramework.resizeModule;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class defaultResizeModule
implements resizeModule {
    protected int depth;
    protected Vec3 usedSize;
    protected Vec3 size;
    protected Vec3 direction;
    protected Vec3 absDirection;
    protected Vec3 rotationPoint;
    protected Vec3 position;
    protected Vec2 textureModifier;
    protected Vec3 spacing;
    protected Direction top;
    protected Direction bottom;
    protected float delta = 0.0f;

    public defaultResizeModule(int maxDepth, Vec3 direction, Vec3 position, Vec3 fullSize, Vec3 rotationPoint) {
        this(maxDepth, direction, position, fullSize, rotationPoint, new Vec3(0.0, 0.0, 0.0));
    }

    public defaultResizeModule(int maxDepth, Vec3 direction, Vec3 position, Vec3 fullSize, Vec3 rotationPoint, @Nullable Direction t, @Nullable Direction b) {
        this(maxDepth, direction, position, fullSize, rotationPoint, new Vec3(0.0, 0.0, 0.0), 0.0f, t, b);
    }

    public defaultResizeModule(int maxDepth, Vec3 direction, Vec3 position, Vec3 fullSize, Vec3 rotationPoint, float delta) {
        this(maxDepth, direction, position, fullSize, rotationPoint, new Vec3(0.0, 0.0, 0.0), delta, null, null);
    }

    public defaultResizeModule(Vec3 fullSize) {
        this(1, new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 0.0, 0.0), fullSize, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
    }

    public defaultResizeModule(int maxDepth, Vec3 direction, Vec3 position, Vec3 fullSize, Vec3 rotationPoint, Vec3 spacing) {
        this(maxDepth, direction, position, fullSize, rotationPoint, spacing, 0.0f, null, null);
    }

    public defaultResizeModule(int maxDepth, Vec3 direction, Vec3 position, Vec3 fullSize, Vec3 rotationPoint, Vec3 spacing, float newDelta, @Nullable Direction t, @Nullable Direction b) {
        this.top = t;
        this.bottom = b;
        this.depth = maxDepth;
        this.size = fullSize;
        this.delta = newDelta;
        this.usedSize = new Vec3(0.0, 0.0, 0.0);
        this.direction = direction.m_82541_();
        this.absDirection = new Vec3(Math.abs(direction.f_82479_), Math.abs(direction.f_82480_), Math.abs(direction.f_82481_));
        this.rotationPoint = rotationPoint;
        this.position = position;
        this.spacing = spacing;
    }

    @Override
    public Vec3 getPosition() {
        return this.position;
    }

    @Override
    public Vec3 getSize() {
        Vec3 directedSize = this.size.m_82559_(this.absDirection);
        Vec3 thisSize = this.size.m_82546_(directedSize.m_82490_((double)(this.depth - 1) / (double)this.depth).m_82549_(this.spacing));
        this.size = this.size.m_82546_(directedSize.m_82490_(1.0 / (double)this.depth));
        this.usedSize = this.usedSize.m_82553_() == 0.0 ? thisSize.m_82549_(this.spacing) : this.usedSize.m_82549_(thisSize.m_82559_(this.direction)).m_82549_(this.spacing);
        Vec3 modifier = thisSize.m_82559_(this.direction);
        this.textureModifier = new Vec2((float)(modifier.f_82479_ + modifier.f_82481_), (float)modifier.f_82480_);
        return thisSize;
    }

    @Override
    public Vec3 getRotationPoint() {
        return this.rotationPoint;
    }

    @Override
    public Vec2 getTextureModifier() {
        return this.textureModifier;
    }

    @Override
    public resizeModule nextLevel() {
        --this.depth;
        this.delta += 0.01f;
        return this;
    }

    @Override
    public boolean continueResizing() {
        return this.depth != 1;
    }

    @Override
    public Vec3 getOriginalSize() {
        return this.usedSize;
    }

    @Override
    public Vec3 getSpacing() {
        return this.spacing;
    }

    @Override
    public float getDelta() {
        return this.delta;
    }

    @Override
    public Direction getTop() {
        return this.top;
    }

    @Override
    public Direction getBottom() {
        return this.bottom;
    }
}

