/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.mlmanimator.Client;

import DaoOfModding.mlmanimator.Client.ClientReflection;
import DaoOfModding.mlmanimator.Client.Models.MultiLimbedModel;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPoseHandler;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import DaoOfModding.mlmanimator.Common.Config;
import DaoOfModding.mlmanimator.Common.Reflection;
import DaoOfModding.mlmanimator.Network.PacketHandler;
import DaoOfModding.mlmanimator.mlmanimator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ParrotModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ParrotOnShoulderLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class MultiLimbedRenderer {
    protected static MultiBufferSource currentBuffer;
    protected static MultiLimbedModel currentModel;
    protected static AbstractClientPlayer currentEntity;
    protected static VertexConsumer currentVertexBuilder;
    protected static Field thirdPersonField;
    protected static Field slimField;
    protected static Method moveTowardsClosestSpaceFunction;
    protected static Method cameraMoveFunction;
    protected static Field layers;
    protected static Field parrotModel;
    protected static Field skullModels;
    protected static final double defaultCameraDistance = (double)0.3f;
    protected static double decayingDistance;
    protected static boolean fakeThird;
    protected static boolean enableFullBodyFirstPerson;
    public static boolean enableFirstPersonHands;

    public static void setup() {
        thirdPersonField = ObfuscationReflectionHelper.findField(Camera.class, (String)"f_90560_");
        cameraMoveFunction = ObfuscationReflectionHelper.findMethod(Camera.class, (String)"m_90584_", (Class[])new Class[]{Double.TYPE, Double.TYPE, Double.TYPE});
        slimField = ObfuscationReflectionHelper.findField(PlayerModel.class, (String)"f_103380_");
        moveTowardsClosestSpaceFunction = ObfuscationReflectionHelper.findMethod(LocalPlayer.class, (String)"m_108704_", (Class[])new Class[]{Double.TYPE, Double.TYPE});
        layers = ObfuscationReflectionHelper.findField(LivingEntityRenderer.class, (String)"f_115291_");
        parrotModel = ObfuscationReflectionHelper.findField(ParrotOnShoulderLayer.class, (String)"f_117290_");
        skullModels = ObfuscationReflectionHelper.findField(CustomHeadLayer.class, (String)"f_174473_");
        enableFullBodyFirstPerson = (Boolean)Config.Client.enableFullBodyFirstPerson.get();
        enableFirstPersonHands = Config.Client.vanillaHands();
    }

    public static void rotateCamera(ViewportEvent.ComputeCameraAngles event) {
        if (!fakeThird) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler(player.m_20148_());
        if (handler == null) {
            return;
        }
        double pitch = handler.getPlayerModel().getViewPoint().getNotLookingPitch();
        double oldPitch = handler.getPlayerModel().getViewPoint().getOldNotLookingPitch();
        event.setPitch(event.getPitch() + (float)Mth.m_14139_((double)event.getPartialTick(), (double)oldPitch, (double)pitch));
    }

    public static boolean isSlim(PlayerModel model) {
        boolean slim;
        try {
            slim = slimField.getBoolean(model);
        }
        catch (Exception e) {
            mlmanimator.LOGGER.error("Error acquiring model slimness");
            return false;
        }
        return slim;
    }

    public static boolean fakeThirdPersonOn() {
        if (!enableFullBodyFirstPerson) {
            return false;
        }
        Camera rendererInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        if (rendererInfo.m_90594_()) {
            return false;
        }
        fakeThird = true;
        try {
            thirdPersonField.setBoolean(rendererInfo, true);
        }
        catch (Exception e) {
            mlmanimator.LOGGER.error("Error adjusting third person toggle");
            return false;
        }
        return true;
    }

    public static void moveTowardsClosestSpace(LocalPlayer player, double x, double z) {
        try {
            moveTowardsClosestSpaceFunction.invoke((Object)player, x, z);
        }
        catch (Exception e) {
            mlmanimator.LOGGER.error("Error calling moveTowardsClosestSpace - " + e);
        }
    }

    public static boolean isFakeThirdPerson() {
        return fakeThird;
    }

    public static void fakeThirdPersonOff() {
        if (!enableFullBodyFirstPerson) {
            return;
        }
        if (!fakeThird) {
            return;
        }
        Camera rendererInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        try {
            thirdPersonField.setBoolean(rendererInfo, false);
        }
        catch (Exception e) {
            mlmanimator.LOGGER.error("Error adjusting third person toggle");
        }
        fakeThird = false;
    }

    public static void doModelCalculations(AbstractClientPlayer entityIn, PoseStack PoseStackIn, float partialTicks, PlayerPoseHandler handler) {
        PoseStackIn.m_85836_();
        PoseHandler.applyRotations((Player)entityIn, PoseStackIn, 0.0f, partialTicks);
        MultiLimbedRenderer.doPose(entityIn, partialTicks, handler);
        PoseStackIn.m_85849_();
    }

    public static void doPose(AbstractClientPlayer entityIn, float partialTicks, PlayerPoseHandler handler) {
        boolean noCollision = entityIn.f_19853_.m_45756_((Entity)entityIn, entityIn.m_20191_());
        PoseHandler.doPose(entityIn.m_20148_(), partialTicks);
        handler.getPlayerModel().calculateHeightAdjustment((Player)entityIn);
        if (noCollision && !entityIn.f_19853_.m_45756_((Entity)entityIn, entityIn.m_20191_())) {
            PoseHandler.revertPose(entityIn.m_20148_());
            handler.getPlayerModel().calculateHeightAdjustment((Player)entityIn);
            handler.collision = true;
        }
    }

    public static ParrotModel getParrotModel(PlayerRenderer render) {
        try {
            List layerList = (List)layers.get(render);
            for (RenderLayer layer : layerList) {
                if (!(layer instanceof ParrotOnShoulderLayer)) continue;
                return (ParrotModel)parrotModel.get(layer);
            }
        }
        catch (Exception e) {
            mlmanimator.LOGGER.error("Error acquiring player's parrot");
            return null;
        }
        return null;
    }

    public static SkullModelBase getSkullModel(PlayerRenderer render, SkullBlock.Type skullType) {
        try {
            List layerList = (List)layers.get(render);
            for (RenderLayer layer : layerList) {
                if (!(layer instanceof CustomHeadLayer)) continue;
                Map skullList = (Map)skullModels.get(layer);
                return (SkullModelBase)skullList.get(skullType);
            }
        }
        catch (Exception e) {
            mlmanimator.LOGGER.error("Error acquiring custom head");
            return null;
        }
        return null;
    }

    public static void handleLayers(AbstractClientPlayer player, PlayerRenderer renderer) {
        PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler(player.m_20148_());
        MultiLimbedModel model = handler.getPlayerModel();
        if (model.getParrotModel() == null) {
            model.setParrotModel(MultiLimbedRenderer.getParrotModel(renderer));
        }
        model.updateSkull(player, renderer);
    }

    public static boolean renderFirstPerson(AbstractClientPlayer entityIn, float partialTicks, PoseStack PoseStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        PoseStackIn.m_85849_();
        PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler(entityIn.m_20148_());
        if (!enableFullBodyFirstPerson) {
            MultiLimbedRenderer.doModelCalculations(entityIn, PoseStackIn, partialTicks, handler);
        }
        MultiLimbedRenderer.render2FirstPerson(handler.getPlayerModel(), entityIn, partialTicks, PoseStackIn, bufferIn, packedLightIn);
        MultiLimbedRenderer.adjustEyeHeight(entityIn, handler);
        PoseStackIn.m_85836_();
        ClientReflection.doBob(PoseStackIn);
        return !enableFirstPersonHands;
    }

    public static boolean shouldRenderHands() {
        return enableFirstPersonHands;
    }

    public static void adjustEyeHeight(AbstractClientPlayer player, PlayerPoseHandler handler) {
        float oldHeight = player.m_20192_();
        float eyeHeight = handler.getPlayerModel().getEyeHeight() * -1.0f;
        Reflection.adjustEyeHeight((Entity)player, eyeHeight);
        if (oldHeight != player.m_20192_()) {
            PacketHandler.sendEyeHeightToServer(eyeHeight);
        }
    }

    public static void render2FirstPerson(MultiLimbedModel entityModel, AbstractClientPlayer entityIn, float partialTicks, PoseStack PoseStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        PoseStackIn.m_85836_();
        PoseStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        currentModel = entityModel;
        currentEntity = entityIn;
        currentBuffer = bufferIn;
        RenderType rendertype = MultiLimbedRenderer.getRenderType(MultiLimbedRenderer.getSkin(currentEntity));
        if (rendertype != null) {
            int i = LivingEntityRenderer.m_115338_((LivingEntity)entityIn, (float)0.0f);
            entityModel.renderFirstPerson(PoseStackIn, packedLightIn, i, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        PoseStackIn.m_85849_();
    }

    public static boolean render(AbstractClientPlayer entityIn, float partialTicks, PoseStack PoseStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean inInventory) {
        boolean rememberingFake = MultiLimbedRenderer.isFakeThirdPerson();
        if (rememberingFake && entityIn.m_20148_().compareTo(Minecraft.m_91087_().f_91074_.m_20148_()) != 0) {
            MultiLimbedRenderer.fakeThirdPersonOff();
        }
        PlayerPoseHandler handler = PoseHandler.getPlayerPoseHandler(entityIn.m_20148_());
        boolean hideHands = MultiLimbedRenderer.shouldRenderHands();
        if (!rememberingFake || entityIn.m_20148_().compareTo(Minecraft.m_91087_().f_91074_.m_20148_()) != 0 || inInventory) {
            hideHands = false;
        }
        MultiLimbedRenderer.render2(handler, entityIn, partialTicks, PoseStackIn, bufferIn, packedLightIn, hideHands, inInventory);
        if (!inInventory) {
            MultiLimbedRenderer.adjustEyeHeight(entityIn, handler);
        }
        if (rememberingFake) {
            MultiLimbedRenderer.fakeThirdPersonOn();
        }
        return true;
    }

    public static void render2(PlayerPoseHandler handler, AbstractClientPlayer entityIn, float partialTicks, PoseStack PoseStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean hideHands, boolean inInventory) {
        Direction direction;
        boolean shouldSit;
        PoseStackIn.m_85836_();
        MultiLimbedModel entityModel = handler.getPlayerModel();
        entityModel.getBaseModel().f_102609_ = shouldSit = PoseHandler.shouldSit((Player)entityIn);
        float f = Mth.m_14189_((float)partialTicks, (float)entityIn.f_20884_, (float)entityIn.f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)entityIn.f_20886_, (float)entityIn.f_20885_);
        float f2 = f1 - f;
        if (shouldSit && entityIn.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.m_20202_();
            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_((float)partialTicks, (float)entityIn.f_19860_, (float)entityIn.m_146909_());
        if (entityIn.m_20089_() == Pose.SLEEPING && (direction = entityIn.m_21259_()) != null) {
            float f4 = entityIn.m_20236_(Pose.STANDING) - 0.1f;
            PoseStackIn.m_85837_((double)((float)(-direction.m_122429_()) * f4), 0.0, (double)((float)(-direction.m_122431_()) * f4));
        }
        PoseHandler.applyRotations((Player)entityIn, PoseStackIn, f, partialTicks);
        entityModel.setupAnim(f2, f6);
        if (!inInventory) {
            MultiLimbedRenderer.doPose(entityIn, partialTicks, handler);
        }
        double height = entityModel.getHeightAdjustment();
        PoseStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        PoseStackIn.m_85837_(0.0, 0.0 - height, 0.0);
        currentModel = entityModel;
        currentEntity = entityIn;
        currentBuffer = bufferIn;
        RenderType rendertype = MultiLimbedRenderer.getRenderType(MultiLimbedRenderer.getSkin(currentEntity));
        entityModel.updateArmorsTextures(entityIn);
        entityModel.lock();
        if (rendertype != null) {
            if (MultiLimbedRenderer.isFakeThirdPerson() && entityIn.m_20148_().compareTo(Minecraft.m_91087_().f_91074_.m_20148_()) == 0) {
                Vec3 pushBack = MultiLimbedRenderer.getCameraDistance();
                PoseStackIn.m_85837_(pushBack.f_82479_, pushBack.f_82480_, pushBack.f_82481_);
            } else {
                entityModel.renderHead(PoseStackIn, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), packedLightIn, 1.0f, 1.0f, 1.0f, 1.0f, entityIn.f_19797_);
            }
            int i = LivingEntityRenderer.m_115338_((LivingEntity)entityIn, (float)0.0f);
            if (entityIn.m_6047_()) {
                PoseStackIn.m_85837_(0.0, -0.125, 0.0);
            }
            entityModel.render(PoseStackIn, packedLightIn, i, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        entityModel.renderShoulder(PoseStackIn, (MultiBufferSource)bufferSource, packedLightIn, 1.0f, 1.0f, 1.0f, 1.0f, entityIn.f_19797_);
        if (!hideHands) {
            entityModel.renderHandItem(false, 0, (LivingEntity)entityIn, entityIn.m_21205_(), PoseStackIn, (MultiBufferSource)bufferSource, packedLightIn);
            entityModel.renderHandItem(true, 1, (LivingEntity)entityIn, entityIn.m_21206_(), PoseStackIn, (MultiBufferSource)bufferSource, packedLightIn);
        }
        entityModel.unlock();
        PoseStackIn.m_85849_();
    }

    public static Vec3 getCameraDistance() {
        double xlocation = MultiLimbedRenderer.currentModel.getViewPoint().getRotationPoint().f_82479_;
        double zlocation = MultiLimbedRenderer.currentModel.getViewPoint().getRotationPoint().f_82481_;
        float angle = Mth.m_14177_((float)Minecraft.m_91087_().f_91074_.f_20883_);
        double zDistance = currentModel.getSize().getDepth();
        double xDistance = currentModel.getSize().getWidth();
        if (angle > 45.0f && angle < 135.0f || angle > -180.0f && angle < -135.0f) {
            zDistance = currentModel.getSize().getWidth();
            xDistance = currentModel.getSize().getDepth();
        }
        xDistance *= xlocation;
        return new Vec3(0.0, 0.0, zDistance *= zlocation);
    }

    public static VertexConsumer getVertexBuilder() {
        return MultiLimbedRenderer.getVertexBuilder(MultiLimbedRenderer.getSkin(currentEntity));
    }

    public static VertexConsumer getVertexBuilder(ResourceLocation resourceLocation) {
        RenderType rendertype = MultiLimbedRenderer.getRenderType(resourceLocation);
        currentVertexBuilder = currentBuffer.m_6299_(rendertype);
        return currentVertexBuilder;
    }

    public static RenderType getRenderType(ResourceLocation resourcelocation) {
        boolean visible;
        boolean invis = currentEntity.m_20145_();
        boolean bl = visible = !invis && !currentEntity.m_20177_((Player)Minecraft.m_91087_().f_91074_);
        if (visible) {
            return currentModel.renderType(resourcelocation);
        }
        return null;
    }

    public static ResourceLocation getSkin(AbstractClientPlayer EntityIn) {
        return EntityIn.m_108560_();
    }

    static {
        decayingDistance = 0.3f;
        fakeThird = false;
        enableFullBodyFirstPerson = true;
        enableFirstPersonHands = false;
    }
}

